/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XMLDecryptionTransformer2;
import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class XMLDecryptionTransformer
extends XMLDecryptionTransformer2 {
    private static final TraceComponent tc = Tr.register(XMLDecryptionTransformer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDecryptionTransformer.class.getName();
    private String _nsWsse;
    private String _nsWsu;

    @Override
    public void transform(TransformContext context) throws TransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(TransformContext context[" + context + "])");
        }
        super.transform(context);
        SignatureContext scontext = context.getSignatureContext();
        if (scontext instanceof WSSSignatureContext) {
            WSSSignatureContext wsssc = (WSSSignatureContext)scontext;
            int wssVersion = wsssc.getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][wssVersion];
            this._nsWsu = Constants.NAMESPACES[1][wssVersion];
        }
        ArrayList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset(context.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        if (nl != null) {
            nl = this.removeNonce(nl, this._nsWsse, this._nsWsu);
        }
        context.setContent(nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(TransformContext context)");
        }
    }

    private ArrayList removeNonce(ArrayList nl, String nsWsse, String nsWsu) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNonce(NodeList nl[" + nl + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "])");
        }
        ArrayList list = new ArrayList();
        int iLast = nl.size();
        for (int i = 0; i < iLast; ++i) {
            Object node = nl.get(i);
            if (node instanceof OMElement) {
                OMElement el = (OMElement)node;
                if (DOMUtils.equals(el, nsWsse, "Nonce")) {
                    if ("weenc".equals(el.getAttributeValue(Constants.WAS_EXTENTION_Q))) {
                        i = this.removeNodes(nl, i + 1, el);
                        continue;
                    }
                } else if (DOMUtils.equals(el, nsWsu, "Timestamp") && "weenc".equals(el.getAttributeValue(Constants.WAS_EXTENTION_Q))) {
                    i = this.removeNodes(nl, i + 1, el);
                    continue;
                }
            }
            list.add(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNonce(NodeList nl,String nsWsse,String nsWsu) returns NodeList[" + list + "]");
        }
        return list;
    }

    private int removeNodes(ArrayList nl, int start, OMNode root) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodes(NodeList nl[" + nl + "]," + "int start[" + start + "]," + "Node root[" + DOMUtils.getDisplayName(root) + "])");
        }
        boolean finish = false;
        int iLast = nl.size();
        for (i = start; i < iLast; ++i) {
            Object node = nl.get(i);
            if (node instanceof OMElement) {
                if (((OMElement)node).getParent().equals(root)) {
                    i = this.removeNodes(nl, i + 1, (OMElement)node);
                } else {
                    finish = true;
                    break;
                }
            }
            if (finish) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodes(NodeList nl,int start,Node root)");
        }
        return i - 1;
    }
}

