/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.security.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public class XMLDTKeyInfoResolver
extends KeyInfoResolverBase {
    private static final TraceComponent tc = Tr.register(XMLDTKeyInfoResolver.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDTKeyInfoResolver.class.getName();
    private IDResolver _idResolver;
    private Collection<TokenConsumerConfig> _tokenConsumers;
    private Collection<Configuration> _encKIConsumers;
    private Map<Object, Object> _context;
    private Map<Object, Object> _selectors;
    private boolean _storedToken = false;
    private Collection<SecurityTokenWrapper> _stokens = null;
    private Result[] _results = null;

    protected XMLDTKeyInfoResolver() {
    }

    protected void setTokenConsumers(Collection<TokenConsumerConfig> tokenConsumers) {
        this._tokenConsumers = tokenConsumers;
    }

    protected void setEncKeyInfoConsumers(Collection<Configuration> encKIConsumers) {
        this._encKIConsumers = encKIConsumers;
    }

    protected void setContext(Map<Object, Object> context) {
        this._context = context;
    }

    protected void setSelectors(Map<Object, Object> selectors) {
        this._selectors = new HashMap<Object, Object>(selectors);
    }

    @Override
    public void setIdResolver(IDResolver idResolver) {
        this._idResolver = idResolver;
        super.setIdResolver(idResolver);
    }

    @Override
    public Key resolve(KeyInfo keyInfo, EncryptionMethod encMethod) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolve(");
            buf.append("KeyInfo keyInfo[").append(keyInfo).append("],");
            buf.append("EncryptionMethod encMethod[").append(encMethod).append("])");
            Tr.entry(tc, buf.toString());
        }
        Key key = null;
        if (keyInfo != null) {
            SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            try {
                OMElement target = keyInfo.getBase();
                if (target != null) {
                    if (!this._storedToken) {
                        this._stokens = XMLDTKeyInfoResolver.storeSubject(securityTokenManager);
                        this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                        this._storedToken = true;
                    }
                    OMDocument doc = DOMUtil.getOwnerDocument(target);
                    HashMap<Object, Object> type = new HashMap<Object, Object>();
                    int wssVersion = 0;
                    Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
                    if (obj != null && obj instanceof Integer) {
                        wssVersion = (Integer)obj;
                    }
                    String nsWsse = Constants.NAMESPACES[0][wssVersion];
                    String kitype = KeyInfoConsumer.getKeyInfoType(target, nsWsse);
                    boolean strref = "STRREF".equals(kitype);
                    String uri = null;
                    if (strref) {
                        uri = XMLDTKeyInfoResolver.getReferenceURI(target, nsWsse);
                    }
                    if (strref) {
                        OMElement tElement = this._idResolver.resolveID(doc, uri);
                        OMElement tEnvelope = doc.getOMDocumentElement();
                        boolean isUNT = XMLDTKeyInfoResolver.isUNT(tElement, wssVersion);
                        boolean isBST = isUNT ? false : XMLDTKeyInfoResolver.isBST(tElement, wssVersion);
                        WSSConsumer.callTokenConsumer(null, this._tokenConsumers, tEnvelope, null, tElement, securityTokenManager, this._context, isUNT, isBST, wssVersion, true);
                    }
                    key = XMLDTKeyInfoResolver.callKeyInfoConsumer(this._encKIConsumers, type, this._selectors, target, this._context);
                }
                if (key == null) {
                    key = super.resolve(keyInfo, encMethod);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (KeyInfoResolvingException e) {
                throw e;
            }
            catch (Throwable e) {
                Throwable t2;
                if (e instanceof SoapSecurityException && (t2 = ((SoapSecurityException)e).getCauseException()) != null) {
                    e = t2;
                }
                throw new KeyInfoResolvingException(e.toString());
            }
            finally {
                if (this._storedToken) {
                    XMLDTKeyInfoResolver.restoreSubject(securityTokenManager, this._stokens);
                    XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                    this._storedToken = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolve(");
            buf.append("KeyInfo, EncryptionMethod)");
            buf.append(" returns Key[").append(key).append("]");
            Tr.exit(tc, buf.toString());
        }
        return key;
    }

    private static String getReferenceURI(OMElement elem, String nsWsse) throws SoapSecurityException {
        OMElement child;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getReferenceURI(");
            buf.append("OMElement elem[").append(DOMUtils.getDisplayName(elem)).append("],");
            buf.append("String nsWsse[").append(nsWsse).append("])");
            Tr.entry(tc, buf.toString());
        }
        if ((child = DOMUtils.getOneElement(elem, nsWsse, "Reference")) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getReferenceURI01");
        }
        String ref = DOMUtils.getAttribute(child, "URI");
        if (ref == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getReferenceURI02");
        }
        if (ref.startsWith("#")) {
            ref = ref.substring(1);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getReferenceURI(");
            buf.append("OMElement, String)");
            buf.append(" returns String[").append(ref).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ref;
    }

    private static Key callKeyInfoConsumer(Collection<Configuration> kconfig, Map<Object, Object> type, Map<Object, Object> properties, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callKeyInfoConsumer(");
            buf.append("Collection kconfig, Map type, Map properties, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("],");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        boolean succeeded = false;
        Throwable lastException = null;
        Object var7_8 = null;
        Key key = null;
        for (KeyInfoConsumerConfig keyInfoConsumerConfig : kconfig) {
            try {
                key = SignatureConsumer.callKeyInfoConsumer(keyInfoConsumerConfig, "DecryptingKey", type, properties, target, context);
                succeeded = true;
                break;
            }
            catch (Exception e) {
                Tr.processException(e, clsName + ".callSignatureConsumer", "233");
                lastException = e;
            }
        }
        if (!succeeded) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", new String[]{lastException.getMessage()}, lastException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callKeyInfoConsumer(");
            buf.append("Collection, Map, Map, OMElement, Map)");
            buf.append(" returns Key[").append(key).append("]");
            Tr.exit(tc, buf.toString());
        }
        return key;
    }

    protected static Collection<SecurityTokenWrapper> storeSubject(SecurityTokenManagerImpl securityTokenManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeSubject(SecurityTokenManagerImpl securityTokenManager)");
        }
        Collection<SecurityToken> tokens = securityTokenManager.getTokens();
        Collection<SecurityTokenWrapper> tokenWrappers = securityTokenManager.getTokenWrappers(tokens);
        HashSet<SecurityTokenWrapper> ret = new HashSet<SecurityTokenWrapper>(tokenWrappers);
        securityTokenManager.removeTokens(tokens);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("storeSubject(");
            buf.append("SecurityTokenManagerImpl)");
            buf.append(" returns Collection[").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    protected static void restoreSubject(SecurityTokenManagerImpl securityTokenManager, Collection<SecurityTokenWrapper> tokenWrappers) {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("restoreSubject(");
            buf.append("SecurityTokenManagerImpl securityTokenManager, Collection tokens)");
            Tr.entry(tc, buf.toString());
        }
        if (tokenWrappers != null) {
            securityTokenManager.removeAllTokens();
            securityTokenManager.addTokenWrappers(tokenWrappers);
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("restoreSubject(");
            buf.append("SecurityTokenManagerImpl, Collection)");
            Tr.exit(tc, buf.toString());
        }
    }

    protected static Result[] storeResult(Map<Object, Object> context) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeResult(Map context)");
        }
        if ((results = ResultPool.get(context, KeyInfoResult.class)) != null) {
            ResultPool.remove(context, results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeResult(Map)");
        }
        return results;
    }

    protected static void restoreResult(Map<Object, Object> context, Result[] results) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreResult(Map context, Result[] results)");
        }
        if (results != null) {
            Result[] nresults = ResultPool.get(context, KeyInfoResult.class);
            if (nresults != null) {
                ResultPool.remove(context, nresults);
            }
            for (int i = 0; i < results.length; ++i) {
                ResultPool.add(context, results[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreResult(Map, Result[])");
        }
    }

    protected static boolean isUNT(OMElement element, int wssVersion) {
        return NamespaceUtil.checkWsseVersion(element, wssVersion, "UsernameToken") >= 0;
    }

    protected static boolean isBST(OMElement element, int wssVersion) {
        return NamespaceUtil.checkWsseVersion(element, wssVersion, "BinarySecurityToken") >= 0;
    }
}

