/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.SignatureConfirmationGenerator;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.impl.wsse11.SignatureConfirmation;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

public class WSSObjectSignatureConfirmationGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSObjectSignatureConfirmationGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        if ((messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        List<String> sigCache = SignatureConfirmationGenerator.getSignatureConfirmationCache(messageContext);
        Security security = WSSObjectUtils.getWSSObjectSecurityHeader(context);
        if (security == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "ds:Signature");
        }
        WSSObjectDocumentImpl wssObjectDocument = security.getWSSObjectDocument();
        if (sigCache != null) {
            int numSigConfElements = sigCache.size();
            for (int i = 0; i < numSigConfElements; ++i) {
                String sigValue = sigCache.get(i);
                SignatureConfirmation sigConfElement = new SignatureConfirmation(wssObjectDocument);
                sigConfElement.setValue(VariablePartFactory.getInstance().createAttrValueWithString(sigValue));
                IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(context);
                sigConfElement.setWsuId(idAttrVal.getVariablePartValue());
                if (security.getChildrenSize() > 0) {
                    security.insertChildBefore(0, sigConfElement);
                } else {
                    security.addChild(sigConfElement);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding SignatureConfirmation with value attribute: " + sigValue);
            }
        } else {
            SignatureConfirmation sigConfElement = new SignatureConfirmation(wssObjectDocument);
            IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(context);
            sigConfElement.setWsuId(idAttrVal.getVariablePartValue());
            if (security.getChildrenSize() > 0) {
                security.insertChildBefore(0, sigConfElement);
            } else {
                security.addChild(sigConfElement);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding SignatureConfirmation with no value attribute.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
        }
    }
}

