/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.handler.WSSecurityGeneratorHandler;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TemplateGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.saaj.SOAPElementImpl;

public class SignatureGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(SignatureGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureGenerator.class.getName();
    private static final String SIGNATURE_PREFIX = "ds";
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;
    private static QName ID_Q = new QName("", "Id");

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        OMElement c14nElem;
        OMElement inc;
        ArrayList<OMNode> parts;
        SigningReferenceConfig srconfig;
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        OMFactory omFactory = doc.getOMDocumentElement().getOMFactory();
        Object object = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (object != null && object instanceof Integer) {
            wssVersion = (Integer)object;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        String pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "ds:Signature");
        }
        String ln = parent.getLocalName();
        String string = ns = parent.getNamespace() == null ? null : parent.getNamespace().getName();
        if (NamespaceUtil.isWsse(ns) != wssVersion || !"Security".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtils.getQualifiedName(parent), "Security");
        }
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        SignatureGeneratorConfig config2 = (SignatureGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.signatureGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureGeneratorConfig [" + config2 + "].");
        }
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        selectorMap.put(NonceManager.class, gconfig.getNonceManager());
        String canonicalizationMethod = config2.getCanonicalizationMethod().getAlgorithm();
        String signatureMethod = config2.getSignatureMethod().getAlgorithm();
        TemplateGenerator gen = new TemplateGenerator(omFactory, null, canonicalizationMethod, signatureMethod);
        gen.setPrefix(SIGNATURE_PREFIX);
        boolean isGoldenPath = false;
        if (gconfig instanceof PrivateGeneratorConfig) {
            boolean isNormalBodyProcessing = gconfig.isNormalBodyProcessing();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isNormalBodyProcessing = " + isNormalBodyProcessing);
            }
            if (isNormalBodyProcessing) {
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                if (messageContext == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no MessageContext");
                    }
                } else {
                    boolean securityIsLastPhase = false;
                    ArrayList outPhases = messageContext.getConfigurationContext().getAxisConfiguration().getOutFlowPhases();
                    if (outPhases != null && outPhases.size() > 0) {
                        Phase lastPhase = (Phase)outPhases.get(outPhases.size() - 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "last phase = " + lastPhase.getName());
                        }
                        if ("Security".equals(lastPhase.getName())) {
                            for (Object handler : lastPhase.getHandlers()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "handler class = " + handler.getClass().getName());
                                }
                                if (!(handler instanceof WSSecurityGeneratorHandler)) continue;
                                securityIsLastPhase = true;
                                break;
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "securityIsLastPhase = " + securityIsLastPhase);
                    }
                    if (securityIsLastPhase) {
                        context.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_OUTBOUND_GOLDEN_PATH", Boolean.TRUE);
                        if (config2.addInclusiveNamespaces()) {
                            context.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES", Boolean.TRUE);
                        }
                        isGoldenPath = true;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGoldenPth = " + isGoldenPath);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        OMElement root = doc.getOMDocumentElement();
        boolean signSomething = false;
        boolean signNonce = false;
        HashSet<ReferencePartConfig.PartConfig> nonces1 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> nonces2 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
        HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>> nonces3 = new HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>>();
        boolean signSpecial = false;
        HashSet<ReferencePartConfig.PartConfig> specials1 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig> specials2 = new HashMap<ReferencePartConfig.PartConfig, SigningReferenceConfig>();
        HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>> specials3 = new HashMap<ReferencePartConfig.PartConfig, HashMap<Object, Object>>();
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.config", gconfig.getTokenGenerators());
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        Iterator<SigningReferenceConfig> i1 = null;
        if (config2 != null && config2.getReferences() != null && config2.getReferences().iterator() != null) {
            i1 = config2.getReferences().iterator();
        }
        if (i1 != null) {
            while (i1.hasNext()) {
                HashMap<Object, Object> cpSelectorMap = new HashMap<Object, Object>(selectorMap);
                srconfig = i1.next();
                SignatureGenerator.prepareTransform(srconfig, cpSelectorMap);
                ReferencePartConfig rpconfig = srconfig.getReference();
                if (rpconfig == null || rpconfig.getParts() == null || rpconfig.getParts().iterator() == null) continue;
                block13: for (ReferencePartConfig.PartConfig pconfig : rpconfig.getParts()) {
                    if (pconfig.isTimestamp() || pconfig.isNonce()) {
                        signNonce = true;
                        nonces1.add(pconfig);
                        nonces2.put(pconfig, srconfig);
                        nonces3.put(pconfig, cpSelectorMap);
                        continue;
                    }
                    if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(pconfig.getDialect()) && (IntegralDialectElementSelector.WASDIALECTS[2].equals(pconfig.getKeyword()) || IntegralDialectElementSelector.WASDIALECTS[3].equals(pconfig.getKeyword())) || com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(pconfig.getDialect())) {
                        signSpecial = true;
                        specials1.add(pconfig);
                        specials2.put(pconfig, srconfig);
                        specials3.put(pconfig, cpSelectorMap);
                        continue;
                    }
                    boolean processed = false;
                    String dialect = pconfig.getDialect();
                    String keyword = pconfig.getKeyword();
                    Class elemSelector = IntegralDialectElementSelector.class;
                    if (dialect.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER)) {
                        cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
                        cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
                        elemSelector = QNameHeaderSelector.class;
                    }
                    OMDocument doc2 = doc;
                    int docOrder = -1;
                    while (doc2 != null) {
                        parts = SignatureGenerator.getMessagePart(doc2, dialect, keyword, "signature_mode", this._selectors, elemSelector, cpSelectorMap);
                        if (parts != null && parts.size() > 0) {
                            processed = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, parts.size() + " parts found.");
                            }
                            for (int j = 0; j < parts.size(); ++j) {
                                OMElement part = (OMElement)parts.get(j);
                                if (docOrder >= 0) {
                                    Reference ref;
                                    String idname;
                                    RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, part, docOrder);
                                    if (eobj == null) continue;
                                    if (eobj.getEncryptedData() != null) {
                                        idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getEncryptedData(), nsWsu, context);
                                        ref = gen.createReference(idname);
                                        ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                        SignatureGenerator.addTransforms(ref, doc, omFactory, eobj.getEncryptedData(), srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                                        gen.addReference(ref);
                                        signSomething = true;
                                        list.add(part);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Added the encrypted data[" + DOMUtils.getDisplayName(eobj.getEncryptedData()) + "] because the element[" + DOMUtils.getDisplayName(part) + "] has already encrypted.");
                                        }
                                    }
                                    if (eobj.getHeaderInfo() == null) continue;
                                    idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getHeaderInfo(), nsWsu, context);
                                    ref = gen.createReference(idname);
                                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms(ref, doc, omFactory, eobj.getHeaderInfo(), srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                                    gen.addReference(ref);
                                    signSomething = true;
                                    list.add(part);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Added the header info[" + DOMUtils.getDisplayName(eobj.getHeaderInfo()) + "] because the element[" + DOMUtils.getDisplayName(part) + "] has already encrypted.");
                                    continue;
                                }
                                String idname = DOMUtils.equals(part, root) ? "" : "#" + SignatureGenerator.addWsuId(doc, part, nsWsu, context);
                                Reference ref = gen.createReference(idname);
                                ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms(ref, doc, omFactory, part, srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                                gen.addReference(ref);
                                signSomething = true;
                                list.add(part);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Added the element[" + DOMUtils.getDisplayName(part) + "].");
                            }
                            processed = true;
                            continue block13;
                        }
                        processed = true;
                        doc2 = RequestMessagePool.getDocument(context, ++docOrder);
                    }
                }
            }
        }
        if (!signSomething && !signSpecial) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        boolean addDummy = false;
        if (!signSomething) {
            addDummy = true;
            Reference ref = gen.createReference("#dummy001");
            gen.addReference(ref);
        }
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        AlgorithmConfig aconfig = config2.getSignatureMethod();
        OMElement signature = null;
        try {
            AlgorithmParameterSpec spec = afactory.convertParameter(aconfig.getAlgorithm(), aconfig.getProperties());
            if (spec != null) {
                gen.setSignatureMethodParameter(spec);
            }
            signature = gen.getSignatureElement(afactory);
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.processException(e, clsName + ".invoke", "424");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException(e, clsName + ".invoke", "428");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            Tr.processException(e, clsName + ".invoke", "432");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (gconfig.isUserDefinedComponentsUsed()) {
            OMElement keyInfo = omFactory.createOMElement("KeyInfo", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
            signature.addChild(keyInfo);
        }
        signature = SignatureGenerator.insertSignatureElement(parent, signature);
        TimestampGeneratorConfig tgconfig = gconfig.getTimestampGenerator();
        if (tgconfig != null && !tgconfig.isDefault()) {
            TimestampGenerator.moveTimestamp(doc, gconfig.getTimestampGenerator(), this._selectors, context);
        }
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", config2.getSignatureMethod().getAlgorithm());
        Key key = SignatureGenerator.callKeyInfoGenerator(config2.getSigningKeyInfo(), "SigningKey", type, this._selectors, doc, signature, context);
        OMElement sinfo = DOMUtils.getOneChildElement(signature, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "SignedInfo");
        if (config2.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(canonicalizationMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(canonicalizationMethod)) && (inc = SignatureGenerator.createInclusiveNamespaces(omFactory, c14nElem = DOMUtils.getOneChildElement(sinfo, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "CanonicalizationMethod"))) != null) {
            c14nElem.addChild(inc);
        }
        if (addDummy) {
            OMElement reference = DOMUtils.getOneChildElement(sinfo, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "Reference");
            reference.detach();
        }
        if (signSpecial) {
            block16: for (ReferencePartConfig.PartConfig pconfig : specials1) {
                srconfig = (SigningReferenceConfig)specials2.get(pconfig);
                Map cpSelectorMap = (Map)specials3.get(pconfig);
                boolean processed = false;
                String dialect = pconfig.getDialect();
                String keyword = pconfig.getKeyword();
                OMDocument doc2 = doc;
                int docOrder = -1;
                while (doc2 != null) {
                    parts = SignatureGenerator.getSpecialPart(doc2, pconfig, "signature_mode", this._selectors, cpSelectorMap);
                    if (parts != null && parts.size() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, parts.size() + " parts found.");
                        }
                        processed = false;
                        for (int j = 0; j < parts.size(); ++j) {
                            OMElement part = (OMElement)parts.get(j);
                            if (docOrder >= 0) {
                                Reference ref;
                                String idname;
                                RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, part, docOrder);
                                if (eobj == null) continue;
                                if (eobj.getEncryptedData() != null) {
                                    idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getEncryptedData(), nsWsu, context);
                                    ref = gen.createReference(idname);
                                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms(ref, doc, omFactory, eobj.getEncryptedData(), srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                                    sinfo.addChild(ref.getReferenceElement());
                                    list.add(part);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Added the encrypted data[" + DOMUtils.getDisplayName(eobj.getEncryptedData()) + "] because the element[" + DOMUtils.getDisplayName(part) + "] has already encrypted.");
                                    }
                                }
                                if (eobj.getHeaderInfo() == null) continue;
                                idname = "#" + SignatureGenerator.addWsuId(doc, eobj.getHeaderInfo(), nsWsu, context);
                                ref = gen.createReference(idname);
                                ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms(ref, doc, omFactory, eobj.getHeaderInfo(), srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                                sinfo.addChild(ref.getReferenceElement());
                                list.add(part);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Added the header info[" + DOMUtils.getDisplayName(eobj.getHeaderInfo()) + "] because the element[" + DOMUtils.getDisplayName(part) + "] has already encrypted.");
                                continue;
                            }
                            String idname = DOMUtils.equals(part, root) ? "" : "#" + SignatureGenerator.addWsuId(doc, part, nsWsu, context);
                            Reference ref = gen.createReference(idname);
                            ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                            SignatureGenerator.addTransforms(ref, doc, omFactory, part, srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                            sinfo.addChild(ref.getReferenceElement());
                            list.add(part);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Added the element[" + DOMUtils.getDisplayName(part) + "].");
                        }
                        processed = true;
                        continue block16;
                    }
                    processed = true;
                    doc2 = RequestMessagePool.getDocument(context, ++docOrder);
                }
            }
        }
        if (signNonce) {
            Object[] objs = list.toArray();
            for (ReferencePartConfig.PartConfig pconfig : nonces1) {
                srconfig = (SigningReferenceConfig)nonces2.get(pconfig);
                Map cpSelectorMap = (Map)nonces3.get(pconfig);
                parts = SignatureGenerator.getNoncePart(doc, objs, pconfig, "signature_mode", this._selectors, IntegralDialectElementSelector.class, cpSelectorMap);
                if (parts == null || parts.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, parts.size() + " parts found.");
                }
                for (int j = 0; j < parts.size(); ++j) {
                    OMElement part = (OMElement)parts.get(j);
                    String idname = DOMUtils.equals(part, root) ? "" : "#" + SignatureGenerator.addWsuId(doc, part, nsWsu, context);
                    Reference ref = gen.createReference(idname);
                    ref.setDigestMethod(srconfig.getDigestMethod().getAlgorithm());
                    SignatureGenerator.addTransforms(ref, doc, omFactory, part, srconfig.getTransforms(), pWsse, nsWsse, config2.addInclusiveNamespaces(), isGoldenPath, context);
                    sinfo.addChild(ref.getReferenceElement());
                    list.add(part);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the element[" + DOMUtils.getDisplayName(part) + "].");
                }
            }
        }
        if (gconfig.doIndentation()) {
            DOMUtils.indent(signature, 6, 2);
            signature.insertSiblingBefore(omFactory.createOMText("\n      "));
        }
        WSSSignatureContext scontext = new WSSSignatureContext();
        if (tc.isDebugEnabled()) {
            scontext.setResourceShower(ShowerImpl.getInstance());
        }
        scontext.setIDResolver(this._idResolver);
        scontext.setAlgorithmFactory(afactory);
        scontext.setDocument(doc);
        if (config2.getKeyInfoSignature() != null) {
            scontext.setKeyInfoSignature(config2.getKeyInfoSignature().getAlgorithm());
        } else {
            scontext.setKeyInfoSignature(null);
        }
        if (isGoldenPath) {
            scontext.setContext(context);
        }
        scontext.setOnlySignEntireHeadersAndBody(gconfig.isOnlySignEntireHeadersAndBody());
        if (context.get(com.ibm.ws.wssecurity.common.Constants.ADD_INC_NAMESPACES_FOR_STRD) != null) {
            scontext.setInclusiveNamespacesForSTRDT((Boolean)context.get(com.ibm.ws.wssecurity.common.Constants.ADD_INC_NAMESPACES_FOR_STRD));
        }
        HashSet<Configuration> dsigKConfig = new HashSet<Configuration>();
        HashSet<Configuration> encKConfig = new HashSet<Configuration>();
        for (Configuration configuration : gconfig.getOperationGenerators()) {
            if (configuration instanceof SignatureGeneratorConfig) {
                dsigKConfig.add(((SignatureGeneratorConfig)configuration).getSigningKeyInfo());
                continue;
            }
            if (!(configuration instanceof EncryptionGeneratorConfig)) continue;
            encKConfig.add(((EncryptionGeneratorConfig)configuration).getEncryptionKeyInfo());
        }
        STRDTKeyInfoResolver skiResolver = new STRDTKeyInfoResolver();
        skiResolver.setContext(context);
        skiResolver.setSelectors(this._selectors);
        skiResolver.setDsigKeyInfoSet(dsigKConfig);
        skiResolver.setEncKeyInfoSet(encKConfig);
        skiResolver.setGeneration(true);
        scontext.setSTRDTKeyInfoResolver(skiResolver);
        String sigAlgorithm = null;
        AlgorithmConfig sigMethod = config2.getSignatureMethod();
        if (sigMethod != null) {
            sigAlgorithm = sigMethod.getAlgorithm();
        }
        scontext.setSigAlgorithm(sigAlgorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signature Algorithm = " + sigAlgorithm);
        }
        Map<Object, Object> props = config2.getProperties();
        Map<Object, Object> gprops = gconfig.getProperties();
        scontext.setHWConfigName((String)gprops.get("HWCONFIG"));
        scontext.setOffload(Boolean.TRUE);
        if (scontext.shouldChangeProvider()) {
            Provider p1;
            HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + scontext.getHWConfigName());
            }
            if ((p1 = ConfigUtil.getHWCryptoProviderInstance(scontext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                scontext.setHWAccelerationProvider(p1);
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                fHWKeyCache.setProvider(p1, hardwareCacheSize);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + p1.getName());
                }
            }
            try {
                key = fHWKeyCache.translate(key);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e);
            }
        }
        scontext.setHWKeyStoreName((String)props.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        if (scontext.useHWKeyStore()) {
            Provider p2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + scontext.getHWKeyStoreName());
            }
            if ((p2 = ConfigUtil.getHWCryptoProviderInstance(scontext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                scontext.setHWKeyStoreProvider(p2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + p2.getName());
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        try {
            OMElement signatureValue;
            OMElement signatureWithValue = scontext.sign(signature, key);
            List signatureCache = (List)context.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            if (signatureCache != null && (signatureValue = DOMUtil.getFirstChildElementNamed(signatureWithValue, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue")) != null) {
                String sigValue = DOMUtil.getStringValue(signatureValue);
                signatureCache.add(sigValue);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached signature value for SignatureConfirmation: " + sigValue);
                }
            }
        }
        catch (XSignatureException e) {
            Exception ex = e.getException();
            Tr.processException(ex, clsName + ".invoke", "711");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s12", ex);
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s12", new String[]{ex.getMessage()}, (Throwable)ex);
        }
        finally {
            if (scontext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(scontext.getHWConfigName(), scontext.getHWAccelerationProvider());
            }
            if (scontext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(scontext.getHWKeyStoreName(), scontext.getHWKeyStoreProvider());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
        }
    }

    public static ArrayList<OMNode> getMessagePart(OMDocument doc, String dialect, String keyword, String type, Map<Object, Object> selectors, Class dialectSelector, Map<Object, Object> selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessagePart(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "]," + "String type[" + type + "]," + "Map selectors," + "Class dialectSelector[" + dialectSelector + "]," + "Map selectorMap)");
        }
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", type);
        ElementSelector esel = null;
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(dialectSelector);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
            esel = (ElementSelector)selectors.get(QNameHeaderSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        ArrayList<OMNode> list = esel.getElements(doc.getOMDocumentElement(), selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getMessagePart returns an OMNodeList. Contents follow:");
            CommonLogUtils.logDebug(list, tc);
            Tr.exit(tc, "getMessagePart(OMDocument doc,String dialect,String keyword,String type,Map selectors,Class dialectSelector,Map selectorMap,Map context) returns NodeList[list]");
        }
        return list;
    }

    private static ArrayList<OMNode> getSpecialPart(OMDocument doc, ReferencePartConfig.PartConfig pconfig, String type, Map selectors, Map<Object, Object> selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecialPart(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "PartConfig pconfig[" + pconfig + "]," + "String type[" + type + "]," + "Map selectors," + "Map selectorMap)");
        }
        String dialect = pconfig.getDialect();
        String keyword = pconfig.getKeyword();
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", type);
        ElementSelector esel = (ElementSelector)selectors.get(IntegralDialectElementSelector.class);
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        }
        ArrayList<OMNode> list = esel.getElements(doc.getOMDocumentElement(), selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getSpecialPart returns an OMNodeList. Contents follow:");
            CommonLogUtils.logDebug(list, tc);
            Tr.exit(tc, "getSpecialPart(OMDocument doc,PartConfig pconfig,String type,Map selectors,Map selectorMap) returns NodeList[list]");
        }
        return list;
    }

    public static ArrayList<OMNode> getNoncePart(OMDocument doc, Object[] parents, ReferencePartConfig.PartConfig pconfig, String type, Map<Object, Object> selectors, Class dialectSelector, Map<Object, Object> selectorMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNoncePart(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "Object[] parents[" + parents + "]," + "PartConfig pconfig[" + pconfig + "]," + "String type[" + type + "]," + "Map selectors," + "Class dialectSelector[" + dialectSelector + "]," + "Map selectorMap)");
        }
        String dialect = pconfig.getDialect();
        String keyword = pconfig.getKeyword();
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", type);
        if (parents != null) {
            selectorMap.put("com.ibm.ws.wssecurity.util.selector.element", parents);
        }
        if (pconfig.isTimestamp()) {
            selectorMap.put("com.ibm.ws.util.selector.processType", "timestamp");
        } else if (pconfig.isNonce()) {
            selectorMap.put("com.ibm.ws.util.selector.processType", "nonce");
        }
        ElementSelector esel = null;
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(dialectSelector);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
            esel = (ElementSelector)selectors.get(QNameHeaderSelector.class);
            selectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
            selectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        ArrayList<OMNode> list = esel.getElements(doc.getOMDocumentElement(), selectorMap);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getNoncePart returns an OMNodeList. Contents follow:");
            CommonLogUtils.logDebug(list, tc);
            Tr.exit(tc, "getNoncePart(OMDocument doc,Object[] parents,PartConfig pconfig,String typeMap selectors,Class dialectSelector,Map selectorMap) returns ArrayList[list]");
        }
        return list;
    }

    private static String addWsuId(OMDocument doc, OMElement part, String nsWsu, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWsuId(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement part[" + DOMUtils.getDisplayName(part) + "]," + "String nsWsu[" + nsWsu + "]," + "Map context");
        }
        String idname = null;
        QName attrname = IdUtils.getInstance().getIdAttributeName(part);
        if (attrname != null) {
            idname = part.getAttributeValue(attrname);
        }
        if (idname == null || idname.length() == 0) {
            String ns = part.getNamespace() == null ? null : part.getNamespace().getName();
            String ln = part.getLocalName();
            int nsHash = ns == null ? 0 : ns.hashCode();
            int hash = nsHash * 31;
            hash += ln == null ? 0 : ln.hashCode();
            if (nsHash == com.ibm.ws.wssecurity.common.Constants.HASH_DS) {
                if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATURE || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREVALUE || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNEDINFO || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_REFERENCE || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_KEYINFO || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_OBJECT || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_MANIFEST || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREPROPS || hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREPROP) {
                    idname = IdUtils.getInstance().makeUniqueId(context, "wssecurity_signature_id_");
                    part.addAttribute("Id", idname, null);
                }
            } else if (nsHash == com.ibm.ws.wssecurity.common.Constants.HASH_ENC && (hash == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTEDKEY || hash == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTEDDATA || hash == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTIONPROPS || hash == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTIONPROP)) {
                idname = IdUtils.getInstance().makeUniqueId(context, "wssecurity_signature_id_");
                part.addAttribute("Id", idname, null);
            }
            if (idname == null) {
                idname = IdUtils.getInstance().makeUniqueId(context, "wssecurity_signature_id_");
                String prefix = DOMUtils.getNamespacePrefix(part, nsWsu);
                if (prefix == null) {
                    prefix = "wsu";
                }
                part.declareNamespace(nsWsu, prefix);
                part.addAttribute("Id", idname, part.getOMFactory().createOMNamespace(nsWsu, prefix));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWsuId(Document doc,Element part,String nsWsu,Map context) returns String[" + idname + "]");
        }
        return idname;
    }

    private static void addTransforms(Reference ref, OMDocument doc, OMFactory factory, OMElement part, List config2, String pWsse, String nsWsse, boolean addIncNS, boolean isGoldenPath, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransforms(Reference gen[" + ref + "]," + "OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMFactory factory[" + factory + "]," + "OMElement part[" + DOMUtils.getDisplayName(part) + "]," + "List config[" + config2 + "]," + "String pWsse[" + pWsse + "]," + "String nsWsse[" + nsWsse + "]," + "boolean addIncNS[" + addIncNS + "])");
        }
        for (AlgorithmConfig aconfig : config2) {
            String transform = aconfig.getAlgorithm();
            Map<Object, Object> properties = aconfig.getProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the transform [" + transform + "]...");
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(transform) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(transform)) {
                ref.addTransform(SignatureGenerator.createInclusiveTransform(factory, part, transform, addIncNS, isGoldenPath));
                continue;
            }
            if ("http://www.w3.org/2002/07/decrypt#XML".equals(transform)) {
                Set<String> ids = SignatureGenerator.collectIdsOfEncryptedData(part, context);
                ref.addTransform(SignatureGenerator.createDecryptionTransform(factory, ids, transform));
                continue;
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transform)) {
                ref.addTransform(SignatureGenerator.createSTRTransform(factory, part, transform, pWsse, nsWsse, addIncNS));
                if (!addIncNS) continue;
                context.put(com.ibm.ws.wssecurity.common.Constants.ADD_INC_NAMESPACES_FOR_STRD, addIncNS);
                continue;
            }
            if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(transform)) {
                ref.addTransform(SignatureGenerator.createXPathTransform(factory, transform, properties));
                continue;
            }
            if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(transform)) {
                ref.addTransform(SignatureGenerator.createXPath2Transform(factory, transform, properties));
                continue;
            }
            ref.addTransform(transform);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransforms(Reference gen,OMDocument doc,OMFactory factory,OMElement part,List config,String pWsse,String nsWsse,boolean addIncNS)");
        }
    }

    private static OMElement createInclusiveTransform(OMFactory factory, OMElement part, String transform, boolean addIncNS, boolean isGoldenPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveTransform(OMFactory factory[" + factory + "]," + "OMElement part[" + DOMUtils.getDisplayName(part) + "]," + "String transform[" + transform + "]," + "boolean addIncNS[" + addIncNS + "])");
        }
        OMElement tr = factory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        tr.addAttribute("Algorithm", transform, null);
        if (addIncNS) {
            OMNode child;
            if (isGoldenPath && part instanceof SOAPBody && (child = part.getFirstOMChild()) != null && child instanceof OMSourcedElementImpl) {
                return tr;
            }
            OMElement inc = SignatureGenerator.createInclusiveNamespaces(factory, part);
            if (inc != null) {
                tr.addChild(inc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveTransform(OMFactory factory,OMElement part,String transform,boolean addIncNS) returns Element[" + DOMUtils.getDisplayName(tr) + "]");
        }
        return tr;
    }

    private static OMElement createInclusiveNamespaces(OMFactory factory, OMElement part) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveNamespaces(OMFactory factory[" + factory + "]," + "OMElement part[" + DOMUtils.getDisplayName(part) + "])");
        }
        StringBuffer buffer = null;
        if (part != null && part instanceof SOAPElementImpl) {
            Iterator nsListIter = ((SOAPElementImpl)((Object)part)).getNamespacePrefixes();
            if (nsListIter != null) {
                buffer = new StringBuffer();
                OMNamespace attr = null;
                while (nsListIter.hasNext()) {
                    attr = (OMNamespace)nsListIter.next();
                    if (attr instanceof OMNamespaceWithOwner) continue;
                    String prefix = attr.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        buffer.append("#default ");
                        continue;
                    }
                    buffer.append(prefix);
                    buffer.append(" ");
                }
            }
        } else {
            OMNode cur = part;
            HashSet<String> prefixes = new HashSet<String>();
            while (cur != null && cur.getType() == 1) {
                Iterator i = cur.getAllDeclaredNamespaces();
                while (i.hasNext()) {
                    OMNamespace ns = (OMNamespace)i.next();
                    if (ns instanceof OMNamespaceWithOwner) continue;
                    String prefix = ns.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        prefixes.add("#default");
                        continue;
                    }
                    prefixes.add(prefix);
                }
                OMContainer parent = cur.getParent();
                if (parent instanceof OMDocument) break;
                cur = (OMNode)((Object)parent);
            }
            SignatureGenerator.scanNamespaceDecls(part, prefixes);
            if (prefixes.size() > 0) {
                buffer = new StringBuffer();
                Iterator iter = prefixes.iterator();
                while (iter.hasNext()) {
                    buffer.append(iter.next());
                    buffer.append(" ");
                }
            }
        }
        OMElement inc = null;
        if (buffer != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "node search generated PrefixList: " + buffer);
            }
            inc = factory.createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            inc.declareNamespace("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            inc.addAttribute("PrefixList", new String(buffer), null);
        } else if (tc.isEntryEnabled()) {
            Tr.debug(tc, "node search generated an empty list");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveNamespaces(OMFactory factory,OMElement part) returns OMElement[" + DOMUtils.getDisplayName(inc) + "]");
        }
        return inc;
    }

    private static void scanNamespaceDecls(OMNode node, Set<String> prefixes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanNamespaceDecls(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "Set prefixes[" + prefixes + "])");
        }
        if (node.getType() == 1) {
            Iterator nss = ((OMElement)node).getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefixes.add("#default");
                    continue;
                }
                prefixes.add(prefix);
            }
            for (OMNode n = ((OMElement)node).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                if (n.getType() != 1) continue;
                SignatureGenerator.scanNamespaceDecls(n, prefixes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanNamespaceDecls(OMNode node, Set prefixes)");
        }
    }

    private static void scanNamespaceDecls(OMNode node, Set<String> prefixes, String nsWsse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanNamespaceDecls(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "Set prefixes[" + prefixes + "String nsWsse[" + nsWsse + "])");
        }
        if (node.getType() == 1) {
            Iterator nss = ((OMElement)node).getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefixes.add("#default");
                    continue;
                }
                prefixes.add(prefix);
            }
            for (OMNode n = ((OMElement)node).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                if (n.getType() != 1 || DOMUtils.equals(n, nsWsse, "SecurityTokenReference")) continue;
                SignatureGenerator.scanNamespaceDecls(n, prefixes, nsWsse);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanNamespaceDecls(OMNode node, Set prefixes, String nsWsse)");
        }
    }

    private static Set<String> collectIdsOfEncryptedData(OMNode node, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectIdsOfEncryptedData(OMNode node[" + DOMUtils.getDisplayName(node) + "])");
        }
        HashSet<String> ids = new HashSet<String>();
        if (node != null) {
            SignatureGenerator.collectIdsOfEncryptedData(node, ids, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectIdsOfEncryptedData(OMNode node) returns Set[" + ids + "]");
        }
        return ids;
    }

    private static void collectIdsOfEncryptedData(OMNode node, Set<String> ids, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectIdsOfEncryptedData(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "Set ids[" + ids + "])");
        }
        if (node.getType() == 1) {
            if (EncryptedData.isOfType((OMElement)node)) {
                OMElement ed = (OMElement)node;
                String id = ed.getAttributeValue(ID_Q);
                if (id == null) {
                    id = IdUtils.getInstance().makeUniqueId(context, "wssecurity_encryption_id_");
                    ed.addAttribute("Id", id, null);
                }
                ids.add(id);
            } else {
                for (OMNode n = ((OMElement)node).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                    if (n.getType() != 1 && n.getType() != 9) continue;
                    SignatureGenerator.collectIdsOfEncryptedData(n, ids, context);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectIdsOfEncryptedData(OMNode node, Set ids)");
        }
    }

    private static OMElement createDecryptionTransform(OMFactory factory, Set<String> ids, String transform) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionTransform(OMFactory factory[" + factory + "]," + "Set ids[" + ids + "]," + "String transform[" + transform + "])");
        }
        OMElement tr = factory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        tr.addAttribute("Algorithm", transform, null);
        DOMUtils.declareDecryptionNamespace(tr);
        for (String id : ids) {
            OMElement ex = DOMUtils.createDecryptionOMElement("Except", factory, tr);
            ex.addAttribute("URI", "#" + id, null);
            tr.addChild(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionTransform(OMFactory factory,Set ids) returns OMElement[" + DOMUtils.getDisplayName(tr) + "]");
        }
        return tr;
    }

    private static OMElement createSTRTransform(OMFactory factory, OMElement part, String transform, String pWsse, String nsWsse, boolean addIncNS) {
        String prefix;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTRTransform(OMFactory factory[" + factory + "]," + "OMElement part[" + DOMUtils.getDisplayName(part) + "]," + "String transform[" + transform + "]," + "String pWsse[" + pWsse + "]," + "String nsWsse[" + nsWsse + "]," + "boolean addIncNS[" + addIncNS + "])");
        }
        OMNode cur = part;
        HashSet<String> prefixes = new HashSet<String>();
        OMContainer parent = cur.getParent();
        boolean isSTR = false;
        if (DOMUtils.equals(part, nsWsse, "SecurityTokenReference")) {
            cur = (OMNode)((Object)parent);
            isSTR = true;
        }
        while (cur != null && cur.getType() == 1) {
            Iterator nss = ((OMElement)cur).getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                prefix = ns.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefixes.add("#default");
                    continue;
                }
                prefixes.add(prefix);
            }
            parent = cur.getParent();
            if (parent instanceof OMDocument) break;
            cur = (OMNode)((Object)parent);
        }
        if (!isSTR) {
            SignatureGenerator.scanNamespaceDecls(part, prefixes, nsWsse);
        }
        OMElement tr = factory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        tr.addAttribute("Algorithm", transform, null);
        boolean addNsDecl = false;
        prefix = pWsse;
        if (prefix == null) {
            prefix = "wsse";
            addNsDecl = true;
        }
        OMElement tp = factory.createOMElement("TransformationParameters", nsWsse, prefix);
        if (addNsDecl) {
            tp.declareNamespace(nsWsse, "wsse");
        }
        tr.addChild(tp);
        OMElement cm = factory.createOMElement("CanonicalizationMethod", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        cm.addAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#", null);
        tp.addChild(cm);
        if (addIncNS && prefixes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = prefixes.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                buffer.append(" ");
            }
            OMElement inc = factory.createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            inc.declareNamespace("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            inc.addAttribute("PrefixList", new String(buffer), null);
            cm.addChild(inc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTRTransform(OMFactory factory,OMElement part,String transform,String pWsse,String nsWsse,boolean addIncNS) returns OMElement[" + DOMUtils.getDisplayName(tr) + "]");
        }
        return tr;
    }

    public static OMElement createXPathTransform(OMFactory factory, String transform, Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXPathTransform(OMFactory factory[" + factory + "]," + "String transform[" + transform + "]," + "Map properties)");
        }
        String value = (String)properties.get(Constants.WSSECURITY_XPATH_EXPRESSION);
        OMElement tr = factory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        tr.addAttribute("Algorithm", transform, null);
        OMElement xpath = factory.createOMElement("XPath", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        tr.addChild(xpath);
        OMText expression = factory.createOMText(value);
        xpath.addChild(expression);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createXPathTransform(OMFactory factory,String transform,Map properties) returns OMElement[" + DOMUtils.getDisplayName(tr) + "]");
        }
        return tr;
    }

    public static OMElement createXPath2Transform(OMFactory factory, String transform, Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXPath2Transform(OMFactory doc[" + factory + "]," + "String transform[" + transform + "]," + "Map properties)");
        }
        OMElement tr = factory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        tr.addAttribute("Algorithm", transform, null);
        HashMap<String, Integer> id2Order = new HashMap<String, Integer>();
        HashMap<String, String> id2Filter = new HashMap<String, String>();
        HashMap<String, String> id2Expression = new HashMap<String, String>();
        String orderStr = Constants.WSSECURITY_XPATH2_ORDER + "_";
        String filterStr = Constants.WSSECURITY_XPATH2_FILTER + "_";
        String expressionStr = Constants.WSSECURITY_XPATH2_EXPRESSION + "_";
        for (String string : properties.keySet()) {
            String value = (String)properties.get(string);
            if (string.startsWith(expressionStr)) {
                id2Expression.put(string.substring(expressionStr.length()), value);
                continue;
            }
            if (string.startsWith(filterStr)) {
                id2Filter.put(string.substring(filterStr.length()), value);
                continue;
            }
            if (!string.startsWith(orderStr)) continue;
            id2Order.put(string.substring(orderStr.length()), new Integer(value));
        }
        int size = id2Order.keySet().size();
        if (size > 0) {
            String[] stringArray = new String[size];
            int[] orders = new int[size];
            int pos = -1;
            Iterator i = id2Order.keySet().iterator();
            while (i.hasNext()) {
                ++pos;
                String id = (String)i.next();
                int order = (Integer)id2Order.get(id);
                boolean inserted = false;
                for (int j = 0; j < pos; ++j) {
                    if (order >= orders[j]) continue;
                    for (int k = pos - 1; k >= j; --k) {
                        stringArray[k + 1] = stringArray[k];
                        orders[k + 1] = orders[k];
                    }
                    stringArray[j] = id;
                    orders[j] = order;
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                stringArray[pos] = id;
                orders[pos] = order;
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String filter = (String)id2Filter.get(stringArray[i2]);
                String expression = (String)id2Expression.get(stringArray[i2]);
                OMElement xpath = factory.createOMElement("XPath", "http://www.w3.org/2002/06/xmldsig-filter2", "dsf2");
                xpath.declareNamespace("http://www.w3.org/2002/06/xmldsig-filter2", "dsf2");
                xpath.addAttribute("Filter", filter, null);
                tr.addChild(xpath);
                OMText text = factory.createOMText(expression);
                xpath.addChild(text);
                tr.addChild(xpath);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createXPathTransform(OMFactory factory,String transform,Map properties) returns OMElement[" + DOMUtils.getDisplayName(tr) + "]");
        }
        return tr;
    }

    protected static void prepareTransform(SigningReferenceConfig srconfig, Map<Object, Object> selectorMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTransform(SigningReferenceConfig srconfig],Map selectorMap)");
        }
        boolean existSTRTransform = false;
        for (AlgorithmConfig aconfig : srconfig.getTransforms()) {
            String transform = aconfig.getAlgorithm();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(transform)) continue;
            existSTRTransform = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "STR-Transform transform found.");
        }
        if (existSTRTransform) {
            selectorMap.put("security.wssecurity.integraldialectelementselector.existstrtransform", Boolean.toString(existSTRTransform));
        } else {
            selectorMap.remove("security.wssecurity.integraldialectelementselector.existstrtransform");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTransform(SigningReferenceConfig srconfig,Map selectorMap)");
        }
    }

    public static Key callKeyInfoGenerator(KeyInfoGeneratorConfig config2, String keytype, Map<Object, Object> type, Map<Object, Object> properties, OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype[" + keytype + "]," + "Map type," + "Map properties," + "OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        KeyInfoGenerator gen = (KeyInfoGenerator)properties.get(KeyInfoGenerator.class);
        type.clear();
        type.put(Constants.WSSECURITY_KEY_TYPE, keytype);
        context.put("com.ibm.ws.wssecurity.impl.config.keyinfoGenerator.configKey", config2);
        Key key = gen.getKey(doc, parent, type, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype,Map type,Map properties,OMDocument doc,OMElement parent,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    private static OMElement insertSignatureElement(OMElement parent, OMElement elem) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertSignatureElement(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "OMElement elem[" + DOMUtils.getDisplayName(elem) + "])");
        }
        String lnSign = "Signature";
        String lnEncKey = "EncryptedKey";
        String lnRefList = "ReferenceList";
        OMNode nextElem = null;
        OMElement lastElem = null;
        if (parent != null) {
            OMElement el = DOMUtils.getFirstElement(parent);
            while (el != null) {
                lastElem = el;
                String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
                String ln = el.getLocalName();
                if (com.ibm.ws.wssecurity.common.Constants.NS_ENC.equals(ns) && (lnEncKey.equals(ln) || lnRefList.equals(ln)) || com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(ns) && lnSign.equals(ln)) {
                    nextElem = el;
                    break;
                }
                el = DOMUtils.getNextElement(el);
            }
        }
        if (lastElem == null) {
            parent.addChild(elem);
        } else if (nextElem == null) {
            parent.addChild(elem);
        } else {
            nextElem.insertSiblingBefore(elem);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertSignatureElement(OMElement parent,OMElement elem) returns Element[" + DOMUtils.getDisplayName(elem) + "]");
        }
        return elem;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, int offset, int length, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content, offset, length);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

