/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.VerificationResult;
import com.ibm.ws.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonContentConsumer;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.SameDocumentEncryptedKeyRetriever;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.ByteArrayInputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class SignatureConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(SignatureConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureConsumer.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private static final QName TYPE_Q = new QName("", "Type");
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        OMElement signatureValue;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtils.getDisplayName(target) + "]," + "Map context)");
        }
        int hash = 0;
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "ds:Signature");
        }
        if (target.getType() == 1) {
            OMElement el = (OMElement)target;
            String ns = el.getNamespace() == null ? null : el.getNamespace().getName();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) != com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATURE) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(target));
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(target));
        }
        OMElement signature = (OMElement)target;
        IDResolver resolver2 = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        obj = context.remove("com.ibm.ws.wssecurity.constants.copiedDOMTree");
        boolean domRequired = ConfigUtil.isTrue((String)obj);
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        SignatureConsumerConfig config2 = (SignatureConsumerConfig)context.remove("com.ibm.ws.wssecurity.impl.config.signatureConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureConsumerConfig [" + config2 + "].");
        }
        OMDocument doc = DOMUtil.getOwnerDocument(signature);
        SignatureObject signatureObject = new SignatureObject();
        signatureObject.setOwnerDocument(doc);
        VerificationResult vresult = SignatureConsumer.checkSignature(doc, signature, gconfig, config2, resolver2, nsWsse, nsWsu, domRequired, signatureObject, context);
        if (vresult._domRequired) {
            doc = vresult._copiedDOM;
            ArrayList<OMNode> list = DOMUtils.getOneOrMoreElements(doc.getOMDocumentElement(), com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "Signature");
            for (int i = 0; i < list.size(); ++i) {
                if (!DOMUtils.equals(signature, list.get(i))) continue;
                signature = (OMElement)list.get(i);
                break;
            }
        }
        HashMap<Object, Object> type = new HashMap<Object, Object>(2);
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", config2.getSignatureMethod().getAlgorithm());
        Key key = SignatureConsumer.callKeyInfoConsumer(config2.getSigningKeyInfo(), "VerifyingKey", type, this._selectors, KeyInfo.searchForKeyInfo(signature), context);
        SignatureConsumer.verify(signature, key, gconfig, config2, resolver2, doc, vresult, this._selectors, signatureObject, context);
        SignatureConsumer.setVerificationResult(vresult, config2, context);
        List signatureCache = (List)context.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
        if (signatureCache != null && (signatureValue = DOMUtil.getFirstChildElementNamed(signature, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue")) != null) {
            String sigValue = DOMUtil.getStringValue(signatureValue);
            signatureCache.add(sigValue);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cached signature value for SignatureConfirmation: " + sigValue);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Node target, Map context)");
        }
    }

    private static VerificationResult checkSignature(OMDocument doc, OMElement signature, WSSConsumerConfig gconfig, SignatureConsumerConfig config2, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, SignatureObject signatureObject, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignature(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element signature[" + DOMUtils.getDisplayName(signature) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "SignatureObject signatureObject[" + signatureObject + "]," + "Map context)");
        }
        VerificationResult vresult = new VerificationResult(config2);
        int hash = 0;
        OMElement el = DOMUtils.getFirstElement(signature);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNEDINFO) {
                signatureObject.setSignedInfoElement(el);
                SignatureConsumer.checkSignedInfo(doc, el, gconfig, config2, vresult, idResolver, nsWsse, nsWsu, domRequired, signatureObject, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_KEYINFO) {
                signatureObject.setKey(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREVALUE) {
                signatureObject.setSignatureValue(DOMUtil.getStringValue(el));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_OBJECT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(signature)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignature(Document doc,Element signature,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,SignatureObject signatureObject,Map context) returns VerificationResult[" + vresult + "]");
        }
        return vresult;
    }

    private static void checkSignedInfo(OMDocument doc, OMElement sinfo, WSSConsumerConfig gconfig, SignatureConsumerConfig config2, VerificationResult vresult, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, SignatureObject signatureObject, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignedInfo(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element sinfo[" + DOMUtils.getDisplayName(sinfo) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "VerificationResult vresult[" + vresult + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "SignatureObject signatureObject[" + signatureObject + "]," + "Map context)");
        }
        int hash = 0;
        OMElement el = DOMUtils.getFirstElement(sinfo);
        while (el != null) {
            String algorithm2;
            String algorithm1;
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_C14NMETHOD) {
                algorithm1 = DOMUtils.getAttribute(el, "Algorithm");
                algorithm2 = null;
                if (config2.getCanonicalizationMethod() != null) {
                    algorithm2 = config2.getCanonicalizationMethod().getAlgorithm();
                }
                if (algorithm2 == null || !algorithm2.equals(algorithm1) || !gconfig.getAllowedCanonicalizationMethods().contains(algorithm1)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s08", algorithm1);
                }
                signatureObject.setC14NMethod(algorithm1);
                signatureObject.setC14NMethodElement(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm1 + "] is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREMETHOD) {
                algorithm1 = DOMUtils.getAttribute(el, "Algorithm");
                algorithm2 = null;
                if (config2.getSignatureMethod() != null) {
                    algorithm2 = config2.getSignatureMethod().getAlgorithm();
                }
                if (algorithm2 == null || !algorithm2.equals(algorithm1) || !gconfig.getAllowedSignatureMethods().contains(algorithm1)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s09", algorithm1);
                }
                signatureObject.setSignatureMethod(algorithm1);
                signatureObject.setSignatureMethodElement(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm1 + "] is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_REFERENCE) {
                SignatureConsumer.checkReference(doc, el, gconfig, config2.getReferences(), vresult, idResolver, nsWsse, nsWsu, domRequired, signatureObject, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(sinfo)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignedInfo(Document doc,Element sinfo,WSSConsumerConfig gconfig,SignatureConsumerConfig config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,SignatureObject signatureObject,Map context)");
        }
    }

    private static void checkReference(OMDocument doc, OMElement reference, WSSConsumerConfig gconfig, List config2, VerificationResult vresult, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, SignatureObject signatureObject, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element reference[" + DOMUtils.getDisplayName(reference) + "]," + "WSSConsumerConfig gconfig," + "List config," + "VerificationResult vresult[" + vresult + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "SignatureObject signatureObject[" + signatureObject + "]," + "Map context)");
        }
        boolean succeeded = false;
        Exception[] exceptions = new Exception[config2.size()];
        int exPos = 0;
        int jFirst = 0;
        Iterator i = config2.iterator();
        while (i.hasNext()) {
            try {
                SigningReferenceConfig srconfig = (SigningReferenceConfig)i.next();
                jFirst = vresult._verifiedParts.size() - 1;
                SignatureConsumer.checkReference(doc, reference, gconfig, srconfig, vresult, idResolver, nsWsse, nsWsu, domRequired, signatureObject, context);
                vresult._srconfig = srconfig;
                succeeded = true;
                break;
            }
            catch (Exception e) {
                exceptions[exPos++] = e;
                for (int j = vresult._verifiedParts.size() - 1; j > jFirst; --j) {
                    vresult._verifiedParts.remove(j);
                }
            }
        }
        if (!succeeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, exPos + " exceptions were caught.");
                for (int j = 0; j < exPos; ++j) {
                    Tr.debug(tc, "No." + i + "'s exception: " + exceptions[j]);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s12", new String[]{exceptions[exPos - 1].getMessage()}, (Throwable)exceptions[exPos - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,List config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,SignatureObject signatureObject,Map context)");
        }
    }

    private static void checkReference(OMDocument doc, OMElement reference, WSSConsumerConfig gconfig, SigningReferenceConfig config2, VerificationResult vresult, IDResolver idResolver, String nsWsse, String nsWsu, boolean domRequired, SignatureObject signatureObject, Map<Object, Object> context) throws SoapSecurityException {
        OMElement nonce;
        OMElement timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element reference[" + DOMUtils.getDisplayName(reference) + "]," + "WSSConsumerConfig gconfig," + "SigningReferenceConfig config," + "VerificationResult vresult[" + vresult + "]," + "IDResolver idResolver[" + idResolver + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "boolean domRequired[" + domRequired + "]," + "SignatureObject signatureObject[" + signatureObject + "]," + "Map context)");
        }
        boolean noncefirst = false;
        int hash = 0;
        OMElement object = null;
        ReferenceObject referenceObject = new ReferenceObject();
        VerificationResult.VerifiedPart part = new VerificationResult.VerifiedPart();
        OMElement el = DOMUtils.getFirstElement(reference);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_TRANSFORMS) {
                SignatureConsumer.checkTransforms(el, gconfig, config2.getTransforms(), part, domRequired, referenceObject, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_DIGESTMETHOD) {
                String algorithm1 = DOMUtils.getAttribute(el, "Algorithm");
                String algorithm2 = null;
                if (config2.getDigestMethod() != null) {
                    algorithm2 = config2.getDigestMethod().getAlgorithm();
                }
                if (algorithm2 == null || !algorithm2.equals(algorithm1) || !gconfig.getAllowedDigestMethods().contains(algorithm1)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s11", algorithm1);
                }
                referenceObject.setDigestAlgorithm(algorithm1);
                referenceObject.setDigestMethod(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm1 + "] is OK.");
                }
            } else if (hash == com.ibm.ws.wssecurity.common.Constants.HASH_DS_DIGESTVALUE) {
                referenceObject.setDigestValue(DOMUtil.getStringValue(el));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(reference)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (vresult._domRequired) {
            doc = vresult._copiedDOM;
        } else if (part._domRequired) {
            OMDocument doc2 = doc.getOMDocumentElement().getOMFactory().createOMDocument();
            doc2.addChild(doc.getOMDocumentElement().cloneOMElement());
            vresult._domRequired = true;
            vresult._copiedDOM = doc2;
            doc = doc2;
        }
        String refUri = DOMUtils.getAttribute(reference, "URI");
        referenceObject.setUriRef(refUri);
        String type = reference.getAttributeValue(TYPE_Q);
        referenceObject.setType(type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing URI [" + refUri + "]...");
        }
        if (refUri.length() == 0) {
            object = doc.getOMDocumentElement();
        } else {
            if (refUri.length() < 2 || refUri.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", refUri);
            }
            refUri = refUri.substring(1);
            object = idResolver.resolveID(doc, refUri);
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The URI [" + refUri + "] is not supported." + "  Either the id is defined in the wrong namespace or no id's have a matching value.");
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", refUri);
        }
        referenceObject.setOwnerDocument(signatureObject.getOwnerDocument());
        signatureObject.add(referenceObject);
        boolean enforceStrictLayout = true;
        String s1 = (String)gconfig.getProperties().get("com.ibm.ws.wssecurity.EnforceStrictLayout");
        if (s1 != null) {
            enforceStrictLayout = !s1.equals("false");
        }
        if (enforceStrictLayout) {
            HashMap previousTimestamps;
            OMElement aTimestamp;
            String ln2 = object.getLocalName();
            if (gconfig.getLayout() == "Strict" && ln2.equals("Timestamp") && (aTimestamp = (OMElement)(previousTimestamps = (HashMap)context.get("com.ibm.ws.wssecurity.constants.timestampVerificationHash")).get(refUri)) == null) {
                throw SoapSecurityException.format("Signature for timestamp found ahead of timestamp. Strict Layout not followed in incoming message. Check that the policy for sending application specifies a Strict layout.");
            }
        }
        part._parent = object.getParent();
        part._object = object;
        part._timestamp = timestamp = NonceUtil.getTimestamp(object, nsWsu);
        part._nonce = nonce = NonceUtil.getNonce(object, nsWsse);
        part._noncefirst = noncefirst = NonceUtil.isNonceFirst(object, nonce, timestamp);
        vresult._verifiedParts.add(part);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added Verified part[" + part + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,SignatureConsumerConfig config,List parts,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,SignatureObject signatureObject,Map context)");
        }
    }

    private static void checkTransforms(OMElement transforms, WSSConsumerConfig gconfig, List config2, VerificationResult.VerifiedPart part, boolean domRequired, ReferenceObject referenceObject, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransform(Element transforms[" + DOMUtils.getDisplayName(transforms) + "]," + "WSSConsumerConfig gconfig," + "List config[" + config2 + "]," + "VerifiedPart part[" + part + "]," + "boolean domRequired[" + domRequired + "]," + "ReferenceObject referenceObject[" + referenceObject + "]," + "Map context])");
        }
        int hash = 0;
        referenceObject.setTransformsElement(transforms);
        OMElement el = DOMUtils.getFirstElement(transforms);
        while (el != null) {
            OMElement el2 = DOMUtils.getNextElement(el);
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_TRANSFORM) {
                SignatureConsumer.checkTransform(el, el2 == null, gconfig, config2, part, domRequired, referenceObject, context);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtils.getQualifiedName(el) + " in the " + DOMUtils.getQualifiedName(transforms) + " element.");
            }
            el = el2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransform(Element transforms,WSSConsumerConfig gconfig,List config,VerifiedPart part,boolean domRequired,ReferenceObject referenceObject,Map context)");
        }
    }

    private static void checkTransform(OMElement transform, boolean lastTransform, WSSConsumerConfig gconfig, List config2, VerificationResult.VerifiedPart part, boolean domRequired, ReferenceObject referenceObject, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransform(Element transform[" + DOMUtils.getDisplayName(transform) + "]," + "boolean lastTransform[" + lastTransform + "]," + "WSSConsumerConfig gconfig," + "List config[" + config2 + "]," + "VerifiedPart part[" + part + "]," + "boolean domRequired[" + domRequired + "]," + "ReferenceObject referenceObject[" + referenceObject + "]," + "Map context)");
        }
        boolean result = false;
        Iterator i = config2.iterator();
        String algorithm1 = transform.getAttributeValue(ALGORITHM_Q);
        while (i.hasNext()) {
            AlgorithmConfig aconfig = (AlgorithmConfig)i.next();
            String algorithm2 = aconfig.getAlgorithm();
            if (!algorithm2.equals(algorithm1) || !gconfig.getAllowedTransforms().contains(algorithm1)) continue;
            result = true;
            break;
        }
        if (!result) {
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s12", algorithm1);
        }
        referenceObject.addTransformAlgorithmAndParameter(algorithm1, DOMUtil.getFirstChildElement(transform));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Transform [" + algorithm1 + "] is OK.");
        }
        if (ConfigUtil.isC14nTransform(algorithm1)) {
            ++part._numC14n;
            if (lastTransform) {
                part._lastIsC14n = true;
            }
        } else if (domRequired && ConfigUtil.isDOMRequiredTransform(algorithm1)) {
            part._domRequired = domRequired;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransform(List config,WSSConsumerConfig gconfig,String algorithm,VerifiedPart part,boolean domRequired,ReferenceObject referenceObject,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verify(OMElement signature, Key key, WSSConsumerConfig gconfig, SignatureConsumerConfig config2, IDResolver idResolver, OMDocument document, VerificationResult vresult, Map<Object, Object> selectors, SignatureObject signatureObject, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(Element signature[" + DOMUtils.getDisplayName(signature) + "]," + "Key key[" + key + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + idResolver + "]," + "Document document[" + DOMUtils.getDisplayName(document.getOMDocumentElement()) + "]," + "VerificationResult vresult[" + vresult + "]," + "Map selectors," + "SignatureObject signatureObject[" + signatureObject + "]," + "Map context)");
        }
        WSSSignatureContext scontext = new WSSSignatureContext();
        scontext.setContext(context);
        Map<Object, Object> gprops = gconfig.getProperties();
        scontext.setHWKeyStoreName((String)context.remove("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef"));
        String sigAlgorithm = null;
        if (config2.getSignatureMethod() != null) {
            sigAlgorithm = config2.getSignatureMethod().getAlgorithm();
        }
        scontext.setSigAlgorithm(sigAlgorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signature Algorithm = " + sigAlgorithm);
        }
        if (scontext.useHWKeyStore()) {
            Provider p;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + scontext.getHWKeyStoreName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance(scontext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                scontext.setHWKeyStoreProvider(p);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + p.getName());
                }
            }
        }
        scontext.setHWConfigName((String)gprops.get("HWCONFIG"));
        scontext.setOffload((Boolean)gprops.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (scontext.shouldChangeProvider()) {
            Provider p;
            HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + scontext.getHWConfigName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance(scontext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                scontext.setHWAccelerationProvider(p);
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                fHWKeyCache.setProvider(p, hardwareCacheSize);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + p.getName());
                }
            }
        }
        if (tc.isDebugEnabled()) {
            scontext.setResourceShower(ShowerImpl.getInstance());
        }
        if (idResolver != null) {
            scontext.setIDResolver(idResolver);
        }
        HashSet<Configuration> dsigKConfig = new HashSet<Configuration>();
        Iterator<Configuration> i = gconfig.getSignatureConsumers().iterator();
        while (i.hasNext()) {
            dsigKConfig.add(i.next().getSigningKeyInfo());
        }
        HashSet<Configuration> encKConfig = new HashSet<Configuration>();
        i = gconfig.getEncryptionConsumers().iterator();
        while (i.hasNext()) {
            encKConfig.add(((EncryptionConsumerConfig)i.next()).getEncryptionKeyInfo());
        }
        Set<TokenConsumerConfig> tokenConfig = gconfig.getTokenConsumers();
        WSSAlgorithmFactory factory = gconfig.getAlgorithmFactory();
        scontext.setAlgorithmFactory(factory);
        scontext.setDocument(document);
        if (config2.getKeyInfoSignature() != null) {
            scontext.setKeyInfoSignature(config2.getKeyInfoSignature().getAlgorithm());
        } else {
            scontext.setKeyInfoSignature(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DecryptionTransform is used: " + config2.isDecryptionTransformEnabled());
        }
        if (config2.isDecryptionTransformEnabled()) {
            SameDocumentEncryptedKeyRetriever ekRetriever = null;
            try {
                ekRetriever = new SameDocumentEncryptedKeyRetriever(document);
            }
            catch (StructureException e) {
                Tr.processException(e, clsName + ".verify", "826");
                throw new SoapSecurityException(e);
            }
            scontext.setEncryptedKeyRetriever(ekRetriever);
            XMLDTKeyInfoResolver kiResolver = new XMLDTKeyInfoResolver();
            kiResolver.setAlgorithmFactory(factory);
            kiResolver.setContext(context);
            kiResolver.setSelectors(selectors);
            kiResolver.setIdResolver(idResolver);
            kiResolver.setEncKeyInfoConsumers(encKConfig);
            kiResolver.setTokenConsumers(tokenConfig);
            scontext.setKeyInfoResolver(kiResolver);
        }
        STRDTKeyInfoResolver skiResolver = new STRDTKeyInfoResolver();
        skiResolver.setContext(context);
        skiResolver.setSelectors(selectors);
        skiResolver.setDsigKeyInfoSet(dsigKConfig);
        skiResolver.setEncKeyInfoSet(encKConfig);
        skiResolver.setGeneration(false);
        scontext.setSTRDTKeyInfoResolver(skiResolver);
        scontext.setContext(context);
        scontext.setOnlySignEntireHeadersAndBody(gconfig.isOnlySignEntireHeadersAndBody());
        scontext.setVerificationResult(vresult);
        Validity validity = null;
        try {
            validity = scontext.verify(signature, key, signatureObject);
        }
        finally {
            if (scontext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(scontext.getHWConfigName(), scontext.getHWAccelerationProvider());
            }
            if (scontext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(scontext.getHWKeyStoreName(), scontext.getHWKeyStoreProvider());
            }
            signatureObject.clear();
        }
        boolean coreValidity = validity.getCoreValidity();
        String errMsg = null;
        if (!coreValidity || tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Core validity=");
            buf.append(coreValidity);
            buf.append(" Signed info validity=");
            buf.append(validity.getSignedInfoValidity());
            buf.append(" Signed info message='");
            buf.append(validity.getSignedInfoMessage());
            buf.append("'");
            int count = validity.getNumberOfReferences();
            for (int j = 0; j < count; ++j) {
                buf.append(" Ref[");
                buf.append(i);
                buf.append("](validity=");
                buf.append(validity.getReferenceValidity(j));
                buf.append(" message='");
                buf.append(validity.getReferenceMessage(j));
                buf.append("' uri='");
                buf.append(validity.getReferenceURI(j));
                buf.append("' type='");
                buf.append(validity.getReferenceType(j));
                buf.append("')");
            }
            errMsg = buf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errMsg);
            }
            if (coreValidity) {
                errMsg = null;
            }
        }
        if (errMsg != null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s01", errMsg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element signature,Key key,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,Document document,VerificationResult vresult,Map selectors,SignatureObject signatureObject,Map context)");
        }
    }

    public static Key callKeyInfoConsumer(KeyInfoConsumerConfig config2, String keytype, Map<Object, Object> type, Map<Object, Object> properties, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype[" + keytype + "]," + "Map type," + "Map properties," + "OMElement target[" + DOMUtils.getDisplayName(target) + "]," + "Map context)");
        }
        CommonContentConsumer.ResolvedKeyInfo kinfo = CommonContentConsumer.resolveKeyInfo(target, context);
        Key key = SignatureConsumer.callKeyInfoConsumer(config2, keytype, type, properties, kinfo, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype,Map type,Map properties,OMElement target,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    public static Key callKeyInfoConsumer(KeyInfoConsumerConfig config2, String keytype, Map<Object, Object> type, Map<Object, Object> properties, CommonContentConsumer.ResolvedKeyInfo kinfo, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype[" + keytype + "]," + "Map type," + "Map properties," + "ResolvedKeyInfo kinfo[" + kinfo + "]," + "Map context)");
        }
        KeyInfoConsumer con = (KeyInfoConsumer)properties.get(KeyInfoConsumer.class);
        type.clear();
        type.put(Constants.WSSECURITY_KEY_TYPE, keytype);
        context.put("com.ibm.ws.wssecurity.impl.config.keyinfoConsumer.configKey", config2);
        Key key = con.getKey(kinfo, type, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype,Map type,Map properties,ResolvedKeyInfo kinfo,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    private static void setVerificationResult(VerificationResult vresult, SignatureConsumerConfig sconfig, Map<Object, Object> context) throws SoapSecurityException {
        SecurityTokenWrapper tokenWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerificationResult(VerificationResult vresult[" + vresult + "]," + "SignatureConsumerConfig sconfig," + "Map context)");
        }
        for (VerificationResult.VerifiedPart part : vresult._verifiedParts) {
            SignatureConsumer.removeNode(part._timestamp, "wedsig");
            SignatureConsumer.removeNode(part._nonce, "wedsig");
        }
        vresult._tokenWrapper = tokenWrapper = SignatureConsumer.getTokenWrapper(vresult, sconfig, context);
        ResultPool.add(context, vresult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerificationResult(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context)");
        }
    }

    public static void removeNode(OMElement element, String type) {
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "String type[" + type + "])");
        }
        if (element != null && (value = element.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.WAS_EXTENTION_Q)) != null && value.equals(type)) {
            element.detach();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNode(OMElement element, String type)");
        }
    }

    protected static KeyInfoResult[] getKeyInfoResults(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] kresults = null;
        Result[] results = ResultPool.get(context, KeyInfoResult.class);
        if (results != null) {
            kresults = new KeyInfoResult[results.length];
            for (int i = 0; i < results.length; ++i) {
                kresults[i] = (KeyInfoResult)results[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoResults(Map context) returns KeyInfoResult[][" + kresults + "]");
        }
        return kresults;
    }

    private static KeyInfoResult getProcessedResult(VerificationResult vresult, KeyInfoResult[] results, List<KeyInfoContentConsumerConfig> kclist) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist");
        }
        KeyInfoResult result = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                if (result == null && kclist.contains(r.getKeyInfoContentConsumer()) && r.getError() == null) {
                    result = r;
                    continue;
                }
                vresult._kresults.put(r.getKeyInfoContentConsumer(), r);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + result + "]");
        }
        return result;
    }

    private static SecurityTokenWrapper getTokenWrapper(VerificationResult vresult, SignatureConsumerConfig sconfig, Map<Object, Object> context) throws SoapSecurityException {
        List<VerifiedConfig> vlist;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenWrapper(VerificationResult vresult[" + vresult + "]," + "SignatureConsumerConfig sconfig," + "Map context)");
        }
        SecurityTokenWrapper stw = null;
        Collection<SecurityTokenWrapper> tokenWrappers = null;
        KeyInfoResult[] results = SignatureConsumer.getKeyInfoResults(context);
        KeyInfoResult kresult = SignatureConsumer.getProcessedResult(vresult, results, sconfig.getSigningKeyInfo().getContentConsumers());
        if (kresult != null) {
            SecurityToken token;
            String id = kresult.getIdInSubject();
            SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            final SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token = securityTokenManager.getToken(kresult.getKeyInfoContentConsumer().getTokenConsumer(), id));
            if (tokenWrapper != null) {
                if (tokenWrapper.getError() != null) {
                    throw tokenWrapper.getError();
                }
                stw = AccessController.doPrivileged(new PrivilegedAction<SecurityTokenWrapper>(){

                    @Override
                    public SecurityTokenWrapper run() {
                        tokenWrapper.setReferenced(true);
                        SecurityTokenWrapper stw = new SecurityTokenWrapper(tokenWrapper.getSecurityToken(), tokenWrapper.getWssapiCallbackHandler(), tokenWrapper.getWssapiLoginConfigName());
                        stw.setKeyInfoType(tokenWrapper.getKeyInfoType());
                        stw.setProcessed(tokenWrapper.isProcessed());
                        if (tokenWrapper.isReadOnly()) {
                            stw.setReadOnly();
                        }
                        stw.setReferenced(tokenWrapper.isReferenced());
                        stw.setUsedTokenConsumer(tokenWrapper.getUsedTokenConsumerHash(), tokenWrapper.getUsedTokenConsumerClass());
                        stw.setUsedTokenGenerator(tokenWrapper.getUsedTokenGeneratorHash());
                        stw.setUsedToLogin(tokenWrapper.isUsedToLogin());
                        stw.setWssapiReferenceType(tokenWrapper.getWssapiReferenceType());
                        return stw;
                    }
                });
            }
            Collection<SecurityToken> tokens = securityTokenManager.getTokens(id);
            tokenWrappers = securityTokenManager.getTokenWrappers(tokens);
        }
        if ((vlist = sconfig.getIdentityMap().get(vresult._srconfig)) != null && vlist.size() > 0) {
            for (VerifiedConfig vconfig : vlist) {
                block1: for (KeyInfoContentConsumerConfig kiconfig : vconfig._sconfig.getSigningKeyInfo().getContentConsumers()) {
                    for (int k = 0; k < results.length; ++k) {
                        if (!kiconfig.equals(results[k].getKeyInfoContentConsumer())) continue;
                        vresult._identities.put(vconfig, results[k]);
                        continue block1;
                    }
                }
            }
        }
        if (tokenWrappers != null && tokenWrappers.size() > 0) {
            block3: for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                TokenConsumerConfig tconfig = r.getKeyInfoContentConsumer().getTokenConsumer();
                if (tconfig == null) continue;
                for (SecurityTokenWrapper t : tokenWrappers) {
                    if (tconfig.hashCode() != t.getUsedTokenConsumerHash()) continue;
                    vresult._kresults.put(r, t);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenWrapper(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context) returns SecurityTokenWrapper[" + stw + "]");
        }
        return stw;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, int offset, int length, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content, offset, length);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

