/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class SignatureConfirmationGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(SignatureConfirmationGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        boolean isDecl1 = false;
        String pWsse = DOMUtils.getNamespacePrefix(parent, Constants.NS_WSSE11);
        if (pWsse == null) {
            isDecl1 = true;
            pWsse = "wsse11";
        }
        if ((messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        List<String> sigCache = SignatureConfirmationGenerator.getSignatureConfirmationCache(messageContext);
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        if (sigCache != null) {
            int numSigConfElements = sigCache.size();
            for (int i = 0; i < numSigConfElements; ++i) {
                String sigValue = sigCache.get(i);
                OMElement sigConfElement = factory.createOMElement("SignatureConfirmation", Constants.NS_WSSE11, pWsse);
                if (isDecl1) {
                    sigConfElement.declareNamespace(Constants.NS_WSSE11, "wsse11");
                }
                sigConfElement.addAttribute("Value", sigValue, null);
                OMNode firstChild = parent.getFirstOMChild();
                if (firstChild == null) {
                    parent.addChild(sigConfElement);
                } else {
                    firstChild.insertSiblingBefore(sigConfElement);
                }
                String idname = IdUtils.getInstance().makeUniqueId(context, "wssecurity_sigconf_id_");
                OMNamespace wsu_ns = DOMUtils.getNamespaceDeclaration(sigConfElement, Constants.NS_WSU);
                if (wsu_ns == null) {
                    wsu_ns = sigConfElement.getOMFactory().createOMNamespace(Constants.NS_WSU, "wsu");
                    sigConfElement.declareNamespace(wsu_ns);
                }
                sigConfElement.addAttribute("Id", idname, wsu_ns);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding SignatureConfirmation with value attribute: " + sigValue);
            }
        } else {
            OMNode firstChild;
            OMElement sigConfElement = factory.createOMElement("SignatureConfirmation", Constants.NS_WSSE11, pWsse);
            if (isDecl1) {
                sigConfElement.declareNamespace(Constants.NS_WSSE11, "wsse11");
            }
            if ((firstChild = parent.getFirstOMChild()) == null) {
                parent.addChild(sigConfElement);
            } else {
                firstChild.insertSiblingBefore(sigConfElement);
            }
            String idname = IdUtils.getInstance().makeUniqueId(context, "wssecurity_sigconf_id_");
            OMNamespace wsu_ns = DOMUtils.getNamespaceDeclaration(sigConfElement, Constants.NS_WSU);
            if (wsu_ns == null) {
                wsu_ns = sigConfElement.getOMFactory().createOMNamespace(Constants.NS_WSU, "wsu");
                sigConfElement.declareNamespace(wsu_ns);
            }
            sigConfElement.addAttribute("Id", idname, wsu_ns);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding SignatureConfirmation with no value attribute.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
        }
    }

    protected static List<String> getSignatureConfirmationCache(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignatureConfirmationCache(MessageContext messageContext)");
        }
        ArrayList sigCacheWssPropMap = null;
        ArrayList sigCacheRAMPPropMap = null;
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Valid operation context to look for Signature_Confirmation cache");
            }
            HashMap allMsgCtxs = opCtx.getMessageContexts();
            Set msgContexts = allMsgCtxs.entrySet();
            Iterator it = msgContexts.iterator();
            Object prop = null;
            HashMap pMap = null;
            while (it.hasNext()) {
                List propList;
                Map.Entry singleMsgCtx = (Map.Entry)it.next();
                MessageContext tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                pMap = (HashMap)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                if (pMap != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the WSS_PROPERTYMAP in the msg ctx with key: " + singleMsgCtx.getKey());
                    }
                    if ((prop = (Object)pMap.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                        }
                        propList = null;
                        if (prop instanceof List) {
                            propList = (List)prop;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + prop);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + prop.getClass().getName());
                            }
                        }
                        if (propList != null) {
                            if (sigCacheWssPropMap == null) {
                                sigCacheWssPropMap = new ArrayList();
                            }
                            sigCacheWssPropMap.addAll(propList);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing Signature_Confirmation Cache from the WSS_PROPERTYMAP");
                        }
                        pMap.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                        tempMsgCtx.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", pMap);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                    }
                }
                if ((pMap = (HashMap)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP")) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the WSS_RAMP_PROPERTYMAP in the msg ctx with key: " + singleMsgCtx.getKey());
                }
                if ((prop = (Object)pMap.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                    }
                    propList = null;
                    if (prop instanceof List) {
                        propList = (List)prop;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + prop);
                        Tr.debug(tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + prop.getClass().getName());
                    }
                    if (propList != null) {
                        if (sigCacheRAMPPropMap == null) {
                            sigCacheRAMPPropMap = new ArrayList();
                        }
                        sigCacheRAMPPropMap.addAll(propList);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing Signature_Confirmation Cache from the WSS_RAMP_PROPERTYMAP");
                    }
                    pMap.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                    tempMsgCtx.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", pMap);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OperationContext was null, cannot look for SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP.");
        }
        if (sigCacheWssPropMap != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSignatureConfirmationCache(MessageContext messageContext) returns " + sigCacheWssPropMap);
            }
            return sigCacheWssPropMap;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignatureConfirmationCache(MessageContext messageContext) returns " + sigCacheRAMPPropMap);
        }
        return sigCacheRAMPPropMap;
    }
}

