/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.dsig.ExclusiveCanonicalizer;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public class STRDereferenceTransformer
extends Transform {
    private static final TraceComponent tc = Tr.register(STRDereferenceTransformer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRDereferenceTransformer.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private static final QName PREFIXLIST_Q = new QName("", "PrefixList");
    private static final QName URI_Q = new QName("", "URI");
    private static final QName VALUETYPE_Q = new QName("", "ValueType");
    public static final String STRT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private String _nsWsse = Constants.NS_WSSE;
    private OMDocument _document;
    private IDResolver _idResolver;
    private STRDTKeyInfoResolver _kiResolver;
    private String _c14nMethod;
    private Hashtable _prefixList;
    private boolean _prefixListIsModified = false;

    @Override
    public String getURI() {
        return STRT;
    }

    public boolean isPrefixListModified() {
        return this._prefixListIsModified;
    }

    public void modifyPrefixListAttrib(OMNode node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyPrefixListAttrib(OMNode node[" + DOMUtils.getDisplayName(node) + "])");
        }
        for (OMNode n1 = node; n1 != null; n1 = n1.getNextOMSibling()) {
            String ln;
            String ns;
            OMElement e1;
            if (n1.getType() != 1 || !DOMUtils.equals(e1 = (OMElement)n1, ns = this._nsWsse, ln = "TransformationParameters")) continue;
            OMElement e2 = DOMUtils.getFirstElement(e1);
            while (e2 != null) {
                ns = Constants.NS_DSIG;
                ln = "CanonicalizationMethod";
                if (DOMUtils.equals(e2, ns, ln) && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod))) {
                    OMElement e3 = DOMUtils.getFirstElement(e2);
                    while (e3 != null) {
                        ns = "http://www.w3.org/2001/10/xml-exc-c14n#";
                        ln = "InclusiveNamespaces";
                        if (DOMUtils.equals(e3, ns, ln)) {
                            OMAttribute prefixListAttrib = e3.getAttribute(PREFIXLIST_Q);
                            if (prefixListAttrib != null) {
                                e3.removeAttribute(prefixListAttrib);
                            }
                            e3.addAttribute("PrefixList", ExclusiveCanonicalizer.serializePrefixList(this._prefixList), null);
                            break;
                        }
                        e3 = DOMUtils.getNextElement(e3);
                    }
                }
                e2 = DOMUtils.getNextElement(e2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyPrefixListAttrib(OMNode node) = " + DOMUtils.getDisplayName(node));
        }
    }

    @Override
    public OMElement createTransformElement(OMFactory factory, IndentConfig iconf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransformElement(OMFactory factory[" + factory + "]," + "IndentConfig iconf[" + iconf + "])");
        }
        OMElement trans = super.createTransformElement(factory, iconf);
        if (this._c14nMethod != null) {
            OMElement e = null;
            if (("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) && this._prefixList != null) {
                String s = ExclusiveCanonicalizer.serializePrefixList(this._prefixList);
                e = DOMUtils.createExclusiveOMElement("InclusiveNamespaces", factory);
                e.addAttribute("PrefixList", s, null);
            }
            OMElement e2 = DOMUtils.createDsigOMElement("CanonicalizationMethod", factory);
            e2.addAttribute("Algorithm", this._c14nMethod, null);
            if (e != null) {
                e2.addChild(e);
            }
            e = e2;
            String prefix = DOMUtils.getNamespacePrefix(trans, this._nsWsse);
            boolean addNsDecl = false;
            if (prefix == null) {
                prefix = "wsse";
                addNsDecl = true;
            }
            e2 = factory.createOMElement("TransformationParameters", this._nsWsse, prefix);
            if (addNsDecl) {
                e2.declareNamespace(this._nsWsse, "wsse");
            }
            e2.addChild(e);
            trans.addChild(e2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransformElement(OMFactory factory,IndentConfig iconf) returns Element[" + trans + "]");
        }
        return trans;
    }

    @Override
    public void setParameter(OMNode node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter(OMNode node[" + DOMUtils.getDisplayName(node) + "])");
        }
        this._c14nMethod = null;
        this._prefixList = null;
        for (OMNode n1 = node; n1 != null; n1 = n1.getNextOMSibling()) {
            String ln;
            String ns;
            OMElement e1;
            if (n1.getType() != 1 || !DOMUtils.equals(e1 = (OMElement)n1, ns = this._nsWsse, ln = "TransformationParameters")) continue;
            OMElement e2 = DOMUtils.getFirstElement(e1);
            while (e2 != null) {
                ns = Constants.NS_DSIG;
                ln = "CanonicalizationMethod";
                if (DOMUtils.equals(e2, ns, ln)) {
                    this._c14nMethod = e2.getAttributeValue(ALGORITHM_Q);
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
                        OMElement e3 = DOMUtils.getFirstElement(e2);
                        while (e3 != null) {
                            ns = "http://www.w3.org/2001/10/xml-exc-c14n#";
                            ln = "InclusiveNamespaces";
                            if (DOMUtils.equals(e3, ns, ln)) {
                                String s = e3.getAttributeValue(PREFIXLIST_Q);
                                this._prefixList = ExclusiveCanonicalizer.parsePrefixList(s);
                            }
                            e3 = DOMUtils.getNextElement(e3);
                        }
                    }
                }
                e2 = DOMUtils.getNextElement(e2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter(OMNode node)");
        }
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        SignatureContext scontext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(TransformContext context[" + context + "])");
        }
        if ((scontext = context.getSignatureContext()) instanceof WSSSignatureContext) {
            WSSSignatureContext wsssc = (WSSSignatureContext)scontext;
            this._document = wsssc.getDocument();
            this._idResolver = wsssc.getIDResolver();
            this._kiResolver = wsssc.getSTRDTKeyInfoResolver();
            int wssVersion = wsssc.getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][wssVersion];
        }
        ArrayList nodeSet = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nodeSet = XPathCanonicalizer.toNodeset(context.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                nodeSet = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nodeSet = context.getNodeset();
            }
        }
        ByteArrayHolder binary = null;
        if (nodeSet != null) {
            this.typeCheck(nodeSet);
            try {
                binary = this.transform(nodeSet);
            }
            catch (RuntimeException e) {
                Tr.processException((Throwable)e, clsName + ".transform", "215", this);
                throw e;
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".transform", "218", this);
                throw TransformException.create(e);
            }
        }
        context.setContent(binary, "UTF-8");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(TransformContext context)");
        }
    }

    private ByteArrayHolder transform(ArrayList nodeSet) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(ArrayList nodeSet[" + nodeSet + "])");
        }
        Map<OMNode, ArrayList> replNodeSets = this.dereferenceSTR(nodeSet);
        ByteArrayHolder serialized = this.serializeNodeSet(nodeSet, replNodeSets);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(ArrayList nodeSet)");
        }
        return serialized;
    }

    private Map<OMNode, ArrayList> dereferenceSTR(ArrayList nodeSet) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceSTR(NodeList nodeSet[" + nodeSet + "])");
        }
        HashMap<OMNode, ArrayList> node2Ns = new HashMap<OMNode, ArrayList>();
        int l = nodeSet.size();
        for (int i = 0; i < l; ++i) {
            OMElement e;
            Object n = nodeSet.get(i);
            if (!(n instanceof OMElement) || !DOMUtils.equals(e = (OMElement)n, Constants.NS_WSSE, "SecurityTokenReference")) continue;
            ArrayList nl = this.dereferenceSTR(e);
            nl = this.convertToNodeSet(nl);
            node2Ns.put(e, nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceSTR(NodeList nodeSet), returns Map[" + node2Ns + "]");
        }
        return node2Ns;
    }

    private ByteArrayHolder serializeNodeSet(ArrayList nodeSet, Map replNodeSets) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeNodeSet(ArrayList nodeSet[" + nodeSet + "]," + "Map replNodeSets[" + replNodeSets + "])");
        }
        ByteArrayHolder bytes = null;
        if (this._c14nMethod == null) {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s01");
        }
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(this._c14nMethod)) {
            bytes = Canonicalizer.serializeSubset(nodeSet, false, replNodeSets);
        } else if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(this._c14nMethod)) {
            bytes = Canonicalizer.serializeSubset(nodeSet, true, replNodeSets);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod)) {
            bytes = ExclusiveCanonicalizer.serializeSubset(this._prefixList, nodeSet, false, replNodeSets);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
            bytes = ExclusiveCanonicalizer.serializeSubset(this._prefixList, nodeSet, true, replNodeSets);
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s02", this._c14nMethod);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeNodeSet(ArrayList nodeSet, Map replNodeSets)");
        }
        return bytes;
    }

    private ArrayList dereferenceSTR(OMElement secTokenRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceSTR(OMElement secTokenRef[" + DOMUtils.getDisplayName(secTokenRef) + "])");
        }
        Object obj = this.dereferenceToST(secTokenRef);
        ArrayList list = this.wrapInNodeList(obj);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceSTR(OMElement secTokenRef)");
        }
        return list;
    }

    private Object dereferenceToST(OMElement secTokenRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceToST(OMElement secTokenRef[" + DOMUtils.getDisplayName(secTokenRef) + "])");
        }
        Object secToken = null;
        OMElement e = DOMUtils.getFirstElement(secTokenRef);
        if (DOMUtils.equals(e, this._nsWsse, "Embedded")) {
            secToken = this.dereferenceEmbedded(e);
        } else if (DOMUtils.equals(e, this._nsWsse, "Reference")) {
            secToken = this.dereferenceReference(e);
        } else if (DOMUtils.equals(e, this._nsWsse, "KeyIdentifier")) {
            secToken = this.dereferenceOthers(secTokenRef, "KEYID");
        } else if (DOMUtils.equals(e, Constants.NS_DSIG, "X509Data")) {
            secToken = this.dereferenceOthers(secTokenRef, "X509ISSUER");
        }
        if (secToken != null && this._prefixList != null) {
            this.makePrefixNSList(secToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceToST(OMElement secTokenRef)");
        }
        return secToken;
    }

    private ArrayList<OMNode> dereferenceEmbedded(OMElement embedded) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceEmbedded(OMElement embedded[" + DOMUtils.getDisplayName(embedded) + "])");
        }
        ArrayList<OMNode> secToken = null;
        for (OMNode n = embedded.getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            if (secToken == null) {
                secToken = new ArrayList<OMNode>();
            }
            secToken.add(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceEmbedded(OMElement embedded) returns Object[" + secToken + "]");
        }
        return secToken;
    }

    private OMElement dereferenceReference(OMElement ref) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceReference(Element ref[" + DOMUtils.getDisplayName(ref) + "])");
        }
        String uri = null;
        uri = ref.getAttributeValue(URI_Q);
        QName valType = null;
        valType = DOMUtils.getQName(ref, ref.getAttributeValue(VALUETYPE_Q));
        OMElement object = this.resolveURI(uri, valType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceReference(Element ref) returns OMElement[" + object + "]");
        }
        return object;
    }

    private OMElement resolveURI(String uri, QName valType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveURI(String uri[" + uri + "]," + "QName valType[" + valType + "])");
        }
        OMElement secToken = null;
        if (uri != null) {
            if (uri.length() < 2 || uri.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s04", uri);
            }
            String id = uri.substring(1);
            if (this._idResolver == null) {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s03");
            }
            OMElement e = this._idResolver.resolveID(this._document, id);
            if (e != null) {
                secToken = e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveURI(String uri, QName valType) returns OMElement[" + secToken + "]");
        }
        return secToken;
    }

    private OMElement dereferenceOthers(OMElement secTokenRef, String keyInfoType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dereferenceOthers(OMElement secTokenRef[" + DOMUtils.getDisplayName(secTokenRef) + "]," + "String keyInfoType[" + keyInfoType + "])");
        }
        OMElement secToken = null;
        if (this._kiResolver != null) {
            secToken = this._kiResolver.resolve(secTokenRef, keyInfoType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dereferenceOthers(OMElement secTokenRef,String keyInfoType) returns OMElement[" + secToken + "]");
        }
        return secToken;
    }

    private void makePrefixNSList(Object secToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makePrefixNSList(Object secToken[" + secToken + "])");
        }
        HashSet<String> prefixes = new HashSet<String>();
        if (secToken instanceof OMElement) {
            OMNode cur = (OMNode)secToken;
            Iterator nss = ((OMElement)cur).getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefixes.add("#default");
                    continue;
                }
                prefixes.add(prefix);
            }
            STRDereferenceTransformer.getAncestorsNamespaceDeclaration(cur, prefixes);
            STRDereferenceTransformer.scanNamespaceDecls((OMNode)secToken, prefixes);
        } else if (secToken instanceof ArrayList) {
            int l = ((ArrayList)secToken).size();
            for (int i = 0; i < l; ++i) {
                Object n = ((ArrayList)secToken).get(i);
                if (!(n instanceof OMElement)) continue;
                OMNode cur = (OMNode)n;
                Iterator nss = ((OMElement)cur).getAllDeclaredNamespaces();
                while (nss.hasNext()) {
                    OMNamespace ns = (OMNamespace)nss.next();
                    if (ns instanceof OMNamespaceWithOwner) continue;
                    String prefix = ns.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        prefixes.add("#default");
                        continue;
                    }
                    prefixes.add(prefix);
                }
                STRDereferenceTransformer.getAncestorsNamespaceDeclaration(cur, prefixes);
                STRDereferenceTransformer.scanNamespaceDecls((OMNode)secToken, prefixes);
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s05");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original prefix List = " + this._prefixList.toString());
        }
        String key2 = null;
        if (prefixes.size() > 0) {
            for (String key2 : prefixes) {
                if ("#default".equals(key2)) {
                    key2 = "";
                }
                if (this._prefixList.containsKey(key2)) continue;
                this._prefixList.put(key2, key2);
                this._prefixListIsModified = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "is prefix List modified? =  " + this._prefixListIsModified);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makePrefixNSList(Object secToken) sets prefix list = " + this._prefixList.toString());
        }
    }

    private static void scanNamespaceDecls(OMNode node, Set<String> prefixes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanNamespaceDecls(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "Set prefixes[" + prefixes + "])");
        }
        if (node.getType() == 1) {
            Iterator nss = ((OMElement)node).getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                OMNamespace ns = (OMNamespace)nss.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefixes.add("#default");
                    continue;
                }
                prefixes.add(prefix);
            }
            for (OMNode n = ((OMElement)node).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
                if (n.getType() != 1) continue;
                STRDereferenceTransformer.scanNamespaceDecls(n, prefixes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanNamespaceDecls(OMNode node, Set prefixes)");
        }
    }

    public static void copyAncestorsNamespaceDeclaration(OMElement parent, OMElement part) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyAncestorsNamespaceDeclaration(OMElement parent, OMElement part)");
        }
        HashSet<String> prefixes = new HashSet<String>();
        Hashtable ns1 = STRDereferenceTransformer.getAncestorsNamespaceDeclaration(parent, prefixes);
        Hashtable ns2 = STRDereferenceTransformer.getAncestorsNamespaceDeclaration(part, prefixes);
        String nsWsse = Constants.NAMESPACES[0][0];
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            pWsse = "wsse";
        }
        OMElement dummyElem = parent.getOMFactory().createOMElement("Dummy", nsWsse, pWsse);
        OMNamespace pns = null;
        if (part.getNamespace() != null) {
            pns = part.getNamespace();
        }
        if (!ns1.isEmpty()) {
            Enumeration e = ns1.keys();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                if (ns2.containsKey(prefix)) continue;
                OMNamespace ns = (OMNamespace)ns1.get(prefix);
                dummyElem.setNamespace(ns);
            }
            dummyElem.addChild(part);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyAncestorsNamespaceDeclaration(OMElement parent, OMElement part) :" + DOMUtils.getDisplayName(dummyElem));
        }
    }

    public static Hashtable getAncestorsNamespaceDeclaration(OMNode part, Set<String> prefixes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAncestorsNamespaceDeclaration(OMNode part, Set prefixes)");
        }
        Hashtable<String, OMNamespace> prefixAndNSList = new Hashtable<String, OMNamespace>();
        OMContainer cur = (OMElement)part;
        cur = cur.getParent();
        while (cur != null && cur instanceof OMElement) {
            Iterator map = cur.getAllDeclaredNamespaces();
            while (map.hasNext()) {
                String value;
                OMNamespace ns = (OMNamespace)map.next();
                if (ns instanceof OMNamespaceWithOwner) continue;
                String prefix = ns.getPrefix();
                if (prefix == null || prefix.equals("")) {
                    value = "#default";
                    prefixAndNSList.put(value, ns);
                    prefixes.add(value);
                    continue;
                }
                value = prefix;
                prefixAndNSList.put(value, ns);
                prefixes.add(value);
            }
            cur = ((OMElement)cur).getParent();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAncestorsNamespaceDeclaration(OMNode part, Set prefixes)");
        }
        return prefixAndNSList;
    }

    private ArrayList wrapInNodeList(Object secToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapInNodeList(Object secToken[" + secToken + "])");
        }
        ArrayList<OMElement> secToken2 = null;
        if (secToken instanceof OMElement) {
            ArrayList<OMElement> nl = new ArrayList<OMElement>(1);
            nl.add((OMElement)secToken);
            secToken2 = nl;
        } else if (secToken instanceof ArrayList) {
            secToken2 = (ArrayList<OMElement>)secToken;
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s05");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapInNodeList(Object secToken) returns ArrayList[" + secToken2 + "]");
        }
        return secToken2;
    }

    private ArrayList convertToNodeSet(ArrayList apexNodes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToNodeSet(ArrayList apexNodes[" + apexNodes + "])");
        }
        ArrayList nodeSet = new ArrayList();
        int l = apexNodes.size();
        for (int i = 0; i < l; ++i) {
            ArrayList nl = XPathCanonicalizer.toNodeset((OMNode)apexNodes.get(i), null, true);
            int l2 = nl.size();
            for (int j = 0; j < l2; ++j) {
                nodeSet.add(nl.get(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToNodeSet(ArrayList apexNodes) returns ArrayList[" + nodeSet + "]");
        }
        return nodeSet;
    }

    private void typeCheck(ArrayList nodeset) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "typeIsOk(ArrayList nodeset)");
        }
        boolean found = false;
        for (int i = 0; i < nodeset.size(); ++i) {
            Object node = nodeset.get(i);
            if (!(node instanceof OMElement) || !DOMUtils.equals((OMElement)node, Constants.NS_DSIG, "KeyInfo")) continue;
            found = true;
            break;
        }
        if (!found && tc.isDebugEnabled()) {
            Tr.debug(tc, "The nodeset to be signed doesn't include ds:KeyInfo element.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "typeIsOk(ArrayList nodeset)");
        }
    }
}

