/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.handler.WSSBasicAuth;
import com.ibm.ws.wssecurity.handler.WSSBinding;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.handler.WSSCallbackHandler;
import com.ibm.ws.wssecurity.handler.WSSCertPathSettings;
import com.ibm.ws.wssecurity.handler.WSSCollectionCertStores;
import com.ibm.ws.wssecurity.handler.WSSDerivedKeyInfo;
import com.ibm.ws.wssecurity.handler.WSSEncryptionInfo;
import com.ibm.ws.wssecurity.handler.WSSJaasConfig;
import com.ibm.ws.wssecurity.handler.WSSKey;
import com.ibm.ws.wssecurity.handler.WSSKeyInfo;
import com.ibm.ws.wssecurity.handler.WSSKeyStore;
import com.ibm.ws.wssecurity.handler.WSSLdapCertStores;
import com.ibm.ws.wssecurity.handler.WSSOutboundBinding;
import com.ibm.ws.wssecurity.handler.WSSSigningInfo;
import com.ibm.ws.wssecurity.handler.WSSSigningPartReference;
import com.ibm.ws.wssecurity.handler.WSSToken;
import com.ibm.ws.wssecurity.handler.WSSTransform;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSecurityDefaultGeneratorConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultGeneratorConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultGeneratorConfig.class.getName();
    private static WSSBindings securityBindings;

    public WSSecurityDefaultGeneratorConfig(WSSBindings appBindings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultGeneratorConfig(Generator):", new Object[]{appBindings});
        }
        this.init(appBindings);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultGeneratorConfig(Generator)");
        }
    }

    protected final void init(WSSBindings appBindings) throws SoapSecurityException {
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl kigconfig;
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl kicgconfig;
        HashMap<Object, Object> properties;
        int kMax;
        int jMax;
        PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig;
        String value;
        int iMax;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Generator", new Object[]{appBindings});
        }
        Object appClassLoader = null;
        WSSOutboundBinding conBnd = null;
        PrivateCommonConfig.CallbackHandlerConfImpl chconfig = null;
        HashMap<String, PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl> nameKeyInfo = new HashMap<String, PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl>();
        this._properties = new HashMap();
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        securityBindings = appBindings;
        List<WSSBinding> securityBindingList = securityBindings.getSecurityBindings();
        VariableExpander varMap = VariableExpanderFactory.getVariableExpander();
        this.processPrivateConfig(DOMUtils.getPrivateConfig());
        WSSBinding securityBinding = null;
        for (int l = 0; l < securityBindingList.size(); ++l) {
            securityBinding = securityBindingList.get(l);
            if (!securityBinding.getName().equals("application")) continue;
            conBnd = securityBinding.getSecurityOutboundBindingConfig();
        }
        List<WSSEncryptionInfo> encryptionInfos = null;
        List<WSSKeyInfo> keyInfos = null;
        List<WSSSigningInfo> signingInfos = null;
        List<WSSToken> tokenGenerators = null;
        List<WSSCollectionCertStores> collectionCertStores = null;
        List<WSSLdapCertStores> ldapCertStores = null;
        HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl> nameToken = new HashMap<String, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
        boolean isExplicitlyProtectSignatureConfirmation = false;
        boolean isOnlySignEntireHeadersAndBody = false;
        Map<Object, Object> bndProperties = null;
        Map<Object, Object> bndParameters = null;
        if (securityBinding != null) {
            List<Object> p;
            List<Object> sbp = securityBinding.getParameters();
            if (sbp != null) {
                bndParameters = ConfigConstants.getProperties(sbp, varMap);
            }
            if (bndParameters != null) {
                this._properties.putAll(bndParameters);
            }
            if (conBnd != null && (p = conBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
                this._properties.putAll(bndProperties);
            }
        }
        if (conBnd != null) {
            encryptionInfos = conBnd.getEncryptionInfos();
            collectionCertStores = conBnd.getCollectionCertStores();
            ldapCertStores = conBnd.getLdapCertStores();
            keyInfos = conBnd.getKeyInfos();
            signingInfos = conBnd.getSigningInfos();
            tokenGenerators = conBnd.getTokens();
            isExplicitlyProtectSignatureConfirmation = conBnd.isExplicitlyProtectSignatureConfirmation();
            isOnlySignEntireHeadersAndBody = conBnd.isOnlySignEntireHeadersAndBody();
            this._defaultBindingNamespace = conBnd.getTargetNamespace();
            if (tc.isDebugEnabled()) {
                String bndparam = bndParameters == null ? "null" : bndParameters.toString();
                String bndprop = bndProperties == null ? "null" : bndProperties.toString();
                Tr.debug(tc, "Default bindings name space = " + this._defaultBindingNamespace);
                Tr.debug(tc, "Default Outbound Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators, ExplicitlyProtectSignatureConfirmation, OnlySignEntireHeadersAndBody, Property):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenGenerators, isExplicitlyProtectSignatureConfirmation, isOnlySignEntireHeadersAndBody, bndparam, bndprop});
            }
        }
        this._clientSetMustUnderstand = ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_SET_MUSTUNDERSTAND);
        boolean alwaysTrue = ConfigUtil.getIsTrueProperty(this._properties, Constants.WSSECURITY_GET_MUSTUNDERSTAND);
        this._serviceGetMustUnderstand = !alwaysTrue;
        this._explicitlyProtectSignatureConfirmation = isExplicitlyProtectSignatureConfirmation;
        this._onlySignEntireHeadersAndBody = isOnlySignEntireHeadersAndBody;
        if (tokenGenerators != null) {
            iMax = tokenGenerators.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                WSSJaasConfig jaasConfig;
                WSSCallbackHandler callbackHandler;
                WSSToken tokenGenerator = tokenGenerators.get(i1);
                QName qn = tokenGenerator.getValueType();
                if (qn == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.nullValueType", tokenGenerator.getName());
                }
                value = tokenGenerator.getSecurityTokenReference();
                if (value != null && value.length() > 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityDefaultGeneratorConfig.s01", value, qn.toString());
                }
                tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                tconfig._type = qn;
                tconfig._className = tokenGenerator.getClassname();
                if (!this._defaultTokenGenerators.contains(tconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                    tconfig._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; token generator = " + tconfig._className);
                    }
                }
                if ((callbackHandler = tokenGenerator.getCallbackHandler()) != null) {
                    WSSBasicAuth basicAuth;
                    String certStoreRef;
                    WSSCertPathSettings certPathSettings;
                    WSSKey key;
                    WSSKeyStore keystore;
                    chconfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    chconfig._className = callbackHandler.getClassname();
                    if (!this._defaultCallbackHandlers.contains(chconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                        tconfig._userDefinedComponentsUsed = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "userDefinedComponentsUsed set to true; callback handler = " + chconfig._className);
                        }
                    }
                    if ((keystore = callbackHandler.getKeyStore()) != null) {
                        PrivateCommonConfig.KeyStoreConfImpl ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                        ksconfig._type = keystore.getType();
                        ksconfig._path = ConfigUtil.expandInstallLocation(keystore.getPath());
                        ksconfig._password = PasswordUtilFactory.getInstance().passwordDecode(keystore.getStorepass());
                        ksconfig._ksRef = keystore.getKeyStoreRef();
                        chconfig._keyStore = ksconfig;
                        if (ksconfig._ksRef != null && ksconfig._ksRef.length() != 0) {
                            tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksconfig._ksRef);
                        }
                    }
                    if ((key = callbackHandler.getKey()) != null) {
                        PrivateCommonConfig.KeyInformationConfImpl kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                        kiconfig._alias = key.getAlias();
                        kiconfig._keypass = PasswordUtilFactory.getInstance().passwordDecode(key.getKeypass());
                        kiconfig._name = key.getName();
                        chconfig._keyInformation = kiconfig;
                    }
                    if ((certPathSettings = callbackHandler.getCertPathSettings()) != null && (certStoreRef = certPathSettings.getCertStoreRef()) != null) {
                        ArrayList<CertStore> certStores = new ArrayList<CertStore>();
                        Provider provider = null;
                        if (certStoreRef != null) {
                            value = certStoreRef;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CertStoreRef = " + value);
                            }
                            boolean certStoreFound = false;
                            if (collectionCertStores != null || ldapCertStores != null) {
                                int j1;
                                if (collectionCertStores != null && (jMax = collectionCertStores.size()) > 0) {
                                    for (j1 = 0; j1 < jMax; ++j1) {
                                        String msgKey;
                                        List<String> crlPaths;
                                        WSSCollectionCertStores collectionStore = collectionCertStores.get(j1);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "collectionCertStore.get(" + j1 + ") = " + collectionStore.getName());
                                        }
                                        if (value == null || !value.equals(collectionStore.getName())) continue;
                                        provider = Security.getProvider(collectionStore.getProvider());
                                        HashMap<String, CertificateFactory> cache = new HashMap<String, CertificateFactory>();
                                        HashSet<X509Extension> eeCerts = new HashSet<X509Extension>();
                                        List<String> x509Paths = collectionStore.getX509Paths();
                                        kMax = x509Paths.size();
                                        if (kMax > 0) {
                                            for (int k1 = 0; k1 < kMax; ++k1) {
                                                String x509Path = x509Paths.get(k1);
                                                String path = null;
                                                path = ConfigUtil.expandInstallLocation(x509Path);
                                                String provider2 = "";
                                                CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                                if (cfac == null) {
                                                    cfac = ConfigUtil.createCertificateFactory(provider2);
                                                    cache.put(provider2, cfac);
                                                }
                                                File f = new File(path);
                                                eeCerts.add(ConfigUtil.getX509Certificate(f, cfac));
                                                if (!tc.isDebugEnabled()) continue;
                                                Tr.debug(tc, "Adding the X509 certificate: " + path);
                                            }
                                        }
                                        if ((kMax = (crlPaths = collectionStore.getCRLPaths()).size()) > 0) {
                                            for (int k1 = 0; k1 < kMax; ++k1) {
                                                String crlPath = crlPaths.get(k1);
                                                String path = null;
                                                path = ConfigUtil.expandInstallLocation(crlPath);
                                                String provider2 = "";
                                                CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                                if (cfac == null) {
                                                    cfac = ConfigUtil.createCertificateFactory(provider2);
                                                    cache.put(provider2, cfac);
                                                }
                                                File f = new File(path);
                                                eeCerts.add(ConfigUtil.getX509CRL(f, cfac));
                                                if (!tc.isDebugEnabled()) continue;
                                                Tr.debug(tc, "Adding the X509 CRL: " + path);
                                            }
                                        }
                                        String algorithm = "Collection";
                                        CollectionCertStoreParameters cparams = null;
                                        try {
                                            cparams = new CollectionCertStoreParameters(eeCerts);
                                            CertStore certStore = null;
                                            certStore = provider == null ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                            certStores.add(certStore);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Found CertStore for " + value);
                                            }
                                            certStoreFound = true;
                                            break;
                                        }
                                        catch (NoSuchAlgorithmException e) {
                                            msgKey = "security.wssecurity.CommonReceiverConfig.s20";
                                            Tr.error(tc, msgKey, new Object[]{algorithm});
                                            throw SoapSecurityException.format(msgKey, algorithm, (Throwable)e);
                                        }
                                        catch (InvalidAlgorithmParameterException e) {
                                            msgKey = "security.wssecurity.CommonReceiverConfig.s21";
                                            Tr.error(tc, msgKey, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                            throw SoapSecurityException.format(msgKey, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                                        }
                                        catch (Throwable e) {
                                            msgKey = "security.wssecurity.load.collectioncertstore.failed";
                                            Tr.error(tc, msgKey, new String[]{collectionStore.getName(), e.getMessage()});
                                            throw SoapSecurityException.format(msgKey, new String[]{collectionStore.getName(), e.getMessage()}, e);
                                        }
                                    }
                                }
                                if (!certStoreFound && ldapCertStores != null && (jMax = ldapCertStores.size()) > 0) {
                                    for (j1 = 0; j1 < jMax; ++j1) {
                                        String msgKey;
                                        CertStore certStore;
                                        int port;
                                        WSSLdapCertStores ldapCertStore = ldapCertStores.get(j1);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "ldapCertStores.get(" + j1 + ") = " + ldapCertStore.getName());
                                        }
                                        if (value == null || !value.equals(ldapCertStore.getName())) continue;
                                        String host = ldapCertStore.getHost();
                                        try {
                                            port = Integer.parseInt(ldapCertStore.getPort());
                                        }
                                        catch (NumberFormatException e) {
                                            String msgKey2 = "security.wssecurity.PrivateGeneratorConfig.s19";
                                            String arg = ldapCertStore.getPort();
                                            Tr.processException((Throwable)e, clsName + ".PolicyOutboundConfig", "1632", this);
                                            Tr.error(tc, msgKey2, arg);
                                            throw SoapSecurityException.format(msgKey2, arg, (Throwable)e);
                                        }
                                        String algorithm = "LDAP";
                                        provider = Security.getProvider(ldapCertStore.getProvider());
                                        LDAPCertStoreParameters ldapParams = new LDAPCertStoreParameters(host, port);
                                        try {
                                            certStore = provider == null ? CertStore.getInstance(algorithm, ldapParams) : CertStore.getInstance(algorithm, (CertStoreParameters)ldapParams, provider);
                                        }
                                        catch (NoSuchAlgorithmException e) {
                                            msgKey = "security.wssecurity.PrivateGeneratorConfig.s20";
                                            Tr.processException((Throwable)e, clsName + ".PolicyOutboundConfig", "1649", this);
                                            Tr.error(tc, msgKey, algorithm);
                                            throw SoapSecurityException.format(msgKey, algorithm);
                                        }
                                        catch (InvalidAlgorithmParameterException e) {
                                            msgKey = "security.wssecurity.PrivateGeneratorConfig.s21";
                                            Tr.processException((Throwable)e, clsName + ".PolicyOutboundConfig", "1654", this);
                                            Tr.error(tc, msgKey, ldapParams.toString());
                                            throw SoapSecurityException.format(msgKey, ldapParams.toString());
                                        }
                                        certStores.add(certStore);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found CertStore for " + value);
                                        }
                                        certStoreFound = true;
                                        break;
                                    }
                                }
                            }
                        }
                        chconfig._provider = provider;
                        chconfig._certStores = certStores;
                    }
                    if ((basicAuth = callbackHandler.getBasicAuth()) != null) {
                        value = basicAuth.getUserid();
                        if (value != null && value.length() > 0) {
                            chconfig._userId = value;
                        }
                        if ((value = PasswordUtilFactory.getInstance().passwordDecode(basicAuth.getPassword())) != null && value.length() > 0) {
                            chconfig._userPassword = value.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(chconfig._properties, callbackHandler.getProperties(), varMap);
                    tconfig._callbackHandler = chconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + chconfig.getClassName());
                    }
                }
                if ((jaasConfig = tokenGenerator.getJaasConfig()) == null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s17", qn.toString());
                }
                tconfig._jaasConfig = jaasConfig.getConfigName();
                if (!this._defaultJAASConfigs.contains(tconfig._jaasConfig)) {
                    this._userDefinedComponentsUsed = true;
                    tconfig._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; JAAS config = " + tconfig._jaasConfig);
                    }
                }
                ConfigConstants.getProperties(tconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                ConfigConstants.getProperties(tconfig._properties, tokenGenerator.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tconfig._className);
                if (appClassLoader != null) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                }
                properties = new HashMap<Object, Object>();
                try {
                    tconfig._instance = (TokenGeneratorComponent)factory.createGenerator(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.Instantiate", new Object[]{tconfig._className});
                }
                this._tokenGenerators.add(tconfig);
                value = tokenGenerator.getName();
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (nameToken.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: token generator [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token generator: " + value);
                }
                nameToken.put(value, tconfig);
                tconfig._name = value;
            }
        }
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                WSSKeyInfo keyInfo = keyInfos.get(i1);
                kicgconfig = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
                kicgconfig._className = keyInfo.getClassname();
                boolean defaultSystemKeyInfoGenerator = true;
                boolean ksExist = false;
                if (!this._defaultKeyInfoContentGenerators.contains(kicgconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                    defaultSystemKeyInfoGenerator = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; key info content generator = " + kicgconfig._className);
                    }
                }
                kicgconfig._keyInfoType = keyInfo.getType();
                String tokenReference = keyInfo.getTokenReference();
                if (tokenReference != null) {
                    value = tokenReference;
                    if (value != null && value.length() > 0) {
                        kicgconfig._tokenGenerator = (PrivateGeneratorConfig.TokenGeneratorConfImpl)nameToken.get(value);
                        if (kicgconfig._tokenGenerator == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the token reference: " + value);
                        }
                        if (!defaultSystemKeyInfoGenerator) {
                            kicgconfig._tokenGenerator._userDefinedComponentsUsed = true;
                        }
                        if (!ksExist) {
                            tconfig = kicgconfig._tokenGenerator;
                            String ksRef = (String)tconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                            if (ksRef != null) {
                                kicgconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksRef);
                            }
                        }
                    } else if (kicgconfig._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                    }
                } else if (kicgconfig._className.equals("com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator")) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s29");
                }
                if (keyInfo.getDerivedKeyInfo() != null) {
                    WSSDerivedKeyInfo wssDerivedKeyInfo = keyInfo.getDerivedKeyInfo();
                    DerivedKeyInfoConfig derivedKeyInfo = new DerivedKeyInfoConfig();
                    derivedKeyInfo.setClientLabel(wssDerivedKeyInfo.getClientLabel());
                    derivedKeyInfo.setServiceLabel(wssDerivedKeyInfo.getServiceLabel());
                    derivedKeyInfo.setKeyLength(wssDerivedKeyInfo.getKeyLength());
                    derivedKeyInfo.setNonceLength(wssDerivedKeyInfo.getNonceLength());
                    derivedKeyInfo.setRequireDerivedKeys(wssDerivedKeyInfo.isRequireDerivedKeys());
                    derivedKeyInfo.setRequireExplicitDerivedKeys(wssDerivedKeyInfo.isRequireExplicitDerivedKeys());
                    derivedKeyInfo.setRequireImpliedDerivedKeys(wssDerivedKeyInfo.isRequireImpliedDerivedKeys());
                    kicgconfig._derivedKeyInfo = derivedKeyInfo;
                } else {
                    Map<Object, Object> props = kicgconfig._tokenGenerator.getProperties();
                    String keyLength = (String)props.get(Constants.DERIVED_KEY_LENGTH);
                    String serviceLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
                    String clientLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
                    String requireImpliedDerivedKeys = (String)props.get("RequiredImpliedDerivedKeys");
                    boolean oldSC = com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(kicgconfig._tokenGenerator._type);
                    if (oldSC) {
                        DerivedKeyInfoConfig derivedKeyInfo = new DerivedKeyInfoConfig();
                        derivedKeyInfo.setRequireDerivedKeys(true);
                        derivedKeyInfo.setRequireExplicitDerivedKeys(true);
                        if (keyLength != null && keyLength.length() > 0) {
                            derivedKeyInfo.setKeyLength(keyLength);
                        }
                        if (serviceLabel != null && serviceLabel.length() > 0) {
                            derivedKeyInfo.setServiceLabel(serviceLabel);
                        }
                        if (clientLabel != null && clientLabel.length() > 0) {
                            derivedKeyInfo.setClientLabel(clientLabel);
                        }
                        if ("true".equals(requireImpliedDerivedKeys)) {
                            derivedKeyInfo.setRequireImpliedDerivedKeys(true);
                        }
                        kicgconfig._derivedKeyInfo = derivedKeyInfo;
                    }
                }
                ConfigConstants.getProperties(kicgconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", kicgconfig._className);
                if (kicgconfig._className == null || kicgconfig._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyInfoContentGenerator classname = " + kicgconfig._className);
                }
                if (defaultSystemKeyInfoGenerator) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (appClassLoader != null) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClassLoader used = " + type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader"));
                }
                properties = new HashMap();
                try {
                    kicgconfig._instance = (KeyInfoContentGeneratorComponent)factory.createGenerator(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.Instantiate", new Object[]{kicgconfig._className});
                }
                value = keyInfo.getName();
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (nameKeyInfo.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key info [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + value);
                }
                nameKeyInfo.put(value, kicgconfig);
            }
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                String dataEncryptionKey;
                WSSEncryptionInfo encryptionInfo = encryptionInfos.get(i1);
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl econfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                String keyStoreName = null;
                String orderField = encryptionInfo.getOrder();
                if (orderField == null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.encorder");
                }
                Integer order = Integer.parseInt(orderField);
                econfig._properties.put("com.ibm.ws.wssecurity.constants.order", order);
                List<String> encryptionKeys = encryptionInfo.getKeyEncryptionKeyInfos();
                if (encryptionKeys != null && encryptionKeys.size() == 1) {
                    econfig._isKeyEncryption = true;
                    String encryptionKey = encryptionKeys.get(0);
                    value = encryptionKey;
                    if (value != null && value.length() > 0) {
                        kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameKeyInfo.get(value);
                        if (kicgconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        tconfig = kicgconfig._tokenGenerator;
                        if (tconfig != null) {
                            tconfig._usedForEncryption = true;
                        }
                        kigconfig._contentGenerator = kicgconfig;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key info reference: " + value);
                        }
                    }
                }
                if (encryptionInfo.getEncryptionPartReference() != null && (dataEncryptionKey = encryptionInfo.getEncryptionPartReference().getDataEncryptionKeyInfo()) != null) {
                    econfig._isKeyEncryption = false;
                    value = dataEncryptionKey;
                    if (value != null && value.length() > 0) {
                        kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameKeyInfo.get(value);
                        if (kicgconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        tconfig = kicgconfig._tokenGenerator;
                        if (tconfig != null) {
                            tconfig._usedForEncryption = true;
                        }
                        kigconfig._contentGenerator = kicgconfig;
                        econfig._encryptionKeyInfo = kigconfig;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key info reference: " + value);
                        }
                    }
                }
                econfig._encryptionKeyInfo = kigconfig;
                if (keyStoreName != null && ConfigUtil.isHWKeyStore(keyStoreName)) {
                    econfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hardware KeyStore is used: " + keyStoreName);
                    }
                }
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                this._operationGenerators.add(econfig);
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                String signingKey;
                PrivateCommonConfig.AlgorithmConfImpl aconfig;
                WSSSigningInfo signingInfo = signingInfos.get(i1);
                PrivateGeneratorConfig.SignatureGeneratorConfImpl sconfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                Object canonicalizationMethod = null;
                Object signatureMethod = null;
                String orderField = signingInfo.getOrder();
                if (orderField == null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyOutboundConfig.sigorder");
                }
                Integer order = Integer.parseInt(orderField);
                sconfig._properties.put("com.ibm.ws.wssecurity.constants.order", order);
                List<WSSSigningPartReference> prefs = signingInfo.getSigningPartReferences();
                if (prefs != null) {
                    jMax = prefs.size();
                    for (int j1 = 0; j1 < jMax; ++j1) {
                        WSSSigningPartReference pref = prefs.get(j1);
                        PrivateCommonConfig.SigningReferenceConfImpl srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        List<WSSTransform> transforms = pref.getTransforms();
                        if (transforms != null) {
                            kMax = transforms.size();
                            for (int k1 = 0; k1 < kMax; ++k1) {
                                WSSTransform transform = transforms.get(k1);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = transform.getAlgorithm();
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(aconfig._algorithm)) {
                                    srconfig._transforms.add(0, aconfig);
                                    continue;
                                }
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: PartReference not found on SigningInfo. PartReference is required in order to retrieve the signature algorithms from Policy.");
                }
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = canonicalizationMethod;
                sconfig._canonicalizationMethod = aconfig;
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = signatureMethod;
                sconfig._signatureMethod = aconfig;
                kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                String keyStoreName = null;
                List<String> signingKeys = signingInfo.getSigningKeyInfos();
                if ((signingKeys != null || signingKeys.size() == 1) && (value = (signingKey = signingKeys.get(0))) != null && value.length() > 0) {
                    kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameKeyInfo.get(value);
                    if (kicgconfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    keyStoreName = (String)kicgconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    tconfig = kicgconfig._tokenGenerator;
                    if (tconfig != null) {
                        tconfig._usedForSignature = true;
                    }
                    kigconfig._contentGenerator = kicgconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                sconfig._signingKeyInfo = kigconfig;
                if (keyStoreName != null && ConfigUtil.isHWKeyStore(keyStoreName)) {
                    sconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", keyStoreName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hardware KeyStore is used: " + keyStoreName);
                    }
                }
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                this._operationGenerators.add(sconfig);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Consumer, HashMap):", new Object[]{appBindings, varMap});
        }
    }
}

