/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.handler.WSSBasicAuth;
import com.ibm.ws.wssecurity.handler.WSSBinding;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.handler.WSSCallbackHandler;
import com.ibm.ws.wssecurity.handler.WSSCaller;
import com.ibm.ws.wssecurity.handler.WSSCertPathSettings;
import com.ibm.ws.wssecurity.handler.WSSCollectionCertStores;
import com.ibm.ws.wssecurity.handler.WSSDerivedKeyInfo;
import com.ibm.ws.wssecurity.handler.WSSEncryptionInfo;
import com.ibm.ws.wssecurity.handler.WSSEncryptionPartReference;
import com.ibm.ws.wssecurity.handler.WSSInboundBinding;
import com.ibm.ws.wssecurity.handler.WSSJaasConfig;
import com.ibm.ws.wssecurity.handler.WSSKey;
import com.ibm.ws.wssecurity.handler.WSSKeyInfo;
import com.ibm.ws.wssecurity.handler.WSSKeyStore;
import com.ibm.ws.wssecurity.handler.WSSLdapCertStores;
import com.ibm.ws.wssecurity.handler.WSSSigningInfo;
import com.ibm.ws.wssecurity.handler.WSSSigningPartReference;
import com.ibm.ws.wssecurity.handler.WSSToken;
import com.ibm.ws.wssecurity.handler.WSSTransform;
import com.ibm.ws.wssecurity.handler.WSSTrustAnchor;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSecurityDefaultConsumerConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConsumerConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultConsumerConfig.class.getName();
    private static WSSBindings securityBindings;

    public WSSecurityDefaultConsumerConfig(WSSBindings appBindings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultConsumerConfig(Consumer):", new Object[]{appBindings});
        }
        this.init(appBindings);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultConsumerConfig(Consumer");
        }
    }

    protected final void init(WSSBindings appBindings) throws SoapSecurityException {
        int i;
        int kMax;
        int jMax;
        WSSCallbackHandler callbackHandler;
        int iMax;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Consumer):", new Object[]{appBindings});
        }
        Object appClassLoader = null;
        String value = null;
        PrivateCommonConfig.AlgorithmConfImpl aconfig = null;
        PrivateConsumerConfig.EncryptionConsumerConfImpl econfig = null;
        PrivateConsumerConfig.KeyInfoConsumerConfImpl kicconfig = null;
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl kiccconfig = null;
        PrivateConsumerConfig.SignatureConsumerConfImpl sconfig = null;
        PrivateCommonConfig.SigningReferenceConfImpl srconfig = null;
        PrivateConsumerConfig.TokenConsumerConfImpl tconfig = null;
        WSSInboundBinding conBnd = null;
        PrivateCommonConfig.CallbackHandlerConfImpl chconfig = null;
        PrivateCommonConfig.KeyStoreConfImpl ksconfig = null;
        PrivateCommonConfig.KeyInformationConfImpl kiconfig = null;
        HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl> nameToken = null;
        HashMap<String, PrivateConsumerConfig.KeyInfoContentConsumerConfImpl> nameKeyInfo = new HashMap<String, PrivateConsumerConfig.KeyInfoContentConsumerConfImpl>();
        PrivateConsumerConfig.CallerConfImpl cconfig = null;
        this._properties = new HashMap();
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        securityBindings = appBindings;
        List<WSSBinding> securityBindingList = securityBindings.getSecurityBindings();
        VariableExpander varMap = VariableExpanderFactory.getVariableExpander();
        boolean isBindingTargetNamespace10 = false;
        this.processPrivateConfig(DOMUtils.getPrivateConfig());
        WSSBinding securityBinding = null;
        for (int l = 0; l < securityBindingList.size(); ++l) {
            securityBinding = securityBindingList.get(l);
            if (!securityBinding.getName().equals("application")) continue;
            conBnd = securityBinding.getSecurityInboundBindingConfig();
        }
        List<WSSEncryptionInfo> encryptionInfos = null;
        List<WSSKeyInfo> keyInfos = null;
        List<WSSSigningInfo> signingInfos = null;
        List<WSSToken> tokenConsumers = null;
        List<WSSCaller> callers = null;
        List<WSSTrustAnchor> trustAnchors = null;
        Map<Object, Object> bndParameters = null;
        Map<Object, Object> bndProperties = null;
        if (securityBinding != null) {
            List<Object> sbp = securityBinding.getParameters();
            if (sbp != null) {
                bndParameters = ConfigConstants.getProperties(sbp, varMap);
            }
            if (bndParameters != null) {
                this._properties.putAll(bndParameters);
            }
            if (conBnd != null) {
                List<Object> p = conBnd.getProperties();
                if (p != null) {
                    bndProperties = ConfigConstants.getProperties(p, varMap);
                }
                if (bndProperties != null) {
                    this._properties.putAll(bndProperties);
                }
            }
        }
        List<WSSCollectionCertStores> collectionCertStores = null;
        List<WSSLdapCertStores> ldapCertStores = null;
        nameToken = new HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl>();
        boolean isExplicitlyProtectSignatureConfirmation = false;
        boolean isOnlySignEntireHeadersAndBody = false;
        String bindingTargetNamespace = null;
        if (conBnd != null) {
            encryptionInfos = conBnd.getEncryptionInfos();
            collectionCertStores = conBnd.getCollectionCertStores();
            ldapCertStores = conBnd.getLdapCertStores();
            keyInfos = conBnd.getKeyInfos();
            signingInfos = conBnd.getSigningInfos();
            tokenConsumers = conBnd.getTokens();
            trustAnchors = conBnd.getTrustAnchors();
            callers = conBnd.getCallers();
            isExplicitlyProtectSignatureConfirmation = conBnd.isExplicitlyProtectSignatureConfirmation();
            isOnlySignEntireHeadersAndBody = conBnd.isOnlySignEntireHeadersAndBody();
            bindingTargetNamespace = conBnd.getTargetNamespace();
            if (bindingTargetNamespace.equals("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding")) {
                isBindingTargetNamespace10 = true;
            }
            this._defaultBindingNamespace = bindingTargetNamespace;
            if (tc.isDebugEnabled()) {
                String bndparam = bndParameters == null ? "null" : bndParameters.toString();
                String bndprop = bndProperties == null ? "null" : bndProperties.toString();
                Tr.debug(tc, "Default bindings name space = " + bindingTargetNamespace);
                Tr.debug(tc, "Default Inbound Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenConsumers, ExplicitlyProtectSignatureConfirmation, OnlySignEntireHeadersAndBodyProperty):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenConsumers, isExplicitlyProtectSignatureConfirmation, isOnlySignEntireHeadersAndBody, bndparam, bndprop});
            }
        }
        this._skipOperationLevelPolicyCheck = !ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_CHECK_OPERATION_LEVEL_POLICIES);
        this._explicitlyProtectSignatureConfirmation = isExplicitlyProtectSignatureConfirmation;
        this._onlySignEntireHeadersAndBody = isOnlySignEntireHeadersAndBody;
        if (tokenConsumers != null) {
            iMax = tokenConsumers.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                WSSJaasConfig jaasConfig;
                WSSToken tokenConsumer = tokenConsumers.get(i1);
                QName qn = tokenConsumer.getValueType();
                if (qn == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.nullValueType", tokenConsumer.getName());
                }
                value = tokenConsumer.getSecurityTokenReference();
                if (value != null && value.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found securityTokenReference on default bindings. This is not supported.");
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityDefaultConsumerConfig.s04", value, qn.toString());
                }
                tconfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
                tconfig._type = qn;
                tconfig._className = tokenConsumer.getClassname();
                if (!this._defaultTokenConsumers.contains(tconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; token consumer = " + tconfig._className);
                    }
                }
                boolean foundTA = false;
                callbackHandler = tokenConsumer.getCallbackHandler();
                if (callbackHandler != null) {
                    WSSBasicAuth basicAuth;
                    WSSCertPathSettings certPathSettings;
                    WSSKey key;
                    WSSKeyStore keystore;
                    chconfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    chconfig._className = callbackHandler.getClassname();
                    if (!this._defaultCallbackHandlers.contains(chconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "userDefinedComponentsUsed set to true; callback handler = " + chconfig._className);
                        }
                    }
                    if ((keystore = callbackHandler.getKeyStore()) != null) {
                        ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                        ksconfig._type = keystore.getType();
                        ksconfig._path = ConfigUtil.expandInstallLocation(keystore.getPath());
                        ksconfig._password = PasswordUtilFactory.getInstance().passwordDecode(keystore.getStorepass());
                        ksconfig._ksRef = keystore.getKeyStoreRef();
                        chconfig._keyStore = ksconfig;
                        if (ksconfig._ksRef != null && ksconfig._ksRef.length() != 0) {
                            tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", ksconfig._ksRef);
                        }
                    }
                    if ((key = callbackHandler.getKey()) != null) {
                        kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                        kiconfig._alias = key.getAlias();
                        kiconfig._keypass = PasswordUtilFactory.getInstance().passwordDecode(key.getKeypass());
                        kiconfig._name = key.getName();
                        chconfig._keyInformation = kiconfig;
                    }
                    if ((certPathSettings = callbackHandler.getCertPathSettings()) != null) {
                        chconfig._trustAnyCertificate = certPathSettings.isTrustAnyCertificate();
                        if (!certPathSettings.isTrustAnyCertificate()) {
                            String trustAnchorRef = certPathSettings.getTrustAnchorRef();
                            String certStoreRef = certPathSettings.getCertStoreRef();
                            if (trustAnchorRef != null || certStoreRef != null) {
                                if (trustAnchorRef != null) {
                                    value = trustAnchorRef;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "TrustAnchorRef = " + value);
                                    }
                                    for (int j1 = 0; j1 < trustAnchors.size(); ++j1) {
                                        WSSTrustAnchor trustAnchor = trustAnchors.get(j1);
                                        if (value == null || !value.equals(trustAnchor.getName())) continue;
                                        keystore = trustAnchor.getKeyStore();
                                        if (keystore != null) {
                                            ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                                            ksconfig._type = keystore.getType();
                                            ksconfig._path = ConfigUtil.expandInstallLocation(keystore.getPath());
                                            ksconfig._password = PasswordUtilFactory.getInstance().passwordDecode(keystore.getStorepass());
                                            ksconfig._ksRef = keystore.getKeyStoreRef();
                                            chconfig._trustAnchor = ksconfig;
                                        }
                                        foundTA = true;
                                        break;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(from application binding) Keystore for TrustAnchor: " + value + " = " + chconfig._trustAnchor + ": Found = " + foundTA);
                                    }
                                    if (!foundTA) {
                                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                                    }
                                }
                                if (chconfig._trustAnchor == null) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s32");
                                }
                                KeyStoreManager keystoreManager = KeyStoreManager.getInstance();
                                ksconfig = chconfig._trustAnchor;
                                char[] password = ksconfig._password == null ? null : ksconfig._password.toCharArray();
                                KeyStore kstore = keystoreManager.getKeyStore(ksconfig._path, ksconfig._type, password, ksconfig._ksRef);
                                PKIXBuilderParameters pkixBuilderParams = null;
                                Provider provider = null;
                                try {
                                    X509CertSelector selector = new X509CertSelector();
                                    pkixBuilderParams = new PKIXBuilderParameters(kstore, (CertSelector)selector);
                                    pkixBuilderParams.setDate(null);
                                }
                                catch (InvalidAlgorithmParameterException e) {
                                    String msgKey = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                    Tr.error(tc, msgKey, new Object[]{pkixBuilderParams.toString() == null ? "" : pkixBuilderParams.toString()});
                                    throw SoapSecurityException.format(msgKey, pkixBuilderParams.toString() == null ? "" : pkixBuilderParams.toString(), (Throwable)e);
                                }
                                catch (KeyStoreException e) {
                                    String msgKey = "security.wssecurity.WSSecurityDefaultConsumerConfig.s01";
                                    Tr.processException((Throwable)e, clsName + ".init", "377", this);
                                    Tr.error(tc, msgKey, e.toString());
                                    throw SoapSecurityException.format(msgKey, e);
                                }
                                if (certStoreRef != null) {
                                    value = certStoreRef;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CertStoreRef = " + value);
                                    }
                                    if (collectionCertStores != null || ldapCertStores != null) {
                                        boolean hasCollectionCertStores = false;
                                        jMax = collectionCertStores.size();
                                        if (jMax > 0) {
                                            hasCollectionCertStores = true;
                                        }
                                        if (hasCollectionCertStores) {
                                            for (int j1 = 0; j1 < jMax; ++j1) {
                                                String msgKey;
                                                WSSCollectionCertStores collectionStore = collectionCertStores.get(j1);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "collectionCertStores.get(" + j1 + ") = " + collectionStore.getName());
                                                }
                                                if (value == null || !value.equals(collectionStore.getName())) continue;
                                                provider = Security.getProvider(collectionStore.getProvider());
                                                HashMap<String, CertificateFactory> cache = new HashMap<String, CertificateFactory>();
                                                HashSet<X509Extension> eeCerts = new HashSet<X509Extension>();
                                                List<String> x509s = collectionStore.getX509Paths();
                                                kMax = x509s.size();
                                                if (kMax > 0) {
                                                    for (int k1 = 0; k1 < kMax; ++k1) {
                                                        String x509Path = x509s.get(k1);
                                                        String path = null;
                                                        path = ConfigUtil.expandInstallLocation(x509Path);
                                                        String provider2 = "";
                                                        CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                                        if (cfac == null) {
                                                            cfac = ConfigUtil.createCertificateFactory(provider2);
                                                            cache.put(provider2, cfac);
                                                        }
                                                        File f = new File(path);
                                                        eeCerts.add(ConfigUtil.getX509Certificate(f, cfac));
                                                        if (!tc.isDebugEnabled()) continue;
                                                        Tr.debug(tc, "Adding the X509 Certificate: " + path);
                                                    }
                                                }
                                                List<String> CRLs = collectionStore.getCRLPaths();
                                                if (kMax > 0 && CRLs.size() > 0) {
                                                    for (int k1 = 0; k1 < kMax; ++k1) {
                                                        String crlPath = CRLs.get(k1);
                                                        String path = null;
                                                        path = ConfigUtil.expandInstallLocation(crlPath);
                                                        String provider2 = "";
                                                        CertificateFactory cfac = (CertificateFactory)cache.get(provider2);
                                                        if (cfac == null) {
                                                            cfac = ConfigUtil.createCertificateFactory(provider2);
                                                            cache.put(provider2, cfac);
                                                        }
                                                        File f = new File(path);
                                                        eeCerts.add(ConfigUtil.getX509CRL(f, cfac));
                                                        if (!tc.isDebugEnabled()) continue;
                                                        Tr.debug(tc, "Adding the X509 CRL: " + path);
                                                    }
                                                }
                                                String algorithm = "Collection";
                                                CollectionCertStoreParameters cparams = null;
                                                try {
                                                    cparams = new CollectionCertStoreParameters(eeCerts);
                                                    CertStore certStore = null;
                                                    certStore = provider == null ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                                    pkixBuilderParams.addCertStore(certStore);
                                                    if (!tc.isDebugEnabled()) break;
                                                    Tr.debug(tc, "Found CertStore for " + value);
                                                    break;
                                                }
                                                catch (NoSuchAlgorithmException e) {
                                                    Tr.error(tc, "security.wssecurity.WSSecurityDefaultConsumerConfig.s02", new Object[]{algorithm, e});
                                                    throw SoapSecurityException.format("security.wssecurity.WSSecurityDefaultConsumerConfig.s02", algorithm, e.toString());
                                                }
                                                catch (InvalidAlgorithmParameterException e) {
                                                    msgKey = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                                    Tr.error(tc, msgKey, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                                    throw SoapSecurityException.format(msgKey, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                                                }
                                                catch (Throwable e) {
                                                    msgKey = "security.wssecurity.load.collectioncertstore.failed";
                                                    Tr.error(tc, msgKey, new String[]{collectionStore.getName(), e.getMessage()});
                                                    throw SoapSecurityException.format(msgKey, new String[]{collectionStore.getName(), e.getMessage()}, e);
                                                }
                                            }
                                        }
                                    }
                                }
                                chconfig._provider = provider;
                                chconfig._pkixBuilderParams = pkixBuilderParams;
                            }
                        }
                    }
                    if ((basicAuth = callbackHandler.getBasicAuth()) != null) {
                        value = basicAuth.getUserid();
                        if (value != null && value.length() > 0) {
                            chconfig._userId = value;
                        }
                        if ((value = PasswordUtilFactory.getInstance().passwordDecode(basicAuth.getPassword())) != null && value.length() > 0) {
                            chconfig._userPassword = value.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(chconfig._properties, callbackHandler.getProperties(), varMap);
                    tconfig._callbackHandler = chconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + chconfig.getClassName());
                    }
                }
                if ((jaasConfig = tokenConsumer.getJaasConfig()) == null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s20", qn.toString());
                }
                tconfig._jaasConfig = jaasConfig.getConfigName();
                if (!this._defaultJAASConfigs.contains(tconfig._jaasConfig)) {
                    this._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; JAAS config = " + tconfig._jaasConfig);
                    }
                }
                ConfigConstants.getProperties(tconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                ConfigConstants.getProperties(tconfig._properties, tokenConsumer.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tconfig._className);
                if (appClassLoader != null) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                }
                HashMap<Object, Object> properties = new HashMap<Object, Object>();
                try {
                    tconfig._instance = (TokenConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.Instantiate", new Object[]{tconfig._className});
                }
                this._tokenConsumers.add(tconfig);
                value = ConfigUtil.trim(tokenConsumer.getName());
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + value);
                }
                nameToken.put(value, tconfig);
                tconfig._name = value;
            }
        }
        ArrayList<KeyInfoContentConsumerConfig> kicontentList = new ArrayList<KeyInfoContentConsumerConfig>();
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                String tokenReference;
                WSSKeyInfo keyInfo = keyInfos.get(i1);
                kiccconfig = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                kiccconfig._className = keyInfo.getClassname();
                if (!this._defaultKeyInfoContentConsumers.contains(kiccconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userDefinedComponentsUsed set to true; KeyInfoContentConsumer config = " + kiccconfig._className);
                    }
                }
                if ((tokenReference = keyInfo.getTokenReference()) != null) {
                    boolean ksExist = false;
                    value = tokenReference;
                    if (value != null && value.length() > 0) {
                        kiccconfig._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)nameToken.get(value);
                        if (kiccconfig._tokenConsumer == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the token reference: " + value);
                        }
                        if (!ksExist) {
                            tconfig = kiccconfig._tokenConsumer;
                            String ksRef = (String)tconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                            if (ksRef != null && ConfigUtil.isHWKeyStore(ksRef)) {
                                kiccconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", ksRef);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Hardware KeyStore is selected: " + ksRef);
                                }
                            }
                        }
                    }
                }
                if (keyInfo.getDerivedKeyInfo() != null) {
                    WSSDerivedKeyInfo wssDerivedKeyInfo = keyInfo.getDerivedKeyInfo();
                    DerivedKeyInfoConfig derivedKeyInfo = new DerivedKeyInfoConfig();
                    derivedKeyInfo.setClientLabel(wssDerivedKeyInfo.getClientLabel());
                    derivedKeyInfo.setServiceLabel(wssDerivedKeyInfo.getServiceLabel());
                    derivedKeyInfo.setKeyLength(wssDerivedKeyInfo.getKeyLength());
                    derivedKeyInfo.setNonceLength(wssDerivedKeyInfo.getNonceLength());
                    derivedKeyInfo.setRequireDerivedKeys(wssDerivedKeyInfo.isRequireDerivedKeys());
                    derivedKeyInfo.setRequireExplicitDerivedKeys(wssDerivedKeyInfo.isRequireExplicitDerivedKeys());
                    derivedKeyInfo.setRequireImpliedDerivedKeys(wssDerivedKeyInfo.isRequireImpliedDerivedKeys());
                    kiccconfig._derivedKeyInfo = derivedKeyInfo;
                } else {
                    Map<Object, Object> props = kiccconfig.getTokenConsumer().getProperties();
                    String keyLength = (String)props.get(Constants.DERIVED_KEY_LENGTH);
                    String serviceLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
                    String clientLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
                    String requireImpliedDerivedKeys = (String)props.get("RequiredImpliedDerivedKeys");
                    boolean oldSC = com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(kiccconfig._tokenConsumer._type);
                    if (oldSC) {
                        DerivedKeyInfoConfig derivedKeyInfo = new DerivedKeyInfoConfig();
                        derivedKeyInfo.setRequireDerivedKeys(true);
                        derivedKeyInfo.setRequireExplicitDerivedKeys(true);
                        if (keyLength != null && keyLength.length() > 0) {
                            derivedKeyInfo.setKeyLength(keyLength);
                        }
                        if (serviceLabel != null && serviceLabel.length() > 0) {
                            derivedKeyInfo.setServiceLabel(serviceLabel);
                        }
                        if (clientLabel != null && clientLabel.length() > 0) {
                            derivedKeyInfo.setClientLabel(clientLabel);
                        }
                        if ("true".equals(requireImpliedDerivedKeys)) {
                            derivedKeyInfo.setRequireImpliedDerivedKeys(true);
                        }
                        kiccconfig._derivedKeyInfo = derivedKeyInfo;
                    }
                }
                ConfigConstants.getProperties(kiccconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", kiccconfig._className);
                if (kiccconfig._className == null || kiccconfig._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyInfoContentConsumer classname = " + kiccconfig._className);
                }
                if (this._defaultKeyInfoContentConsumers.contains(kiccconfig._className)) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (appClassLoader != null) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClassLoader used = " + type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader"));
                }
                HashMap<Object, Object> properties = new HashMap<Object, Object>();
                try {
                    kiccconfig._instance = (KeyInfoContentConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.Instantiate", new Object[]{kiccconfig._className});
                }
                kicontentList.add(kiccconfig);
                value = keyInfo.getName();
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (nameKeyInfo.containsKey(value) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: key info [" + value + "] is overwritten.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + value);
                }
                nameKeyInfo.put(value, kiccconfig);
            }
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (i = 0; i < iMax; ++i) {
                String dataEncKeyInfo;
                boolean dataEncryptionFound = false;
                WSSEncryptionInfo encryptionInfo = encryptionInfos.get(i);
                econfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                WSSEncryptionPartReference pref = encryptionInfo.getEncryptionPartReference();
                if (pref != null && (dataEncKeyInfo = pref.getDataEncryptionKeyInfo()) != null) {
                    dataEncryptionFound = true;
                    econfig._isKeyDecryption = false;
                    kicconfig._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                    value = dataEncKeyInfo;
                    if (value != null && value.length() > 0) {
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForDecryption = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Got the key info reference: " + value);
                        }
                    }
                }
                if (!dataEncryptionFound) {
                    List<String> encryptionKeys = encryptionInfo.getKeyEncryptionKeyInfos();
                    if (encryptionKeys == null || encryptionKeys.size() == 0) {
                        kicconfig._contentConsumers = kicontentList;
                        jMax = kicontentList.size();
                        for (int j1 = 0; j1 < jMax; ++j1) {
                            kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)kicontentList.get(j1);
                            tconfig = kiccconfig._tokenConsumer;
                            if (tconfig == null) continue;
                            tconfig._usedForDecryption = true;
                        }
                    } else {
                        econfig._isKeyDecryption = true;
                        kicconfig._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                        jMax = encryptionKeys.size();
                        for (int j2 = 0; j2 < jMax; ++j2) {
                            String encryptionKey = encryptionKeys.get(j2);
                            value = encryptionKey;
                            if (value == null || value.length() <= 0) continue;
                            kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameKeyInfo.get(value);
                            if (kiccconfig == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                            }
                            tconfig = kiccconfig._tokenConsumer;
                            if (tconfig != null) {
                                tconfig._usedForDecryption = true;
                            }
                            kicconfig._contentConsumers.add(kiccconfig);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Got the key info reference: " + value);
                        }
                    }
                }
                econfig._encryptionKeyInfo = kicconfig;
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                this._encryptionConsumers.add(econfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption consumer.");
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (int i1 = 0; i1 < iMax; ++i1) {
                int j1;
                WSSSigningInfo signingInfo = signingInfos.get(i1);
                sconfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                List<WSSSigningPartReference> prefs = signingInfo.getSigningPartReferences();
                if (prefs != null) {
                    jMax = prefs.size();
                    for (int j12 = 0; j12 < jMax; ++j12) {
                        WSSSigningPartReference pref = prefs.get(j12);
                        srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        value = pref.getReference();
                        List<WSSTransform> transforms = pref.getTransforms();
                        if (transforms != null) {
                            kMax = transforms.size();
                            for (int k1 = 0; k1 < kMax; ++k1) {
                                WSSTransform transform = transforms.get(k1);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = transform.getAlgorithm();
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: PartReference not found on SigningInfo. PartReference is required in order to retrieve the signature algorithms from Policy.");
                }
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                List<String> signingKeys = signingInfo.getSigningKeyInfos();
                if (signingKeys == null || signingKeys.size() == 0) {
                    kicconfig._contentConsumers = kicontentList;
                    jMax = kicontentList.size();
                    for (j1 = 0; j1 < jMax; ++j1) {
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)kicontentList.get(j1);
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig == null) continue;
                        tconfig._usedForVerification = true;
                    }
                } else {
                    kicconfig._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                    jMax = signingKeys.size();
                    for (j1 = 0; j1 < jMax; ++j1) {
                        String signingKey = signingKeys.get(j1);
                        value = signingKey;
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForVerification = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                }
                sconfig._signingKeyInfo = kicconfig;
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                this._signatureConsumers.add(sconfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature consumer.");
            }
        }
        if (callers != null) {
            iMax = callers.size();
            for (i = 0; i < iMax; ++i) {
                QName callerIdentity;
                this._loginRequired = true;
                WSSCaller caller = callers.get(i);
                if (caller == null) continue;
                cconfig = new PrivateConsumerConfig.CallerConfImpl();
                if (caller.getOrder() != null && !isBindingTargetNamespace10) {
                    cconfig._order = Integer.parseInt(caller.getOrder());
                }
                if ((callerIdentity = caller.getCallerIdentity()) != null) {
                    cconfig._callerIdentity = callerIdentity;
                }
                if (caller.isAnyTrustedIdentity()) {
                    cconfig._anyTrustedIdentity = true;
                } else {
                    QName trustedIdentity = caller.getTrustedIdentity();
                    if (trustedIdentity != null) {
                        cconfig._identityAssertion = true;
                        cconfig._trustedIdentity = trustedIdentity;
                    }
                }
                WSSJaasConfig jaasConfig = caller.getJaasConfig();
                if (jaasConfig == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC6834E", cconfig.toString());
                }
                cconfig._jaasConfig = jaasConfig.getConfigName();
                ConfigConstants.getProperties(cconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                callbackHandler = caller.getCallbackHandler();
                if (callbackHandler != null) {
                    chconfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    chconfig._className = callbackHandler.getClassname();
                    if (!this._defaultCallbackHandlers.contains(chconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    ConfigConstants.getProperties(chconfig._properties, callbackHandler.getProperties(), varMap);
                    cconfig._callbackHandler = chconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + chconfig.getClassName());
                    }
                }
                this._callers.add(cconfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding caller: " + cconfig);
            }
            if (!isBindingTargetNamespace10) {
                this.setOrderedCallerList();
                this._isOrderEnforced = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Consumer, HashMap):", new Object[]{appBindings, varMap});
        }
    }
}

