/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.SignatureConfirmationGenerator;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.time.WSSObjectTimestampGenerator;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.SetupJCEProviders;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.XMLStructureHelper;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.wssapi.CommonContentGenerator;
import com.ibm.ws.wssecurity.wssapi.WSSObjectStructureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.CommonTokenGenerator;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssobject.axiom.OMWSSObjectDataSource;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.interfaces.BelongsToNamespace;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsNSPrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.wssapi.WSSObjectStructure;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.context.MessageContext;

public abstract class WSSGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private Map<String, Object> _handlerOption = new HashMap<String, Object>();
    private boolean _initialized = false;
    private Map<Object, Object> _axiomProperties = new HashMap<Object, Object>();
    private Map<Object, Object> _wssObjectProperties = Collections.synchronizedMap(new HashMap());
    private boolean _axiomPropertiesInitialized = false;
    private boolean _wssObjectPropertiesInitialized = false;
    private static boolean _useWSSObject;

    public void setHandlerOption(String key, Object value) {
        this._handlerOption.put(key, value);
    }

    public Object getHandlerOption(String key) {
        return this._handlerOption.get(key);
    }

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this.setInitialWSSObjectProperties();
            this.setInitialAxiomProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        boolean doSecurity;
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        if ((messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        RequestPool.initialize(context);
        boolean externalRequests = WSSGenerator.adjustContext(messageContext, context);
        SecurityTokenManagerImpl securityTokenManager = new SecurityTokenManagerImpl(context);
        RequestMessagePool.initialize(context);
        Object obj = messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
            context.put("com.ibm.ws.wssecurity.constants.wssVersion", obj);
        }
        WSSGeneratorConfig config2 = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSGeneratorConfig [" + config2 + "].");
        }
        TimestampGeneratorConfig tsconfig = config2.getTimestampGenerator();
        String enforceLayout = (String)messageContext.getProperty("com.ibm.ws.wssecurity.EnforceStrictLayout");
        if (enforceLayout != null) {
            HashMap props = (HashMap)config2.getProperties();
            props.put("com.ibm.ws.wssecurity.EnforceStrictLayout", enforceLayout);
        }
        HashMap<Object, Object> properties = new HashMap<Object, Object>(20);
        context.put(NonceManager.class, config2.getNonceManager());
        boolean isRequest = config2.isRequest();
        boolean doSignatureConfirmation = config2.isSignatureConfirmationRequired();
        boolean doTimestamp = config2.isTimestampEnabled();
        boolean bl = doSecurity = config2.isTokenEnabled() || config2.isSignatureEnabled() || config2.isEncryptionEnabled() || doTimestamp && !tsconfig.isSOAPHeaderElement() || externalRequests;
        if (!doTimestamp && !doSecurity) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        String actionURI = null;
        if (messageContext.getTo() != null) {
            String serviceEndpointAddress = messageContext.getTo().getAddress();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The Target end point address = " + serviceEndpointAddress);
            }
            if (serviceEndpointAddress.equals(com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS_ANONYMOUS[0]) || serviceEndpointAddress.equals(com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS_ANONYMOUS[1])) {
                actionURI = messageContext.getWSAAction();
                if (actionURI != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the action as Target end point address = " + actionURI);
                    }
                    context.put("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", actionURI);
                }
            } else {
                context.put("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", serviceEndpointAddress);
            }
        }
        SOAPEnvelope soapEnv = messageContext.getEnvelope();
        if (doc == null) {
            doc = DOMUtil.getOwnerDocument(soapEnv);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The original message to be processed by WSSGenerator: ");
            CommonLogUtils.logDebug(doc.getOMDocumentElement(), tc);
        }
        if (parent == null) {
            parent = WSSGenerator.getHeader(doc, true);
        } else {
            int ret = NamespaceUtil.checkSoapVersion(parent, -1, "Header");
            if (ret < 0) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtils.getQualifiedName(parent), "Header");
            }
        }
        int soapVersion = NamespaceUtil.isSoap(parent.getNamespace() == null ? null : parent.getNamespace().getNamespaceURI());
        context.put("com.ibm.ws.wssecurity.constants.soapVersion", new Integer(soapVersion));
        this.outboundHeaderGoldenPathCheck(context, config2);
        boolean mustUnderstand = true;
        boolean isServer = Axis2Util.isServiceProvider(messageContext);
        if (!doSecurity) {
            properties.putAll(this._axiomProperties);
            if (doTimestamp) {
                mustUnderstand = this.checkMustUnderstand(config2, messageContext, isServer);
                WSSGenerator.callTimestampGenerator(tsconfig, properties, doc, parent, context);
            }
        } else {
            Set<TokenGeneratorConfig> tokens;
            mustUnderstand = this.checkMustUnderstand(config2, messageContext, isServer);
            OMElement security = WSSGenerator.addSecurityHeader(doc, parent, soapVersion, wssVersion, config2.getTargetActor(), context, mustUnderstand);
            if (WSSObjectUtils.getWSSObjectSecurityHeader(context) == null) {
                properties.putAll(this._axiomProperties);
            } else {
                properties.putAll(this._wssObjectProperties);
            }
            String rmActionURI = null;
            if (doSignatureConfirmation && (rmActionURI = WSSGenerator.getRMAction(parent, messageContext, config2.getTargetActor(), soapVersion)) != null) {
                if (!isRequest) {
                    if (rmActionURI.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[0]) || rmActionURI.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[2]) || rmActionURI.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[3]) || rmActionURI.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[5])) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not doing SignatureConfirmation generation since this is a CreateSequence or SequenceAcknowledgement from provider");
                        }
                        doSignatureConfirmation = false;
                    }
                } else if (rmActionURI.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[1]) || rmActionURI.equals(com.ibm.ws.wssecurity.common.Constants.NS_RMACTION[4])) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not doing SignatureConfirmation generation since this is a CreateSequenceResponse from client");
                    }
                    doSignatureConfirmation = false;
                }
            }
            if (doSignatureConfirmation && !isRequest) {
                WSSGenerator.callSignatureConfirmationGenerator(properties, doc, security, context);
            }
            if (doTimestamp) {
                WSSGenerator.callTimestampGenerator(tsconfig, properties, doc, security, context);
            }
            if ((tokens = config2.getTokenGenerators()).size() > 0) {
                this.retrieveCachedInformation(messageContext);
            }
            Iterator<Object> i = tokens.iterator();
            while (i.hasNext()) {
                WSSGenerator.callTokenGenerator((TokenGeneratorConfig)i.next(), properties, doc, security, context);
            }
            Collection<SecurityToken> saTokens = securityTokenManager.getTokens();
            if (saTokens != null && saTokens.size() > 0) {
                HashSet<Object> set = new HashSet<Object>();
                i = saTokens.iterator();
                XMLStructureHelper xmlHlpr = new XMLStructureHelper();
                OMElement ome = null;
                while (i.hasNext()) {
                    final SecurityToken token = (SecurityToken)i.next();
                    XMLStructure xmlStr = null;
                    xmlStr = token instanceof UsernameToken ? AccessController.doPrivileged(new PrivilegedAction<XMLStructure>(){

                        @Override
                        public XMLStructure run() {
                            XMLStructure xmlStr = token.getXML();
                            return xmlStr;
                        }
                    }) : token.getXML();
                    if (xmlStr == null) continue;
                    if (xmlStr instanceof WSSObjectStructure) {
                        set.add(((WSSObjectStructureImpl)xmlStr).getObject());
                    } else {
                        ome = xmlHlpr.getOMElement(token, context);
                        if (ome != null) {
                            set.add(ome);
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the element of stand-alone token [" + token + "].");
                }
                context.put("com.ibm.ws.wssecurity.constants.standAloneElements", set);
            }
            ArrayList sigCache = null;
            if (doSignatureConfirmation && isRequest) {
                sigCache = new ArrayList();
                context.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", sigCache);
            }
            List<Configuration> operations = config2.getOperationGenerators();
            if (config2.isNormalBodyProcessing() && config2.isOutboundGoldenPath()) {
                for (Configuration tconf : operations) {
                    EncryptionGeneratorConfig econf;
                    if (!(tconf instanceof EncryptionGeneratorConfig) || !(econf = (EncryptionGeneratorConfig)tconf).encryptsBody()) continue;
                    context.put("com.ibm.ws.wssecurity.emc.BodyEncryptionGeneratorConfig", econf);
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Added Body EncryptionGeneratorConfig object to context Map");
                    break;
                }
            }
            for (Configuration conf : operations) {
                if (conf instanceof SignatureGeneratorConfig) {
                    WSSGenerator.callSignatureGenerator((SignatureGeneratorConfig)conf, properties, doc, security, context);
                    continue;
                }
                if (conf instanceof EncryptionGeneratorConfig) {
                    WSSGenerator.callEncryptionGenerator((EncryptionGeneratorConfig)conf, properties, doc, security, context);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s04", conf.getClass().getName());
            }
            List sigCacheOnContext = (List)context.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            if (sigCacheOnContext != null && sigCacheOnContext.size() > 0) {
                if (tc.isDebugEnabled()) {
                    int numSigConfElements = sigCacheOnContext.size();
                    Tr.debug(tc, "client side , Signature_Confirmation cache size = " + numSigConfElements);
                    for (int k = 0; k < numSigConfElements; ++k) {
                        String sigValue = (String)sigCacheOnContext.get(k);
                        Tr.debug(tc, "client side , Signature_Confirmation value = " + sigValue);
                    }
                }
                HashMap<String, List> wssProperties = null;
                wssProperties = (HashMap<String, List>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                if (wssProperties == null) {
                    wssProperties = new HashMap<String, List>();
                }
                HashMap<String, List> wssRampProperties = null;
                wssRampProperties = (HashMap<String, List>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                if (wssRampProperties == null) {
                    wssRampProperties = new HashMap<String, List>();
                }
                wssProperties.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", sigCacheOnContext);
                messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", wssProperties);
                wssRampProperties.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", sigCacheOnContext);
                messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssRampProperties);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stored SIGNATURE_CONFIRMATION_CACHE on msg ctx in WSS_PROPERTYMAP and WSS_RAMP_PROPERTYMAP properties");
                }
                context.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            }
        }
        if (doTimestamp) {
            if (WSSObjectUtils.getWSSObjectSecurityHeader(context) == null) {
                TimestampGenerator.moveTimestamp(doc, config2.getTimestampGenerator(), properties, context);
            } else {
                WSSObjectTimestampGenerator.moveTimestamp(doc, config2.getTimestampGenerator(), properties, context);
            }
        }
        if (config2.isUserDefinedComponentsUsed()) {
            IdUtils.getInstance().checkIdUniqueness(doc);
        }
        securityTokenManager.finalizeSubject();
        RequestPool.finalize(context);
        RequestMessagePool.finalize(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument doc, OMElement parent, Map context)");
        }
    }

    public void onFault(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(SOAPMessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(SOAPMessageContext context)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
    }

    private void setInitialAxiomProperties() throws SoapSecurityException {
        if (!this._axiomPropertiesInitialized) {
            this._axiomProperties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
            this._axiomProperties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
            this._axiomProperties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
            this._axiomProperties.put(QNameHeaderSelector.class, new QNameHeaderSelector());
            this._axiomProperties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
            this._axiomProperties.put(XPathElementSelector.class, new XPathElementSelector());
            this._axiomProperties.put("com.ibm.ws.wssecurity.util.selector.IDResolver", IdUtils.getInstance());
            WSSFactory factory = WSSFactory.getInstance("soap");
            HashMap<Object, Object> type = new HashMap<Object, Object>();
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp");
            this._axiomProperties.put(TimestampGenerator.class, factory.createGenerator(type, this._axiomProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signature");
            this._axiomProperties.put(SignatureGenerator.class, factory.createGenerator(type, this._axiomProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption");
            this._axiomProperties.put(EncryptionGenerator.class, factory.createGenerator(type, this._axiomProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo");
            this._axiomProperties.put(KeyInfoGenerator.class, factory.createGenerator(type, this._axiomProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signatureConfirmation");
            this._axiomProperties.put(SignatureConfirmationGenerator.class, factory.createGenerator(type, this._axiomProperties));
            this._axiomPropertiesInitialized = true;
        }
    }

    private void setInitialWSSObjectProperties() throws SoapSecurityException {
        if (!this._wssObjectPropertiesInitialized) {
            this._wssObjectProperties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
            this._wssObjectProperties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
            this._wssObjectProperties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
            this._wssObjectProperties.put(QNameHeaderSelector.class, new QNameHeaderSelector());
            this._wssObjectProperties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
            this._wssObjectProperties.put(XPathElementSelector.class, new XPathElementSelector());
            this._wssObjectProperties.put("com.ibm.ws.wssecurity.util.selector.IDResolver", IdUtils.getInstance());
            WSSFactory factory = WSSFactory.getInstance("WSSObject");
            HashMap<Object, Object> type = new HashMap<Object, Object>();
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp");
            this._wssObjectProperties.put(TimestampGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signature");
            this._wssObjectProperties.put(SignatureGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption");
            this._wssObjectProperties.put(EncryptionGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo");
            this._wssObjectProperties.put(KeyInfoGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfoContent");
            this._wssObjectProperties.put(CommonContentGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.token");
            this._wssObjectProperties.put(CommonTokenGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signatureConfirmation");
            this._wssObjectProperties.put(SignatureConfirmationGenerator.class, factory.createGenerator(type, this._wssObjectProperties));
            this._wssObjectPropertiesInitialized = true;
        }
    }

    private static boolean adjustContext(MessageContext context, Map<Object, Object> ccontext) throws SoapSecurityException {
        return false;
    }

    public abstract void retrieveCachedInformation(MessageContext var1) throws SoapSecurityException;

    public static OMElement getHeader(OMDocument doc, boolean creation) throws SoapSecurityException {
        OMNamespace ns;
        OMElement root;
        OMElement header;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeader(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "boolean creation[" + creation + "})");
        }
        if ((header = DOMUtils.getFirstElement(root, (ns = (root = doc.getOMDocumentElement()).getNamespace()) == null ? null : ns.getNamespaceURI(), "Header")) == null && creation) {
            OMNode first;
            OMFactory factory = root.getOMFactory();
            if (factory instanceof SOAPFactory) {
                header = ((SOAPFactory)factory).createSOAPHeader();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Header found, so creating SOAPHeader.");
                }
            } else {
                header = factory.createOMElement("Header", ns);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Header found, so creating OMElement named Header.");
                }
            }
            if ((first = root.getFirstOMChild()) == null) {
                root.addChild(header);
            } else {
                first.insertSiblingBefore(header);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getheader(OMDocument doc) returns Element[", DOMUtils.getDisplayName(header) + "]");
        }
        return header;
    }

    private static OMElement addSecurityHeader(OMDocument doc, OMElement header, int soapVersion, int wssVersion, String actor, Map context, boolean mustUnderstand) throws SoapSecurityException {
        boolean useWSSObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSecurityHeader(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement header[" + DOMUtils.getDisplayName(header) + "]," + "int soapVersion[" + soapVersion + "]," + "int wssVersion[" + wssVersion + "]," + "String actor[" + actor + "]," + "Map context[HashMap]," + "boolean mustUnderstand[" + mustUnderstand + "])");
        }
        OMElement security = null;
        security = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, mustUnderstand);
        if (security != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSecurityHeader Uses existing wsse:Security element");
            }
            context.put("com.ibm.ws.wssecurity.useWSSObject", Boolean.FALSE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Use of WSSObject disabled because existing Security header found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,Map context,boolean mustUnderstand) returns Element[" + DOMUtils.getDisplayName(security) + "]");
            }
            return security;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addSecurityHeader Creates new wsse:Security element");
        }
        security = (useWSSObject = WSSObjectUtils.isWSSObjectEnabled(context)) ? WSSGenerator.addWSSObjectSecurityHeader(doc, header, soapVersion, actor, context, mustUnderstand) : WSSGenerator.addAxiomSecurityHeader(doc, header, soapVersion, actor, mustUnderstand);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSecurityHeader(Document doc,Element header,int soapVersion,int wssVersion,String actor,Map context,boolean mustUnderstand) returns Element[" + DOMUtils.getDisplayName(security) + "]");
        }
        return security;
    }

    private static OMElement addAxiomSecurityHeader(OMDocument doc, OMElement header, int soapVersion, String actor, boolean mustUnderstand) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAxiomSecurityHeader(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement header[" + DOMUtils.getDisplayName(header) + "]," + "int soapVersion[" + soapVersion + "]," + "String actor[" + actor + "]," + "boolean mustUnderstand[" + mustUnderstand + "])");
        }
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        OMElement security = null;
        security = factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock("Security", factory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse")) : factory.createOMElement("Security", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        security.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        WSSGenerator.insertSecurityHeader(header, security);
        String prefix = header.getNamespace() == null ? null : header.getNamespace().getPrefix();
        String nsSoap = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][soapVersion];
        if (actor != null) {
            String ac = soapVersion == 0 ? "actor" : "role";
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                security.declareNamespace(nsSoap, prefix);
            }
            security.addAttribute(ac, actor, factory.createOMNamespace(nsSoap, prefix));
        }
        if (mustUnderstand) {
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                security.declareNamespace(nsSoap, prefix);
            }
            security.addAttribute("mustUnderstand", "1", factory.createOMNamespace(nsSoap, prefix));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAxiomSecurityHeader(Document doc,Element header,int soapVersion,String actor,boolean mustUnderstand) returns Element[" + DOMUtils.getDisplayName(security) + "]");
        }
        return security;
    }

    private static OMElement addWSSObjectSecurityHeader(OMDocument doc, OMElement header, int soapVersion, String actor, Map context, boolean mustUnderstand) throws SoapSecurityException {
        OMSourcedElement secElement;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSSObjectSecurityHeader(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement header[" + DOMUtils.getDisplayName(header) + "]," + "int soapVersion[" + soapVersion + "]," + "String actor[" + actor + "]," + "Map context[HashMap]," + "boolean mustUnderstand[" + mustUnderstand + "])");
        }
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        WSSObjectDocumentImpl wssObjectDocumentImpl = new WSSObjectDocumentImpl(1);
        wssObjectDocumentImpl.getNamespacesInAncestor().gatherDeclaredOMNamespacesInAncestor(header);
        Security security = new Security(wssObjectDocumentImpl);
        if (security instanceof BelongsToNamespace) {
            Security belongsToNamespace = security;
            wssObjectDocumentImpl.declareNamespace(belongsToNamespace.getNamespace());
        }
        security.setParent(wssObjectDocumentImpl);
        wssObjectDocumentImpl.setRootWSSObject(security);
        if (soapVersion == 0) {
            if (actor != null) {
                security.setSoapActor(VariablePartFactory.getInstance().createAttrValueWithString(actor));
            }
            if (mustUnderstand) {
                security.setSoapMustUnderstand(Utf8ByteConstantsVariableParts.VPA_1);
            } else {
                security.setSoapMustUnderstand(Utf8ByteConstantsVariableParts.VPA_0);
            }
        } else {
            if (actor != null) {
                security.setSoap12Role(VariablePartFactory.getInstance().createAttrValueWithString(actor));
            }
            if (mustUnderstand) {
                security.setSoap12MustUnderstand(Utf8ByteConstantsVariableParts.VPA_1);
            } else {
                security.setSoap12MustUnderstand(Utf8ByteConstantsVariableParts.VPA_0);
            }
        }
        QName qname = new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, LocalNameConstants.LocalNamesWSSE10.LN_SECURITY, Utf8ByteConstantsNSPrefixPair.PRE_NS_WSSE);
        OMWSSObjectDataSource omwssoda = new OMWSSObjectDataSource(qname, wssObjectDocumentImpl);
        if (factory instanceof SOAPFactory) {
            OMNamespace omnamespace = factory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, Utf8ByteConstantsNSPrefixPair.PRE_NS_WSSE);
            secElement = ((SOAPFactory)factory).createSOAPHeaderBlock(LocalNameConstants.LocalNamesWSSE10.LN_SECURITY, omnamespace, omwssoda);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created SOAPHeaderBlock OMSourcedElement Security header");
            }
        } else {
            secElement = new OMSourcedElementImpl(qname, factory, omwssoda);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created OMSourcedElement Security header");
            }
        }
        WSSGenerator.insertSecurityHeader(header, secElement);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added the Security header: " + security.toString());
        }
        context.put("com.ibm.ws.wssecurity.WSSObjectSecurityHeader", security);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSSObjectSecurityHeader(Document doc,Element header,int soapVersion,String actor,Map context,boolean mustUnderstand) returns Element[" + DOMUtils.getDisplayName(secElement) + "]");
        }
        return secElement;
    }

    private static void insertSecurityHeader(OMElement header, OMElement security) throws SoapSecurityException {
        OMNode first = header.getFirstOMChild();
        if (first == null) {
            header.addChild(security);
        } else {
            if (tc.isDebugEnabled() && first.getPreviousOMSibling() != null) {
                Tr.debug(tc, "ERROR: addSecurityHeader: First child points to himself!");
            }
            first.insertSiblingBefore(security);
        }
    }

    public static OMElement getSecurityHeader(OMElement header, int soapVersion, int wssVersion, String actor, boolean mustUnderstand) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchForSecurityHeader(Element header[" + DOMUtils.getDisplayName(header) + "]," + "int soapVersion[" + soapVersion + "]," + "int wssVersion[" + wssVersion + "]," + "String actor[" + actor + "]," + "boolean mustUnderstand[" + mustUnderstand + "])");
        }
        OMElement el = DOMUtils.getFirstElement(header);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            if ((wssVersion < 0 || NamespaceUtil.isWsse(ns) == wssVersion) && "Security".equals(ln)) {
                String mu;
                String act;
                if (soapVersion == 1) {
                    act = el.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
                    mu = el.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_MU_Q);
                } else if (soapVersion == 0) {
                    act = el.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
                    mu = el.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_MU_Q);
                } else {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(soapVersion));
                }
                if (!(actor != null && actor.length() != 0 ? !actor.equals(act) : act != null && act.trim().length() != 0)) {
                    if (mustUnderstand) {
                        boolean muAttribute = false;
                        if (mu != null && !"".equals(mu)) {
                            muAttribute = ConfigUtil.isTrue(mu);
                        }
                        if (!muAttribute) {
                            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s12", mu, Boolean.toString(mustUnderstand));
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, " searchForSecurityHeader() return an OMElement. Its contents follow:");
                        CommonLogUtils.logDebug(el, tc);
                        Tr.exit(tc, "searchForSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns Element[ el ]");
                    }
                    return el;
                }
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchForSecurityHeader(Element header,int soapVersion,int wssVersion,String actor,boolean mustUnderstand) returns null");
        }
        return null;
    }

    private static void callSignatureConfirmationGenerator(Map<Object, Object> selectors, OMDocument document, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callSignatureConfirmationGenerator(Map selectors,OMDocument document[" + document + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        WSSGeneratorComponent gen = (WSSGeneratorComponent)selectors.get(SignatureConfirmationGenerator.class);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callSignatureConfirmationGenerator(Map selctors,Document document,Element parent,Map context)");
        }
    }

    private static void callTimestampGenerator(TimestampGeneratorConfig config2, Map<Object, Object> selectors, OMDocument document, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document[" + DOMUtils.getDisplayName(document.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        WSSGeneratorComponent gen = (WSSGeneratorComponent)selectors.get(TimestampGenerator.class);
        context.put("com.ibm.ws.wssecurity.impl.config.timestampGenerator.configKey", config2);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callTimestampGenerator(TimestampGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callTokenGenerator(TokenGeneratorConfig config2, Map properties, OMDocument document, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callTokenGenerator(TokenGeneratorConfig config,Map properties,Document document[" + DOMUtils.getDisplayName(document.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        if (config2.isStandAlone()) {
            PrivateGeneratorConfig.TokenGeneratorConfImpl confImpl = (PrivateGeneratorConfig.TokenGeneratorConfImpl)config2;
            TokenGeneratorComponent gen = confImpl.getInstance();
            if (gen == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get the TokenGenerator object: [" + config2 + "].");
                }
            } else {
                Security security;
                TokenGeneratorComponent tmp = (TokenGeneratorComponent)properties.get(gen.getClass());
                if (tmp != null) {
                    gen = tmp;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Will invoke TokenGenerator of type " + gen.getClass().getName());
                }
                if ((security = WSSObjectUtils.getWSSObjectSecurityHeader(context)) != null) {
                    context.put("com.ibm.ws.wssecurity.WSSObjectTokenParent", security);
                }
                context.put("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey", config2);
                gen.invoke(document, parent, context);
                context.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
                if (security != null) {
                    context.remove("com.ibm.ws.wssecurity.WSSObjectTokenParent");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callTokenGenerator(TokenGeneratorConfig config,Map properties,Document document,Element parent,Map context)");
        }
    }

    private static void callSignatureGenerator(SignatureGeneratorConfig config2, Map<Object, Object> selectors, OMDocument document, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callSignatureGenerator(SignatureGeneratorConfig config,Map selectors,Document document[" + DOMUtils.getDisplayName(document.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        WSSGeneratorComponent gen = (WSSGeneratorComponent)selectors.get(SignatureGenerator.class);
        context.put("com.ibm.ws.wssecurity.impl.config.signatureGenerator.configKey", config2);
        context.put("com.ibm.ws.wssecurity.WSSGeneratorSelectors", selectors);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callSignatureGenerator(WSSFactory factory,SignatureGeneratorConfig config,Map type,Map selectors,Document document,Element parent,Map context)");
        }
    }

    private static void callEncryptionGenerator(EncryptionGeneratorConfig config2, Map<Object, Object> selectors, OMDocument document, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document[" + DOMUtils.getDisplayName(document.getOMDocumentElement()) + "]," + "Element parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        WSSGeneratorComponent gen = (WSSGeneratorComponent)selectors.get(EncryptionGenerator.class);
        context.put("com.ibm.ws.wssecurity.impl.config.encryptionGenerator.configKey", config2);
        gen.invoke(document, parent, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callEncryptionGenerator(EncryptionGeneratorConfig config,Map selectors,Document document,Element parent,Map context)");
        }
    }

    public static String getRMAction(OMElement parent, MessageContext messageContext, String act, int soapVersion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMAction()");
        }
        boolean isRMServiceRequest = false;
        ArrayList rmactionHeader = null;
        String actionURI = null;
        if (messageContext.getWSAAction() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found wsa:Action[" + actionURI + "] in the message context.");
            }
            actionURI = messageContext.getWSAAction();
        } else {
            OMElement actionHeader;
            rmactionHeader = com.ibm.ws.wssecurity.util.DOMUtil.getHeadersForNamespace(parent, com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0], "Action", act, soapVersion);
            if (rmactionHeader == null || rmactionHeader.size() <= 0) {
                rmactionHeader = com.ibm.ws.wssecurity.util.DOMUtil.getHeadersForNamespace(parent, com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[1], "Action", act, soapVersion);
            }
            if (rmactionHeader != null && rmactionHeader.size() > 0 && (actionHeader = (OMElement)rmactionHeader.get(0)) != null) {
                actionURI = actionHeader.getText();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMAction returns = " + actionURI);
        }
        return actionURI;
    }

    private void outboundHeaderGoldenPathCheck(Map<Object, Object> context, WSSGeneratorConfig config2) {
        if (_useWSSObject) {
            if (config2.isOutboundGoldenPath()) {
                context.put("com.ibm.ws.wssecurity.useWSSObject", Boolean.TRUE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use of WSSObject enabled because configuration is Golden Path");
                }
            } else {
                context.put("com.ibm.ws.wssecurity.useWSSObject", Boolean.FALSE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use of WSSObject disabled because configuration is not Golden Path");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Use of WSSObject not enabled via System property");
        }
    }

    private boolean checkMustUnderstand(WSSGeneratorConfig config2, MessageContext messageContext, boolean isServer) {
        boolean mustUnderstand = true;
        if (isServer) {
            boolean setMustUnderstand = config2.getServiceGetMustUnderstand();
            if (setMustUnderstand) {
                mustUnderstand = Axis2Util.getMustUnderstand(messageContext);
            }
        } else {
            mustUnderstand = config2.getClientSetMustUnderstand();
        }
        Axis2Util.setMustUnderstand(messageContext, mustUnderstand);
        return mustUnderstand;
    }

    static {
        String prop;
        tc = Tr.register(WSSGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        _useWSSObject = true;
        if (System.getProperty("setup-jce") != null) {
            SetupJCEProviders.setup();
        }
        if ((prop = System.getProperty("com.ibm.ws.wssecurity.useWSSObject")) != null && ("false".equalsIgnoreCase(prop) || "no".equalsIgnoreCase(prop) || "0".equalsIgnoreCase(prop) || "off".equalsIgnoreCase(prop))) {
            _useWSSObject = false;
        }
    }
}

