/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.ResultMessagePool;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.dsig.VerificationResult;
import com.ibm.ws.wssecurity.dsig.VerifiedPartChecker;
import com.ibm.ws.wssecurity.enc.DecryptedPartChecker;
import com.ibm.ws.wssecurity.enc.DecryptionResult;
import com.ibm.ws.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.time.TimestampChecker;
import com.ibm.ws.wssecurity.time.TimestampConsumer;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.token.LoginProcessor;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IDResolverImpl;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class WSSConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(WSSConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSConsumer.class.getName();
    private static final QName URI_Q = new QName("", "URI");
    private static final QName VALUETYPE_Q = new QName("", "ValueType");
    private static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
    private Map<String, Object> _handlerOption = new HashMap<String, Object>();
    private Map<Object, Object> _properties = new HashMap<Object, Object>();
    private boolean _initialized = false;
    public static boolean useInboundBodyOptimization = true;
    private static boolean isSecurityEnabled;

    public void setHandlerOption(String key, Object value) {
        this._handlerOption.put(key, value);
    }

    public Object getHandlerOption(String key) {
        return this._handlerOption.get(key);
    }

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invoke(");
            buf.append("OMNode target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        HashMap tokensToConsume = new HashMap(2);
        HashMap securityHeaders = new HashMap(2);
        HashMap storedTokenTypes = new HashMap(2);
        HashMap v1TokensokenTypes = new HashMap(2);
        HashMap<String, OMElement> timestampVerificationHash = new HashMap<String, OMElement>(2);
        context.put("com.ibm.ws.wssecurity.constants.tokenCache", tokensToConsume);
        context.put("com.ibm.ws.wssecurity.constants.securityHeadersCache", securityHeaders);
        context.put("com.ibm.ws.wssecurity.constants.tokenCacheType", storedTokenTypes);
        context.put("com.ibm.ws.wssecurity.constants.viTokensHash", v1TokensokenTypes);
        context.put("com.ibm.ws.wssecurity.constants.timestampVerificationHash", timestampVerificationHash);
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        WSSConsumerConfig config2 = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        SOAPEnvelope soapEnv = messageContext.getEnvelope();
        boolean bl = true;
        while (true) {
            ArrayList sigCache;
            int numSigsInCache;
            int numSigConfElements;
            String act;
            boolean mustUnderstand;
            OMElement security;
            int i;
            int wssVersion;
            int soapVersion;
            OMElement header;
            OMElement root;
            boolean doSignatureConfirmation;
            boolean isRequest;
            HashMap<Object, Object> properties;
            SecurityTokenManagerImpl securityTokenManager;
            block153: {
                ArrayList sigCacheRAMPPropMap;
                ArrayList sigCacheWssPropMap;
                block157: {
                    HashMap pMap;
                    Object prop;
                    Iterator it;
                    block156: {
                        SOAPHeaderBlock sh;
                        boolean processHeader;
                        block150: {
                            OMDocument doc;
                            block152: {
                                block154: {
                                    block155: {
                                        ArrayList<OMElement> secList;
                                        block149: {
                                            boolean requiredSecurity;
                                            TimestampConsumerConfig tsconfig;
                                            block151: {
                                                if (!bl || (bl = false)) break block149;
                                                processHeader = this.shouldProcessSecurityHeader(config2);
                                                if (!processHeader) break block150;
                                                ResultPool.initialize(context);
                                                WSSConsumer.adjustContext(messageContext, context);
                                                ResultMessagePool.initialize(context);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "WSSConsumerConfig [" + config2 + "].");
                                                }
                                                securityTokenManager = new SecurityTokenManagerImpl(context);
                                                tsconfig = config2.getTimestampConsumer();
                                                String enforceLayout = (String)messageContext.getProperty("com.ibm.ws.wssecurity.EnforceStrictLayout");
                                                if (enforceLayout != null) {
                                                    HashMap props = (HashMap)config2.getProperties();
                                                    props.put("com.ibm.ws.wssecurity.EnforceStrictLayout", enforceLayout);
                                                }
                                                properties = new HashMap<Object, Object>(this._properties);
                                                context.put(NonceManager.class, config2.getNonceManager());
                                                context.put(CertCacheManager.class, config2.getCertManager());
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Finished initializing the subject.");
                                                }
                                                isRequest = config2.isRequest();
                                                doSignatureConfirmation = config2.isSignatureConfirmationRequired();
                                                boolean bl2 = requiredSecurity = config2.isTokenRequired() || config2.isVerificationRequired() || config2.isDecryptionRequired() || config2.isLoginRequired() || config2.isTimestampRequired();
                                                if (config2.isVerificationRequired() || config2.isDecryptionRequired()) {
                                                    String prop2 = "org.apache.axis2.jaxws.enableJAXBPayloadStreaming";
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Setting property \"" + prop2 + "\" to false on MessageContext to disable JAXB Streaming");
                                                    }
                                                    messageContext.setProperty(prop2, new Boolean(false));
                                                } else if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "No verification or decryption used. Allow JAXB Streaming.");
                                                }
                                                doc = DOMUtil.getOwnerDocument(soapEnv);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "The original message to be processed by WSSConsumer:");
                                                    CommonLogUtils.logDebug(doc.getOMDocumentElement(), tc);
                                                }
                                                if (!requiredSecurity) {
                                                    if (tc.isEntryEnabled()) {
                                                        Tr.exit(tc, "invoke(Element target, Map context)");
                                                    }
                                                    return;
                                                }
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Starts WS-Security operation.");
                                                }
                                                root = doc.getOMDocumentElement();
                                                header = WSSGenerator.getHeader(doc, false);
                                                if (header != null) break block151;
                                                Tr.debug(tc, "SOAP Header is null. Bypassed consuming of security header.");
                                                break block152;
                                            }
                                            soapVersion = NamespaceUtil.isSoap(header.getNamespace() == null ? null : header.getNamespace().getNamespaceURI());
                                            IDResolverImpl resolver2 = new IDResolverImpl(header);
                                            context.put("com.ibm.ws.wssecurity.util.selector.IDResolver", resolver2);
                                            Integer aSoapVersion = new Integer(soapVersion);
                                            context.put("com.ibm.ws.wssecurity.constants.soapVersion", aSoapVersion);
                                            if (tc.isDebugEnabled()) {
                                                String msg = null;
                                                msg = soapVersion == 0 ? "The spec of SOAP is SOAP1.1." : (soapVersion == 1 ? "The spec of SOAP is SOAP1.2." : ("Unknown spec of SOAP: " + header.getNamespace() == null ? null : header.getNamespace().getNamespaceURI()));
                                                Tr.debug(tc, msg);
                                            }
                                            secList = WSSConsumer.getSecurityHeaders(header, soapVersion, config2.isUltimateReceiver(), config2.getMyActor());
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, secList.size() + " security headers found");
                                            }
                                            if (secList.size() == 0) {
                                                Tr.warning(tc, "security.wssecurity.WSSConsumer.s38", config2.getMyActor());
                                            }
                                            boolean requireIdCheck = false;
                                            String skipId = (String)messageContext.getProperty("com.ibm.ws.wssecurity.constants.checkIdUniqueness");
                                            if (skipId != null && skipId.equals("true")) {
                                                requireIdCheck = true;
                                            }
                                            if (!requireIdCheck) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Skipping the Id uniqueness check.");
                                                }
                                            } else {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Performing the Id uniqueness check.");
                                                }
                                                IdUtils.getInstance().checkIdUniqueness(doc);
                                            }
                                            wssVersion = -1;
                                            if (requiredSecurity && secList.size() == 0) {
                                                if (WSSConsumer.countSecurityHeaders(header) > 0) {
                                                    if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                                        WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.SEC_HEADER_MISSING, null);
                                                        WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
                                                    }
                                                    if (config2.getMyActor() == null || config2.getMyActor().trim().length() == 0) {
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace, but it was not found.");
                                                        }
                                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s39");
                                                    }
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace and the " + config2.getMyActor() + " actor, but it was not found.");
                                                    }
                                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s40", config2.getMyActor());
                                                }
                                                if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                                    WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.SEC_HEADER_MISSING, null);
                                                    WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
                                                }
                                                if (config2.getMyActor() == null || config2.getMyActor().trim().length() == 0) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace, but it was not found.");
                                                    }
                                                } else if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace and the " + config2.getMyActor() + " actor, but it was not found.");
                                                }
                                            }
                                            if (config2.isTimestampRequired()) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Processing the timestamp.");
                                                }
                                                ArrayList<OMElement> list = null;
                                                list = WSSConsumer.getTimestampHeader(header, -1, false);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, list.size() + " timestamp headers found.");
                                                }
                                                if (list.size() > 0) {
                                                    OMElement elem = list.get(0);
                                                    String ns = elem.getNamespace() == null ? null : elem.getNamespace().getNamespaceURI();
                                                    wssVersion = NamespaceUtil.isWsu(ns);
                                                    context.put("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(wssVersion));
                                                    messageContext.setProperty("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(wssVersion));
                                                    for (int i2 = 0; i2 < list.size(); ++i2) {
                                                        OMElement timestamp = list.get(i2);
                                                        WSSConsumer.callTimestampConsumer(tsconfig, properties, timestamp, context);
                                                    }
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Checking the required timestamp.");
                                                    }
                                                    WSSConsumer.checkRequiredTimestamp(doc, config2.getTimestampConsumer(), properties, context);
                                                }
                                            }
                                            i = 0;
                                        }
                                        if (i >= secList.size()) break block152;
                                        security = secList.get(i);
                                        mustUnderstand = false;
                                        String value = security.getAttributeValue(new QName(header.getNamespace().getNamespaceURI(), "mustUnderstand"));
                                        if (value != null && !"".equals(value)) {
                                            mustUnderstand = ConfigUtil.isTrue(value);
                                        }
                                        Axis2Util.setMustUnderstand(messageContext, mustUnderstand);
                                        act = null;
                                        if (soapVersion == 1) {
                                            act = security.getAttributeValue(Constants.SOAP12_ROLE_Q);
                                        } else if (soapVersion == 0) {
                                            act = security.getAttributeValue(Constants.SOAP11_ACTOR_Q);
                                        }
                                        numSigConfElements = 0;
                                        numSigsInCache = 0;
                                        sigCache = null;
                                        String rmActionURI = null;
                                        if (doSignatureConfirmation && (rmActionURI = WSSGenerator.getRMAction(header, messageContext, act, soapVersion)) != null) {
                                            if (!isRequest) {
                                                if (rmActionURI.equals(Constants.NS_RMACTION[0]) || rmActionURI.equals(Constants.NS_RMACTION[2]) || rmActionURI.equals(Constants.NS_RMACTION[3]) || rmActionURI.equals(Constants.NS_RMACTION[5])) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Not doing SignatureConfirmation processing since this is a CreateSequence or SequenceAcknowledgement from provider");
                                                    }
                                                    doSignatureConfirmation = false;
                                                }
                                            } else if (rmActionURI.equals(Constants.NS_RMACTION[1]) || rmActionURI.equals(Constants.NS_RMACTION[4])) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Not doing SignatureConfirmation processing since this is a CreateSequenceResponse from client");
                                                }
                                                doSignatureConfirmation = false;
                                            }
                                        }
                                        if (!doSignatureConfirmation) break block153;
                                        if (isRequest) break block154;
                                        sigCacheWssPropMap = null;
                                        sigCacheRAMPPropMap = null;
                                        OperationContext opCtx = messageContext.getOperationContext();
                                        if (opCtx == null) {
                                            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
                                        }
                                        if (opCtx == null) break block155;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Valid Operation context to look for Signature_Confirmation cache");
                                        }
                                        HashMap allMsgCtxs = opCtx.getMessageContexts();
                                        Set msgContexts = allMsgCtxs.entrySet();
                                        it = msgContexts.iterator();
                                        prop = null;
                                        pMap = null;
                                        break block156;
                                    }
                                    if (!tc.isDebugEnabled()) break block157;
                                    Tr.debug(tc, "Null Operation context. Cannot locate Signature_Confirmation cache.");
                                    break block157;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SignatureConfirmation is enabled on requests.");
                                }
                                break block153;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "All security handlers is processed.");
                            }
                            WSSConsumer.cleanSubject(securityTokenManager, context);
                            if (config2.isVerificationRequired()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Checking the required integrity.");
                                }
                                WSSConsumer.checkRequiredIntegrity(doc, properties, context);
                            }
                            if (config2.isDecryptionRequired()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Checking the required confidentiality.");
                                }
                                WSSConsumer.checkRequiredConfidentiality(doc, properties, context);
                            }
                            if (config2.isTokenRequired()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Checking the required security token.");
                                }
                                WSSConsumer.checkRequiredSecurityToken(config2.getRequiredSecurityTokens(), config2.getCallers(), securityTokenManager, context);
                            }
                            if (config2.isLoginRequired()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Checking the caller.");
                                }
                                WSSConsumer.checkCaller(properties, context);
                            }
                            if (header == null) {
                                throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", "SOAP Header");
                            }
                            this.mapSignedPartsToMessageContext(messageContext, context);
                            this.mapEncryptedPartsToMessageContext(messageContext, context);
                            WSSConsumer.copyContextSubjectToMessageContext(messageContext, context);
                            WSSConsumer.mapTokenToMessageContext(messageContext, securityTokenManager, context);
                            this.proveKeyPossession(securityTokenManager, messageContext, context);
                            securityTokenManager.finalizeSubject();
                            ResultPool.finalize(context);
                            ResultMessagePool.finalize(context);
                        }
                        if ((sh = NamespaceUtil.getWsseHeaderByName(soapEnv, config2.getMyActor(), "Security")) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Security header processed is " + (processHeader ? "processed." : "skipped."));
                            }
                            sh.setProcessed();
                        }
                        if ((sh = NamespaceUtil.getWsuHeaderByName(soapEnv, config2.getMyActor(), "Timestamp")) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Timestamp header processed is " + (processHeader ? "processed." : "skipped."));
                            }
                            sh.setProcessed();
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "invoke(OMNode, Map)");
                        }
                        return;
                    }
                    while (it.hasNext()) {
                        List propList;
                        Map.Entry singleMsgCtx = (Map.Entry)it.next();
                        MessageContext tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                        pMap = (HashMap)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                        if (pMap != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the WSS_PROPERTYMAP property map in the msg ctx with key: " + singleMsgCtx.getKey());
                            }
                            if ((prop = (Object)pMap.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                                }
                                propList = null;
                                if (prop instanceof List) {
                                    propList = (List)prop;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + prop);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + prop.getClass().getName());
                                    }
                                }
                                if (propList != null) {
                                    if (sigCacheWssPropMap == null) {
                                        sigCacheWssPropMap = new ArrayList();
                                    }
                                    sigCacheWssPropMap.addAll(propList);
                                }
                                pMap.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                tempMsgCtx.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", pMap);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_PROPERTYMAP property map.");
                            }
                        }
                        if ((pMap = (HashMap)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP")) == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found the WSS_RAMP_PROPERTYMAP property map in the msg ctx with key: " + singleMsgCtx.getKey());
                        }
                        if ((prop = (Object)pMap.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache")) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                            }
                            propList = null;
                            if (prop instanceof List) {
                                propList = (List)prop;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found SIGNATURE_CONFIRMATION_CACHE, but it is not a List: " + prop);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Classname of SIGNATURE_CONFIRMATION_CACHE: " + prop.getClass().getName());
                                }
                            }
                            if (propList != null) {
                                if (sigCacheRAMPPropMap == null) {
                                    sigCacheRAMPPropMap = new ArrayList();
                                }
                                sigCacheRAMPPropMap.addAll(propList);
                            }
                            pMap.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                            tempMsgCtx.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", pMap);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Did NOT find SIGNATURE_CONFIRMATION_CACHE in WSS_RAMP_PROPERTYMAP property map.");
                    }
                }
                if ((sigCache = sigCacheWssPropMap != null ? sigCacheWssPropMap : sigCacheRAMPPropMap) != null) {
                    numSigsInCache = sigCache.size();
                    if (tc.isDebugEnabled()) {
                        for (i = 0; i < numSigsInCache; ++i) {
                            String sigValue = (String)sigCache.get(i);
                            Tr.debug(tc, "SignatureConfirmation value from the cache = " + sigValue);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SignatureConfirmation is enabled on replies. The number of signature values in the cache is " + numSigsInCache);
                }
            }
            try {
                int j;
                ArrayList encryptedHeaders;
                int version = NamespaceUtil.isWsse(security.getNamespace() == null ? null : security.getNamespace().getNamespaceURI());
                if (wssVersion < 0) {
                    wssVersion = version;
                    context.put("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(wssVersion));
                    messageContext.setProperty("com.ibm.ws.wssecurity.constants.wssVersion", new Integer(wssVersion));
                } else if (version != wssVersion) {
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s06");
                }
                if (tc.isDebugEnabled()) {
                    String msg = null;
                    msg = wssVersion == 0 ? "The spec of WS-Security is 2004/01 ver." : ("Unknown spec of WS-Security: " + security.getNamespace() == null ? null : security.getNamespace().getNamespaceURI());
                    Tr.debug(tc, msg);
                }
                ArrayList signatureCache = null;
                if (doSignatureConfirmation && isRequest) {
                    signatureCache = new ArrayList();
                    context.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", signatureCache);
                }
                OMElement el = DOMUtils.getFirstElement(security);
                while (true) {
                    block147: {
                        OMElement tel;
                        boolean copiedDOMTree;
                        block162: {
                            block158: {
                                String ns;
                                String ln;
                                block163: {
                                    block164: {
                                        block161: {
                                            block160: {
                                                block159: {
                                                    if (el == null) break block158;
                                                    ln = el.getLocalName();
                                                    ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
                                                    version = NamespaceUtil.isWsu(ns);
                                                    if (version < 0) break block159;
                                                    if (version != wssVersion) {
                                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", ns);
                                                    }
                                                    if (!ln.equals("Timestamp")) {
                                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(security));
                                                    }
                                                    String id = el.getAttributeValue(Constants.WSU_ID);
                                                    timestampVerificationHash.put(id, el);
                                                    break block147;
                                                }
                                                version = NamespaceUtil.isWsse(ns);
                                                if (version < 0) break block160;
                                                if (version != wssVersion) {
                                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", ns);
                                                }
                                                if (ln.equals("UsernameToken")) {
                                                    WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, el, securityTokenManager, context, true, false, wssVersion, false);
                                                    break block147;
                                                } else if (ln.equals("BinarySecurityToken")) {
                                                    WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, el, securityTokenManager, context, false, true, wssVersion, false);
                                                    break block147;
                                                } else {
                                                    if (!ln.equals(SECURITY_TOKEN_REFERENCE)) {
                                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(security));
                                                    }
                                                    WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, el, securityTokenManager, context, false, true, wssVersion, false);
                                                }
                                                break block147;
                                            }
                                            if (!Constants.NS_DSIG.equals(ns)) break block161;
                                            if (!ln.equals("Signature")) {
                                                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(security));
                                            }
                                            copiedDOMTree = false;
                                            tel = DOMUtils.getNextElement(el);
                                            break block162;
                                        }
                                        if (!Constants.NS_WSSE11.equals(ns)) break block163;
                                        if (!ln.equals("SignatureConfirmation")) {
                                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(security));
                                        }
                                        if (!doSignatureConfirmation) break block164;
                                        ++numSigConfElements;
                                        if (!isRequest) {
                                            String sigValue = null;
                                            sigValue = el.getAttributeValue(new QName("", "Value"));
                                            if (sigValue != null) {
                                                if (sigCache == null || !sigCache.contains(sigValue)) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "SignatureConfirmation value attribute does not match one in cache. The value is: " + sigValue);
                                                    }
                                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s42");
                                                }
                                                break block147;
                                            } else if (numSigsInCache != 0) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "SignatureConfirmation did not have value attribute. The value attribute is required.");
                                                }
                                                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s41");
                                            }
                                            break block147;
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "SignatureConfirmation element found on the request message. SignatureConfirmation element should only be found on the response message.");
                                            }
                                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(security));
                                        }
                                    }
                                    Tr.warning(tc, "security.wssecurity.WSSConsumer.s46");
                                    break block147;
                                }
                                if (Constants.NS_ENC.equals(ns)) {
                                    if (ln.equals("EncryptedKey") || ln.equals("ReferenceList")) {
                                        WSSConsumer.callEncryptionConsumer(config2.getEncryptionConsumers(), properties, el, context);
                                        break block147;
                                    } else {
                                        if (!ln.equals("EncryptedData") && !ln.equals("EncryptedAssertion")) {
                                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(security));
                                        }
                                        WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, el, securityTokenManager, context, false, false, wssVersion, true);
                                    }
                                    break block147;
                                } else {
                                    WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, el, securityTokenManager, context, false, false, wssVersion, false);
                                }
                                break block147;
                            }
                            if (!tokensToConsume.isEmpty()) {
                                Object[] keySet = tokensToConsume.keySet().toArray();
                                boolean tryAllCandidates = true;
                                for (int a = 0; a < keySet.length; ++a) {
                                    String id = (String)keySet[a];
                                    WSSConsumer.callStoredTokenConsumer(context, securityTokenManager, id, tryAllCandidates);
                                }
                                if (!tokensToConsume.isEmpty()) {
                                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s02");
                                }
                            }
                            if (doSignatureConfirmation) {
                                if (!isRequest) {
                                    if (numSigsInCache != numSigConfElements) {
                                        if (numSigsInCache != 0 || numSigConfElements != 1) {
                                            int numExpected = numSigsInCache;
                                            if (numSigsInCache == 0) {
                                                numExpected = 1;
                                            }
                                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s43", "" + numExpected, "" + numSigConfElements);
                                        }
                                    } else if (numSigsInCache == 0 && numSigConfElements != 1) {
                                        throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s44");
                                    }
                                } else {
                                    List sigCacheOnContext = (List)context.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                    if (sigCacheOnContext != null && sigCacheOnContext.size() > 0) {
                                        HashMap<String, List> wssProperties = null;
                                        wssProperties = (HashMap<String, List>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                                        if (wssProperties == null) {
                                            wssProperties = new HashMap<String, List>();
                                        }
                                        HashMap<String, List> wssRampProperties = null;
                                        wssRampProperties = (HashMap<String, List>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                                        if (wssRampProperties == null) {
                                            wssRampProperties = new HashMap<String, List>();
                                        }
                                        wssProperties.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", sigCacheOnContext);
                                        messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", wssProperties);
                                        wssRampProperties.put("com.ibm.ws.wssecurity.constants.signatureConfirmationCache", sigCacheOnContext);
                                        messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssRampProperties);
                                        context.remove("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Stored SIGNATURE_CONFIRMATION_CACHE on msg ctx in WSS_PROPERTYMAP and WSS_RAMP_PROPERTYMAP property");
                                        }
                                    }
                                }
                            }
                            encryptedHeaders = com.ibm.ws.wssecurity.util.DOMUtil.getHeadersForNamespace(header, Constants.NS_WSSE11, "EncryptedHeader", act, soapVersion);
                            j = 0;
                            break;
                        }
                        while (tel != null) {
                            String tns = tel.getNamespace() == null ? null : tel.getNamespace().getNamespaceURI();
                            String tln = tel.getLocalName();
                            if (Constants.NS_ENC.equals(tns) && ("EncryptedKey".equals(tln) || "ReferenceList".equals(tln))) {
                                copiedDOMTree = true;
                            }
                            tel = DOMUtils.getNextElement(tel);
                        }
                        WSSConsumer.callSignatureConsumer(config2.getSignatureConsumers(), properties, el, copiedDOMTree, context);
                    }
                    el = DOMUtils.getNextElement(el);
                }
                while (i < encryptedHeaders.size()) {
                    OMElement eh = (OMElement)encryptedHeaders.get(j);
                    boolean mu = false;
                    String value2 = eh.getAttributeValue(new QName("", "mustUnderstand"));
                    if (value2 != null && !"".equals(value2)) {
                        mu = ConfigUtil.isTrue(value2);
                    }
                    if (mustUnderstand && mu) {
                        throw SoapSecurityException.format(new QName(Constants.NS_SOAP, "MustUnderstand.securityException"), "security.wssecurity.WSSConsumer.s45");
                    }
                    ++j;
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".invoke", "516", this);
                Tr.error(tc, "security.wssecurity.WSSConsumer.s23", e);
                if (!mustUnderstand) {
                    Tr.debug(tc, "An exception has occurred when mustUnderstand=0.");
                    Tr.debug(tc, "The mustUnderstand=0 attribute may be honored when there is no inbound WSSecurity configuration for the elements being processed.");
                }
                throw e;
            }
            ++i;
        }
    }

    public void onFault(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(MessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContext)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        if (PlatformContextUtil.isWebSphereServerProcess()) {
            isSecurityEnabled = WSSContextManagerFactory.getInstance().getServerSecurityEnabled();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSecurityEnabled=" + isSecurityEnabled);
        }
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(QNameHeaderSelector.class, new QNameHeaderSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.wssecurity.util.selector.IDResolver", IdUtils.getInstance());
        this._properties.put(NonceUtil.class, new NonceUtil());
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.timestamp");
        this._properties.put(TimestampConsumer.class, factory.createConsumer(type, this._properties));
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.signature");
        this._properties.put(SignatureConsumer.class, factory.createConsumer(type, this._properties));
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.encryption");
        this._properties.put(EncryptionConsumer.class, factory.createConsumer(type, this._properties));
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoConsumer.class, factory.createConsumer(type, this._properties));
        WSSConsumerComponent component = new VerifiedPartChecker();
        component.init(this._properties);
        this._properties.put(VerifiedPartChecker.class, component);
        component = new DecryptedPartChecker();
        component.init(this._properties);
        this._properties.put(DecryptedPartChecker.class, component);
        component = new TimestampChecker();
        component.init(this._properties);
        this._properties.put(TimestampChecker.class, component);
        component = new LoginProcessor();
        component.init(this._properties);
        this._properties.put(LoginProcessor.class, component);
    }

    private static boolean adjustContext(MessageContext context, Map<Object, Object> ccontext) throws SoapSecurityException {
        return false;
    }

    public static ArrayList<OMElement> getSecurityHeaders(OMElement header, int soapVersion, boolean ultimateReceiver, String actor) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getSecurityHeaders(");
            buf.append("OMElement header[").append(DOMUtils.getDisplayName(header)).append("], ");
            buf.append("int soapVersion[").append(soapVersion).append("], ");
            buf.append("boolean untimateReceiver[").append(ultimateReceiver).append("], ");
            buf.append("String actor[").append(actor).append("])");
            Tr.entry(tc, buf.toString());
        }
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        OMElement el = DOMUtils.getFirstElement(header);
        while (el != null) {
            block11: {
                block13: {
                    String act;
                    block12: {
                        String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
                        String ln = el.getLocalName();
                        if (NamespaceUtil.isWsse(ns) < 0 || !"Security".equals(ln)) break block11;
                        if (soapVersion == 1) {
                            act = el.getAttributeValue(Constants.SOAP12_ROLE_Q);
                        } else if (soapVersion == 0) {
                            act = el.getAttributeValue(Constants.SOAP11_ACTOR_Q);
                        } else {
                            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(soapVersion));
                        }
                        if (act != null && act.trim().length() != 0) break block12;
                        if (actor != null && actor.trim().length() != 0) break block11;
                        break block13;
                    }
                    if (soapVersion == 1 ? Constants.SOAP12_ROLE_NONE.equals(act) || (Constants.SOAP12_ROLE_RECEIVER.equals(act) ? !act.equals(actor) : !Constants.SOAP12_ROLE_NEXT.equals(act) && !act.equals(actor)) : !Constants.SOAP11_ACTOR_NEXT.equals(act) && !act.equals(actor)) break block11;
                }
                list.add(el);
            }
            el = DOMUtils.getNextElement(el);
        }
        if (list.size() > 1) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6832E");
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getSecurityHeaders(");
            buf.append("OMElement, int, boolean, String)");
            buf.append(" returns NodeList [").append(list).append("]");
            Tr.exit(tc, buf.toString());
        }
        return list;
    }

    private static int countSecurityHeaders(OMElement header) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("countSecurityHeaders(");
            buf.append("OMElement header[").append(DOMUtils.getDisplayName(header)).append("])");
            Tr.entry(tc, buf.toString());
        }
        int count = 0;
        OMElement el = DOMUtils.getFirstElement(header);
        while (el != null) {
            if ("Security".equals(el.getLocalName())) {
                ++count;
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("countSecurityHeaders(Element)");
            buf.append(" returns int [").append(count).append("]");
            Tr.exit(tc, buf.toString());
        }
        return count;
    }

    public static QName getId(OMNode node) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getId(");
            buf.append("OMNode node[").append(DOMUtils.getDisplayName(node)).append("])");
            Tr.entry(tc, buf.toString());
        }
        QName s = null;
        if (node.getType() == 1) {
            OMElement e = (OMElement)node;
            s = IdUtils.getInstance().getIdAttributeName(e);
        }
        if (s == null && node.getType() == 1) {
            OMElement elem = (OMElement)node;
            for (OMNode n = elem.getFirstOMChild(); n != null && (n.getType() != 1 && n.getType() != 9 || (s = WSSConsumer.getId(n)) == null); n = n.getNextOMSibling()) {
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getId(OMNode)");
            buf.append(" returns QName [").append(s).append("]");
            Tr.exit(tc, buf.toString());
        }
        return s;
    }

    private static ArrayList<OMElement> getTimestampHeader(OMElement root, int wssVersion, boolean trace) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTimestampHeader(");
            buf.append("OMElement root[").append(DOMUtils.getDisplayName(root)).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("boolean trace[").append(trace).append("])");
            Tr.entry(tc, buf.toString());
        }
        String elemName = trace ? "TimestampTrace" : "Timestamp";
        ArrayList<OMElement> ret = new ArrayList<OMElement>();
        ArrayList<OMNode> list = wssVersion < 0 ? NamespaceUtil.getWsuElementsByTagName(root, elemName) : DOMUtils.getOneOrMoreElements(root, Constants.NAMESPACES[1][wssVersion], elemName);
        for (int i = 0; i < list.size(); ++i) {
            OMElement el = (OMElement)list.get(i);
            if (el.getAttributeValue(Constants.WAS_EXTENTION_Q) != null) continue;
            ret.add(el);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTimestampHeader(");
            buf.append("OMElement, int, boolean)");
            buf.append(" returns NodeList [").append(list).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    private static void callTimestampConsumer(TimestampConsumerConfig config2, Map<Object, Object> selectors, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callTimestampConsumer(");
            buf.append("TimestampConsumerConfig config, Map selectors, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        TimestampConsumer con = (TimestampConsumer)selectors.get(TimestampConsumer.class);
        context.put("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey", config2);
        con.invoke(target, context);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callTimestampConsumer(");
            buf.append("TimestampConsumerConfig, Map, OMElement, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    public static void callStoredTokenConsumer(TokenConsumerConfig tconfig, Map<Object, Object> context, String id) throws SoapSecurityException {
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        WSSConsumerConfig config2 = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        List<CallerConfig> cconfigs = config2.getCallers();
        SoapSecurityException throwException = null;
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        HashMap tokensToConsume = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCache");
        HashMap securityHeaders = (HashMap)context.get("com.ibm.ws.wssecurity.constants.securityHeadersCache");
        HashMap tokenTypes = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCacheType");
        HashMap v1Tokens = (HashMap)context.get("com.ibm.ws.wssecurity.constants.viTokensHash");
        OMElement securityToken = (OMElement)tokensToConsume.get(id);
        Integer tokenType = (Integer)tokenTypes.get(id);
        try {
            Boolean isV1Token;
            WSSConsumer.callTokenConsumer(tconfig, securityToken, context);
            final SecurityTokenWrapper tokenWrapper = securityTokenManager.getUnprocessedTokenWrapper();
            if (tokenWrapper != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unprocessed token [" + tokenWrapper + "] found.");
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        tokenWrapper.setProcessed(true);
                        return null;
                    }
                });
                if (cconfigs != null) {
                    WSSConsumer.checkCaller(cconfigs, tconfig, tokenWrapper, securityTokenManager, context);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "All tokens are processed.");
                }
                if (cconfigs != null) {
                    WSSConsumer.checkCaller(cconfigs, tconfig, securityTokenManager, context);
                }
            }
            if ((isV1Token = (Boolean)v1Tokens.get(id)) == null) {
                isV1Token = false;
            }
            if (tokenType == Constants.BINARY_TOKEN_TYPE && isV1Token.booleanValue()) {
                boolean allowX509ErrataTokenConsumption = true;
                String s1 = (String)config2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                if (s1 != null && s1.equals("false")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                    }
                    allowX509ErrataTokenConsumption = false;
                }
                if (allowX509ErrataTokenConsumption) {
                    messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    HashMap<String, Boolean> wssProperties = null;
                    wssProperties = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                    if (wssProperties == null) {
                        wssProperties = new HashMap<String, Boolean>();
                    }
                    HashMap<String, Boolean> wssRampProperties = null;
                    wssRampProperties = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (wssRampProperties == null) {
                        wssRampProperties = new HashMap<String, Boolean>();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copying useErrata boolean to message context");
                    }
                    wssProperties.put("com.ibm.ws.wssecurity.generateX509Errata10Token".toString(), isV1Token);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", wssProperties);
                    wssRampProperties.put("com.ibm.ws.wssecurity.generateX509Errata10Token".toString(), isV1Token);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssRampProperties);
                }
            }
        }
        catch (Exception e) {
            throwException = e instanceof SoapSecurityException ? (SoapSecurityException)e : SoapSecurityException.format("security.wssecurity.WSSConsumer.s34", new String[]{e.getMessage()}, (Throwable)e);
            Object object = context.remove(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
            if (object != null && object instanceof SecurityToken) {
                SecurityToken token = (SecurityToken)object;
                if (!tconfig.isUsedForDecryption() && !tconfig.isUsedForVerification()) {
                    securityTokenManager.removeToken(token);
                } else {
                    final SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper(token);
                    final int tconfigHash = tconfig.hashCode();
                    final int tconfigClassNameHash = tconfig.getClass().getName().hashCode();
                    final SoapSecurityException tempsse = throwException;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            tokenWrapper.setUsedTokenConsumer(tconfigHash, tconfigClassNameHash);
                            tokenWrapper.setKeyInfoType(null);
                            tokenWrapper.setError(tempsse);
                            tokenWrapper.setProcessed(true);
                            return null;
                        }
                    });
                    securityTokenManager.addTokenWrapper(tokenWrapper);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s13", throwException);
        }
        tokensToConsume.remove(id);
        securityHeaders.remove(id);
        tokenTypes.remove(id);
        v1Tokens.remove(id);
    }

    public static void callStoredTokenConsumer(Map<Object, Object> context, SecurityTokenManagerImpl securityTokenManager, String id, boolean tryAllCandidates) throws SoapSecurityException {
        Integer version;
        OMDocument doc;
        SOAPEnvelope soapEnv;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callStoredTokenConsumer(");
            buf.append("Map context, SecurityTokenManagerImpl securityTokenManager, ");
            buf.append("String id[").append(id).append("], ");
            buf.append("boolean tryAllCandidates[").append(tryAllCandidates).append("])");
            Tr.entry(tc, buf.toString());
        }
        OMElement root = null;
        int wssVersion = 0;
        WSSConsumerConfig config2 = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext != null && (soapEnv = messageContext.getEnvelope()) != null && (doc = DOMUtil.getOwnerDocument(soapEnv)) != null) {
            root = doc.getOMDocumentElement();
        }
        if ((version = (Integer)messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssVersion")) != null) {
            wssVersion = version;
        }
        HashMap tokensToConsume = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCache");
        HashMap securityHeaders = (HashMap)context.get("com.ibm.ws.wssecurity.constants.securityHeadersCache");
        HashMap tokenTypes = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCacheType");
        HashMap v1Tokens = (HashMap)context.get("com.ibm.ws.wssecurity.constants.viTokensHash");
        OMElement securityToken = (OMElement)tokensToConsume.get(id);
        OMElement security = (OMElement)securityHeaders.get(id);
        Integer tokenType = (Integer)tokenTypes.get(id);
        if (tokenType == Constants.BINARY_TOKEN_TYPE) {
            WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, securityToken, securityTokenManager, context, false, true, wssVersion, tryAllCandidates);
            Boolean isV1Token = (Boolean)v1Tokens.get(id);
            if (isV1Token == null) {
                isV1Token = false;
            }
            if (isV1Token.booleanValue()) {
                boolean allowX509ErrataTokenConsumption = true;
                String s1 = (String)config2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                if (s1 != null && s1.equals("false")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                    }
                    allowX509ErrataTokenConsumption = false;
                }
                if (allowX509ErrataTokenConsumption) {
                    messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    HashMap<String, Boolean> wssProperties = null;
                    wssProperties = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                    if (wssProperties == null) {
                        wssProperties = new HashMap<String, Boolean>();
                    }
                    HashMap<String, Boolean> wssRampProperties = null;
                    wssRampProperties = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (wssRampProperties == null) {
                        wssRampProperties = new HashMap<String, Boolean>();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copying useErrata boolean to message context");
                    }
                    wssProperties.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), isV1Token);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", wssProperties);
                    wssRampProperties.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), isV1Token);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssRampProperties);
                }
            }
        } else if (tokenType == Constants.USERNAME_TOKEN_TYPE) {
            WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, securityToken, securityTokenManager, context, true, false, wssVersion, tryAllCandidates);
        } else {
            WSSConsumer.callTokenConsumer(config2.getCallers(), config2.getTokenConsumers(), root, security, securityToken, securityTokenManager, context, false, false, wssVersion, tryAllCandidates);
        }
        tokensToConsume.remove(id);
        securityHeaders.remove(id);
        tokenTypes.remove(id);
    }

    public static void callTokenConsumer(Collection<CallerConfig> cconfigs, Collection<TokenConsumerConfig> tconfigs, OMElement envelope, OMElement security, OMElement target, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context, boolean isUT, boolean isBST, int wssVersion, boolean tryAllCandidates) throws SoapSecurityException {
        boolean assertionConsumer;
        QName vt;
        OMElement elem;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callTokenConsumer(");
            buf.append("Collection cconfigs, Collection tconfigs, ");
            buf.append("OMElement envelope[").append(DOMUtils.getDisplayName(envelope)).append("], ");
            buf.append("OMElement security[").append(DOMUtils.getDisplayName(security)).append("], ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("SecurityTokenManagerImpl securityTokenManager, Map context, ");
            buf.append("boolean isUT[").append(isUT).append("], ");
            buf.append("boolean isBST[").append(isBST).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("boolean tryAllCandidates[").append(tryAllCandidates).append("])");
            Tr.entry(tc, buf.toString());
        }
        HashMap tokensToConsume = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCache");
        HashMap securityHeaders = (HashMap)context.get("com.ibm.ws.wssecurity.constants.securityHeadersCache");
        HashMap tokenTypes = (HashMap)context.get("com.ibm.ws.wssecurity.constants.tokenCacheType");
        HashMap v1Tokens = (HashMap)context.get("com.ibm.ws.wssecurity.constants.viTokensHash");
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        Boolean isV1Token = false;
        boolean allowX509ErrataTokenConsumption = true;
        boolean isSCT = false;
        boolean isDKT = false;
        boolean isSTR = false;
        boolean isEncryptedToken = false;
        boolean isSCTV200502 = false;
        QName valueType = null;
        if ("SecurityContextToken".equals(target.getLocalName())) {
            isSCT = true;
        } else if ("DerivedKeyToken".equals(target.getLocalName())) {
            isDKT = true;
        } else if (SECURITY_TOKEN_REFERENCE.equals(target.getLocalName())) {
            isSTR = true;
        } else if ("EncryptedData".equals(target.getLocalName()) || "EncryptedAssertion".equals(target.getLocalName())) {
            isEncryptedToken = true;
        }
        String vts = target.getAttributeValue(VALUETYPE_Q);
        if (vts != null) {
            valueType = DOMUtils.getQName(target, vts, wssVersion);
        }
        if (valueType != null && NamespaceUtil.equals(valueType, Constants.X509V3)) {
            isV1Token = true;
        }
        if (isSCT) {
            if (Constants.NS_WSC_SC.equals(target.getNamespace().getNamespaceURI())) {
                isSCTV200502 = true;
                valueType = Constants.SCT;
            } else if (Constants.NS_WSC_SC_13.equals(target.getNamespace().getNamespaceURI())) {
                valueType = Constants.SCT_13;
            }
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String id = ConfigUtil.trim(IdUtils.getInstance().getId(target));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target's value type is [" + valueType + "].");
            Tr.debug(tc, "UsernameToken flag is [" + isUT + "].");
            Tr.debug(tc, "BinarySecurityToken flag is [" + isBST + "].");
            Tr.debug(tc, "SecurityContextToken flag is [" + isSCT + "].");
            Tr.debug(tc, "DerivedKeyToken flag is [" + isDKT + "].");
            Tr.debug(tc, "The identifier is [" + id + "].");
        }
        TokenConsumerConfig mismatchTokenConsumer = null;
        boolean foundMismatchTokenWithEnforceTokenVersion = false;
        TokenConsumerConfig tconfig2 = null;
        Iterator<TokenConsumerConfig> i = null;
        HashSet<TokenConsumerConfig> configs = new HashSet<TokenConsumerConfig>();
        boolean isDecryption = true;
        boolean isVerification = true;
        int usedFor = 0;
        WSSConsumerConfig config2 = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        boolean isIDAIdentityToken = false;
        if (isUT && (elem = DOMUtils.getZeroOrOneElement(target, nsWsse, "Password")) == null) {
            isIDAIdentityToken = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isIDAIdentityToken=" + isIDAIdentityToken);
        }
        if (envelope != null && security != null && (isBST || isUT || isDKT || isSTR)) {
            isDecryption = false;
            isVerification = false;
            usedFor = WSSConsumer.getUsedFor(envelope, security, nsWsse, id);
            if (usedFor == 1) {
                isVerification = true;
            } else if (usedFor == 2) {
                isDecryption = true;
            }
            if (tc.isDebugEnabled()) {
                if (isVerification) {
                    Tr.debug(tc, "The token is used for signature verification.");
                } else if (isDecryption) {
                    Tr.debug(tc, "The token is used for decryption.");
                } else {
                    Tr.debug(tc, "The token is maybe stand-alone.");
                }
            }
            for (TokenConsumerConfig tconfig2 : tconfigs) {
                if (tc.isDebugEnabled()) {
                    if (tconfig2.isUsedForVerification()) {
                        Tr.debug(tc, "The configuration of token consumers is used for signature verification.");
                    } else if (tconfig2.isUsedForDecryption()) {
                        Tr.debug(tc, "The configuration of token consumers is used for decryption.");
                    } else {
                        Tr.debug(tc, "The configuration of token consumers is maybe used for stand-alone tokens.");
                    }
                }
                if (!(isVerification && tconfig2.isUsedForVerification() || isDecryption && tconfig2.isUsedForDecryption()) && (isVerification || tconfig2.isUsedForVerification() || isDecryption || tconfig2.isUsedForDecryption())) continue;
                vt = null;
                vt = isDKT ? tconfig2.getType() : NamespaceUtil.getExpectedTargetNamespaceForTokenType(tconfig2.getType());
                if (isUT) {
                    if (!Constants.UNTOKEN.equals(vt) && !Constants.UNTOKEN_11.equals(vt)) continue;
                    boolean addConfig = true;
                    if (config2.getUntOptimize() && tconfig2.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig") != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Our UNT token consumer");
                        }
                        addConfig = false;
                        assertionConsumer = false;
                        if (tconfig2.getProperties().get("com.ibm.ws.wssecurity.token.isUntIdaConsumer") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "UNT Identity token consumer");
                            }
                            assertionConsumer = true;
                        }
                        if (isIDAIdentityToken && assertionConsumer) {
                            addConfig = true;
                        } else if (!isIDAIdentityToken && !assertionConsumer) {
                            addConfig = true;
                        }
                    }
                    if (!addConfig) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + vt + "].");
                    }
                    configs.add(tconfig2);
                    continue;
                }
                if (isBST) {
                    if (NamespaceUtil.equals(valueType, vt)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added a config for [" + vt + "].");
                        }
                        configs.add(tconfig2);
                        continue;
                    }
                    if ((Constants.LTPA_TOKEN.equals(vt) || Constants.LTPAv2_TOKEN.equals(vt)) && (Constants.LTPA_TOKEN.equals(valueType) || Constants.LTPAv2_TOKEN.equals(valueType))) {
                        if (tconfig2.isEnforceTokenVersion()) {
                            foundMismatchTokenWithEnforceTokenVersion = true;
                            mismatchTokenConsumer = tconfig2;
                            continue;
                        }
                        mismatchTokenConsumer = tconfig2;
                        continue;
                    }
                    if (!isV1Token.booleanValue()) continue;
                    allowX509ErrataTokenConsumption = true;
                    String s1 = (String)tconfig2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                    if (s1 != null && s1.equals("false")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                        }
                        allowX509ErrataTokenConsumption = false;
                    }
                    if (!NamespaceUtil.equals(vt, Constants.X509V3_OLD) || !NamespaceUtil.equals(valueType, Constants.X509V3) || !allowX509ErrataTokenConsumption) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + vt + "], which will consume Errata token[" + valueType + "]");
                    }
                    configs.add(tconfig2);
                    continue;
                }
                if (isSCT) {
                    if (!NamespaceUtil.equals(valueType, vt)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding a config for [" + vt + "].");
                    }
                    configs.add(tconfig2);
                    break;
                }
                if (isDKT) {
                    QName parentValueType = WSSConsumer.getParentTokenValueType(target, wssVersion, securityTokenManager, messageContext);
                    if (parentValueType == null) continue;
                    if (NamespaceUtil.equals(parentValueType, vt)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding a token config for [" + vt + "].");
                        }
                        configs.add(tconfig2);
                        continue;
                    }
                    if (!NamespaceUtil.equals(vt, Constants.SCT_13) || !Constants.SCT.equals(parentValueType)) continue;
                    if (tconfig2.isEnforceTokenVersion()) {
                        foundMismatchTokenWithEnforceTokenVersion = true;
                        mismatchTokenConsumer = tconfig2;
                        continue;
                    }
                    mismatchTokenConsumer = tconfig2;
                    continue;
                }
                QName qn = new QName(target.getNamespace() == null ? null : target.getNamespace().getNamespaceURI(), target.getLocalName());
                if (!vt.equals(qn)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added a config for [" + vt + "].");
                }
                configs.add(tconfig2);
            }
        }
        if (configs.isEmpty() && mismatchTokenConsumer != null) {
            if (foundMismatchTokenWithEnforceTokenVersion) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The valueType on the message [" + valueType + "] does not match the valueType in the config [" + mismatchTokenConsumer.getType() + "]. The config specified enforceTokenVersion. Cannot process message.");
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s47", new String[]{valueType.toString(), mismatchTokenConsumer.getType().toString()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added a config for [" + mismatchTokenConsumer.getType() + "].");
            }
            configs.add(mismatchTokenConsumer);
            foundMismatchTokenWithEnforceTokenVersion = false;
            mismatchTokenConsumer = null;
        }
        if (configs.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Since it can't select configuration of token cosumers based on the message, it uses all candidates.");
            }
            for (TokenConsumerConfig tconfig2 : tconfigs) {
                vt = null;
                vt = isDKT ? tconfig2.getType() : NamespaceUtil.getExpectedTargetNamespaceForTokenType(tconfig2.getType());
                if (isUT) {
                    if (!Constants.UNTOKEN.equals(vt) && !Constants.UNTOKEN_11.equals(vt)) continue;
                    boolean addConfig = true;
                    if (config2.getUntOptimize() && tconfig2.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig") != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Our UNT token consumer");
                        }
                        addConfig = false;
                        assertionConsumer = false;
                        if (tconfig2.getProperties().get("com.ibm.ws.wssecurity.token.isUntIdaConsumer") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "UNT Identity token consumer");
                            }
                            assertionConsumer = true;
                        }
                        if (isIDAIdentityToken && assertionConsumer) {
                            addConfig = true;
                        } else if (!isIDAIdentityToken && !assertionConsumer) {
                            addConfig = true;
                        }
                    }
                    if (!addConfig) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + vt + "].");
                    }
                    configs.add(tconfig2);
                    continue;
                }
                if (isBST) {
                    QName parentValueType;
                    if (NamespaceUtil.equals(valueType, vt)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added a config for [" + vt + "].");
                        }
                        configs.add(tconfig2);
                        continue;
                    }
                    if ((Constants.LTPA_TOKEN.equals(vt) || Constants.LTPAv2_TOKEN.equals(vt)) && (Constants.LTPA_TOKEN.equals(valueType) || Constants.LTPAv2_TOKEN.equals(valueType))) {
                        if (tconfig2.isEnforceTokenVersion()) {
                            foundMismatchTokenWithEnforceTokenVersion = true;
                            mismatchTokenConsumer = tconfig2;
                            continue;
                        }
                        mismatchTokenConsumer = tconfig2;
                        continue;
                    }
                    if (isV1Token.booleanValue()) {
                        allowX509ErrataTokenConsumption = true;
                        String s1 = (String)tconfig2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                        if (s1 != null && s1.equals("false")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found X509 Errata token in the message, but token consumer has com.ibm.ws.wssecurity.consumeX509Errata10Token property set to false in bindings. Consumption will not take place and message will likely not be processed.");
                            }
                            allowX509ErrataTokenConsumption = false;
                        }
                        if (!NamespaceUtil.equals(vt, Constants.X509V3_OLD) || !NamespaceUtil.equals(valueType, Constants.X509V3) || !allowX509ErrataTokenConsumption) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added a config for [" + vt + "], which will consume Errata token[" + valueType + "]");
                        }
                        configs.add(tconfig2);
                        continue;
                    }
                    if (!isSTR || (parentValueType = WSSConsumer.getParentTokenValueType(target, wssVersion, securityTokenManager, messageContext)) == null || !NamespaceUtil.equals(parentValueType, vt)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding a token config for [" + vt + "].");
                    }
                    configs.add(tconfig2);
                    continue;
                }
                if (isSCT) {
                    if (NamespaceUtil.equals(valueType, vt)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding a config for [" + vt + "].");
                        }
                        configs.add(tconfig2);
                        break;
                    }
                    if (!NamespaceUtil.equals(vt, Constants.SCT_13) || !isSCTV200502) continue;
                    if (tconfig2.isEnforceTokenVersion()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found SCT draft version in the message, but token consumersets enforceTokenVersion attribute in bindings. Cannot process message");
                        }
                        foundMismatchTokenWithEnforceTokenVersion = true;
                        mismatchTokenConsumer = tconfig2;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added a config for [" + vt + "], which will consume SCT draft version token[" + valueType + "]");
                    }
                    configs.add(tconfig2);
                    break;
                }
                if (isDKT) {
                    QName parentValueType = WSSConsumer.getParentTokenValueType(target, wssVersion, securityTokenManager, messageContext);
                    if (parentValueType == null) continue;
                    if (NamespaceUtil.equals(parentValueType, vt)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding a token config for [" + vt + "].");
                        }
                        configs.add(tconfig2);
                        continue;
                    }
                    if (!NamespaceUtil.equals(vt, Constants.SCT_13) || !Constants.SCT.equals(parentValueType)) continue;
                    if (tconfig2.isEnforceTokenVersion()) {
                        foundMismatchTokenWithEnforceTokenVersion = true;
                        mismatchTokenConsumer = tconfig2;
                        continue;
                    }
                    mismatchTokenConsumer = tconfig2;
                    continue;
                }
                if (isEncryptedToken) {
                    configs.add(tconfig2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EncryptedToken. Added a config for [" + vt + "].");
                    continue;
                }
                QName qn = new QName(target.getNamespace() == null ? null : target.getNamespace().getNamespaceURI(), target.getLocalName());
                if (!vt.equals(qn)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added a config for [" + vt + "].");
                }
                configs.add(tconfig2);
            }
        }
        if (configs.isEmpty() && mismatchTokenConsumer != null) {
            if (foundMismatchTokenWithEnforceTokenVersion) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The valueType on the message [" + valueType + "] does not match the valueType in the config [" + mismatchTokenConsumer.getType() + "]. The config specified enforceTokenVersion. Cannot process message.");
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s47", new String[]{valueType.toString(), mismatchTokenConsumer.getType().toString()});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added a config for [" + mismatchTokenConsumer.getType() + "].");
            }
            configs.add(mismatchTokenConsumer);
        }
        if (configs.isEmpty()) {
            if (Axis2Util.getMustUnderstand(context)) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(target));
            }
            Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.WSSConsumer.s03", new String[]{DOMUtils.getQualifiedName(target)}));
            Tr.debug(tc, "mustUnderstand=0.  Ignoring unexpected element.");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configs.size() + " TokenConsumerConfig candidates found.");
            }
            context.remove(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_KEYINFO_TYPE);
            boolean succeeded = false;
            Exception[] exceptions = new Exception[configs.size()];
            int exPos = 0;
            SoapSecurityException throwException = null;
            if (configs.size() > 1 && !tryAllCandidates) {
                tokensToConsume.put(id, target);
                securityHeaders.put(id, security);
                if (isUT) {
                    tokenTypes.put(id, Constants.USERNAME_TOKEN_TYPE);
                } else if (isBST) {
                    tokenTypes.put(id, Constants.BINARY_TOKEN_TYPE);
                    v1Tokens.put(id, isV1Token);
                } else {
                    tokenTypes.put(id, Constants.UNDETERMINED_TOKEN_TYPE);
                }
                succeeded = true;
            }
            if (configs.size() == 1 || tryAllCandidates) {
                for (TokenConsumerConfig tconfig2 : configs) {
                    try {
                        WSSConsumer.callTokenConsumer(tconfig2, target, context);
                        final SecurityTokenWrapper tokenWrapper = securityTokenManager.getUnprocessedTokenWrapper();
                        if (tokenWrapper != null) {
                            DKToken dktoken;
                            SecurityToken baseToken;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unprocessed token [" + tokenWrapper + "] found.");
                            }
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    tokenWrapper.setProcessed(true);
                                    return null;
                                }
                            });
                            SecurityTokenWrapper baseTokenWrapper = null;
                            if (isDKT && (baseToken = (dktoken = (DKToken)tokenWrapper.getSecurityToken()).getDerivableSecurityToken()) != null) {
                                baseTokenWrapper = securityTokenManager.getTokenWrapper(baseToken);
                                if (baseTokenWrapper == null) {
                                    final SecurityTokenWrapper tw = new SecurityTokenWrapper(baseToken);
                                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                        @Override
                                        public Object run() {
                                            tw.setUsedTokenConsumer(tokenWrapper.getUsedTokenConsumerHash(), tokenWrapper.getUsedTokenConsumerClass());
                                            tw.setProcessed(true);
                                            return null;
                                        }
                                    });
                                    securityTokenManager.addTokenWrapper(tw);
                                    baseTokenWrapper = tw;
                                } else {
                                    baseTokenWrapper = null;
                                }
                            }
                            if (baseTokenWrapper == null) {
                                baseTokenWrapper = tokenWrapper;
                            }
                            if (cconfigs != null) {
                                WSSConsumer.checkCaller(cconfigs, tconfig2, baseTokenWrapper, securityTokenManager, context);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "All tokens are processed.");
                            }
                            if (cconfigs != null) {
                                WSSConsumer.checkCaller(cconfigs, tconfig2, securityTokenManager, context);
                            }
                        }
                        succeeded = true;
                        if (isBST && isV1Token.booleanValue()) {
                            String s1 = (String)tconfig2.getProperties().get("com.ibm.ws.wssecurity.consumeX509Errata10Token");
                            allowX509ErrataTokenConsumption = true;
                            if (s1 != null && s1.equals("false")) {
                                allowX509ErrataTokenConsumption = false;
                            }
                            if (allowX509ErrataTokenConsumption) {
                                HashMap<String, Boolean> wssProperties = null;
                                wssProperties = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                                if (wssProperties == null) {
                                    wssProperties = new HashMap<String, Boolean>();
                                }
                                HashMap<String, Boolean> wssRampProperties = null;
                                wssRampProperties = (HashMap<String, Boolean>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                                if (wssRampProperties == null) {
                                    wssRampProperties = new HashMap<String, Boolean>();
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Copying useErrata boolean to message context");
                                }
                                wssProperties.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), isV1Token);
                                messageContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", wssProperties);
                                wssRampProperties.put("com.ibm.ws.wssecurity.consumeX509Errata10Token".toString(), isV1Token);
                                messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssRampProperties);
                            }
                        }
                        if (isDecryption || isVerification) continue;
                        break;
                    }
                    catch (Exception e) {
                        exceptions[exPos++] = e;
                        throwException = e instanceof SoapSecurityException ? (SoapSecurityException)e : SoapSecurityException.format("security.wssecurity.WSSConsumer.s34", new String[]{e.getMessage()}, (Throwable)e);
                        Object object = context.remove(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
                        if (object == null || !(object instanceof SecurityToken)) continue;
                        SecurityToken token = (SecurityToken)object;
                        if (!isDecryption && !isVerification) {
                            securityTokenManager.removeToken(token);
                            continue;
                        }
                        final SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper(token);
                        final int tconfigHash = tconfig2.hashCode();
                        final int tconfigClassNameHash = tconfig2.getClass().getName().hashCode();
                        final SoapSecurityException tempsse = throwException;
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                tokenWrapper.setUsedTokenConsumer(tconfigHash, tconfigClassNameHash);
                                tokenWrapper.setKeyInfoType(null);
                                tokenWrapper.setError(tempsse);
                                tokenWrapper.setProcessed(true);
                                return null;
                            }
                        });
                        securityTokenManager.addTokenWrapper(tokenWrapper);
                    }
                }
            }
            if (!succeeded) {
                if (configs.size() == 1) {
                    throw throwException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, exPos + " exceptions were catched.");
                    for (int j = 0; j < exPos; ++j) {
                        Tr.debug(tc, "No." + j + "'s exception: " + exceptions[j]);
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s13", exceptions[exPos - 1]);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callTokenConsumer(");
            buf.append("Set, Set, OMElement, OMElement, OMElement, SecurityTokenManagerImpl, ");
            buf.append("Map, boolean, boolean, int, boolean)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void callTokenConsumer(TokenConsumerConfig config2, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        PrivateConsumerConfig.TokenConsumerConfImpl confImpl;
        TokenConsumerComponent gen;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callTokenConsumer(");
            buf.append("TokenConsumerConfig config, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        if ((gen = (confImpl = (PrivateConsumerConfig.TokenConsumerConfImpl)config2).getInstance()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get the TokenConsumer object: [" + config2 + "].");
            }
        } else {
            context.put("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey", config2);
            gen.invoke(target, context);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callTokenConsumer(");
            buf.append("TokenConsumerConfig, OMElement, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QName getParentTokenValueType(OMElement target, int wssVersion, SecurityTokenManagerImpl securityTokenManager, MessageContext messageContext) {
        String valueTypeString = null;
        QName valueType = null;
        if (target != null) {
            String ln = target.getLocalName();
            OMElement elem1 = null;
            OMElement elem2 = null;
            if (ln.equals("DerivedKeyToken")) {
                elem1 = DOMUtils.getChildElement(target, Constants.NS_WSSE, SECURITY_TOKEN_REFERENCE);
            }
            if (ln.equals(SECURITY_TOKEN_REFERENCE)) {
                elem1 = target;
            }
            if (elem1 != null) {
                elem2 = DOMUtils.getChildElement(elem1, Constants.NS_WSSE, "Reference");
            }
            if (elem2 != null) {
                valueTypeString = elem2.getAttributeValue(Constants.VALUETYPE_Q);
                if (valueTypeString != null) {
                    valueType = DOMUtils.getQName(target, valueTypeString, wssVersion);
                }
                if (valueType == null) {
                    String uri = elem2.getAttributeValue(Constants.URI_Q);
                    if (uri != null && uri.startsWith("#")) {
                        uri = uri.substring(1);
                    }
                    if (valueType == null && uri != null && CacheableTokenCacheFactory.getInstance().getToken(uri) != null) {
                        QName tokentype = ((SecurityToken)((Object)CacheableTokenCacheFactory.getInstance().getToken(uri))).getValueType();
                        if (tokentype != null) {
                            valueType = tokentype;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found token type: " + valueType);
                        }
                    }
                    if (uri != null && valueType == null) {
                        valueType = WSSConsumer.getValueType(messageContext, securityTokenManager, null, uri, null);
                    }
                }
            } else if (elem1 != null && (elem2 = DOMUtils.getChildElement(elem1, Constants.NS_WSSE, "KeyIdentifier")) != null) {
                String uri = elem2.getText();
                if (uri != null) {
                    CacheableToken ctoken;
                    block28: {
                        ctoken = null;
                        try {
                            CacheableTokenCache ctokenCache = CacheableTokenCacheFactory.getInstance();
                            ctoken = ctokenCache.getToken(uri);
                            String elem2ValueType = elem2.getAttributeValue(Constants.VALUETYPE_Q);
                            if (ctoken != null || elem2ValueType == null || elem2ValueType.compareTo(Constants.KRB5_APREQ_SHA1.getLocalPart()) != 0) break block28;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Searching token with key id: " + uri);
                            }
                            CacheableTokenCache cacheableTokenCache = ctokenCache;
                            synchronized (cacheableTokenCache) {
                                for (int count = 1; count <= 15; ++count) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, count + " wait...with key id: " + uri);
                                    }
                                    ctokenCache.wait(1000L);
                                    ctoken = CacheableTokenCacheFactory.getInstance().getToken(uri);
                                    if (ctoken != null) break;
                                }
                                ctokenCache.notifyAll();
                            }
                        }
                        catch (InterruptedException iex) {
                            ctoken = null;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Token found?..." + ctoken);
                    }
                    if (ctoken != null) {
                        QName tokentype = ((SecurityToken)((Object)ctoken)).getValueType();
                        if (tokentype != null) {
                            valueType = tokentype;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found token type: " + valueType);
                            Tr.debug(tc, "Searching key: " + uri);
                        }
                    }
                }
                if (uri != null && valueType == null) {
                    String keyIDValueTypeString = elem2.getAttributeValue(Constants.VALUETYPE_Q);
                    valueType = WSSConsumer.getValueType(messageContext, securityTokenManager, uri, null, keyIDValueTypeString);
                }
            }
        }
        return valueType;
    }

    private static QName getValueType(MessageContext messageContext, SecurityTokenManagerImpl securityTokenManager, String keyID, String tokenID, String keyIDValueTypeString) {
        QName valueType;
        block5: {
            block4: {
                valueType = null;
                SecurityToken token = null;
                if (tokenID == null) break block4;
                token = securityTokenManager.getToken(tokenID);
                if (token == null) break block5;
                valueType = token.getValueType();
                break block5;
            }
            if (keyID != null) {
                if (keyIDValueTypeString != null) {
                    String id = keyIDValueTypeString + ":" + keyID;
                    valueType = (QName)Axis2Util.getProperty(messageContext, id);
                }
                if (valueType == null) {
                    Collection<SecurityToken> tokens = securityTokenManager.getTokens();
                    for (SecurityToken token : tokens) {
                        if (!keyID.equals(token.getKeyIdentifier())) continue;
                        valueType = token.getValueType();
                        break;
                    }
                }
            }
        }
        return valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callSignatureConsumer(Collection<SignatureConsumerConfig> sconfig, Map<Object, Object> selectors, OMElement target, boolean copiedDOMTree, Map<Object, Object> context) throws SoapSecurityException {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("callSignatureConsumer(");
            buf.append("Collection sconfig, Map selectors, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("boolean copiedDOMTree[").append(copiedDOMTree).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (sconfig.size() <= 0) {
            if (Axis2Util.getMustUnderstand(context)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An XML Digital signature was found in the security header, but there is no inbound signature configuration.");
                }
                String msg2 = ConfigUtil.getMessage("security.wssecurity.WSSConsumer.s48");
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", msg2);
            }
        } else {
            boolean succeeded = false;
            Exception[] exceptions = new Exception[sconfig.size()];
            int exPos = 0;
            WSSConsumer.lockResults(context, true, true);
            SignatureConsumerConfig config2 = null;
            Iterator<SignatureConsumerConfig> i = sconfig.iterator();
            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
            boolean isAuditSigningSuccessRequired = false;
            isAuditSigningSuccessRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS, context);
            boolean isAuditSigningErrorRequired = false;
            isAuditSigningErrorRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS, context);
            while (i.hasNext()) {
                config2 = i.next();
                try {
                    WSSConsumer.callSignatureConsumer(config2, selectors, target, copiedDOMTree, context);
                    succeeded = true;
                    if (!isAuditSigningSuccessRequired) break;
                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    if (wssAuditService.isVerbose() && context.get("CertChain") != null) {
                        wssAuditEventGenerator.setExtendedAuditData(context, "CertificateChain", (String)context.remove("CertChain"));
                    }
                    wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.VALID_SIGNATURE, null);
                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
                    break;
                }
                catch (Exception e) {
                    exceptions[exPos++] = e;
                    if (!isAuditSigningErrorRequired) continue;
                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.INVALID_SIGNATURE, e.getMessage());
                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(context);
                    if (succeeded) continue;
                    WSSConsumer.restoreResults(context, true);
                }
            }
            wssAuditEventGenerator.clearAuditData(context);
            if (!succeeded) {
                if (sconfig.size() == 1) {
                    if (exceptions[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptions[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s15", exceptions[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, exPos + " exceptions were catched.");
                    for (int j = 0; j < exPos; ++j) {
                        Tr.debug(tc, "No." + j + "'s exception: " + exceptions[j]);
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s11", exceptions[exPos - 1]);
            }
            WSSConsumer.lockResults(context, true, false);
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("callSignatureConsumer(");
            buf.append("Set, Map, OMElement, boolean, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void callSignatureConsumer(SignatureConsumerConfig config2, Map<Object, Object> selectors, OMElement target, boolean copiedDOMTree, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callSignatureConsumer(");
            buf.append("SignatureConsumerConfig config, Map properties, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("boolean copiedDOMTree[").append(copiedDOMTree).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        SignatureConsumer con = (SignatureConsumer)selectors.get(SignatureConsumer.class);
        context.put("com.ibm.ws.wssecurity.impl.config.signatureConsumer.configKey", config2);
        if (copiedDOMTree) {
            context.put("com.ibm.ws.wssecurity.constants.copiedDOMTree", "true");
        } else {
            context.remove("com.ibm.ws.wssecurity.constants.copiedDOMTree");
        }
        con.invoke(target, context);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callSignatureConsumer(");
            buf.append("SignatureConsumerConfig, Map, OMElement, boolean, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callEncryptionConsumer(Collection<EncryptionConsumerConfig> econfig, Map<Object, Object> selectors, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callEncryptionConsumer(");
            buf.append("Collection econfig, Map selectors, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        boolean succeeded = false;
        Exception[] exceptions = new Exception[econfig.size()];
        int exPos = 0;
        if (econfig.size() <= 0) {
            if (Axis2Util.getMustUnderstand(context)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encryption information was found in the security header, but there is no inbound encryption configuration.");
                }
                String msg2 = ConfigUtil.getMessage("security.wssecurity.WSSConsumer.s49");
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", msg2);
            }
        } else {
            WSSConsumer.lockResults(context, false, true);
            EncryptionConsumerConfig config2 = null;
            Iterator<EncryptionConsumerConfig> i = econfig.iterator();
            boolean isAuditEncryptionErrorRequired = false;
            isAuditEncryptionErrorRequired = WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.ERROR, context);
            while (i.hasNext()) {
                config2 = i.next();
                try {
                    WSSConsumer.callEncryptionConsumer(config2, selectors, target, context);
                    succeeded = true;
                    break;
                }
                catch (Exception e) {
                    exceptions[exPos++] = e;
                    if (!isAuditEncryptionErrorRequired) continue;
                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.DECRYPTION_ERROR, e.getMessage());
                    WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, messageContext, context);
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(context);
                    if (succeeded) continue;
                    WSSConsumer.restoreResults(context, false);
                }
            }
            WSSAuditEventGeneratorFactory.getInstance().clearAuditData(context);
            if (!succeeded) {
                if (econfig.size() == 1) {
                    if (exceptions[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptions[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", exceptions[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, exPos + " exceptions were catched.");
                    for (int j = 0; j < exPos; ++j) {
                        Tr.debug(tc, "No." + j + "'s exception: " + exceptions[j]);
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s12", exceptions[exPos - 1]);
            }
            WSSConsumer.lockResults(context, false, false);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callEncryptionConsumer(");
            buf.append("Set, Map, OMElement, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void callEncryptionConsumer(EncryptionConsumerConfig config2, Map<Object, Object> selectors, OMElement target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callEncryptionConsumer(");
            buf.append("EncryptionConsumerConfig config, Map selectors, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        EncryptionConsumer con = (EncryptionConsumer)selectors.get(EncryptionConsumer.class);
        context.put("com.ibm.ws.wssecurity.impl.config.encryptionConsumer.configKey", config2);
        con.invoke(target, context);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("callEncryptionConsumer(");
            buf.append("EncryptionConsumerConfig, Map, OMElement, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void checkRequiredIntegrity(OMDocument doc, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkRequiredIntegrity(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("Map selectors, Map context)");
            Tr.entry(tc, buf.toString());
        }
        try {
            WSSConsumerComponent component = (WSSConsumerComponent)selectors.get(VerifiedPartChecker.class);
            component.invoke(doc.getOMDocumentElement(), context);
        }
        catch (SoapSecurityException e) {
            if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.INTEGRITY_BAD, e.getMessage());
                WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
            }
            throw e;
        }
        if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS, context)) {
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.INTEGRITY, null);
            WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredIntegrity(OMDocument, Map, Map)");
        }
    }

    private static void checkRequiredConfidentiality(OMDocument doc, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkRequiredConfidentiality(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("Map selectors, Map context)");
            Tr.entry(tc, buf.toString());
        }
        try {
            WSSConsumerComponent component = (WSSConsumerComponent)selectors.get(DecryptedPartChecker.class);
            component.invoke(doc.getOMDocumentElement(), context);
        }
        catch (SoapSecurityException e) {
            if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.CONFIDENTIALITY_BAD, e.getMessage());
                WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, messageContext, context);
            }
            throw e;
        }
        if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.SUCCESS, context)) {
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.CONFIDENTIALITY, null);
            WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, messageContext, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredConfidentiality(OMDocument, Map, Map)");
        }
    }

    private static void checkRequiredSecurityToken(Collection<TokenConsumerConfig> tokens, Collection<CallerConfig> callers, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkRequiredSecurityToken(");
            buf.append("Collection tokens, Collection callers, ");
            buf.append("SecurityTokenManagerImpl securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        Collection<SecurityToken> ts = securityTokenManager.getTokens();
        if (tc.isDebugEnabled()) {
            if (ts == null) {
                Tr.debug(tc, "The subject has no Token object.");
            } else {
                Tr.debug(tc, ts.size() + " tokens found in the subject.");
            }
        }
        boolean foundMismatchLTPAWithEnforceTokenVersion = false;
        SecurityToken mismatchLTPAToken = null;
        Iterator<TokenConsumerConfig> i1 = null;
        Iterator<SecurityToken> i2 = null;
        QName config_qn = null;
        QName token_qn = null;
        TokenConsumerConfig tconfig2 = null;
        SecurityToken token2 = null;
        boolean typeCheck = false;
        for (TokenConsumerConfig tconfig2 : tokens) {
            typeCheck = false;
            config_qn = tconfig2.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the value type [" + config_qn + "]...");
            }
            if (ts != null) {
                for (SecurityToken token2 : ts) {
                    token_qn = token2.getValueType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Comparing with the value type of the Token [" + token_qn + "]...");
                    }
                    if (config_qn.equals(token_qn)) {
                        typeCheck = true;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "A corresponding token found.");
                        break;
                    }
                    if (!Constants.LTPA_TOKEN.equals(config_qn) && !Constants.LTPAv2_TOKEN.equals(config_qn) || !Constants.LTPA_TOKEN.equals(token_qn) && !Constants.LTPAv2_TOKEN.equals(token_qn)) continue;
                    if (tconfig2.isEnforceTokenVersion()) {
                        foundMismatchLTPAWithEnforceTokenVersion = true;
                        mismatchLTPAToken = token2;
                        continue;
                    }
                    mismatchLTPAToken = token2;
                }
            }
            if (!typeCheck) {
                if (mismatchLTPAToken != null && !foundMismatchLTPAWithEnforceTokenVersion) {
                    typeCheck = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A corresponding token found with value type [" + mismatchLTPAToken.getValueType().toString() + "].");
                    }
                }
                if (!typeCheck && callers.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The value type of the token consumer configuration: " + config_qn);
                        Tr.debug(tc, "The value type of the token: " + token_qn);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, callers.size() + " CallerConfigs found, so start to process it...");
                    }
                    for (CallerConfig cconfig : callers) {
                        boolean trustedIdentityCandidate;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing a CallerConfig [" + cconfig + "]...");
                        }
                        QName caller_qn = cconfig.getCallerIdentity();
                        QName tidentity_qn = cconfig.getTrustedIdentity();
                        ReferencePartConfig spart = cconfig.getRequiredSigningPartReference();
                        boolean callerIdentityCandidate = caller_qn != null && caller_qn.equals(config_qn) && (spart == null || tidentity_qn != null);
                        boolean bl = trustedIdentityCandidate = tidentity_qn != null && tidentity_qn.equals(config_qn) && spart == null;
                        if (!callerIdentityCandidate && !trustedIdentityCandidate) continue;
                        typeCheck = true;
                    }
                }
            }
            if (typeCheck) continue;
            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.WSSConsumer.s14", tconfig2.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredSecurityToken(Set, Set, SecurityTokenManagerImpl)");
        }
    }

    private static void checkRequiredTimestamp(OMDocument doc, TimestampConsumerConfig config2, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("checkRequiredTimestamp(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("TimestampConsumerConfig config, Map selectors, Map context)");
            Tr.entry(tc, buf.toString());
        }
        try {
            WSSConsumerComponent component = (WSSConsumerComponent)selectors.get(TimestampChecker.class);
            context.put("com.ibm.ws.wssecurity.impl.config.timestampConsumer.configKey", config2);
            component.invoke(doc.getOMDocumentElement(), context);
        }
        catch (SoapSecurityException e) {
            if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.TIMESTAMP_BAD, e.getMessage());
                WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
            }
            throw e;
        }
        if (WSSContextManagerFactory.getInstance().getAuditService().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.SUCCESS, context)) {
            WSSAuditEventGeneratorFactory.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.TIMESTAMP, null);
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            WSSAuditEventGeneratorFactory.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("callEncryptionConsumer(");
            buf.append("OMDocument, TimestampConsumerConfig, Map, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void checkCaller(Collection<CallerConfig> cconfigs, TokenConsumerConfig tconfig, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkCaller(");
            buf.append("Collection cconfigs, TokenConsumerConfig tconfig, ");
            buf.append("SecurityTokenManagerImpl securityTokenManager, Map context)");
            Tr.entry(tc, buf.toString());
        }
        boolean isSupportingToken = false;
        if (tconfig != null && cconfigs != null) {
            Collection<SecurityToken> tokens;
            if (!tconfig.isUsedForDecryption() && !tconfig.isUsedForVerification()) {
                isSupportingToken = true;
            }
            if ((tokens = securityTokenManager.getTokens()).size() > 0) {
                QName config_qn = tconfig.getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, tokens.size() + " tokens found.");
                    Tr.debug(tc, cconfigs.size() + " CallerConfigs found, so start to process it...");
                    Tr.debug(tc, "The value type of the token consumer configuration: " + config_qn);
                }
                for (CallerConfig cconfig : cconfigs) {
                    boolean requiredTrustedIdentityChecking;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing a CallerConfig [" + cconfig + "]...");
                    }
                    QName caller_qn = cconfig.getCallerIdentity();
                    QName tidentity_qn = cconfig.getTrustedIdentity();
                    ReferencePartConfig spart = cconfig.getRequiredSigningPartReference();
                    boolean requiredCallerIdentityChecking = caller_qn != null && caller_qn.equals(config_qn) && (spart == null || tidentity_qn != null);
                    boolean bl = requiredTrustedIdentityChecking = tidentity_qn != null && tidentity_qn.equals(config_qn) && spart == null;
                    if (!requiredCallerIdentityChecking && !requiredTrustedIdentityChecking) continue;
                    boolean callerIdentityCandidate = false;
                    boolean trustedIdentityCandidate = false;
                    for (SecurityToken token : tokens) {
                        QName token_qn = token.getValueType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The value type of the token: " + token_qn);
                        }
                        if (requiredCallerIdentityChecking) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking the caller identity [" + caller_qn + "]...");
                            }
                            if (caller_qn.equals(token_qn)) {
                                callerIdentityCandidate = true;
                            } else if ((Constants.LTPA_TOKEN.equals(caller_qn) || Constants.LTPAv2_TOKEN.equals(caller_qn)) && (Constants.LTPA_TOKEN.equals(token_qn) || Constants.LTPAv2_TOKEN.equals(token_qn))) {
                                if (!tconfig.isEnforceTokenVersion()) {
                                    callerIdentityCandidate = true;
                                } else {
                                    context.put("com.ibm.ws.wssecurity.ltpa.enforceTokenVersion", "true");
                                }
                            }
                        }
                        if (requiredTrustedIdentityChecking) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking the trusted identity [" + tidentity_qn + "]...");
                            }
                            if (tidentity_qn.equals(token_qn)) {
                                trustedIdentityCandidate = true;
                            } else if ((Constants.LTPA_TOKEN.equals(tidentity_qn) || Constants.LTPAv2_TOKEN.equals(tidentity_qn)) && (Constants.LTPA_TOKEN.equals(token_qn) || Constants.LTPAv2_TOKEN.equals(token_qn))) {
                                if (!tconfig.isEnforceTokenVersion()) {
                                    trustedIdentityCandidate = true;
                                } else {
                                    context.put("com.ibm.ws.wssecurity.ltpa.enforceTokenVersion", "true");
                                }
                            }
                        }
                        if (!callerIdentityCandidate && !trustedIdentityCandidate) continue;
                        SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token);
                        AuthResult aresult = new AuthResult(tokenWrapper, cconfig, callerIdentityCandidate, trustedIdentityCandidate, isSupportingToken);
                        ResultPool.add(context, aresult);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added AuthResult[" + aresult + "] into the ResultPool.");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkCaller(");
            buf.append("Set, TokenConsumerConfig, SecurityTokenManagerImpl, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void checkCaller(Collection<CallerConfig> cconfigs, TokenConsumerConfig tconfig, SecurityTokenWrapper tokenWrapper, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkCaller(");
            buf.append("Collection cconfigs, TokenConsumerConfig tconfig, ");
            buf.append("SecurityTokenWrapper tokenWrapper[").append(tokenWrapper).append("], ");
            buf.append("SecurityTokenManagerImpl securityTokenManager, Map context)");
            Tr.entry(tc, buf.toString());
        }
        boolean isSupportingToken = false;
        if (tconfig != null && cconfigs != null) {
            if (!tconfig.isUsedForDecryption() && !tconfig.isUsedForVerification()) {
                isSupportingToken = true;
            }
            QName config_qn = tconfig.getType();
            QName token_qn = tokenWrapper.getValueType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The value type of the token consumer configuration: " + config_qn);
                Tr.debug(tc, "The value type of the token: " + token_qn);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, cconfigs.size() + " CallerConfigs found, so start to process it...");
            }
            for (CallerConfig cconfig : cconfigs) {
                boolean requiredTrustedIdentityChecking;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing a CallerConfig [" + cconfig + "]...");
                }
                QName caller_qn = cconfig.getCallerIdentity();
                QName tidentity_qn = cconfig.getTrustedIdentity();
                ReferencePartConfig spart = cconfig.getRequiredSigningPartReference();
                boolean requiredCallerIdentityChecking = caller_qn != null && caller_qn.equals(config_qn) && (spart == null || tidentity_qn != null);
                boolean bl = requiredTrustedIdentityChecking = tidentity_qn != null && tidentity_qn.equals(config_qn) && spart == null;
                if (!requiredCallerIdentityChecking && !requiredTrustedIdentityChecking) continue;
                boolean callerIdentityCandidate = false;
                boolean trustedIdentityCandidate = false;
                if (requiredCallerIdentityChecking) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the caller identity [" + caller_qn + "]...");
                    }
                    if (caller_qn.equals(token_qn)) {
                        callerIdentityCandidate = true;
                    } else if ((Constants.LTPA_TOKEN.equals(caller_qn) || Constants.LTPAv2_TOKEN.equals(caller_qn)) && (Constants.LTPA_TOKEN.equals(token_qn) || Constants.LTPAv2_TOKEN.equals(token_qn))) {
                        if (!tconfig.isEnforceTokenVersion()) {
                            callerIdentityCandidate = true;
                        } else {
                            context.put("com.ibm.ws.wssecurity.ltpa.enforceTokenVersion", "true");
                        }
                    }
                }
                if (requiredTrustedIdentityChecking) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the trusted identity [" + tidentity_qn + "]...");
                    }
                    if (tidentity_qn.equals(token_qn)) {
                        trustedIdentityCandidate = true;
                    } else if ((Constants.LTPA_TOKEN.equals(tidentity_qn) || Constants.LTPAv2_TOKEN.equals(tidentity_qn)) && (Constants.LTPA_TOKEN.equals(token_qn) || Constants.LTPAv2_TOKEN.equals(token_qn))) {
                        if (!tconfig.isEnforceTokenVersion()) {
                            trustedIdentityCandidate = true;
                        } else {
                            context.put("com.ibm.ws.wssecurity.ltpa.enforceTokenVersion", "true");
                        }
                    }
                }
                if (!callerIdentityCandidate && !trustedIdentityCandidate) continue;
                AuthResult aresult = new AuthResult(tokenWrapper, cconfig, callerIdentityCandidate, trustedIdentityCandidate, isSupportingToken);
                ResultPool.add(context, aresult);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added AuthResult[" + aresult + "] into the ResultPool.");
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkCaller(");
            buf.append("Set, TokenConsumerConfig, SecurityTokenWrapper, ");
            buf.append("SecurityTokenManagerImpl, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static void checkCaller(Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCaller(Map selectors, Map context)");
        }
        WSSConsumerComponent component = null;
        component = (WSSConsumerComponent)selectors.get(LoginProcessor.class);
        component.invoke(null, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCaller(Map, Map)");
        }
    }

    private static void cleanSubject(SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) throws SoapSecurityException {
        Collection<SecurityTokenWrapper> tokenWrappers;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanSubject(Map context)");
        }
        if ((tokenWrappers = securityTokenManager.getTokenWrappers()) != null && tokenWrappers.size() > 0) {
            String uid;
            SecurityTokenWrapper tokenWrapper;
            Result result;
            int i;
            HashMap<String, SecurityTokenWrapper> id2token = new HashMap<String, SecurityTokenWrapper>();
            Result[] results = ResultPool.get(context, VerificationResult.class);
            if (results != null) {
                for (i = 0; i < results.length; ++i) {
                    result = (VerificationResult)results[i];
                    tokenWrapper = ((VerificationResult)result).getTokenWrapper();
                    if (tokenWrapper == null) continue;
                    uid = tokenWrapper.getId();
                    if (id2token.containsKey(uid)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WARNING: The token that has the same unique id [" + uid + "] exists.");
                        Tr.debug(tc, "The already stored token is [" + id2token.get(uid) + "] and this is keeped.");
                        Tr.debug(tc, "A newly found token is [" + tokenWrapper + "] and this is ignored.");
                        continue;
                    }
                    id2token.put(uid, tokenWrapper);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The token whose unique id is [" + uid + "]: <<<" + tokenWrapper + ">>>.");
                }
            }
            if ((results = ResultPool.get(context, DecryptionResult.class)) != null) {
                for (i = 0; i < results.length; ++i) {
                    result = (DecryptionResult)results[i];
                    tokenWrapper = ((DecryptionResult)result).getTokenWrapper();
                    if (tokenWrapper == null) continue;
                    uid = tokenWrapper.getId();
                    if (id2token.containsKey(uid)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WARNING: The token that has the same unique id [" + uid + "] exists.");
                        Tr.debug(tc, "The already stored token is [" + id2token.get(uid) + "] and this is keeped.");
                        Tr.debug(tc, "A newly found token is [" + tokenWrapper + "] and this is ignored.");
                        continue;
                    }
                    id2token.put(uid, tokenWrapper);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The token whose unique id is [" + uid + "]: <<<" + tokenWrapper + ">>>.");
                }
            }
            for (SecurityTokenWrapper tokenWrapper2 : tokenWrappers) {
                String uid2;
                if (tokenWrapper2.getError() != null || id2token.containsKey(uid2 = tokenWrapper2.getId())) continue;
                id2token.put(uid2, tokenWrapper2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The token whose unique id is [" + uid2 + "]: <<<" + tokenWrapper2 + ">>>.");
            }
            securityTokenManager.removeAllTokens();
            if (id2token.size() > 0) {
                securityTokenManager.addTokenWrappers(id2token.values());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanSubject(Map context)");
        }
    }

    private static void mapTokenToMessageContext(MessageContext messageContext, SecurityTokenManagerImpl securityTokenManager, Map<Object, Object> context) throws SoapSecurityException {
        block21: {
            SecurityToken token2;
            block24: {
                Result[] results;
                block23: {
                    VerificationResult result;
                    SecurityTokenWrapper tw;
                    SecurityToken t;
                    block22: {
                        boolean isServer;
                        if (tc.isEntryEnabled()) {
                            StringBuffer buf = new StringBuffer("mapTokenToMessageContext(");
                            buf.append("MessageContext messageContext, ");
                            buf.append("SecurityTokenManagerImpl securityTokenManager, Map context)");
                            Tr.entry(tc, buf.toString());
                        }
                        int number = 0;
                        Collection<SecurityToken> tokens = securityTokenManager.getTokens();
                        if (tokens != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, tokens.size() + " tokens found.");
                            }
                            if (tokens.size() > 0) {
                                Hashtable<String, SecurityToken> table = new Hashtable<String, SecurityToken>();
                                for (SecurityToken token2 : tokens) {
                                    String id = token2.getId();
                                    if (id == null) {
                                        id = IdUtils.getInstance().makeUniqueId(context, "Token_") + "_" + ++number;
                                    }
                                    table.put(id, token2);
                                }
                                messageContext.setProperty(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TOKEN_PROPERGATION, table);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "A table of tokens is copied to the property in the MessageContext.");
                                }
                            }
                        }
                        if (!(isServer = Axis2Util.isServiceProvider(messageContext))) break block21;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This is server process. So the runtime is storing a signer certificate...");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking verification results...");
                        }
                        if ((results = ResultPool.get(context, VerificationResult.class)) != null && results.length != 0) break block22;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No signer X509 certificate was found in the request message.");
                        }
                        break block21;
                    }
                    token2 = null;
                    if (results.length != 1) break block23;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Only one verification token found.");
                    }
                    if (!((t = (tw = (result = (VerificationResult)results[0]).getTokenWrapper()).getSecurityToken()) instanceof X509Token)) break block24;
                    token2 = (X509Token)t;
                    break block24;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "More than one verification tokens found.");
                }
                for (int i = 0; i < results.length; ++i) {
                    VerificationResult result = (VerificationResult)results[i];
                    SecurityTokenWrapper tw = result.getTokenWrapper();
                    SecurityToken t = tw.getSecurityToken();
                    if (!(t instanceof X509Token) || !tw.isUsedToLogin()) continue;
                    token2 = (X509Token)t;
                    break;
                }
            }
            if (token2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to specify the one of X509 certificates in the request message.");
                }
            } else {
                X509Certificate cert;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The X509 token that includes a signer certificate [" + token2 + "].");
                }
                if ((cert = token2.getCertificate()) == null) {
                    Tr.warning(tc, "security.wssecurity.WSSConsumer.s33");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Signer certificate is stored in the message context [" + cert + "].");
                    }
                    messageContext.setProperty("com.ibm.xml.soapsec.RequestCert", cert);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapTokenToMessageContext(MessageContext, Map)");
        }
    }

    private static void copyContextSubjectToMessageContext(MessageContext messageContext, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("copyContextSubjectToMessageContext(");
            buf.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, buf.toString());
        }
        Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        messageContext.setProperty(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TOKEN_WSSSUBJECT, subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyContextSubjectToMessageContext(MessageContext, Map)");
        }
    }

    private static void lockResults(Map<Object, Object> context, boolean signature, boolean locked) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("lockResults(");
            buf.append("Map context, ");
            buf.append("boolean signature[").append(signature).append("], ");
            buf.append("boolean locked[").append(locked).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (signature) {
            results = ResultPool.get(context, VerificationResult.class);
            if (results != null && results.length > 0) {
                for (int i = 0; i < results.length; ++i) {
                    VerificationResult result = (VerificationResult)results[i];
                    result.setLocked(locked);
                }
            }
        } else {
            results = ResultPool.get(context, DecryptionResult.class);
            if (results != null && results.length > 0) {
                for (int i = 0; i < results.length; ++i) {
                    DecryptionResult result = (DecryptionResult)results[i];
                    result.setLocked(locked);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lockResults(Map, boolean, boolean)");
        }
    }

    private static void removeKeyInfoResults(Map<Object, Object> context) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeKeyInfoResults(Map context)");
        }
        if ((results = ResultPool.get(context, KeyInfoResult.class)) != null && results.length > 0) {
            ResultPool.remove(context, results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreResults(Map<Object, Object> context, boolean signature) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("restoreResults(");
            buf.append("Map context, ");
            buf.append("boolean signature[").append(signature).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (signature) {
            VerificationResult result;
            results = ResultPool.get(context, VerificationResult.class);
            if (results != null && results.length > 0 && !(result = (VerificationResult)results[results.length - 1]).getLocked()) {
                List<VerificationResult.VerifiedPart> list;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restoring a verification result [" + result + "]...");
                }
                if ((list = result.getVerifiedParts()) != null) {
                    int iMax = list.size();
                    for (int i = 0; i < iMax; ++i) {
                        VerificationResult.VerifiedPart part = list.get(i);
                        if (part.getNonce() == null && part.getTimestamp() == null) continue;
                        if (part.getNonceFirst()) {
                            part.getParent().addChild(part.getNonce());
                            if (tc.isDebugEnabled()) {
                                if (part.getParent() instanceof OMElement) {
                                    Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMElement)part.getParent()) + "].");
                                } else {
                                    Tr.debug(tc, "Nonce is restored into the node[" + part.getParent() + "].");
                                }
                            }
                            if (part.getNonce() == null) continue;
                            part.getParent().addChild(part.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            if (part.getParent() instanceof OMElement) {
                                Tr.debug(tc, "Timestmap is restored into the node[" + DOMUtils.getDisplayName((OMElement)part.getParent()) + "].");
                                continue;
                            }
                            Tr.debug(tc, "Timestmap is restored into the node[" + part.getParent() + "].");
                            continue;
                        }
                        part.getParent().addChild(part.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Timestamp is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)part.getParent())) + "].");
                        }
                        if (part.getNonce() == null) continue;
                        part.getParent().addChild(part.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)part.getParent())) + "].");
                    }
                }
                ResultPool.remove(context, result);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed the verification result.");
                }
            }
        } else {
            DecryptionResult result;
            results = ResultPool.get(context, DecryptionResult.class);
            if (results != null && results.length > 0 && !(result = (DecryptionResult)results[results.length - 1]).getLocked()) {
                List<DecryptionResult.DecryptedPart> list;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restoring a decryption result [" + result + "]...");
                }
                if ((list = result.getDecryptedParts()) != null) {
                    int iMax = list.size();
                    for (int i = 0; i < iMax; ++i) {
                        DecryptionResult.DecryptedPart part = list.get(i);
                        if (part.getNonce() == null && part.getTimestamp() == null) continue;
                        if (part.getNonceFirst()) {
                            part.getParent().addChild(part.getNonce());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)part.getParent())) + "].");
                            }
                            if (part.getNonce() == null) continue;
                            part.getParent().addChild(part.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Timestmap is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)part.getParent())) + "].");
                            continue;
                        }
                        part.getParent().addChild(part.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Timestamp is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)part.getParent())) + "].");
                        }
                        if (part.getNonce() == null) continue;
                        part.getParent().addChild(part.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Nonce is restored into the node[" + DOMUtils.getDisplayName((OMNode)((Object)part.getParent())) + "].");
                    }
                }
                ResultPool.remove(context, result);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed the decryption result.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreResults(Map, boolean)");
        }
    }

    private static int getUsedFor(OMElement envelope, OMElement security, String nsWsse, String id) {
        int ret;
        block10: {
            ArrayList list;
            block11: {
                if (tc.isEntryEnabled()) {
                    StringBuffer buf = new StringBuffer("getUsedFor(");
                    buf.append("OMElement envelope[").append(DOMUtils.getDisplayName(envelope)).append("], ");
                    buf.append("OMElement security[").append(DOMUtils.getDisplayName(security)).append("], ");
                    buf.append("String nsWsse[").append(nsWsse).append("], ");
                    buf.append("String id[").append(id).append("])");
                    Tr.entry(tc, buf.toString());
                }
                ret = 0;
                if (id == null || id.length() <= 0) break block10;
                id = "#" + id;
                list = DOMUtils.getElementsByTagNameNS(security, nsWsse, "Reference");
                if (list != null && list.size() != 0) break block11;
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "No wsse:Reference element found.");
                break block10;
            }
            int len = list.size();
            if (tc.isDebugEnabled()) {
                if (len == 1) {
                    Tr.debug(tc, len + " wsse:Reference element found.");
                } else {
                    Tr.debug(tc, len + " wsse:Reference elements found.");
                }
            }
            for (int i = 0; i < len; ++i) {
                OMContainer parent;
                OMElement sec2;
                OMElement elem = (OMElement)list.get(i);
                String refUri = elem.getAttributeValue(URI_Q);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing URI [" + refUri + "]...");
                }
                if (!id.equals(refUri) || !DOMUtils.equals(sec2 = DOMUtils.getAncestorElement(elem, nsWsse, "Security"), security)) continue;
                OMElement keyInfo = DOMUtils.getAncestorElement(elem, Constants.NS_DSIG, "KeyInfo");
                if (keyInfo == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ds:KeyInfo is not found as an ancestor.");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ds:KeyInfo is found as an ancestor.");
                }
                if ((parent = keyInfo.getParent()) == null || !(parent instanceof OMElement)) continue;
                if (DOMUtils.equals((OMElement)parent, Constants.NS_DSIG, "Signature")) {
                    ret = 1;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "The token is used for signature verification.");
                    break;
                }
                if (!DOMUtils.equals((OMElement)parent, Constants.NS_ENC, "EncryptedKey") && !DOMUtils.equals((OMElement)parent, Constants.NS_ENC, "EncryptedData")) continue;
                ret = 2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "The token is used for decryption.");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getUsedFor(");
            buf.append("OMElement, OMElement, String, String)");
            buf.append(" returns int [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    public void mapSignedPartsToMessageContext(MessageContext msgCtx, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("mapSignedPartsToMessageContext(");
            buf.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking verification results...");
        }
        Result[] results = ResultPool.get(context, VerificationResult.class);
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        DerivedKeyToken dkt = null;
        if (results == null || results.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No verification results were found.");
            }
        } else {
            if (results.length == 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Only one VerificationResult object found.");
            }
            for (int i = 0; i < results.length; ++i) {
                SecurityToken token;
                VerificationResult result = (VerificationResult)results[i];
                SecurityTokenWrapper tokenWrapper = result.getTokenWrapper();
                if (tokenWrapper == null || !((token = tokenWrapper.getSecurityToken()) instanceof DerivedKeyToken)) continue;
                dkt = (DerivedKeyToken)token;
                Iterator<VerificationResult.VerifiedPart> it = result.getVerifiedParts().iterator();
                VerificationResult.VerifiedPart part = null;
                while (it.hasNext()) {
                    part = it.next();
                    if (part.getObject() == null) continue;
                    list.add(part.getObject());
                }
            }
            if (!list.isEmpty()) {
                HashMap<String, ArrayList<OMElement>> map = new HashMap<String, ArrayList<OMElement>>();
                map.put(dkt.getSecurityContextTokenTokenUUID(), list);
                msgCtx.setProperty("SIGNED_ELEMENTS_MAP", map);
                msgCtx.setProperty("SCT_USEDFOR_MS", dkt.getSecurityContextTokenTokenUUID());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapSignedPartsToMessageContext(MessageContext, Map)");
        }
    }

    public void mapEncryptedPartsToMessageContext(MessageContext msgCtx, Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("mapEncryptedPartsToMessageContext(");
            buf.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking decryption results...");
        }
        Result[] results = ResultPool.get(context, DecryptionResult.class);
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        DerivedKeyToken dkt = null;
        if (results == null || results.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No decryption results were found.");
            }
        } else {
            if (results.length == 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Only one DecryptionResult object found.");
            }
            for (int i = 0; i < results.length; ++i) {
                SecurityToken token;
                DecryptionResult result = (DecryptionResult)results[i];
                SecurityTokenWrapper tokenWrapper = result.getTokenWrapper();
                if (tokenWrapper == null || !((token = tokenWrapper.getSecurityToken()) instanceof DerivedKeyToken)) continue;
                dkt = (DerivedKeyToken)token;
                Iterator<DecryptionResult.DecryptedPart> it = result.getDecryptedParts().iterator();
                DecryptionResult.DecryptedPart part = null;
                while (it.hasNext()) {
                    part = it.next();
                    if (part.getObject() == null) continue;
                    list.add(part.getObject());
                }
            }
            if (!list.isEmpty()) {
                HashMap<String, ArrayList<OMElement>> map = new HashMap<String, ArrayList<OMElement>>();
                map.put(dkt.getSecurityContextTokenTokenUUID(), list);
                msgCtx.setProperty("DECRYPTED_ELEMENTS_MAP", map);
                msgCtx.setProperty("SCT_USEDFOR_MS", dkt.getSecurityContextTokenTokenUUID());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapEncryptedPartsToMessageContext(MessageContext, Map)");
        }
    }

    private boolean shouldProcessSecurityHeader(WSSConsumerConfig config2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldProcessSecurityHeader");
        }
        boolean processHeader = true;
        if (config2 != null) {
            boolean configSetting = config2.getBypassSecurityHeaderSetting();
            if (configSetting) {
                if (!isSecurityEnabled) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server security is disabled and " + com.ibm.wsspi.wssecurity.core.Constants.BYPASS_HEADER + " is true.  The security header will not be processed.");
                    }
                    processHeader = false;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server security is enabled.  The security header will be processed.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Consumer config is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldProcessSecurityHeader returns " + processHeader);
        }
        return processHeader;
    }

    public void proveKeyPossession(SecurityTokenManagerImpl securityTokenManager, MessageContext msgCtx, Map<Object, Object> context) throws SoapSecurityException {
        boolean isServer;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("proveKeyPossession(");
            buf.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (!(isServer = Axis2Util.isServiceProvider(msgCtx))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Receiving response, no validation performed...");
            }
            return;
        }
        ArrayList tokens = WSSConsumer.saerchSAMLToken(securityTokenManager);
        if (tokens.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No SAMLToken, no validation performed...");
            }
            return;
        }
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            Result[] results;
            boolean isHokOk = true;
            SecurityTokenWrapper tWrapper = (SecurityTokenWrapper)it.next();
            SAMLToken saml = null;
            saml = tWrapper.getSecurityToken() instanceof SAMLToken ? (SAMLToken)tWrapper.getSecurityToken() : (SAMLToken)((DKToken)tWrapper.getSecurityToken()).getDerivableSecurityToken();
            if (!saml.getConfirmationMethod().contains("holder-of-key")) continue;
            isHokOk = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking verification results...");
            }
            if ((results = ResultPool.get(context, VerificationResult.class)) == null || results.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No verification results were found.");
                }
            } else {
                block1: for (int i = 0; i < results.length; ++i) {
                    VerificationResult result = (VerificationResult)results[i];
                    SecurityTokenWrapper tokenWrapper = result.getTokenWrapper();
                    if (tokenWrapper != null) {
                        SecurityToken token = tokenWrapper.getSecurityToken();
                        if (token != null && token instanceof DKToken) {
                            DKToken dkt = (DKToken)token;
                            token = dkt.getDerivableSecurityToken();
                        }
                        if (token == null || !(token instanceof SAMLToken) || !saml.getSamlID().equals(((SAMLToken)token).getSamlID())) continue;
                        isHokOk = true;
                        break;
                    }
                    if (result.getSignatureConsumerConfig() == null || result.getSignatureConsumerConfig().getSigningKeyInfo() == null || result.getSignatureConsumerConfig().getSigningKeyInfo().getContentConsumers() == null) continue;
                    for (KeyInfoContentConsumerConfig kconfig : result.getSignatureConsumerConfig().getSigningKeyInfo().getContentConsumers()) {
                        int tcfg;
                        if (kconfig == null || (tcfg = kconfig.getTokenConsumer().hashCode()) != tWrapper.getUsedTokenConsumerHash()) continue;
                        isHokOk = true;
                        continue block1;
                    }
                }
            }
            if (isHokOk) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "prove proofKey Possession " + saml.getSamlID());
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can not prove proofKey Possession " + saml.getSamlID());
            }
            throw SoapSecurityException.format("SAML holder-of-key Assertion with ID of, " + saml.getSamlID() + "need sign or endorse request.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "proveKeyPossession(MessageContext, Map)");
        }
    }

    private static ArrayList saerchSAMLToken(SecurityTokenManagerImpl securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("saerchSAMLToken(");
            buf.append("SecurityTokenManagerImpl securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        ArrayList<SecurityTokenWrapper> tokenList = new ArrayList<SecurityTokenWrapper>();
        Collection<SecurityTokenWrapper> tokens = securityTokenManager.getTokenWrappers();
        if (tokens != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, tokens.size() + " tokens found.");
            }
            if (tokens.size() > 0) {
                for (SecurityTokenWrapper token : tokens) {
                    if (token.getSecurityToken() instanceof SAMLToken) {
                        tokenList.add(token);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Found SAMLToken=" + ((SAMLToken)token.getSecurityToken()).getSamlID());
                        continue;
                    }
                    if (!(token.getSecurityToken() instanceof DKToken) || !(((DKToken)token.getSecurityToken()).getDerivableSecurityToken() instanceof SAMLToken)) continue;
                    tokenList.add(token);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found SAMLToken from DKToken =" + ((SAMLToken)((DKToken)token.getSecurityToken()).getDerivableSecurityToken()).getSamlID());
                }
            }
        }
        return tokenList;
    }

    static {
        String prop = System.getProperty("com.ibm.ws.wssecurity.useInboundBodyOptimization");
        if (prop != null) {
            useInboundBodyOptimization = "true".equalsIgnoreCase(prop) || "yes".equalsIgnoreCase(prop) || "1".equalsIgnoreCase(prop) || "on".equalsIgnoreCase(prop);
        }
        isSecurityEnabled = false;
    }
}

