/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class RequestMessagePool {
    private static final TraceComponent tc = Tr.register(RequestMessagePool.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    private static void clear(Map<Object, Object> context) {
        StoredMessage smes = (StoredMessage)context.get(RequestMessagePool.class);
        if (smes == null) {
            return;
        }
        smes.clear();
    }

    public static void addDocument(Map<Object, Object> context, OMDocument doc, List<ArrayList<OMNode>> list, List<ArrayList<OMNode>> hlist, boolean cloneDoc) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDocument(Map context,OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "List list," + "List hlist," + "boolean cloneDoc[" + cloneDoc + "]");
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        smes.addDocument(doc, list, hlist, cloneDoc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDocument(Map context,OMDocument doc,List list,List hlist,boolean cloneDoc[" + cloneDoc + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addElement(Map<Object, Object> context, OMElement objToBeEncrypted, OMElement encryptedData, OMElement headerInfo) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement(Map context,OMElement objToBeEncrypted[" + DOMUtils.getDisplayName(objToBeEncrypted) + "]," + "OMElement encryptedData[" + DOMUtils.getDisplayName(encryptedData) + "]," + "OMElement headerInfo[" + DOMUtils.getDisplayName(headerInfo) + "])");
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        StoredMessage storedMessage = smes;
        synchronized (storedMessage) {
            smes.addElement(objToBeEncrypted, encryptedData, headerInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement(Map context,OMElement objToBeEncrypted,OMElement encryptedData,OMElement headerInfo)");
        }
    }

    public static OMDocument getDocument(Map<Object, Object> context, int order) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocument(Map context,int order[" + order + "])");
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        OMDocument ret = smes.getDocument(order);
        if (tc.isEntryEnabled()) {
            OMElement root = ret == null ? null : ret.getOMDocumentElement();
            Tr.exit(tc, "getDocument(Map context,int order) returns Document[" + DOMUtils.getDisplayName(root) + "]");
        }
        return ret;
    }

    public static EncryptedObject convertElement(Map<Object, Object> context, OMElement object, int order) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertElement(Map context,OMElement object[" + DOMUtils.getDisplayName(object) + "]," + "int order[" + order + "])");
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        EncryptedObject ret = smes.convertElement(object, order);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertElement(Map context,OMElement object,int order) returns EncryptedObject[" + ret + "]");
        }
        return ret;
    }

    public static void initialize(Map<Object, Object> context) {
        RequestMessagePool.clear(context);
    }

    public static void finalize(Map<Object, Object> context) {
        RequestMessagePool.clear(context);
        context.remove(RequestMessagePool.class);
    }

    public static class EncryptedObject {
        private OMElement _headerInfo;
        private OMElement _encryptedData;

        public OMElement getHeaderInfo() {
            return this._headerInfo;
        }

        public OMElement getEncryptedData() {
            return this._encryptedData;
        }

        public void setEncryptedData(OMElement encryptedData) {
            this._encryptedData = encryptedData;
        }

        public String toString() {
            return "Element headerInfo[" + DOMUtils.getDisplayName(this._headerInfo) + "]," + "Element encryptedData[" + DOMUtils.getDisplayName(this._encryptedData) + "]";
        }
    }

    private static class StoredMessage {
        private ArrayList<OMDocument> _messageList = new ArrayList();
        private ArrayList<Map<OMElement, OMElement>> _objectList = new ArrayList();
        private ArrayList<Map<OMElement, EncryptedObject>> _edataList = new ArrayList();

        private StoredMessage() {
        }

        private void clear() {
            this._messageList.clear();
            this._objectList.clear();
            this._edataList.clear();
        }

        private void addDocument(OMDocument doc, List<ArrayList<OMNode>> list, List<ArrayList<OMNode>> hlist, boolean cloneDoc) {
            OMDocument doc2;
            HashMap<String, OMElement> av2el = new HashMap<String, OMElement>();
            HashMap<OMElement, OMElement> object = new HashMap<OMElement, OMElement>();
            if (cloneDoc) {
                long lMilli = System.currentTimeMillis();
                String attr = "Attr" + lMilli;
                String valueBase = "dummy_";
                int count = 0;
                count = this.addDummyAttributes(count, attr, valueBase, list, av2el);
                count = this.addDummyAttributes(count, attr, valueBase, hlist, av2el);
                doc2 = this.copyDocument(doc);
                OMElement root = doc2.getOMDocumentElement();
                if (root != null) {
                    this.putElement(root, object, av2el, attr);
                }
                this.removeDummyAttributes(attr, list);
                this.removeDummyAttributes(attr, hlist);
            } else {
                this.createObjectList(list, object);
                this.createObjectList(hlist, object);
                doc2 = doc;
            }
            this._messageList.add(doc2);
            this._objectList.add(object);
            this._edataList.add(new HashMap());
        }

        private void createObjectList(List<ArrayList<OMNode>> list, Map<OMElement, OMElement> object) {
            for (ArrayList<OMNode> parts : list) {
                for (int j = 0; j < parts.size(); ++j) {
                    OMNode node = parts.get(j);
                    if (node.getType() == 1) {
                        OMElement el = (OMElement)node;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "list: el is of type " + el.getClass().getName());
                        }
                        object.put(el, el);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added element to be encrypted to Map: element = " + DOMUtils.getDisplayName(el));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "list: node is of type " + node.getClass().getName());
                }
            }
        }

        private int addDummyAttributes(int count, String attr, String valueBase, List<ArrayList<OMNode>> list, Map<String, OMElement> av2el) {
            for (ArrayList<OMNode> parts : list) {
                for (int j = 0; j < parts.size(); ++j) {
                    OMNode node = parts.get(j);
                    if (node.getType() == 1) {
                        OMElement el = (OMElement)node;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "list: el is of type " + el.getClass().getName());
                        }
                        String value = valueBase + count++;
                        el.addAttribute(attr, value, null);
                        av2el.put(value, el);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Set attribute[" + attr + "=" + value + "] to the element[" + DOMUtils.getDisplayName(el) + "]");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "list: node is of type " + node.getClass().getName());
                }
            }
            return count;
        }

        private void removeDummyAttributes(String attr, List<ArrayList<OMNode>> list) {
            for (ArrayList<OMNode> parts : list) {
                for (int j = 0; j < parts.size(); ++j) {
                    OMNode node = parts.get(j);
                    if (node.getType() != 1) continue;
                    OMElement el = (OMElement)node;
                    el.removeAttribute(el.getAttribute(new QName("", attr)));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Removed attribute[" + attr + "] from the element[" + DOMUtils.getDisplayName(el) + "]");
                }
            }
        }

        private OMDocument copyDocument(OMDocument doc) {
            OMFactory factory = doc.getOMDocumentElement().getOMFactory();
            OMDocument doc2 = factory.createOMDocument();
            OMElement root = doc.getOMDocumentElement();
            OMElement root2 = factory.createOMElement(root.getLocalName(), root.getNamespace());
            doc2.addChild(root2);
            Iterator nss = root.getAllDeclaredNamespaces();
            while (nss.hasNext()) {
                root2.declareNamespace((OMNamespace)nss.next());
            }
            Iterator attrs = root.getAllAttributes();
            while (attrs.hasNext()) {
                root2.addAttribute((OMAttribute)attrs.next());
            }
            for (OMNode child = root.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                if (child instanceof OMElement) {
                    root2.addChild(((OMElement)child).cloneOMElement());
                    continue;
                }
                if (!(child instanceof OMText)) continue;
                root2.addChild(factory.createOMText(((OMText)child).getText()));
            }
            return doc2;
        }

        private void putElement(OMElement root, Map<OMElement, OMElement> object, Map<String, OMElement> av2el, String attr) {
            OMElement el = DOMUtils.getFirstElement(root);
            while (el != null) {
                String value = el.getAttributeValue(new QName("", attr));
                if (value != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found attribute[" + attr + "=" + value + "] at the element[" + DOMUtils.getDisplayName(el) + "]");
                    }
                    object.put(av2el.get(value), el);
                }
                this.putElement(el, object, av2el, attr);
                el = DOMUtils.getNextElement(el);
            }
        }

        private void addElement(OMElement objToBeEncrypted, OMElement encryptedData, OMElement headerInfo) {
            int pos = this._messageList.size() - 1;
            if (pos >= 0) {
                Map<OMElement, OMElement> object = this._objectList.get(pos);
                Map<OMElement, EncryptedObject> edata = this._edataList.get(pos);
                OMElement obj = object.get(objToBeEncrypted);
                if (obj != null) {
                    EncryptedObject eobj = new EncryptedObject();
                    eobj._headerInfo = headerInfo;
                    eobj._encryptedData = encryptedData;
                    edata.put(obj, eobj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Set EncryptedData and HeaderInfo(EncryptedKey or ReferenceList) for the element [" + DOMUtils.getDisplayName(obj) + "].");
                    }
                }
            }
        }

        private OMDocument getDocument(int order) {
            OMDocument doc = null;
            int pos = this._messageList.size() - 1 - order;
            if (pos >= 0) {
                doc = this._messageList.get(pos);
            }
            return doc;
        }

        private EncryptedObject convertElement(OMElement object, int order) {
            EncryptedObject eobj = null;
            if (order >= 0) {
                int pos = this._messageList.size() - 1 - order;
                if (pos >= 0) {
                    Map<OMElement, EncryptedObject> edata = this._edataList.get(pos);
                    eobj = edata.get(object);
                }
            } else {
                for (int pos = this._messageList.size() - 1; pos >= 0; --pos) {
                    Map<OMElement, EncryptedObject> edata = this._edataList.get(pos);
                    Map<OMElement, OMElement> objects = this._objectList.get(pos);
                    for (OMElement key : objects.keySet()) {
                        if (!DOMUtils.equalsc14n(key, object, false)) continue;
                        eobj = edata.get(objects.get(key));
                        break;
                    }
                    if (eobj != null) break;
                }
            }
            return eobj;
        }
    }
}

