/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.core;

import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.KeyGenerationEngine;
import com.ibm.ws.wssecurity.core.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;

public interface EngineFactory {
    public SignatureEngine getSignatureEngine(String var1) throws NoSuchAlgorithmException;

    public MessageDigest getMessageDigest(String var1, AlgorithmParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public EncryptionEngine getEncryptionEngine(String var1) throws NoSuchAlgorithmException;

    public KeyGenerationEngine getKeyGenerationEngine(String var1, String var2) throws NoSuchAlgorithmException;

    public Set getSignatureAlgorithms();

    public Set getDigestAlgorithms();

    public Set getDataEncryptionAlgorithms();

    public Set getKeyEncryptionAlgorithms();

    public boolean releaseSignatureEngine(SignatureEngine var1);

    public boolean releaseMessageDigest(String var1, MessageDigest var2);

    public boolean releaseEncryptionEngine(EncryptionEngine var1);

    public boolean releaseKeyGenerationEngine(KeyGenerationEngine var1);

    public AlgorithmParameterSpec unmarshalParameter(String var1, OMElement var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public AlgorithmParameterSpec convertParameter(String var1, Map var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public void marshalParameter(String var1, AlgorithmParameterSpec var2, OMElement var3) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;
}

