/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.confimpl;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConfigValidation;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Duration;
import com.ibm.ws.wssecurity.util.GetJAASConfigInfo;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public abstract class PrivateGeneratorConfig
extends PrivateCommonConfig
implements WSSGeneratorConfig {
    private static final TraceComponent tc = Tr.register(PrivateGeneratorConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    protected String _myActor = null;
    protected String _targetActor = null;
    protected boolean _indentation = false;
    protected final Set<String> _allowedTransforms = new HashSet<String>();
    protected final Set<String> _allowedCanonicalizationMethods = new HashSet<String>();
    protected final Set<String> _allowedSignatureMethods = new HashSet<String>();
    protected final Set<String> _allowedDigestMethods = new HashSet<String>();
    protected final Set<String> _allowedDataEncryptionMethods = new HashSet<String>();
    protected final Set<String> _allowedKeyEncryptionMethods = new HashSet<String>();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set<String> _defaultKeyInfoContentGenerators = new HashSet<String>();
    protected final Set<String> _defaultTokenGenerators = new HashSet<String>();
    protected final Set<String> _defaultCallbackHandlers = new HashSet<String>();
    protected final Set<String> _defaultKeyLocators = new HashSet<String>();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _signatureEnabled = false;
    protected boolean _encryptionEnabled = false;
    protected boolean _tokenEnabled = false;
    protected boolean _timestampEnabled = false;
    protected final List<ReferencePartConfig> _integralParts = new ArrayList<ReferencePartConfig>();
    protected final List<ReferencePartConfig> _confidentialParts = new ArrayList<ReferencePartConfig>();
    protected final List<TokenGeneratorConfig> _securityTokens = new ArrayList<TokenGeneratorConfig>();
    protected final List<Configuration> _operationGenerators = new ArrayList<Configuration>();
    protected final Set<TokenGeneratorConfig> _tokenGenerators = new HashSet<TokenGeneratorConfig>();
    protected NonceManager _nonceManager = null;
    protected Map<Object, Object> _properties = null;
    protected TimestampGeneratorConfImpl _timestampGenerator = null;
    protected final Set<String> _defaultJAASConfigs = new HashSet<String>();
    protected boolean _symmetricBinding = false;
    protected PrivateConsumerConfig _bootstrapConsumerConfig = null;
    protected PrivateGeneratorConfig _bootstrapGeneratorConfig = null;
    protected boolean _scEnabled = false;
    protected boolean _normalBodyProcessing = false;
    protected boolean _outboundGoldenPath = false;
    protected boolean _policyBasedConfig = false;
    protected boolean _clientSetMustUnderstand = true;
    protected boolean _serviceGetMustUnderstand = true;

    protected void processPrivateConfig(OMDocument privconfig) throws SoapSecurityException {
        String value;
        int i;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processPrivateConfig(");
            buf.append("OMDocument pconfig[").append(privconfig).append("])");
            Tr.entry(tc, buf.toString());
        }
        OMElement pconfig = privconfig.getOMDocumentElement();
        boolean fipsMode = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            fipsMode = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            fipsMode = false;
        }
        ArrayList list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "Transform");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedTransforms.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s11");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedCanonicalizationMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed canonicalizationMethods:", new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s12");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedSignatureMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed signatureMethods:", new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s13");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "digestMethod");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedDigestMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed digestMethods:", new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s14");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedDataEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed encryptionMethods:", new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s15");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(value)) continue;
            this._allowedKeyEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed keyEncryptionMethods:", new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s16");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "KeyInfoContentGenerator");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultKeyInfoContentGenerators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyInfoContentGenerator:", new Object[]{this._defaultKeyInfoContentGenerators});
        }
        if (this._defaultKeyInfoContentGenerators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6715W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "TokenGenerator");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultTokenGenerators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default TokenGenerator:", new Object[]{this._defaultTokenGenerators});
        }
        if (this._defaultTokenGenerators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6716W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "CallbackHandler");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultCallbackHandlers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CallbackHandler:", new Object[]{this._defaultCallbackHandlers});
        }
        if (this._defaultCallbackHandlers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6717W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultKeyLocators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyLocator:", new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6714W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "JAASConfig");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "name");
            this._defaultJAASConfigs.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default JAASConfigs:", new Object[]{this._defaultJAASConfigs});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document pconfig)");
        }
    }

    public PrivateGeneratorConfig getBootstrapGeneratorConfig() {
        return this._bootstrapGeneratorConfig;
    }

    public PrivateConsumerConfig getBootstrapConsumerConfig() {
        return this._bootstrapConsumerConfig;
    }

    public boolean isSCEnabled() {
        return this._scEnabled;
    }

    @Override
    public void validate() throws SoapSecurityException {
        this.validate(false, false, null);
    }

    public void validate(boolean defaultConfig, Map<?, ?> nameToken) throws SoapSecurityException {
        this.validate(defaultConfig, false, nameToken);
    }

    public void validate(boolean defaultConfig, boolean defaultTokenGenerator, Map<?, ?> nameToken) throws SoapSecurityException {
        boolean encryptThenSign;
        boolean isMTOMOptimized;
        boolean timestampInSOAPHeader;
        boolean timestampLastInSecurityHeader;
        boolean encryptedHeaderGenerateWss11PreFp13;
        boolean encryptedHeaderPreV7Compat;
        boolean onlyC14nExclusiveTransformUsed;
        boolean wasExtensionUsed;
        boolean xPathExpressionUsed;
        block112: {
            block113: {
                block114: {
                    String keyword;
                    String dialect;
                    PrivateCommonConfig.ReferencePartConfImpl rconfig;
                    if (tc.isEntryEnabled()) {
                        StringBuffer buf = new StringBuffer("validate(");
                        buf.append("boolean defaultConfig[").append(defaultConfig).append("], ");
                        buf.append("boolean defaultTokenGenerator[").append(defaultTokenGenerator).append("], ");
                        buf.append("Map nameToken[").append(nameToken).append("])");
                        Tr.entry(tc, buf.toString());
                    }
                    xPathExpressionUsed = false;
                    wasExtensionUsed = false;
                    onlyC14nExclusiveTransformUsed = true;
                    encryptedHeaderPreV7Compat = false;
                    encryptedHeaderGenerateWss11PreFp13 = false;
                    timestampLastInSecurityHeader = false;
                    timestampInSOAPHeader = false;
                    Iterator<Configuration> i = this._integralParts.iterator();
                    while (i.hasNext()) {
                        int MessageParts2 = 0;
                        int Nonce2 = 0;
                        int Timestamp2 = 0;
                        rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
                        rconfig.validate();
                        for (PrivateCommonConfig.PartConfImpl partConfImpl : rconfig._parts) {
                            partConfImpl.validate();
                            if (partConfImpl.isNonce()) {
                                ++Nonce2;
                                wasExtensionUsed = true;
                            } else if (partConfImpl.isTimestamp()) {
                                ++Timestamp2;
                                wasExtensionUsed = true;
                            } else {
                                ++MessageParts2;
                            }
                            dialect = partConfImpl._dialect;
                            keyword = partConfImpl._keyword;
                            if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
                                int index = ConfigUtil.isIntegralWASDialect(keyword);
                                if (index == 1) {
                                    if (partConfImpl.isTimestamp()) {
                                        throw new SoapSecurityException("security.wssecurity.TimestampGenerator.s03");
                                    }
                                    if (this._timestampGenerator == null) continue;
                                    TimestampGeneratorConfImpl tsconfig = this._timestampGenerator;
                                    tsconfig._signed = true;
                                    continue;
                                }
                                if (index >= 0) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, partConfImpl.toString());
                            }
                            if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
                                xPathExpressionUsed = true;
                                if (keyword != null) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "SignedElements");
                            }
                            if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
                                if (partConfImpl._headerNamespace != null) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                            }
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, partConfImpl.toString());
                        }
                        if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
                        throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
                    }
                    i = this._confidentialParts.iterator();
                    while (i.hasNext()) {
                        int MessageParts2 = 0;
                        int Nonce2 = 0;
                        int Timestamp2 = 0;
                        rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
                        rconfig.validate();
                        for (PrivateCommonConfig.PartConfImpl partConfImpl : rconfig._parts) {
                            partConfImpl.validate();
                            if (partConfImpl.isNonce()) {
                                ++Nonce2;
                                wasExtensionUsed = true;
                            } else if (partConfImpl.isTimestamp()) {
                                ++Timestamp2;
                                wasExtensionUsed = true;
                            } else {
                                ++MessageParts2;
                            }
                            dialect = partConfImpl._dialect;
                            keyword = partConfImpl._keyword;
                            if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
                                if (ConfigUtil.isConfidentialWASDialect(keyword) >= 0) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, partConfImpl.toString());
                            }
                            if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
                                xPathExpressionUsed = true;
                                if (keyword != null) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "EncryptedElements");
                            }
                            if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
                                if (partConfImpl._headerNamespace != null) continue;
                                throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                            }
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, partConfImpl.toString());
                        }
                        if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
                        throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
                    }
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                        String ourJaasConfig = GetJAASConfigInfo.isJaasConfigOurs(tokenGeneratorConfImpl.getJAASConfig());
                        if (ourJaasConfig == null) continue;
                        tokenGeneratorConfImpl._properties.put("com.ibm.ws.wssecurity.token.ourLoginConfig", ourJaasConfig);
                    }
                    if (defaultConfig || defaultTokenGenerator) {
                        HashMap<QName, TokenGeneratorConfImpl> key2obj = new HashMap<QName, TokenGeneratorConfImpl>();
                        for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                            key2obj.put(tokenGeneratorConfImpl.getType(), tokenGeneratorConfImpl);
                        }
                        for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._securityTokens) {
                            QName tctype = tokenGeneratorConfImpl.getType();
                            TokenGeneratorConfImpl tc2 = (TokenGeneratorConfImpl)key2obj.get(tctype);
                            if (tc2 == null) {
                                throw SoapSecurityException.format("security.wssecurity.WSEC6817E", tokenGeneratorConfImpl._name, tctype.toString());
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Found token generator of type [" + tctype + "].");
                        }
                    } else {
                        for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._securityTokens) {
                            if (!this._tokenGenerators.contains(tokenGeneratorConfImpl)) {
                                throw SoapSecurityException.format("security.wssecurity.WSEC6818E", tokenGeneratorConfImpl._name);
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Found token generator in token generator list: " + tokenGeneratorConfImpl);
                        }
                    }
                    int signBody = 0;
                    int encBodyContent = 0;
                    boolean signThenEncryptBody = false;
                    isMTOMOptimized = false;
                    boolean encryptSomething = false;
                    encryptThenSign = false;
                    boolean encryptBodyViaEncryptedKey = false;
                    ArrayList<EncryptionGeneratorConfImpl> lenc = new ArrayList<EncryptionGeneratorConfImpl>();
                    for (Configuration obj : this._operationGenerators) {
                        KeyInfoContentGeneratorConfImpl kcconfig;
                        KeyInfoGeneratorConfImpl kconfig;
                        String secretKeyAlgorithm;
                        if (obj instanceof SignatureGeneratorConfig) {
                            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
                            SignatureGeneratorConfImpl sconfig = (SignatureGeneratorConfImpl)obj;
                            sconfig.validate(defaultConfig);
                            if (encryptSomething) {
                                encryptThenSign = true;
                            }
                            TokenGeneratorConfig signatureGenerator = sconfig.getSigningKeyInfo().getContentGenerator().getTokenGenerator();
                            QName type = signatureGenerator.getType();
                            if (this._symmetricBinding) {
                                QName signatureTokenType;
                                if (type != null && this._symmetricSignatureTokenAssertion != null && !type.equals(signatureTokenType = this._symmetricSignatureTokenAssertion.getTokenType())) {
                                    Tr.error(tc, "security.wssecurity.PrivateGeneratorConfig.s33", new Object[]{type.toString()});
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s33", type.toString());
                                }
                            } else if (this._request) {
                                int index = this._initiatorSignatureTokenQNames.indexOf(type);
                                if (index < 0) {
                                    index = this._initiatorTokenQNames.indexOf(type);
                                }
                                if (index < 0) {
                                    Tr.error(tc, "security.wssecurity.PrivateGeneratorConfig.s33", new Object[]{type.toString()});
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s33", type.toString());
                                }
                            } else {
                                int index = this._recipientSignatureTokenQNames.indexOf(type);
                                if (index < 0) {
                                    index = this._recipientTokenQNames.indexOf(type);
                                }
                                if (index < 0) {
                                    Tr.error(tc, "security.wssecurity.PrivateGeneratorConfig.s33", new Object[]{type.toString()});
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s33", type.toString());
                                }
                            }
                            if (sconfig._properties.containsKey(Constants.WSSECURITY_INCLUSIVE_NAMESPACES)) {
                                sconfig._inclusiveNamespaces = ConfigUtil.isTrue((String)sconfig._properties.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES));
                            }
                            if ((algorithmConfImpl = sconfig._canonicalizationMethod) != null) {
                                algorithmConfImpl.validate();
                                if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(algorithmConfImpl._algorithm)) {
                                    onlyC14nExclusiveTransformUsed = false;
                                }
                                if (!this._allowedCanonicalizationMethods.contains(algorithmConfImpl._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", algorithmConfImpl._algorithm);
                                }
                            }
                            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl2 = sconfig._signatureMethod;
                            boolean isSecretKeyAlgorithm = false;
                            secretKeyAlgorithm = null;
                            if (algorithmConfImpl2 != null) {
                                algorithmConfImpl2.validate();
                                if (!this._allowedSignatureMethods.contains(algorithmConfImpl2._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", algorithmConfImpl2._algorithm);
                                }
                                secretKeyAlgorithm = algorithmConfImpl2._algorithm;
                                isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm(secretKeyAlgorithm);
                            }
                            for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : sconfig._references) {
                                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl3;
                                signingReferenceConfImpl.validate();
                                Set<ReferencePartConfig.PartConfig> parts = signingReferenceConfImpl._reference.getParts();
                                if (parts != null && !parts.isEmpty()) {
                                    for (PrivateCommonConfig.PartConfImpl partConfImpl : parts) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Signing part = " + partConfImpl);
                                        }
                                        if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfImpl._dialect) || !IntegralDialectElementSelector.WASDIALECTS[0].equals(partConfImpl._keyword) || partConfImpl._nonce || partConfImpl._timestamp) continue;
                                        Iterator<AlgorithmConfig> transIte = signingReferenceConfImpl._transforms.iterator();
                                        String transAlgo = null;
                                        int transNo = 0;
                                        while (transIte.hasNext()) {
                                            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl4 = (PrivateCommonConfig.AlgorithmConfImpl)transIte.next();
                                            transAlgo = algorithmConfImpl4._algorithm;
                                            ++transNo;
                                        }
                                        if (transNo != true || !"http://www.w3.org/2001/10/xml-exc-c14n#".equals(transAlgo)) continue;
                                        ++signBody;
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "Body is signed");
                                    }
                                }
                                if ((algorithmConfImpl3 = signingReferenceConfImpl._digestMethod) != null) {
                                    algorithmConfImpl3.validate();
                                    if (!this._allowedDigestMethods.contains(algorithmConfImpl3._algorithm)) {
                                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithmConfImpl3._algorithm);
                                    }
                                }
                                boolean strTransform = false;
                                for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl5 : signingReferenceConfImpl._transforms) {
                                    algorithmConfImpl5.validate();
                                    if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(algorithmConfImpl5._algorithm)) {
                                        onlyC14nExclusiveTransformUsed = false;
                                    }
                                    if (!this._allowedTransforms.contains(algorithmConfImpl5._algorithm)) {
                                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", algorithmConfImpl5._algorithm);
                                    }
                                    if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmConfImpl5._algorithm)) {
                                        strTransform = true;
                                        continue;
                                    }
                                    if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithmConfImpl5._algorithm) || (keyword = ConfigUtil.trim((String)algorithmConfImpl5._properties.get(Constants.WSSECURITY_XPATH_EXPRESSION))) != null && keyword.length() != 0) continue;
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s27");
                                }
                            }
                            kconfig = sconfig._signingKeyInfo;
                            kconfig.validate();
                            kcconfig = kconfig._contentGenerator;
                            kcconfig.validate();
                            if (ConfigUtil.isKeyInfoType(kcconfig._keyInfoType) < 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", kcconfig.toString());
                            }
                            if (isSecretKeyAlgorithm) {
                                if (ConfigUtil.isKeyInfoEmb(kcconfig._keyInfoType)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                                }
                                if (ConfigUtil.isKeyInfoX509issuer(kcconfig._keyInfoType)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                                }
                            }
                            for (EncryptionGeneratorConfImpl econfig : lenc) {
                                econfig._sigAfterEnc = true;
                            }
                            continue;
                        }
                        if (obj instanceof EncryptionGeneratorConfig) {
                            Set<ReferencePartConfig.PartConfig> parts;
                            TokenGeneratorConfig encryptionGeneratorConf;
                            KeyInfoContentGeneratorConfig kinfoContentGcfg;
                            EncryptionGeneratorConfImpl econfig;
                            econfig = (EncryptionGeneratorConfImpl)obj;
                            econfig.validate(defaultConfig);
                            encryptSomething = true;
                            Map<Object, Object> props = econfig.getProperties();
                            if (props != null) {
                                String value = (String)props.get(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA);
                                if (value != null && value.length() > 0 && ConfigUtil.isTrue(value)) {
                                    isMTOMOptimized = true;
                                }
                                if ((value = (String)props.get(Constants.ENCRYPTED_HEADER_PRE_V7_COMPATIBILITY)) != null && value.length() > 0 && ConfigUtil.isTrue(value)) {
                                    encryptedHeaderPreV7Compat = true;
                                }
                                if ((value = (String)props.get(Constants.ENCRYPTED_HEADER_GENERATE_WSS11_PRE_FP13)) != null && value.length() > 0 && ConfigUtil.isTrue(value)) {
                                    encryptedHeaderGenerateWss11PreFp13 = true;
                                }
                            }
                            KeyInfoGeneratorConfig kInfoGcfg = econfig.getEncryptionKeyInfo();
                            QName type = null;
                            if (kInfoGcfg != null && (kinfoContentGcfg = kInfoGcfg.getContentGenerator()) != null && (encryptionGeneratorConf = kinfoContentGcfg.getTokenGenerator()) != null) {
                                type = encryptionGeneratorConf.getType();
                            }
                            if (this._symmetricBinding) {
                                QName encryptionTokenType;
                                if (type != null && this._symmetricEncryptionTokenAssertion != null && !type.equals(encryptionTokenType = this._symmetricEncryptionTokenAssertion.getTokenType())) {
                                    Tr.error(tc, "security.wssecurity.PrivateGeneratorConfig.s34", new Object[]{type.toString()});
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s34", type.toString());
                                }
                            } else if (this._request) {
                                int index = this._recipientEncryptionTokenQNames.indexOf(type);
                                if (index < 0) {
                                    index = this._recipientTokenQNames.indexOf(type);
                                }
                                if (index < 0) {
                                    Tr.error(tc, "security.wssecurity.PrivateGeneratorConfig.s34", new Object[]{type.toString()});
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s34", type.toString());
                                }
                            } else {
                                int index = this._initiatorEncryptionTokenQNames.indexOf(type);
                                if (index < 0) {
                                    index = this._initiatorTokenQNames.indexOf(type);
                                }
                                if (index < 0) {
                                    Tr.error(tc, "security.wssecurity.PrivateGeneratorConfig.s34", new Object[]{type.toString()});
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s34", type.toString());
                                }
                            }
                            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = econfig._dataEncryptionMethod;
                            algorithmConfImpl.validate();
                            if (!this._allowedDataEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", algorithmConfImpl._algorithm);
                            }
                            secretKeyAlgorithm = algorithmConfImpl._algorithm;
                            boolean isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm(secretKeyAlgorithm);
                            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl6 = econfig._keyEncryptionMethod;
                            if (algorithmConfImpl6 != null) {
                                algorithmConfImpl6.validate();
                                if (!this._allowedKeyEncryptionMethods.contains(algorithmConfImpl6._algorithm)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", algorithmConfImpl6._algorithm);
                                }
                                secretKeyAlgorithm = algorithmConfImpl6._algorithm;
                                isSecretKeyAlgorithm = ConfigUtil.isSecretKeyAlgorithm(secretKeyAlgorithm);
                            }
                            kconfig = econfig._encryptionKeyInfo;
                            kconfig.validate();
                            kcconfig = kconfig._contentGenerator;
                            kcconfig.validate();
                            if (ConfigUtil.isKeyInfoType(kcconfig._keyInfoType) < 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s13", kcconfig.toString());
                            }
                            if (isSecretKeyAlgorithm) {
                                if (ConfigUtil.isKeyInfoEmb(kcconfig._keyInfoType)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                                }
                                if (ConfigUtil.isKeyInfoX509issuer(kcconfig._keyInfoType)) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s08", secretKeyAlgorithm, kcconfig._keyInfoType);
                                }
                            }
                            if ((rconfig = econfig._reference) != null && (parts = rconfig._parts) != null && !parts.isEmpty()) {
                                for (PrivateCommonConfig.PartConfImpl partConfImpl : parts) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Encrypting part = " + partConfImpl);
                                    }
                                    if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfImpl._dialect) || !ConfidentialDialectElementSelector.WASDIALECTS[0].equals(partConfImpl._keyword) || partConfImpl._nonce || partConfImpl._timestamp) continue;
                                    ++encBodyContent;
                                    econfig._encryptsBody = true;
                                    if (econfig._keyEncryptionMethod != null) {
                                        encryptBodyViaEncryptedKey = true;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Body content is encrypted");
                                    }
                                    if (signBody != 1) continue;
                                    signThenEncryptBody = true;
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Sign, then encrypt = true");
                                }
                            }
                            lenc.add(econfig);
                            continue;
                        }
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s01", this.toString());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Conditions checked for normal outbound body processing:");
                        Tr.debug(tc, "    Sign body = " + signBody);
                        Tr.debug(tc, "    Encrypt body content = " + encBodyContent);
                        Tr.debug(tc, "    Sign then encrypt body = " + signThenEncryptBody);
                        Tr.debug(tc, "    Encrypt body via encrypted key = " + encryptBodyViaEncryptedKey);
                        Tr.debug(tc, "    MTOM = " + isMTOMOptimized);
                    }
                    if (signBody == 1 && encBodyContent == 1 && signThenEncryptBody && !encryptBodyViaEncryptedKey && !isMTOMOptimized) {
                        this._normalBodyProcessing = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Detected normal outbound processing");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not detect normal outbound processing");
                    }
                    for (TokenGeneratorConfImpl tokenGeneratorConfImpl : this._tokenGenerators) {
                        String msg;
                        tokenGeneratorConfImpl.validate();
                        PrivateCommonConfig.CallbackHandlerConfImpl cconfig = tokenGeneratorConfImpl._callbackHandler;
                        if (cconfig != null) {
                            PrivateCommonConfig.KeyInformationConfImpl kiconfig;
                            cconfig.validate();
                            PrivateCommonConfig.KeyStoreConfImpl ksconfig = cconfig._keyStore;
                            if (ksconfig != null) {
                                ksconfig.validate();
                            }
                            if ((kiconfig = cconfig._keyInformation) != null) {
                                kiconfig.validate();
                            }
                        }
                        if (!tokenGeneratorConfImpl._standAlone) continue;
                        if (tokenGeneratorConfImpl._usedForSignature) {
                            tokenGeneratorConfImpl._standAlone = false;
                            if (!tc.isDebugEnabled()) continue;
                            msg = ConfigUtil.getMessage("security.wssecurity.WSEC6815E", new String[]{tokenGeneratorConfImpl._name});
                            Tr.debug(tc, msg);
                            continue;
                        }
                        if (!tokenGeneratorConfImpl._usedForEncryption) continue;
                        tokenGeneratorConfImpl._standAlone = false;
                        if (!tc.isDebugEnabled()) continue;
                        msg = ConfigUtil.getMessage("security.wssecurity.WSEC6816E", new String[]{tokenGeneratorConfImpl._name});
                        Tr.debug(tc, msg);
                    }
                    if (this._timestampGenerator == null) break block112;
                    this._timestampGenerator.validate();
                    String value = (String)this._timestampGenerator._properties.get(Constants.WSSECURITY_TIMESTAMP_SOAPHEADER);
                    if (value != null) {
                        this._timestampGenerator._headerAttribute = ConfigUtil.isTrue(value);
                        this._timestampGenerator._soapHeader = true;
                    }
                    if ((value = (String)this._timestampGenerator._properties.get(Constants.WSSECURITY_TIMESTAMP_DIALECT)) == null) break block113;
                    if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(value)) break block114;
                    value = (String)this._timestampGenerator._properties.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD);
                    if (value == null) break block113;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TimestampGenerator property " + Constants.WSSECURITY_TIMESTAMP_KEYWORD + " has value " + value);
                    }
                    int index = ConfigUtil.isTimestampWASDialect(value);
                    switch (index) {
                        case 1: {
                            timestampLastInSecurityHeader = true;
                            break block113;
                        }
                        case 2: 
                        case 3: {
                            timestampInSOAPHeader = true;
                            this._timestampGenerator._soapHeader = true;
                        }
                        case 0: {
                            this._timestampGenerator._default = false;
                            break block113;
                        }
                        default: {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", value, this._timestampGenerator.toString());
                        }
                    }
                }
                this._timestampGenerator._default = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TimestampGenerator._default = " + this._timestampGenerator._default);
                Tr.debug(tc, "TimestampGenerator._soapHeader = " + this._timestampGenerator._soapHeader);
                Tr.debug(tc, "TimestampGenerator._headerAttribute" + this._timestampGenerator._headerAttribute);
            }
        }
        if (encryptThenSign && "Strict".equals(this._layout)) {
            Tr.warning(tc, "The policy specified Strict layout which may not be valid since the bindings specified to encrypt before sign. The bindings may need to be changed to sign before encrypt, or the policy may need to be changed to Lax layout in order to meet the layout rules.");
        }
        if (!(encryptThenSign || isMTOMOptimized || this._userDefinedComponentsUsed || !this._policyBasedConfig || xPathExpressionUsed || wasExtensionUsed || !onlyC14nExclusiveTransformUsed || timestampInSOAPHeader || timestampLastInSecurityHeader || encryptedHeaderPreV7Compat || encryptedHeaderGenerateWss11PreFp13)) {
            this._outboundGoldenPath = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Conditions checked for outbound header optimization:");
            Tr.debug(tc, "    Encrypt then sign = " + encryptThenSign);
            Tr.debug(tc, "    MTOM optimization = " + isMTOMOptimized);
            Tr.debug(tc, "    User-defined components used = " + this._userDefinedComponentsUsed);
            Tr.debug(tc, "    Policy-based config = " + this._policyBasedConfig);
            Tr.debug(tc, "    XPath element selector used = " + xPathExpressionUsed);
            Tr.debug(tc, "    WAS extension used = " + wasExtensionUsed);
            Tr.debug(tc, "    Only Exclusive C14N transfrom used = " + onlyC14nExclusiveTransformUsed);
            Tr.debug(tc, "    Timestamp in SOAP header = " + timestampInSOAPHeader);
            Tr.debug(tc, "    Timestamp last in Security header = " + timestampLastInSecurityHeader);
            Tr.debug(tc, "    EncryptedHeader: pre-V7 compat = " + encryptedHeaderPreV7Compat);
            Tr.debug(tc, "    EncryptedHeader: pre-FP13 compat = " + encryptedHeaderPreV7Compat);
            Tr.debug(tc, "Conditions for outbound header optimization = " + this._outboundGoldenPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(boolean, Map)");
        }
    }

    @Override
    public boolean getServiceGetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceGetMustUnderstand");
            Tr.exit(tc, "getServiceGetMustUnderstand=" + this._serviceGetMustUnderstand);
        }
        return this._serviceGetMustUnderstand;
    }

    @Override
    public boolean getClientSetMustUnderstand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientSetMustUnderstand");
            Tr.exit(tc, "getClientSetMustUnderstand=" + this._clientSetMustUnderstand);
        }
        return this._clientSetMustUnderstand;
    }

    @Override
    public String getMyActor() {
        return this._myActor;
    }

    @Override
    public String getTargetActor() {
        return this._targetActor;
    }

    @Override
    public boolean doIndentation() {
        return this._indentation;
    }

    @Override
    public void setIndentation(boolean f) {
        this._indentation = f;
    }

    @Override
    public Set<String> getAllowedTransforms() {
        return this._allowedTransforms;
    }

    @Override
    public Set<String> getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    @Override
    public Set<String> getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    @Override
    public Set<String> getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    @Override
    public Set<String> getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    @Override
    public Set<String> getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    @Override
    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    @Override
    public boolean isSignatureEnabled() {
        return this._signatureEnabled;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return this._encryptionEnabled;
    }

    @Override
    public boolean isTokenEnabled() {
        return this._tokenEnabled;
    }

    @Override
    public boolean isTimestampEnabled() {
        return this._timestampEnabled;
    }

    @Override
    public List<ReferencePartConfig> getIntegralParts() {
        return this._integralParts;
    }

    @Override
    public List<ReferencePartConfig> getConfidentialParts() {
        return this._confidentialParts;
    }

    @Override
    public List<Configuration> getOperationGenerators() {
        return this._operationGenerators;
    }

    @Override
    public Set<TokenGeneratorConfig> getTokenGenerators() {
        return this._tokenGenerators;
    }

    @Override
    public TimestampGeneratorConfig getTimestampGenerator() {
        return this._timestampGenerator;
    }

    @Override
    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    @Override
    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    @Override
    public Object getProperty(Object key) {
        if (this._properties != null) {
            return this._properties.get(key);
        }
        return null;
    }

    @Override
    public boolean isNormalBodyProcessing() {
        return this._normalBodyProcessing;
    }

    @Override
    public boolean isOutboundGoldenPath() {
        return this._outboundGoldenPath;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("myActor=[").append(this._myActor).append("], ");
        buf.append("targetActor=[").append(this._targetActor).append("], ");
        buf.append("indentation=[").append(this._indentation).append("], ");
        buf.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        buf.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        buf.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        buf.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        buf.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        buf.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        buf.append("algorithmFactory=[").append(this._algorithmFactory).append("], ");
        buf.append("signatureEnabled=[").append(this._signatureEnabled).append("], ");
        buf.append("encryptionEnabled=[").append(this._encryptionEnabled).append("], ");
        buf.append("tokenEnabled=[").append(this._tokenEnabled).append("], ");
        buf.append("timestampEnabled=[").append(this._timestampEnabled).append("], ");
        buf.append("integralParts=[").append(this._integralParts).append("], ");
        buf.append("confidentialParts=[").append(this._confidentialParts).append("], ");
        buf.append("operationGenerators=[").append(this._operationGenerators).append("], ");
        buf.append("tokenGenerators=[").append(this._tokenGenerators).append("], ");
        buf.append("timestampGenerator=[").append(this._timestampGenerator).append("], ");
        buf.append("nonceManager=[").append(this._nonceManager).append("], ");
        buf.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        buf.append("properties=[").append(this._properties).append("]");
        buf.append(")");
        return buf.toString();
    }

    public static class KeyInfoContentGeneratorConfImpl
    implements KeyInfoContentGeneratorConfig {
        public String _className = null;
        public KeyInfoContentGeneratorComponent _instance = null;
        public String _keyInfoType = null;
        public String _keyName = SecurityUIDGenerator.createUID();
        public TokenGeneratorConfImpl _tokenGenerator = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public DerivedKeyInfoConfig _derivedKeyInfo = null;
        public boolean _isRequireExternalUriReference = false;

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
            if (this._keyInfoType == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s26", this.toString());
            }
        }

        @Override
        public KeyInfoContentGeneratorComponent getInstance() {
            return this._instance;
        }

        @Override
        public String getKeyInfoType() {
            return this._keyInfoType;
        }

        @Override
        public String getKeyName() {
            return this._keyName;
        }

        @Override
        public TokenGeneratorConfig getTokenGenerator() {
            return this._tokenGenerator;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public DerivedKeyInfoConfig getDerivedKeyInfoConfig() {
            return this._derivedKeyInfo;
        }

        public boolean isRequireExternalUriReference() {
            return this._isRequireExternalUriReference;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("keyInfoType=[").append(this._keyInfoType).append("], ");
            buf.append("keyName=[").append(this._keyName).append("], ");
            buf.append("tokenGenerator=[").append(this._tokenGenerator).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class KeyInfoGeneratorConfImpl
    implements KeyInfoGeneratorConfig {
        public KeyInfoContentGeneratorConfImpl _contentGenerator = null;

        @Override
        public void validate() throws SoapSecurityException {
            if (this._contentGenerator == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s07", this.toString());
            }
        }

        @Override
        public KeyInfoContentGeneratorConfig getContentGenerator() {
            return this._contentGenerator;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("contentGenerator=[").append(this._contentGenerator).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TimestampGeneratorConfImpl
    implements TimestampGeneratorConfig {
        public String _myActor = null;
        public String _targetActor = null;
        public Duration _duration = null;
        private boolean _signed = false;
        private boolean _headerAttribute = false;
        private boolean _default = true;
        private boolean _soapHeader = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
        }

        @Override
        public String getMyActor() {
            return this._myActor;
        }

        @Override
        public String getTargetActor() {
            return this._targetActor;
        }

        @Override
        public Duration getDuration() {
            return this._duration;
        }

        @Override
        public boolean toBeSigned() {
            return this._signed;
        }

        public void setToBeSigned(boolean signed) {
            this._signed = signed;
        }

        @Override
        public boolean getSOAPHeaderAttribute() {
            return this._headerAttribute;
        }

        @Override
        public boolean isSOAPHeaderElement() {
            return this._soapHeader;
        }

        @Override
        public boolean isDefault() {
            return this._default;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("myActor=[").append(this._myActor).append("], ");
            buf.append("targetActor=[").append(this._targetActor).append("], ");
            buf.append("duration=[").append(this._duration).append("], ");
            buf.append("signed=[").append(this._signed).append("], ");
            buf.append("headerAttribute=[").append(this._headerAttribute).append("], ");
            buf.append("soapHeader=[").append(this._soapHeader).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TokenGeneratorConfImpl
    implements TokenGeneratorConfig {
        public String _name = null;
        public String _className = null;
        public TokenGeneratorComponent _instance = null;
        public QName _type = null;
        public boolean _standAlone = false;
        public String _jaasConfig = null;
        public final Map<Object, Object> _jaasConfigProperties = new HashMap<Object, Object>();
        public PrivateCommonConfig.CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _usedForSignature = false;
        public boolean _usedForEncryption = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public PrivateCommonConfig.TokenAssertion _aTokenAssertion = null;
        public boolean _userDefinedComponentsUsed = false;
        private int _hash;

        public TokenGeneratorConfImpl() {
        }

        public TokenGeneratorConfImpl(TokenGeneratorConfImpl tconfig) {
            this._name = tconfig._name;
            this._className = tconfig._className;
            this._instance = tconfig._instance;
            this._type = tconfig._type;
            this._standAlone = tconfig._standAlone;
            this._jaasConfig = tconfig._jaasConfig;
            tconfig._jaasConfigProperties.putAll(this._jaasConfigProperties);
            this._callbackHandler = tconfig._callbackHandler;
            this._usedForSignature = tconfig._usedForSignature;
            this._usedForEncryption = tconfig._usedForEncryption;
            this._properties.putAll(tconfig._properties);
            this._hash = tconfig._hash;
            this._aTokenAssertion = tconfig._aTokenAssertion;
        }

        public void copyFromDefault(TokenGeneratorConfImpl tconfig) {
            this._name = tconfig._name;
            this._className = tconfig._className;
            this._instance = tconfig._instance;
            this._type = tconfig._type;
            this._jaasConfig = tconfig._jaasConfig;
            tconfig._jaasConfigProperties.putAll(this._jaasConfigProperties);
            this._callbackHandler = tconfig._callbackHandler;
            this._usedForSignature = tconfig._usedForSignature;
            this._usedForEncryption = tconfig._usedForEncryption;
            this._properties.putAll(tconfig._properties);
            this._hash = tconfig._hash;
        }

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s03", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s04", this.toString());
            }
            if (this._jaasConfig == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6834E", this.toString());
            }
            if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(this._type) || com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(this._type)) {
                PolicyConfigUtil.checkLTPATokenValid(this._type, this);
            }
        }

        public TokenGeneratorComponent getInstance() {
            return this._instance;
        }

        @Override
        public QName getType() {
            return this._type;
        }

        @Override
        public boolean isStandAlone() {
            return this._standAlone;
        }

        @Override
        public boolean isUsedForSigning() {
            return this._usedForSignature;
        }

        @Override
        public boolean isUsedForEncryption() {
            return this._usedForEncryption;
        }

        @Override
        public String getJAASConfig() {
            return this._jaasConfig;
        }

        @Override
        public Map<Object, Object> getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        @Override
        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public int hashCode() {
            if (this._hash == 0) {
                if (this._name != null) {
                    this._hash = this._name.hashCode();
                }
                if (this._className != null) {
                    this._hash = this._hash * 31 + this._className.hashCode();
                }
                if (this._type != null) {
                    this._hash = this._hash * 31 + this._type.hashCode();
                }
                this._hash = this._hash * 31 + (this._standAlone ? 1 : 0);
                if (this._jaasConfig != null) {
                    this._hash = this._hash * 31 + this._jaasConfig.hashCode();
                }
                this._hash = this._hash * 31 + ((Object)this._jaasConfigProperties).hashCode();
                if (this._callbackHandler != null) {
                    this._hash = this._hash * 31 + this._callbackHandler.hashCode();
                }
                this._hash = this._hash * 31 + ((Object)this._properties).hashCode();
            }
            return this._hash;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("type=[").append(this._type).append("], ");
            buf.append("standAlone=[").append(this._standAlone).append("], ");
            buf.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            buf.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            buf.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
            buf.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class EncryptionGeneratorConfImpl
    implements EncryptionGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoGeneratorConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public boolean _sigAfterEnc = false;
        public boolean _isKeyEncryption = false;
        public boolean _encryptsBody = false;

        public EncryptionGeneratorConfImpl() {
        }

        public EncryptionGeneratorConfImpl(EncryptionGeneratorConfImpl anEncryptionGenerator) {
            this._dataEncryptionMethod = anEncryptionGenerator._dataEncryptionMethod;
            this._keyEncryptionMethod = anEncryptionGenerator._keyEncryptionMethod;
            this._encryptionKeyInfo = anEncryptionGenerator._encryptionKeyInfo;
            this._reference = anEncryptionGenerator._reference;
            this._properties.putAll(anEncryptionGenerator._properties);
            this._sigAfterEnc = anEncryptionGenerator._sigAfterEnc;
            this._isKeyEncryption = anEncryptionGenerator._isKeyEncryption;
        }

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s02", this.toString());
            }
            if (this._reference == null && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        @Override
        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        @Override
        public KeyInfoGeneratorConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        @Override
        public ReferencePartConfig getReference() {
            return this._reference;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public boolean remainSignatureAfterEncryption() {
            return this._sigAfterEnc;
        }

        @Override
        public boolean encryptsBody() {
            return this._encryptsBody;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            buf.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            buf.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            buf.append("reference=[").append(this._reference).append("], ");
            buf.append("properties=[").append(this._properties).append("], ");
            buf.append("signatureAfterEncryption=[").append(this._sigAfterEnc).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class SignatureGeneratorConfImpl
    implements SignatureGeneratorConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoGeneratorConfImpl _signingKeyInfo = null;
        public final List<SigningReferenceConfig> _references = new ArrayList<SigningReferenceConfig>();
        public boolean _inclusiveNamespaces = true;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s01", this.toString());
            }
            if (this._references.isEmpty() && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        @Override
        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        @Override
        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        @Override
        public KeyInfoGeneratorConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        @Override
        public List<SigningReferenceConfig> getReferences() {
            return this._references;
        }

        @Override
        public boolean addInclusiveNamespaces() {
            return this._inclusiveNamespaces;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            buf.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            buf.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            buf.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            buf.append("refereces=[").append(this._references).append("], ");
            buf.append("addInclusiveNamespaces=[").append(this._inclusiveNamespaces).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }
}

