/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.confimpl;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConfigValidation;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.GetJAASConfigInfo;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public abstract class PrivateConsumerConfig
extends PrivateCommonConfig
implements WSSConsumerConfig {
    private static final TraceComponent tc = Tr.register(PrivateConsumerConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    protected String _myActor = null;
    protected boolean _ultimateReceiver = false;
    protected boolean _nonceCacheDistributed = false;
    protected final Set<String> _allowedTransforms = new HashSet<String>();
    protected final Set<String> _allowedCanonicalizationMethods = new HashSet<String>();
    protected final Set<String> _allowedSignatureMethods = new HashSet<String>();
    protected final Set<String> _allowedDigestMethods = new HashSet<String>();
    protected final Set<String> _allowedDataEncryptionMethods = new HashSet<String>();
    protected final Set<String> _allowedKeyEncryptionMethods = new HashSet<String>();
    protected final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    protected final Set<String> _defaultKeyInfoContentConsumers = new HashSet<String>();
    protected final Set<String> _defaultTokenConsumers = new HashSet<String>();
    protected final Set<String> _defaultJAASConfigs = new HashSet<String>();
    protected final Set<String> _defaultKeyLocators = new HashSet<String>();
    protected boolean _userDefinedComponentsUsed = false;
    protected boolean _verificationRequired = false;
    protected boolean _decryptionRequired = false;
    protected boolean _tokenRequired = false;
    protected boolean _loginRequired = false;
    protected boolean _timestampRequired = false;
    protected final Set<ReferencePartConfig> _requiredIntegralParts = new HashSet<ReferencePartConfig>();
    protected final Set<ReferencePartConfig> _requiredConfidentialParts = new HashSet<ReferencePartConfig>();
    protected final Set<TokenConsumerConfig> _requiredSecurityTokens = new HashSet<TokenConsumerConfig>();
    protected final List<CallerConfig> _callers = new ArrayList<CallerConfig>();
    protected final Set<SignatureConsumerConfig> _signatureConsumers = new HashSet<SignatureConsumerConfig>();
    protected final Set<EncryptionConsumerConfig> _encryptionConsumers = new HashSet<EncryptionConsumerConfig>();
    protected final Set<TokenConsumerConfig> _tokenConsumers = new HashSet<TokenConsumerConfig>();
    protected TimestampConsumerConfImpl _timestampConsumer = null;
    protected NonceManager _nonceManager = null;
    protected CertCacheManager _certManager = null;
    protected int _timestampMaxAge = -1;
    protected int _timestampClockSkew = -1;
    protected Map<Object, Object> _properties = null;
    protected final Set<String> _defaultCallbackHandlers = new HashSet<String>();
    protected boolean _symmetricBinding = false;
    protected boolean _isOrderEnforced = false;
    protected Boolean _bodyMustBeSignedAndEncrypted = null;
    protected boolean _untOptimize = false;
    protected boolean _skipOperationLevelPolicyCheck = false;
    protected boolean _bypassHeader = false;

    protected void processPrivateConfig(OMDocument privconfig) throws SoapSecurityException {
        String value;
        int i;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processPrivateConfig(");
            buf.append("OMDocument pconfig[").append(privconfig).append("])");
            Tr.entry(tc, buf.toString());
        }
        OMElement pconfig = privconfig.getOMDocumentElement();
        boolean fipsMode = false;
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            fipsMode = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            fipsMode = false;
        }
        ArrayList list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "Transform");
        int length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedTransforms.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this._allowedTransforms});
        }
        if (this._allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s11");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "canonicalizationMethod");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedCanonicalizationMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed canonicalizationMethods:", new Object[]{this._allowedCanonicalizationMethods});
        }
        if (this._allowedCanonicalizationMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s12");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsSignatureMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "signatureMethod");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedSignatureMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed signatureMethods:", new Object[]{this._allowedSignatureMethods});
        }
        if (this._allowedSignatureMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s13");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsDigestMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "digestMethod");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedDigestMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed digestMethods:", new Object[]{this._allowedDigestMethods});
        }
        if (this._allowedDigestMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s14");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsEncryptionMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "encryptionMethod");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            this._allowedDataEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed encryptionMethods:", new Object[]{this._allowedDataEncryptionMethods});
        }
        if (this._allowedDataEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s15");
        }
        list = fipsMode ? DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "fipsKeyEncryptionMethod") : DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "keyEncryptionMethod");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "algorithm");
            if (!ConfigValidation.isAlgoSupportedByRuntime(value)) continue;
            this._allowedKeyEncryptionMethods.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed keyEncryptionMethods:", new Object[]{this._allowedKeyEncryptionMethods});
        }
        if (this._allowedKeyEncryptionMethods.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s16");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "KeyInfoContentConsumer");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultKeyInfoContentConsumers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyInfoContentConsumer:", new Object[]{this._defaultKeyInfoContentConsumers});
        }
        if (this._defaultKeyInfoContentConsumers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6711W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "TokenConsumer");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultTokenConsumers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default TokenConsumer:", new Object[]{this._defaultTokenConsumers});
        }
        if (this._defaultTokenConsumers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6712W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "JAASConfig");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "name");
            this._defaultJAASConfigs.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default JAAS configuration:", new Object[]{this._defaultJAASConfigs});
        }
        if (this._defaultJAASConfigs.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6713W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "CallbackHandler");
        for (i = 0; i < list.size(); ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultCallbackHandlers.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CallbackHandler:", new Object[]{this._defaultCallbackHandlers});
        }
        if (this._defaultCallbackHandlers.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6717W");
        }
        list = DOMUtil.getElementsByTagNameNS(pconfig, "http://www.ibm.com/xml/soapsec/config", "KeyLocator");
        length = list.size();
        for (i = 0; i < length; ++i) {
            value = DOMUtils.getAttribute((OMElement)list.get(i), "class");
            this._defaultKeyLocators.add(value);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default KeyLocator:", new Object[]{this._defaultKeyLocators});
        }
        if (this._defaultKeyLocators.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.WSEC6714W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document pconfig)");
        }
    }

    @Override
    public void validate() throws SoapSecurityException {
        this.validate(false, false, null);
    }

    public void validate(boolean defaultConfig, Map<String, TokenConsumerConfig> nameToken) throws SoapSecurityException {
        this.validate(defaultConfig, false, nameToken);
    }

    public void validate(boolean defaultConfig, boolean defaultTokenConsumer, Map<String, TokenConsumerConfig> nameToken) throws SoapSecurityException {
        KeyInfoConsumerConfImpl kconfig;
        QName tokenType;
        TokenConsumerConfig tokenConsumerConf;
        KeyInfoContentConsumerConfig keyInfoContentConsumerConf;
        String keyword;
        String dialect;
        PrivateCommonConfig.ReferencePartConfImpl rconfig;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("validate(");
            buf.append("boolean defaultConfig[").append(defaultConfig).append("], ");
            buf.append("boolean defaultTokenConsumer[").append(defaultTokenConsumer).append("], ");
            buf.append("Map nameToken[").append(nameToken).append("])");
            Tr.entry(tc, buf.toString());
        }
        Iterator<Configuration> i = this._requiredIntegralParts.iterator();
        while (i.hasNext()) {
            int MessageParts2 = 0;
            int Nonce2 = 0;
            int Timestamp2 = 0;
            rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
            rconfig.validate();
            for (PrivateCommonConfig.PartConfImpl partConfImpl : rconfig._parts) {
                partConfImpl.validate();
                if (partConfImpl.isNonce()) {
                    ++Nonce2;
                } else if (partConfImpl.isTimestamp()) {
                    ++Timestamp2;
                } else {
                    ++MessageParts2;
                }
                dialect = partConfImpl._dialect;
                keyword = partConfImpl._keyword;
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
                    int index = ConfigUtil.isIntegralWASDialect(keyword);
                    if (index == 1) {
                        if (!partConfImpl.isTimestamp()) continue;
                        throw new SoapSecurityException("security.wssecurity.TimestampGenerator.s03");
                    }
                    if (index >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, partConfImpl.toString());
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
                    if (keyword != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "SignedElements");
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
                    if (partConfImpl._headerNamespace != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, partConfImpl.toString());
            }
            if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        i = this._requiredConfidentialParts.iterator();
        while (i.hasNext()) {
            int MessageParts2 = 0;
            int Nonce2 = 0;
            int Timestamp2 = 0;
            rconfig = (PrivateCommonConfig.ReferencePartConfImpl)i.next();
            rconfig.validate();
            for (PrivateCommonConfig.PartConfImpl partConfImpl : rconfig._parts) {
                partConfImpl.validate();
                if (partConfImpl.isNonce()) {
                    ++Nonce2;
                } else if (partConfImpl.isTimestamp()) {
                    ++Timestamp2;
                } else {
                    ++MessageParts2;
                }
                dialect = partConfImpl._dialect;
                keyword = partConfImpl._keyword;
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
                    if (ConfigUtil.isConfidentialWASDialect(keyword) >= 0) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", keyword, partConfImpl.toString());
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
                    if (keyword != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s04", "EncryptedElements");
                }
                if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
                    if (partConfImpl._headerNamespace != null) continue;
                    throw SoapSecurityException.format("security.wssecurity.PrivateCommonConfig.s20", this.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s05", dialect, partConfImpl.toString());
            }
            if (Nonce2 <= 0 && Timestamp2 <= 0 || MessageParts2 > 0) continue;
            throw new SoapSecurityException("security.wssecurity.PrivateConsumerConfig.s36");
        }
        for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
            String ourJaasConfig = GetJAASConfigInfo.isJaasConfigOurs(tokenConsumerConfImpl.getJAASConfig());
            if (ourJaasConfig == null) continue;
            tokenConsumerConfImpl._properties.put("com.ibm.ws.wssecurity.token.ourLoginConfig", ourJaasConfig);
        }
        boolean ourUNTConsumerConfigured = false;
        boolean ourIDAUNTConsumerConfigured = false;
        for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
            QName qName = tokenConsumerConfImpl.getType();
            if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName) || tokenConsumerConfImpl.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig") == null) continue;
            String IDAssertionIsUsed = (String)tokenConsumerConfImpl.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (ConfigUtil.isTrue(IDAssertionIsUsed)) {
                tokenConsumerConfImpl._properties.put("com.ibm.ws.wssecurity.token.isUntIdaConsumer", "true");
                ourIDAUNTConsumerConfigured = true;
                continue;
            }
            ourUNTConsumerConfigured = true;
        }
        if (ourIDAUNTConsumerConfigured && ourUNTConsumerConfigured) {
            this._untOptimize = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_untOptimize=" + this._untOptimize);
        }
        if (defaultConfig || defaultTokenConsumer) {
            HashMap<QName, TokenConsumerConfImpl> hashMap = new HashMap<QName, TokenConsumerConfImpl>();
            for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
                hashMap.put(tokenConsumerConfImpl.getType(), tokenConsumerConfImpl);
            }
            for (TokenConsumerConfImpl tokenConsumerConfImpl : this._requiredSecurityTokens) {
                QName tctype = tokenConsumerConfImpl.getType();
                TokenConsumerConfImpl tc2 = (TokenConsumerConfImpl)hashMap.get(tctype);
                if (tc2 == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC6819E", tokenConsumerConfImpl._name, tctype.toString());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found token consumer of type [" + tctype + "].");
            }
        } else {
            for (TokenConsumerConfImpl tokenConsumerConfImpl : this._requiredSecurityTokens) {
                if (this._tokenConsumers.contains(tokenConsumerConfImpl)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could NOT find token consumer [" + tokenConsumerConfImpl + "].");
                }
                throw SoapSecurityException.format("security.wssecurity.WSEC6820E", tokenConsumerConfImpl._name);
            }
        }
        for (SignatureConsumerConfImpl signatureConsumerConfImpl : this._signatureConsumers) {
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl;
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl2;
            signatureConsumerConfImpl.validate(defaultConfig);
            List<KeyInfoContentConsumerConfig> list = signatureConsumerConfImpl.getSigningKeyInfo().getContentConsumers();
            if (list != null) {
                for (int y = 0; y < list.size(); ++y) {
                    keyInfoContentConsumerConf = list.get(y);
                    if (keyInfoContentConsumerConf == null || (tokenConsumerConf = keyInfoContentConsumerConf.getTokenConsumer()) == null) continue;
                    tokenType = tokenConsumerConf.getType();
                    if (this._symmetricBinding) {
                        QName symmetricSignatureAssertionType;
                        if (this._symmetricSignatureTokenAssertion == null || tokenType == null || tokenType.equals(symmetricSignatureAssertionType = this._symmetricSignatureTokenAssertion.getTokenType())) continue;
                        Tr.error(tc, "security.wssecurity.PrivateConsumerConfig.s41", new Object[]{tokenType.toString()});
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s41", tokenType.toString());
                    }
                    if (this._request) {
                        int index = this._initiatorSignatureTokenQNames.indexOf(tokenType);
                        if (index < 0) {
                            index = this._initiatorTokenQNames.indexOf(tokenType);
                        }
                        if (index >= 0) continue;
                        Tr.error(tc, "security.wssecurity.PrivateConsumerConfig.s41", new Object[]{tokenType.toString()});
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s41", tokenType.toString());
                    }
                    int index = this._recipientSignatureTokenQNames.indexOf(tokenType);
                    if (index < 0) {
                        index = this._recipientTokenQNames.indexOf(tokenType);
                    }
                    if (index >= 0) continue;
                    Tr.error(tc, "security.wssecurity.PrivateConsumerConfig.s41", new Object[]{tokenType.toString()});
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s41", tokenType.toString());
                }
            }
            if ((algorithmConfImpl2 = signatureConsumerConfImpl._canonicalizationMethod) != null) {
                algorithmConfImpl2.validate();
                if (!this._allowedCanonicalizationMethods.contains(algorithmConfImpl2._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s08", algorithmConfImpl2._algorithm);
                }
            }
            if ((algorithmConfImpl = signatureConsumerConfImpl._signatureMethod) != null) {
                algorithmConfImpl.validate();
                if (!this._allowedSignatureMethods.contains(algorithmConfImpl._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s09", algorithmConfImpl._algorithm);
                }
            }
            for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : signatureConsumerConfImpl.getReferences()) {
                signingReferenceConfImpl.validate();
                PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl3 = signingReferenceConfImpl._digestMethod;
                if (algorithmConfImpl3 != null) {
                    algorithmConfImpl3.validate();
                    if (!this._allowedDigestMethods.contains(algorithmConfImpl3._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithmConfImpl3._algorithm);
                    }
                }
                for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl4 : signingReferenceConfImpl.getTransforms()) {
                    algorithmConfImpl4.validate();
                    if (!this._allowedTransforms.contains(algorithmConfImpl4._algorithm)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s12", algorithmConfImpl4._algorithm);
                    }
                    if ("http://www.w3.org/2002/07/decrypt#XML".equals(algorithmConfImpl4._algorithm)) {
                        signatureConsumerConfImpl._isDecryptionXformEnabled = true;
                        continue;
                    }
                    if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(algorithmConfImpl4._algorithm)) continue;
                }
            }
            kconfig = signatureConsumerConfImpl._signingKeyInfo;
            kconfig.validate();
            for (KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl : kconfig._contentConsumers) {
                keyInfoContentConsumerConfImpl.validate();
            }
            this.checkIdentity(signatureConsumerConfImpl, this._signatureConsumers);
        }
        int size = this._signatureConsumers.size();
        if (size > 1) {
            for (SignatureConsumerConfImpl signatureConsumerConfImpl : this._signatureConsumers) {
                kconfig = signatureConsumerConfImpl._signingKeyInfo;
                for (SignatureConsumerConfImpl signatureConsumerConfImpl2 : this._signatureConsumers) {
                    if (signatureConsumerConfImpl.equals(signatureConsumerConfImpl2)) continue;
                    kconfig._otherContentConsumers.addAll(signatureConsumerConfImpl2._signingKeyInfo._contentConsumers);
                }
            }
        }
        for (EncryptionConsumerConfImpl encryptionConsumerConfImpl : this._encryptionConsumers) {
            encryptionConsumerConfImpl.validate(defaultConfig);
            List<KeyInfoContentConsumerConfig> list = encryptionConsumerConfImpl.getEncryptionKeyInfo().getContentConsumers();
            if (list != null) {
                for (int y = 0; y < list.size(); ++y) {
                    keyInfoContentConsumerConf = list.get(y);
                    if (keyInfoContentConsumerConf == null || (tokenConsumerConf = keyInfoContentConsumerConf.getTokenConsumer()) == null) continue;
                    tokenType = tokenConsumerConf.getType();
                    if (this._symmetricBinding) {
                        QName symmetricEncryptionAssertionType;
                        if (this._symmetricEncryptionTokenAssertion == null || tokenType == null || tokenType.equals(symmetricEncryptionAssertionType = this._symmetricEncryptionTokenAssertion.getTokenType())) continue;
                        Tr.error(tc, "security.wssecurity.PrivateConsumerConfig.s42", new Object[]{tokenType.toString()});
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s42", tokenType.toString());
                    }
                    if (this._request) {
                        int index = this._recipientEncryptionTokenQNames.indexOf(tokenType);
                        if (index < 0) {
                            index = this._recipientTokenQNames.indexOf(tokenType);
                        }
                        if (index >= 0) continue;
                        Tr.error(tc, "security.wssecurity.PrivateConsumerConfig.s42", new Object[]{tokenType.toString()});
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s42", tokenType.toString());
                    }
                    int index = this._initiatorEncryptionTokenQNames.indexOf(tokenType);
                    if (index < 0) {
                        index = this._initiatorTokenQNames.indexOf(tokenType);
                    }
                    if (index >= 0) continue;
                    Tr.error(tc, "security.wssecurity.PrivateConsumerConfig.s42", new Object[]{tokenType.toString()});
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s42", tokenType.toString());
                }
            }
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = encryptionConsumerConfImpl._dataEncryptionMethod;
            algorithmConfImpl.validate();
            if (!this._allowedDataEncryptionMethods.contains(algorithmConfImpl._algorithm)) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s14", algorithmConfImpl._algorithm);
            }
            PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl5 = encryptionConsumerConfImpl._keyEncryptionMethod;
            if (algorithmConfImpl5 != null) {
                algorithmConfImpl5.validate();
                if (!this._allowedKeyEncryptionMethods.contains(algorithmConfImpl5._algorithm)) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s15", algorithmConfImpl5._algorithm);
                }
            }
            kconfig = encryptionConsumerConfImpl._encryptionKeyInfo;
            kconfig.validate();
            for (KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl : kconfig._contentConsumers) {
                keyInfoContentConsumerConfImpl.validate();
            }
            this.checkIdentity(encryptionConsumerConfImpl, this._encryptionConsumers);
        }
        size = this._encryptionConsumers.size();
        if (size > 1) {
            for (EncryptionConsumerConfImpl encryptionConsumerConfImpl : this._encryptionConsumers) {
                kconfig = encryptionConsumerConfImpl._encryptionKeyInfo;
                for (EncryptionConsumerConfImpl encryptionConsumerConfImpl2 : this._encryptionConsumers) {
                    if (encryptionConsumerConfImpl.equals(encryptionConsumerConfImpl2)) continue;
                    kconfig._otherContentConsumers.addAll(encryptionConsumerConfImpl2._encryptionKeyInfo._contentConsumers);
                }
            }
        }
        for (TokenConsumerConfImpl tokenConsumerConfImpl : this._tokenConsumers) {
            tokenConsumerConfImpl.validate();
            PrivateCommonConfig.CallbackHandlerConfImpl cconfig = tokenConsumerConfImpl._callbackHandler;
            if (cconfig != null) {
                PrivateCommonConfig.KeyInformationConfImpl kiconfig;
                cconfig.validate();
                PrivateCommonConfig.KeyStoreConfImpl ksconfig = cconfig._keyStore;
                if (ksconfig != null) {
                    ksconfig.validate();
                }
                if ((kiconfig = cconfig._keyInformation) != null) {
                    kiconfig.validate();
                }
                if ((ksconfig = cconfig._trustAnchor) != null) {
                    ksconfig.validate();
                }
            }
            if (!this._requiredSecurityTokens.contains(tokenConsumerConfImpl)) continue;
            if (tokenConsumerConfImpl._usedForVerification) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6821E", tokenConsumerConfImpl._name);
            }
            if (!tokenConsumerConfImpl._usedForDecryption) continue;
            throw SoapSecurityException.format("security.wssecurity.WSEC6822E", tokenConsumerConfImpl._name);
        }
        if (this._timestampConsumer != null) {
            int index;
            String string;
            this._timestampConsumer.validate();
            String string2 = (String)this._timestampConsumer._properties.get(Constants.WSSECURITY_TIMESTAMP_DIALECT);
            if (string2 != null && com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string2) && (string = (String)this._timestampConsumer._properties.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD)) != null && (index = ConfigUtil.isTimestampWASDialect(string)) < 0) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s03", string, this._timestampConsumer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(boolean, Map)");
        }
    }

    @Override
    public String getMyActor() {
        return this._myActor;
    }

    @Override
    public boolean isUltimateReceiver() {
        return this._ultimateReceiver;
    }

    @Override
    public boolean isNonceCacheDistributed() {
        return this._nonceCacheDistributed;
    }

    @Override
    public Set<String> getAllowedTransforms() {
        return this._allowedTransforms;
    }

    @Override
    public Set<String> getAllowedCanonicalizationMethods() {
        return this._allowedCanonicalizationMethods;
    }

    @Override
    public Set<String> getAllowedSignatureMethods() {
        return this._allowedSignatureMethods;
    }

    @Override
    public Set<String> getAllowedDigestMethods() {
        return this._allowedDigestMethods;
    }

    @Override
    public Set<String> getAllowedDataEncryptionMethods() {
        return this._allowedDataEncryptionMethods;
    }

    @Override
    public Set<String> getAllowedKeyEncryptionMethods() {
        return this._allowedKeyEncryptionMethods;
    }

    @Override
    public WSSAlgorithmFactory getAlgorithmFactory() {
        return this._algorithmFactory;
    }

    @Override
    public boolean isVerificationRequired() {
        return this._verificationRequired;
    }

    @Override
    public boolean isDecryptionRequired() {
        return this._decryptionRequired;
    }

    @Override
    public boolean isTokenRequired() {
        return this._tokenRequired;
    }

    @Override
    public boolean isLoginRequired() {
        return this._loginRequired;
    }

    @Override
    public boolean isTimestampRequired() {
        return this._timestampRequired;
    }

    @Override
    public Set<ReferencePartConfig> getRequiredIntegralParts() {
        return this._requiredIntegralParts;
    }

    @Override
    public Set<ReferencePartConfig> getRequiredConfidentialParts() {
        return this._requiredConfidentialParts;
    }

    @Override
    public Set<TokenConsumerConfig> getRequiredSecurityTokens() {
        return this._requiredSecurityTokens;
    }

    @Override
    public List<CallerConfig> getCallers() {
        return this._callers;
    }

    @Override
    public Set<SignatureConsumerConfig> getSignatureConsumers() {
        return this._signatureConsumers;
    }

    @Override
    public Set<EncryptionConsumerConfig> getEncryptionConsumers() {
        return this._encryptionConsumers;
    }

    @Override
    public Set<TokenConsumerConfig> getTokenConsumers() {
        return this._tokenConsumers;
    }

    @Override
    public TimestampConsumerConfig getTimestampConsumer() {
        return this._timestampConsumer;
    }

    @Override
    public NonceManager getNonceManager() {
        return this._nonceManager;
    }

    @Override
    public CertCacheManager getCertManager() {
        return this._certManager;
    }

    @Override
    public int getTimestampMaxAge() {
        return this._timestampMaxAge;
    }

    @Override
    public int getTimestampClockSkew() {
        return this._timestampClockSkew;
    }

    @Override
    public boolean isUserDefinedComponentsUsed() {
        return this._userDefinedComponentsUsed;
    }

    @Override
    public boolean getUntOptimize() {
        return this._untOptimize;
    }

    @Override
    public boolean getSkipOperationLevelPolicyCheck() {
        return this._skipOperationLevelPolicyCheck;
    }

    @Override
    public boolean getBypassSecurityHeaderSetting() {
        return this._bypassHeader;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    @Override
    public boolean isCallerOrderEnforced() {
        return this._isOrderEnforced;
    }

    @Override
    public boolean bodyMustBeSignedAndEncrypted() {
        if (this._bodyMustBeSignedAndEncrypted != null) {
            return Boolean.TRUE.equals(this._bodyMustBeSignedAndEncrypted);
        }
        boolean bodycontentMustBeEncrypted = false;
        boolean bodyMustBeSigned = false;
        block0: for (ReferencePartConfig referencePartConfig : this.getRequiredConfidentialParts()) {
            for (ReferencePartConfig.PartConfig partConfig : referencePartConfig.getParts()) {
                if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfig.getDialect()) || !ConfidentialDialectElementSelector.WASDIALECTS[0].equals(partConfig.getKeyword())) continue;
                bodycontentMustBeEncrypted = true;
                break block0;
            }
        }
        block2: for (ReferencePartConfig referencePartConfig : this.getRequiredIntegralParts()) {
            for (ReferencePartConfig.PartConfig partConfig : referencePartConfig.getParts()) {
                if (!com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfig.getDialect()) || !IntegralDialectElementSelector.WASDIALECTS[0].equals(partConfig.getKeyword())) continue;
                bodyMustBeSigned = true;
                break block2;
            }
        }
        if (bodycontentMustBeEncrypted && bodyMustBeSigned) {
            this._bodyMustBeSignedAndEncrypted = Boolean.TRUE;
            return true;
        }
        this._bodyMustBeSignedAndEncrypted = Boolean.FALSE;
        return false;
    }

    @Override
    public Object getProperty(Object key) {
        if (this._properties != null) {
            return this._properties.get(key);
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
        buf.append("myActor=[").append(this._myActor).append("], ");
        buf.append("ultimateReceiver=[").append(this._ultimateReceiver).append("], ");
        buf.append("nonceCacheDistributed=[").append(this._nonceCacheDistributed).append("], ");
        buf.append("allowedTransforms=[").append(this._allowedTransforms).append("], ");
        buf.append("allowedCanonicalizations=[").append(this._allowedCanonicalizationMethods).append("], ");
        buf.append("allowedSignatures=[").append(this._allowedSignatureMethods).append("], ");
        buf.append("allowedDigests=[").append(this._allowedDigestMethods).append("], ");
        buf.append("allowedDataEncryptions=[").append(this._allowedDataEncryptionMethods).append("], ");
        buf.append("allowedKeyEncryptions=[").append(this._allowedKeyEncryptionMethods).append("], ");
        buf.append("algorithmFactory=[").append(this._algorithmFactory).append("], ");
        buf.append("verificationRequired=[").append(this._verificationRequired).append("], ");
        buf.append("decryptionRequired=[").append(this._decryptionRequired).append("], ");
        buf.append("tokenRequired=[").append(this._tokenRequired).append("], ");
        buf.append("timestampRequired=[").append(this._timestampRequired).append("], ");
        buf.append("requiredIntegralParts=[").append(this._requiredIntegralParts).append("], ");
        buf.append("requiredConfidentialParts=[").append(this._requiredConfidentialParts).append("], ");
        buf.append("callers=[").append(this._callers).append("], ");
        buf.append("signatureConsumers=[").append(this._signatureConsumers).append("], ");
        buf.append("encryptionConsumers=[").append(this._encryptionConsumers).append("], ");
        buf.append("tokenConsumers=[").append(this._tokenConsumers).append("], ");
        buf.append("timestampConsumer=[").append(this._timestampConsumer).append("], ");
        buf.append("nonceManager=[").append(this._nonceManager).append("], ");
        buf.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
        buf.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
        buf.append("userDefinedComponentsUsed=[").append(this._userDefinedComponentsUsed).append("], ");
        buf.append("properties=[").append(this._properties).append("]");
        buf.append(")");
        return buf.toString();
    }

    private void checkIdentity(SignatureConsumerConfImpl sconfig, Set<SignatureConsumerConfig> signatureConsumers) {
        if (signatureConsumers.size() > 1) {
            String c14nMethod = sconfig._canonicalizationMethod._algorithm;
            String signMethod = sconfig._signatureMethod._algorithm;
            List<SigningReferenceConfig> references = sconfig._references;
            for (SignatureConsumerConfImpl signatureConsumerConfImpl : signatureConsumers) {
                if (signatureConsumerConfImpl.equals(sconfig) || !c14nMethod.equals(signatureConsumerConfImpl._canonicalizationMethod._algorithm) || !signMethod.equals(signatureConsumerConfImpl._signatureMethod._algorithm)) continue;
                for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : references) {
                    List<VerifiedConfig> vlist = sconfig._identity.get(signingReferenceConfImpl);
                    if (vlist == null) {
                        vlist = new ArrayList<VerifiedConfig>();
                        sconfig._identity.put(signingReferenceConfImpl, vlist);
                    }
                    String digestMethod = signingReferenceConfImpl._digestMethod._algorithm;
                    HashSet<String> transforms = new HashSet<String>();
                    for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl : signingReferenceConfImpl._transforms) {
                        transforms.add(algorithmConfImpl._algorithm);
                    }
                    for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl2 : signatureConsumerConfImpl._references) {
                        if (!digestMethod.equals(signingReferenceConfImpl2._digestMethod._algorithm)) continue;
                        boolean sameTransform = true;
                        for (PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl : signingReferenceConfImpl2._transforms) {
                            if (transforms.contains(algorithmConfImpl._algorithm)) continue;
                            sameTransform = false;
                            break;
                        }
                        if (!sameTransform) continue;
                        vlist.add(new VerifiedConfig(signatureConsumerConfImpl, signingReferenceConfImpl2));
                    }
                }
            }
        }
    }

    private void checkIdentity(EncryptionConsumerConfImpl econfig, Set<EncryptionConsumerConfig> encryptionConsumers) {
        if (encryptionConsumers.size() > 1) {
            String dataEncMethod = econfig._dataEncryptionMethod._algorithm;
            String keyEncMethod = econfig._keyEncryptionMethod == null ? null : econfig._keyEncryptionMethod._algorithm;
            for (EncryptionConsumerConfImpl encryptionConsumerConfImpl : encryptionConsumers) {
                if (encryptionConsumerConfImpl.equals(econfig) || !dataEncMethod.equals(encryptionConsumerConfImpl._dataEncryptionMethod._algorithm)) continue;
                PrivateCommonConfig.AlgorithmConfImpl aconfig = encryptionConsumerConfImpl._keyEncryptionMethod;
                if (keyEncMethod == null ? aconfig != null : aconfig == null || !keyEncMethod.equals(aconfig._algorithm)) continue;
                econfig._identity.add(encryptionConsumerConfImpl);
            }
        }
    }

    public void setOrderedCallerList() {
        ArrayList<CallerConfig> orderedCallerList = new ArrayList<CallerConfig>();
        for (CallerConfig aCallerConfig : this._callers) {
            int index = 0;
            boolean foundIndex = false;
            for (int j = 0; j < orderedCallerList.size() && !foundIndex; ++j) {
                int callerConfigOrder;
                CallerConfig orderedConfig = (CallerConfig)orderedCallerList.get(j);
                int orderedConfigOrder = orderedConfig.getOrder();
                if (orderedConfigOrder > (callerConfigOrder = aCallerConfig.getOrder())) {
                    foundIndex = true;
                    continue;
                }
                ++index;
            }
            orderedCallerList.add(index, aCallerConfig);
        }
        this._callers.clear();
        this._callers.addAll(orderedCallerList);
    }

    public static class KeyInfoContentConsumerConfImpl
    implements KeyInfoContentConsumerConfig {
        public String _className = null;
        public KeyInfoContentConsumerComponent _instance = null;
        public String _keyName = SecurityUIDGenerator.createUID();
        public TokenConsumerConfImpl _tokenConsumer = null;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public DerivedKeyInfoConfig _derivedKeyInfo = null;
        public boolean _isRequireExternalUriReference = false;

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s25", this.toString());
            }
        }

        @Override
        public KeyInfoContentConsumerComponent getInstance() {
            return this._instance;
        }

        @Override
        public String getKeyName() {
            return this._keyName;
        }

        @Override
        public TokenConsumerConfig getTokenConsumer() {
            return this._tokenConsumer;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public DerivedKeyInfoConfig getDerivedKeyInfoConfig() {
            return this._derivedKeyInfo;
        }

        public boolean isRequireExternalUriReference() {
            return this._isRequireExternalUriReference;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("tokenConsumer=[").append(this._tokenConsumer).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class KeyInfoConsumerConfImpl
    implements KeyInfoConsumerConfig {
        public List<KeyInfoContentConsumerConfig> _contentConsumers = null;
        public final List<KeyInfoContentConsumerConfig> _otherContentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();

        @Override
        public void validate() throws SoapSecurityException {
            if (this._contentConsumers == null || this._contentConsumers.isEmpty()) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s24", this.toString());
            }
        }

        @Override
        public List<KeyInfoContentConsumerConfig> getContentConsumers() {
            return this._contentConsumers;
        }

        @Override
        public List<KeyInfoContentConsumerConfig> getOtherContentConsumers() {
            return this._otherContentConsumers;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("contentConsumers=[").append(this._contentConsumers).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TimestampConsumerConfImpl
    implements TimestampConsumerConfig {
        public String _actor = null;
        public int _timestampMaxAge = 300;
        public int _timestampClockSkew = 180;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();

        @Override
        public void validate() throws SoapSecurityException {
        }

        @Override
        public String getActor() {
            return this._actor;
        }

        @Override
        public int getTimestampMaxAge() {
            return this._timestampMaxAge;
        }

        @Override
        public int getTimestampClockSkew() {
            return this._timestampClockSkew;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("actor=[").append(this._actor).append("], ");
            buf.append("timestampMaxAge=[").append(this._timestampMaxAge).append("], ");
            buf.append("timestampClockSkew=[").append(this._timestampClockSkew).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class TokenConsumerConfImpl
    implements TokenConsumerConfig {
        public String _name = null;
        public String _className = null;
        public TokenConsumerComponent _instance = null;
        public QName _type = null;
        public String _jaasConfig = null;
        public final Map<Object, Object> _jaasConfigProperties = new HashMap<Object, Object>();
        public PrivateCommonConfig.CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _usedForVerification = false;
        public boolean _usedForDecryption = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public PrivateCommonConfig.TokenAssertion _aTokenAssertion = null;
        private int _hash;
        public boolean _enforceTokenVersion = false;

        public TokenConsumerConfImpl() {
        }

        public TokenConsumerConfImpl(TokenConsumerConfImpl tconfig) {
            this._name = tconfig._name;
            this._className = tconfig._className;
            this._instance = tconfig._instance;
            this._type = tconfig._type;
            this._jaasConfig = tconfig._jaasConfig;
            tconfig._jaasConfigProperties.putAll(this._jaasConfigProperties);
            this._callbackHandler = tconfig._callbackHandler;
            this._usedForVerification = tconfig._usedForVerification;
            this._usedForDecryption = tconfig._usedForDecryption;
            this._properties.putAll(tconfig._properties);
            this._hash = tconfig._hash;
            this._enforceTokenVersion = tconfig._enforceTokenVersion;
        }

        @Override
        public void validate() throws SoapSecurityException {
            if (this._instance == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s22", this.toString());
            }
            if (this._type == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s23", this.toString());
            }
            if (this._jaasConfig == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6834E", this.toString());
            }
        }

        public TokenConsumerComponent getInstance() {
            return this._instance;
        }

        @Override
        public QName getType() {
            return this._type;
        }

        @Override
        public String getJAASConfig() {
            return this._jaasConfig;
        }

        @Override
        public Map<Object, Object> getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        @Override
        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        @Override
        public boolean isUsedForVerification() {
            return this._usedForVerification;
        }

        @Override
        public boolean isUsedForDecryption() {
            return this._usedForDecryption;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        public int hashCode() {
            if (this._hash == 0) {
                if (this._name != null) {
                    this._hash = this._name.hashCode();
                }
                if (this._className != null) {
                    this._hash = this._hash * 31 + this._className.hashCode();
                }
                if (this._type != null) {
                    this._hash = this._hash * 31 + this._type.hashCode();
                }
                if (this._jaasConfig != null) {
                    this._hash = this._hash * 31 + this._jaasConfig.hashCode();
                }
                this._hash = this._hash * 31 + ((Object)this._jaasConfigProperties).hashCode();
                if (this._callbackHandler != null) {
                    this._hash = this._hash * 31 + this._callbackHandler.hashCode();
                }
                this._hash = this._hash * 31 + (this._usedForVerification ? 1 : 0);
                this._hash = this._hash * 31 + (this._usedForDecryption ? 1 : 0);
                this._hash = this._hash * 31 + ((Object)this._properties).hashCode();
            }
            return this._hash;
        }

        @Override
        public boolean isEnforceTokenVersion() {
            return this._enforceTokenVersion;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("className=[").append(this._className).append("], ");
            buf.append("type=[").append(this._type).append("], ");
            buf.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            buf.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            buf.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            buf.append("usedForVerification=[").append(this._usedForVerification).append("], ");
            buf.append("usedForDecryption=[").append(this._usedForDecryption).append("], ");
            buf.append("enforceTokenVersion=[").append(this._enforceTokenVersion).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class EncryptionConsumerConfImpl
    implements EncryptionConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _dataEncryptionMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyEncryptionMethod = null;
        public KeyInfoConsumerConfImpl _encryptionKeyInfo = null;
        public PrivateCommonConfig.ReferencePartConfImpl _reference = null;
        public boolean _isKeyDecryption = false;
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public final List<EncryptionConsumerConfig> _identity = new ArrayList<EncryptionConsumerConfig>();

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._dataEncryptionMethod == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s19", this.toString());
            }
            if (this._encryptionKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s20", this.toString());
            }
            if (this._reference == null && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getDataEncryptionMethod() {
            return this._dataEncryptionMethod;
        }

        @Override
        public AlgorithmConfig getKeyEncryptionMethod() {
            return this._keyEncryptionMethod;
        }

        @Override
        public KeyInfoConsumerConfig getEncryptionKeyInfo() {
            return this._encryptionKeyInfo;
        }

        @Override
        public ReferencePartConfig getReference() {
            return this._reference;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public List<EncryptionConsumerConfig> getIdentityList() {
            return this._identity;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("dataEncryptionMethod=[").append(this._dataEncryptionMethod).append("], ");
            buf.append("keyEncryptionMethod=[").append(this._keyEncryptionMethod).append("], ");
            buf.append("encryptionKeyInfo=[").append(this._encryptionKeyInfo).append("], ");
            buf.append("reference=[").append(this._reference).append("], ");
            buf.append("properties=[").append(this._properties).append("]");
            buf.append(")");
            return buf.toString();
        }
    }

    public static class SignatureConsumerConfImpl
    implements SignatureConsumerConfig {
        public PrivateCommonConfig.AlgorithmConfImpl _canonicalizationMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _signatureMethod = null;
        public PrivateCommonConfig.AlgorithmConfImpl _keyInfoSignature = null;
        public KeyInfoConsumerConfImpl _signingKeyInfo = null;
        public final List<SigningReferenceConfig> _references = new ArrayList<SigningReferenceConfig>();
        public final Map<Object, Object> _properties = new HashMap<Object, Object>();
        public final Map<SigningReferenceConfig, List<VerifiedConfig>> _identity = new HashMap<SigningReferenceConfig, List<VerifiedConfig>>();
        private boolean _isDecryptionXformEnabled = false;

        @Override
        public void validate() throws SoapSecurityException {
            this.validate(false);
        }

        public void validate(boolean defaultConfig) throws SoapSecurityException {
            if (this._signingKeyInfo == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s17", this.toString());
            }
            if (this._references.isEmpty() && !defaultConfig) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s18", this.toString());
            }
        }

        @Override
        public AlgorithmConfig getCanonicalizationMethod() {
            return this._canonicalizationMethod;
        }

        @Override
        public AlgorithmConfig getSignatureMethod() {
            return this._signatureMethod;
        }

        @Override
        public AlgorithmConfig getKeyInfoSignature() {
            return this._keyInfoSignature;
        }

        @Override
        public KeyInfoConsumerConfig getSigningKeyInfo() {
            return this._signingKeyInfo;
        }

        @Override
        public List<SigningReferenceConfig> getReferences() {
            return this._references;
        }

        @Override
        public Map<Object, Object> getProperties() {
            return this._properties;
        }

        @Override
        public Map<SigningReferenceConfig, List<VerifiedConfig>> getIdentityMap() {
            return this._identity;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("canonicalizationMethod=[").append(this._canonicalizationMethod).append("], ");
            buf.append("signatureMethod=[").append(this._signatureMethod).append("], ");
            buf.append("keyInfoSignature=[").append(this._keyInfoSignature).append("], ");
            buf.append("signingKeyInfo=[").append(this._signingKeyInfo).append("], ");
            buf.append("refereces=[").append(this._references).append("], ");
            buf.append("properties=[").append(this._properties).append("], ");
            buf.append("isDecryptionXformEnabled=[").append(this._isDecryptionXformEnabled).append("], ");
            buf.append(")");
            return buf.toString();
        }

        @Override
        public boolean isDecryptionTransformEnabled() {
            return this._isDecryptionXformEnabled;
        }
    }

    public static class CallerConfImpl
    implements CallerConfig {
        public String _jaasConfig = null;
        public final Map<Object, Object> _jaasConfigProperties = new HashMap<Object, Object>();
        public PrivateCommonConfig.CallbackHandlerConfImpl _callbackHandler = null;
        public boolean _identityAssertion = false;
        public boolean _anyTrustedIdentity = false;
        public QName _callerIdentity = null;
        public QName _trustedIdentity = null;
        public PrivateCommonConfig.ReferencePartConfImpl _requiredSigningPartReference = null;
        public int _order = 0;

        @Override
        public void validate() throws SoapSecurityException {
            if (this._jaasConfig == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC6834E", this.toString());
            }
            if (this._callerIdentity == null) {
                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s16", this.toString());
            }
        }

        @Override
        public String getJAASConfig() {
            return this._jaasConfig;
        }

        @Override
        public Map<Object, Object> getJAASConfigProperties() {
            return this._jaasConfigProperties;
        }

        @Override
        public CallbackHandlerConfig getCallbackHandler() {
            return this._callbackHandler;
        }

        @Override
        public boolean useIdentityAssertion() {
            return this._identityAssertion;
        }

        @Override
        public boolean trustAnyTrustedIdentity() {
            return this._anyTrustedIdentity;
        }

        @Override
        public QName getCallerIdentity() {
            return this._callerIdentity;
        }

        @Override
        public QName getTrustedIdentity() {
            return this._trustedIdentity;
        }

        @Override
        public ReferencePartConfig getRequiredSigningPartReference() {
            return this._requiredSigningPartReference;
        }

        @Override
        public int getOrder() {
            return this._order;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("jaasConfig=[").append(this._jaasConfig).append("], ");
            buf.append("jaasConfigProperties=[").append(this._jaasConfigProperties).append("], ");
            buf.append("callbackHandler=[").append(this._callbackHandler).append("], ");
            buf.append("useIdentityAssertion=[").append(this._identityAssertion).append("], ");
            buf.append("trustAnyTrustedIdentity=[").append(this._anyTrustedIdentity).append("], ");
            buf.append("callerIdentity=[").append(this._callerIdentity).append("], ");
            buf.append("trustedIdentity=[").append(this._trustedIdentity).append("], ");
            buf.append("requiredSigningPartReference=[").append(this._requiredSigningPartReference).append("], ");
            buf.append("order=[").append(this._order).append("]");
            buf.append(")");
            return buf.toString();
        }
    }
}

