/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.config;

import com.ibm.ws.wssecurity.config.KRBConfigException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class KRBConfig {
    private static final short STR_LENGTH = 200;
    private static final String kerbModuleLabel = "Kerberos LoginModule";
    private boolean enableCredDelegate;
    private Oid gssNameType;
    private int gssCredType;
    private int gssCredDuration;
    private String realm;
    private String serviceName;
    private static TraceComponent tc = Tr.register(KRBConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public KRBConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBConfig()");
        }
        this.enableCredDelegate = false;
        this.gssNameType = GSSName.NT_USER_NAME;
        this.gssCredType = 2;
        this.gssCredDuration = Integer.MAX_VALUE;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBConfig()");
        }
    }

    public int getGssCredDuration() {
        return this.gssCredDuration;
    }

    public int getGssCredType() {
        return this.gssCredType;
    }

    public Oid getGssNameType() {
        return this.gssNameType;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isEnableCredDelegate() {
        return this.enableCredDelegate;
    }

    public void setEnableCredDelegate(String b) {
        this.enableCredDelegate = Boolean.valueOf(b);
    }

    public void setGssCredDuration(String string) {
        this.gssCredDuration = string.trim().equalsIgnoreCase("DEFAULT") ? 0 : Integer.MAX_VALUE;
    }

    public void setGssCredType(String string) {
        this.gssCredType = (string = string.trim()).equalsIgnoreCase("INITIATE") ? 1 : (string.equalsIgnoreCase("BOTH") ? 0 : 2);
    }

    public void setGssNameType(String string) {
        this.gssNameType = string.trim().equalsIgnoreCase("NT_HOSTBASED_SERVICE") ? GSSName.NT_HOSTBASED_SERVICE : GSSName.NT_USER_NAME;
    }

    public void setRealm(String string) throws KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRealm " + string);
        }
        if (string == null) {
            throw new KRBConfigException("kerberos.property.notset");
        }
        this.realm = string.toUpperCase().trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRealm exit");
        }
    }

    public void setServiceName(String string) throws KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceName " + string);
        }
        if (string == null) {
            throw new KRBConfigException("kerberos.property.notset");
        }
        StringBuffer result = new StringBuffer();
        result.append(string);
        result.append("@");
        result.append(this.realm);
        this.serviceName = result.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serviceName = " + this.serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceName exit");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("\t[KRBConfig: serviceName=").append(this.getServiceName());
        sb.append("\trealm=").append(this.getRealm());
        sb.append("]\n");
        return sb.toString();
    }
}

