/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.common;

import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.common.Result;
import java.util.Map;
import java.util.Vector;

public class ResultPool {
    private static Result[] emptyResults = new Result[0];

    public static Result[] get(Map context, Class c) {
        Object obj;
        int i;
        int count = 0;
        Vector pool = (Vector)context.get(ResultPool.class);
        if (pool == null) {
            return emptyResults;
        }
        for (i = 0; i < pool.size(); ++i) {
            obj = pool.elementAt(i);
            if (!RequestPool.matchClass(obj.getClass(), c)) continue;
            ++count;
        }
        Result[] ret = new Result[count];
        count = 0;
        for (i = 0; i < pool.size(); ++i) {
            obj = pool.elementAt(i);
            if (!RequestPool.matchClass(obj.getClass(), c)) continue;
            ret[count++] = (Result)obj;
        }
        return ret;
    }

    public static void remove(Map context, Result res) {
        Vector pool = (Vector)context.get(ResultPool.class);
        if (pool == null) {
            return;
        }
        pool.removeElement(res);
    }

    public static void remove(Map context, Result[] ress) {
        for (int i = 0; i < ress.length; ++i) {
            ResultPool.remove(context, ress[i]);
        }
    }

    public static void removeAll(Map context) {
        Vector pool = (Vector)context.get(RequestPool.class);
        if (pool == null) {
            return;
        }
        pool.removeAllElements();
    }

    public static void add(Map<Object, Object> context, Result res) {
        Vector<Result> pool = (Vector<Result>)context.get(ResultPool.class);
        if (pool == null) {
            pool = new Vector<Result>();
            context.put(ResultPool.class, pool);
        }
        pool.addElement(res);
    }

    public static void initialize(Map context) {
        ResultPool.removeAll(context);
    }

    public static void finalize(Map context) {
        ResultPool.removeAll(context);
        context.remove(ResultPool.class);
    }
}

