/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.common;

import com.ibm.ws.wssecurity.common.Request;
import java.util.Map;
import java.util.Vector;

public class RequestPool {
    private static Request[] emptyRequests = new Request[0];

    public static Request[] get(Map context, Class c) {
        Object obj;
        int i;
        int count = 0;
        Vector pool = (Vector)context.get(RequestPool.class);
        if (pool == null) {
            return emptyRequests;
        }
        for (i = 0; i < pool.size(); ++i) {
            obj = pool.elementAt(i);
            if (!RequestPool.matchClass(obj.getClass(), c)) continue;
            ++count;
        }
        Request[] ret = new Request[count];
        count = 0;
        for (i = 0; i < pool.size(); ++i) {
            obj = pool.elementAt(i);
            if (!RequestPool.matchClass(obj.getClass(), c)) continue;
            ret[count++] = (Request)obj;
        }
        return ret;
    }

    protected static boolean matchClass(Class cl, Class c) {
        if (cl.equals(c)) {
            return true;
        }
        Class superclass = cl.getSuperclass();
        if (superclass != null && RequestPool.matchClass(superclass, c)) {
            return true;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!RequestPool.matchClass(interfaces[i], c)) continue;
            return true;
        }
        return false;
    }

    public static void remove(Map context, Request req) {
        Vector pool = (Vector)context.get(RequestPool.class);
        if (pool == null) {
            return;
        }
        pool.removeElement(req);
    }

    public static void remove(Map context, Request[] reqs) {
        for (int i = 0; i < reqs.length; ++i) {
            RequestPool.remove(context, reqs[i]);
        }
    }

    public static void removeAll(Map context) {
        Vector pool = (Vector)context.get(RequestPool.class);
        if (pool == null) {
            return;
        }
        pool.removeAllElements();
    }

    public static void add(Map<Object, Object> context, Request req) {
        Vector<Request> pool = (Vector<Request>)context.get(RequestPool.class);
        if (pool == null) {
            pool = new Vector<Request>();
            context.put(RequestPool.class, pool);
        }
        pool.addElement(req);
    }

    public static void initialize(Map context) {
        RequestPool.removeAll(context);
    }

    public static void finalize(Map context) {
        RequestPool.removeAll(context);
        context.remove(RequestPool.class);
    }
}

