/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.result;

import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class STSTrustAuthenticationRule
implements Serializable {
    private static final long serialVersionUID = 3114328468867164184L;
    private String requiredTokenType;
    private String jaasConfigName;
    private String callbackHandler;
    private Properties[] identities;

    public STSTrustAuthenticationRule(TokenTypeRule ttRule) {
        this.requiredTokenType = ttRule.getRequiredTokenTypeURI();
        this.jaasConfigName = ttRule.getJAASConfigName();
        this.callbackHandler = ttRule.getCallbackHandler();
        IdentityList idList = ttRule.getIdentityList();
        if (idList == null) {
            this.identities = new Properties[0];
        } else {
            List<Identity> idsList = idList.getIdentity();
            this.identities = new Properties[idsList.size()];
            Iterator<Identity> idsIter = idsList.iterator();
            int index = -1;
            while (idsIter.hasNext()) {
                Identity currentID = idsIter.next();
                Properties newID = new Properties();
                List<IdentityPart> idParts = currentID.getIdentityPart();
                for (IdentityPart currentPart : idParts) {
                    newID.setProperty(currentPart.getName(), currentPart.getValue());
                }
                this.identities[++index] = newID;
            }
        }
    }

    public String getRequiredTokenType() {
        return this.requiredTokenType;
    }

    public String getJAASConfigName() {
        return this.jaasConfigName;
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public Properties[] getIdentities() {
        return this.identities;
    }

    public String toString() {
        String result = "";
        result = result + "RequiredTokenTypeURI: " + this.requiredTokenType + "\n";
        result = result + "JAASConfigName: " + this.jaasConfigName + "\n";
        result = result + "CallbackHandler: " + this.callbackHandler + "\n";
        result = result + "IdentityList:\n";
        for (Properties id : this.identities) {
            result = result + "  " + id + "\n";
        }
        return result;
    }
}

