/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.result;

import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSPropertyList
implements Serializable {
    private static final long serialVersionUID = 30154395942243869L;
    private String[] propertyStrings;

    public STSPropertyList(STSProperty[] props) {
        this.propertyStrings = new String[props.length];
        int propStringIndex = -1;
        for (STSProperty current : props) {
            String currentType = current.getType();
            this.propertyStrings[++propStringIndex] = "{" + current.getName() + " " + current.getValue() + (currentType != null ? " " + currentType : "") + "}";
        }
    }

    public STSPropertyList(List<STSProperty> propList) {
        this(propList.toArray(new STSProperty[propList.size()]));
    }

    public String toString() {
        String result = "";
        for (String propertyString : this.propertyStrings) {
            result = result + "\n" + propertyString;
        }
        return result.trim();
    }

    public String[] getPropertyStrings() {
        String[] copy = new String[this.propertyStrings.length];
        System.arraycopy(this.propertyStrings, 0, copy, 0, copy.length);
        return copy;
    }
}

