/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.result;

import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class STSConfigGroupNameTree
implements Serializable {
    private static final long serialVersionUID = -5056121561331859865L;
    private STSConfigGroupNameTree[] children;
    private String name;
    private String padding;
    private static final String INITIAL_PADDING = "";
    private static final String ADDITIONAL_PADDING = "  ";

    public STSConfigGroupNameTree(STSConfigGroup root) {
        this(root, INITIAL_PADDING);
    }

    public String toString() {
        String accumulator = this.padding + this.name;
        for (STSConfigGroupNameTree child : this.children) {
            accumulator = accumulator + "\n" + child.toString();
        }
        return accumulator;
    }

    public String getName() {
        return this.name;
    }

    public STSConfigGroupNameTree[] getChildren() {
        STSConfigGroupNameTree[] copy = new STSConfigGroupNameTree[this.children.length];
        System.arraycopy(this.children, 0, copy, 0, copy.length);
        return copy;
    }

    private STSConfigGroupNameTree(STSConfigGroup root, String padding) {
        this.padding = padding;
        this.name = root.getName();
        List<STSConfigGroup> configGroups = root.getSTSConfigGroup();
        this.children = new STSConfigGroupNameTree[configGroups.size()];
        Iterator<STSConfigGroup> iter = configGroups.iterator();
        String newPadding = padding + ADDITIONAL_PADDING;
        int loopVar = -1;
        while (iter.hasNext()) {
            this.children[++loopVar] = new STSConfigGroupNameTree(iter.next(), newPadding);
        }
    }
}

