/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands.properties;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ListSTSProperties
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(ListSTSProperties.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSProperties(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListSTSProperties(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSConfigGroup propertiesConfigGroup = ListSTSProperties.getConfiguration(configGroup, new String[]{"TrustServiceProperties"});
        List<STSProperty> propertyList = propertiesConfigGroup.getSTSProperty();
        Iterator<STSProperty> iter = propertyList.iterator();
        Properties props = new Properties();
        while (iter.hasNext()) {
            STSProperty current = iter.next();
            String currentName = current.getName();
            String currentValue = current.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  Found property: " + currentName + " = " + currentValue);
            }
            props.setProperty(currentName, currentValue);
        }
        this.setResult(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

