/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class RemoveSTSConfigurationProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(RemoveSTSConfigurationProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RemoveSTSConfigurationProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public RemoveSTSConfigurationProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        RemoveSTSConfigurationProperty.trEntry(method);
        String[] namePath = (String[])this.getTargetObject();
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            RemoveSTSConfigurationProperty.trExit(method);
            return;
        }
        STSConfigGroup subRoot = configGroup;
        if (namePath != null && (subRoot = RemoveSTSConfigurationProperty.getConfiguration(configGroup, namePath)) == null) {
            this.processError(RemoveSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9054W"));
            RemoveSTSConfigurationProperty.trExit(method);
            return;
        }
        String propertyName = null;
        String propertyType = null;
        try {
            propertyName = (String)this.getParameter("propertyName");
            propertyType = (String)this.getParameter("propertyType");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            RemoveSTSConfigurationProperty.trExit(method);
            return;
        }
        List<STSProperty> properties = subRoot.getSTSProperty();
        Iterator<STSProperty> iter = properties.iterator();
        boolean propertyMatched = false;
        while (iter.hasNext()) {
            STSProperty current = iter.next();
            String currentType = current.getType();
            if (!Pattern.matches(propertyName, current.getName()) || !Pattern.matches(propertyType, currentType == null ? "" : currentType)) continue;
            iter.remove();
            propertyMatched = true;
        }
        if (!propertyMatched) {
            this.processError(RemoveSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9059W"));
            RemoveSTSConfigurationProperty.trExit(method);
            return;
        }
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            RemoveSTSConfigurationProperty.trExit(method);
            return;
        }
        this.setResult(RemoveSTSConfigurationProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        RemoveSTSConfigurationProperty.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

