/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

public class RefreshSTS
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(RefreshSTS.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public RefreshSTS(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public RefreshSTS(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        Set mBeans;
        String method = "execute()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        try {
            mBeans = adminService.queryNames(new ObjectName("WebSphere:*,type=SecurityTokenServiceAdmin"), null);
        }
        catch (Exception e) {
            this.processError(new AdminException(e));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Iterator iter = mBeans.iterator();
        boolean success = true;
        try {
            while (iter.hasNext()) {
                ObjectName mBean = (ObjectName)iter.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " Invoking mBean: " + mBean.toString());
                }
                success = success && (Boolean)adminService.invoke(mBean, "refresh", new Object[0], new String[0]) != false;
            }
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (success) {
            this.setResult(RefreshSTS.getMessage("wssecurity.admin.sts.CWWSI9076I"));
        } else {
            this.setResult(RefreshSTS.getMessage("wssecurity.admin.sts.CWWSI9077W"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

