/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import java.util.Iterator;
import java.util.List;

public class QuerySTSDefaultTokenType
extends AbstractSTSCommand {
    private static final TraceComponent tc = Tr.register(QuerySTSDefaultTokenType.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public QuerySTSDefaultTokenType(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public QuerySTSDefaultTokenType(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        QuerySTSDefaultTokenType.trEntry(method);
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            QuerySTSDefaultTokenType.trExit(method);
            return;
        }
        String defaultURI = targetMap.getDefaultTokenTypeURI();
        if (defaultURI == null) {
            this.processError(QuerySTSDefaultTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9047W"));
            QuerySTSDefaultTokenType.trExit(method);
            return;
        }
        STSExtensionMap extensionMap = null;
        try {
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            QuerySTSDefaultTokenType.trExit(method);
            return;
        }
        List<Extension> extensions = extensionMap.getExtension();
        Iterator<Extension> iter = extensions.iterator();
        String defaultLocalName = null;
        while (iter.hasNext()) {
            Extension current = iter.next();
            String currentURI = current.getURI();
            if (!currentURI.equals(defaultURI)) continue;
            defaultLocalName = current.getLocalName();
            break;
        }
        if (defaultLocalName == null) {
            this.processError(QuerySTSDefaultTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9046W"));
            QuerySTSDefaultTokenType.trExit(method);
            return;
        }
        this.setResult(defaultLocalName);
        QuerySTSDefaultTokenType.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

