/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSTrustAuthenticationCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.result.STSTrustAuthenticationRule;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.NoSuchElementException;

public class ListSTSEndpointTrustAuthenticationRules
extends AbstractSTSTrustAuthenticationCommand {
    private static final TraceComponent tc = Tr.register(ListSTSEndpointTrustAuthenticationRules.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSEndpointTrustAuthenticationRules(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListSTSEndpointTrustAuthenticationRules(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        String issuerURI = null;
        String tokenTypeURI = null;
        try {
            issuerURI = (String)this.getParameter("issuer");
            tokenTypeURI = (String)this.getParameter("tokenTypeURI");
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (issuerURI) - " + issuerURI);
            Tr.debug(tc, "Command arg (tokenTypeURI) - " + tokenTypeURI);
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        TokenTypeRule ttRule = null;
        try {
            ttRule = this.findRule(targetMap, null, endpointURI, issuerURI, tokenTypeURI);
        }
        catch (NoSuchElementException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find TokenTypeRule: " + e.getMessage());
            }
            this.processError(ListSTSEndpointTrustAuthenticationRules.instantiateCommandException(e.getMessage()));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        STSTrustAuthenticationRule trustAuthenticationRule = new STSTrustAuthenticationRule(ttRule);
        this.setResult(trustAuthenticationRule);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

