/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ListSTSEndpointTokenTypes
extends AbstractSTSCommand {
    private static final TraceComponent tc = Tr.register(ListSTSEndpointTokenTypes.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSEndpointTokenTypes(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListSTSEndpointTokenTypes(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String endpointArg = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointArg);
        }
        String issuerURI = null;
        try {
            issuerURI = (String)this.getParameter("issuer");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command arg (issuerURI) - " + issuerURI);
        }
        STSTargetMap targetMap = null;
        STSExtensionMap extensionMap = null;
        try {
            targetMap = this.loadTargets();
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through the configuration for specified target.");
        }
        HashSet<String> tokenTypeURIs = new HashSet<String>();
        List<Target> targets = targetMap.getTarget();
        for (Target current : targets) {
            String currentEndpoint = current.getAppliesTo();
            if (currentEndpoint == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found Target with null AppliesTo attribute, which is required. Skipping entry.");
                continue;
            }
            if (!currentEndpoint.equals(endpointArg)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target was found in the configuration. Searching assigned token types for specified issuer.");
            }
            List<AssignedTokenType> assignedTokenTypes = current.getAssignedTokenType();
            for (AssignedTokenType currentTT : assignedTokenTypes) {
                String currentTTURI = currentTT.getTokenTypeURI();
                String currentIssuerURI = currentTT.getIssuerURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found assigned token type:");
                    Tr.debug(tc, "  TokenTypeURI: " + currentTTURI);
                    Tr.debug(tc, "  IssuerURI: " + currentIssuerURI);
                }
                if (currentTTURI == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "An AssignedTokenType element in the configuration contains a null TokenTypeURI, which is required. Skipping this entry.");
                    continue;
                }
                if (!(issuerURI == null ? currentIssuerURI == null : issuerURI.equals(currentIssuerURI))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Match found.");
                }
                tokenTypeURIs.add(currentTTURI);
            }
        }
        ArrayList<String> localNamesList = new ArrayList<String>();
        List<Extension> extensions = extensionMap.getExtension();
        for (Extension current : extensions) {
            String currentTokenTypeURI = current.getURI();
            String currentLocalName = current.getLocalName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found extension element:");
                Tr.debug(tc, "  TokenTypeURI: " + currentTokenTypeURI);
                Tr.debug(tc, "  LocalName: " + currentLocalName);
            }
            if (currentTokenTypeURI == null || currentLocalName == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An Extension element in the configuration contains a null TokenTypeURI or null LocalName, both of which are required. Skipping this entry.");
                continue;
            }
            if (!tokenTypeURIs.contains(currentTokenTypeURI)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found.");
            }
            localNamesList.add(currentLocalName);
        }
        String[] localNames = new String[localNamesList.size()];
        localNames = localNamesList.toArray(localNames);
        this.setResult(localNames);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

