/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListSTSAssignedEndpoints
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(ListSTSAssignedEndpoints.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public ListSTSAssignedEndpoints(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public ListSTSAssignedEndpoints(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        ListSTSAssignedEndpoints.trEntry(method);
        STSTargetMap map = null;
        try {
            map = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            ListSTSAssignedEndpoints.trExit(method);
            return;
        }
        List<Target> targets = map.getTarget();
        Iterator<Target> iter = targets.iterator();
        ArrayList<String> endpointURIs = new ArrayList<String>();
        while (iter.hasNext()) {
            Target currentTarget = iter.next();
            List<AssignedTokenType> tokenTypes = currentTarget.getAssignedTokenType();
            if (tokenTypes == null || tokenTypes.size() <= 0) continue;
            endpointURIs.add(currentTarget.getAppliesTo());
        }
        String[] endpoints = new String[endpointURIs.size()];
        endpoints = endpointURIs.toArray(endpoints);
        this.setResult(endpoints);
        ListSTSAssignedEndpoints.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

