/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.admin.sts.commands.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Configuration;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Property;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class CreateSTSTokenTypeConfiguration
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(CreateSTSTokenTypeConfiguration.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLASS_NAME = CreateSTSTokenTypeConfiguration.class.getName();

    public CreateSTSTokenTypeConfiguration(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public CreateSTSTokenTypeConfiguration(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        Property property;
        String warning;
        Property property2;
        String method = CLASS_NAME + ".execute()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        String localName = (String)this.getTargetObject();
        STSExtensionMap extensionMap = null;
        try {
            extensionMap = this.loadPlugins();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String uri = null;
        String handlerFactory = null;
        try {
            uri = (String)this.getParameter("URI");
            handlerFactory = (String)this.getParameter("HandlerFactory");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        List<Extension> extensionList = extensionMap.getExtension();
        for (Extension currentExtension : extensionList) {
            if (localName.equals(currentExtension.getLocalName())) {
                this.processError(CreateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9042W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            if (!uri.equals(currentExtension.getURI())) continue;
            this.processError(CreateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9043W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Extension newExtension = new Extension();
        newExtension.setLocalName(localName);
        newExtension.setURI(uri);
        newExtension.setHandlerFactory(handlerFactory);
        Integer lifetimeMinutes = null;
        Boolean distributedCache = null;
        String tokenCacheFactory = null;
        Boolean postdatable = null;
        Boolean renewableAfterExpiration = null;
        Integer renewalWindowMinutes = null;
        Properties customProperties = null;
        try {
            lifetimeMinutes = (Integer)this.getParameter("lifetimeMinutes");
            distributedCache = (Boolean)this.getParameter("distributedCache");
            tokenCacheFactory = (String)this.getParameter("tokenCacheFactory");
            postdatable = (Boolean)this.getParameter("postdatable");
            renewableAfterExpiration = (Boolean)this.getParameter("renewableAfterExpiration");
            renewalWindowMinutes = (Integer)this.getParameter("renewalWindowMinutes");
            customProperties = (Properties)this.getParameter("customProperties");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (lifetimeMinutes < Constants.MIN_VALUE_PROPERTY_LIFETIME_MINUTES) {
            this.processError(CreateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9086E", new String[]{"lifetimeMinutes", Constants.MIN_VALUE_PROPERTY_LIFETIME_MINUTES.toString()}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (renewalWindowMinutes < Constants.MIN_VALUE_PROPERTY_RENEWAL_WINDOW_MINUTES) {
            this.processError(CreateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9086E", new String[]{"renewalWindowMinutes", Constants.MIN_VALUE_PROPERTY_RENEWAL_WINDOW_MINUTES.toString()}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        Configuration newConfig = new Configuration();
        List<Property> properties = newConfig.getProperty();
        if (lifetimeMinutes != null) {
            property2 = new Property();
            property2.setName("lifetimeMinutes");
            property2.setValue(lifetimeMinutes.toString());
            properties.add(property2);
        }
        if (distributedCache != null) {
            warning = CreateSTSTokenTypeConfiguration.getMessage("wssecurity.admin.sts.CWWSI9092W", new String[]{"distributedCache"});
            Tr.warning(tc, warning);
            this.addWarning(warning);
            property = new Property();
            property.setName("distributedCache");
            property.setValue(distributedCache.toString());
            properties.add(property);
        }
        if (tokenCacheFactory != null) {
            warning = CreateSTSTokenTypeConfiguration.getMessage("wssecurity.admin.sts.CWWSI9092W", new String[]{"tokenCacheFactory"});
            Tr.warning(tc, warning);
            this.addWarning(warning);
            property = new Property();
            property.setName("tokenCacheFactory");
            property.setValue(tokenCacheFactory);
            properties.add(property);
        }
        if (postdatable != null) {
            property2 = new Property();
            property2.setName("postdatable");
            property2.setValue(postdatable.toString());
            properties.add(property2);
        }
        if (renewableAfterExpiration != null) {
            property2 = new Property();
            property2.setName("renewableAfterExpiration");
            property2.setValue(renewableAfterExpiration.toString());
            properties.add(property2);
        }
        if (renewalWindowMinutes != null) {
            property2 = new Property();
            property2.setName("renewalWindowMinutes");
            property2.setValue(renewalWindowMinutes.toString());
            properties.add(property2);
        }
        if (customProperties != null) {
            Enumeration<Object> customPropNames = customProperties.keys();
            while (customPropNames.hasMoreElements()) {
                String propName = (String)customPropNames.nextElement();
                if (this.isDefaultProperty(propName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "customProperties parameter cannot include a default property name.");
                    }
                    this.processError(CreateSTSTokenTypeConfiguration.instantiateCommandException("wssecurity.admin.sts.CWWSI9074W"));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, method);
                    }
                    return;
                }
                Property property3 = new Property();
                property3.setName(propName);
                property3.setValue(customProperties.getProperty(propName));
                properties.add(property3);
            }
        }
        newExtension.setConfiguration(newConfig);
        extensionList.add(newExtension);
        try {
            this.udpatePlugins(extensionMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(CreateSTSTokenTypeConfiguration.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

