/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.Extension;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.AssignedTokenType;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class AssignSTSEndpointTokenType
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(AssignSTSEndpointTokenType.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AssignSTSEndpointTokenType(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public AssignSTSEndpointTokenType(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        List<AssignedTokenType> assignedTokenTypes;
        String method = "execute";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        STSTargetMap targetMap = null;
        try {
            targetMap = this.loadTargets();
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        String localName = null;
        String issuer = null;
        try {
            localName = (String)this.getParameter("LocalName");
            issuer = (String)this.getParameter("issuer");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Specified parameters:");
            Tr.debug(tc, "  localName: " + localName);
            Tr.debug(tc, "  issuer: " + issuer);
        }
        String tokenTypeURI = null;
        boolean defaulted = false;
        if (localName == null) {
            tokenTypeURI = targetMap.getDefaultTokenTypeURI();
            if (tokenTypeURI == null) {
                this.processError(AssignSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9047W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Since localName parameter is null, default token type will be used.");
            }
            defaulted = true;
        } else {
            STSExtensionMap extensionMap = null;
            try {
                extensionMap = this.loadPlugins();
            }
            catch (Exception e) {
                this.processError(e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            List<Extension> extensionList = extensionMap.getExtension();
            for (Extension currentExtension : extensionList) {
                if (!localName.equals(currentExtension.getLocalName())) continue;
                tokenTypeURI = currentExtension.getURI();
                break;
            }
        }
        if (tokenTypeURI == null) {
            this.processError(AssignSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9044W"));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token type configuration was found.");
        }
        String endpointURI = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command target (endpointURI) - " + endpointURI);
        }
        try {
            new URL(endpointURI);
        }
        catch (MalformedURLException e) {
            this.processError(AssignSTSEndpointTokenType.instantiateCommandException("WSEC0003E", new String[]{e.toString()}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        List<Target> targetList = targetMap.getTarget();
        Iterator<Target> targetIter = targetList.iterator();
        Target specifiedTarget = null;
        while (targetIter.hasNext()) {
            Target currentTarget = targetIter.next();
            if (!endpointURI.equals(currentTarget.getAppliesTo())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target exists in the configuration.");
            }
            specifiedTarget = currentTarget;
            break;
        }
        AssignedTokenType newAssignment = new AssignedTokenType();
        newAssignment.setTokenTypeURI(tokenTypeURI);
        newAssignment.setIssuerURI(issuer);
        if (specifiedTarget == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target not found in the configuration. Creating new entry.");
            }
            specifiedTarget = new Target();
            targetList.add(specifiedTarget);
            specifiedTarget.setAppliesTo(endpointURI);
            assignedTokenTypes = specifiedTarget.getAssignedTokenType();
            assignedTokenTypes.add(newAssignment);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target was found in the configuration. Attempting to add new AssignedTokenType.");
            }
            assignedTokenTypes = specifiedTarget.getAssignedTokenType();
            for (AssignedTokenType currentAssignedTT : assignedTokenTypes) {
                String currentAssignedTTURI = currentAssignedTT.getTokenTypeURI();
                String currentAssignedIssuerURI = currentAssignedTT.getIssuerURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found previously assigned token type:");
                    Tr.debug(tc, "  TokenTypeURI: " + currentAssignedTTURI);
                    Tr.debug(tc, "  IssuerURI: " + currentAssignedIssuerURI);
                }
                if (!tokenTypeURI.equals(currentAssignedTTURI) || !(issuer == null ? currentAssignedIssuerURI == null : issuer.equals(currentAssignedIssuerURI))) continue;
                this.processError(AssignSTSEndpointTokenType.instantiateCommandException("wssecurity.admin.sts.CWWSI9048W"));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, method);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token type assignment not found. OK to add.");
            }
            assignedTokenTypes.add(newAssignment);
        }
        String result = AssignSTSEndpointTokenType.getMessage(defaulted ? "wssecurity.admin.sts.CWWSI9078I" : "wssecurity.admin.sts.CWWSI9075I");
        try {
            this.updateTargets(targetMap);
        }
        catch (Exception e) {
            this.processError(e);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return;
        }
        this.setResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
    }
}

