/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSConfigGroup;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.STSProperty;
import java.util.List;

public class AddSTSConfigurationProperty
extends AbstractSTSCommand {
    private static TraceComponent tc = Tr.register(AddSTSConfigurationProperty.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AddSTSConfigurationProperty(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public AddSTSConfigurationProperty(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        String method = "execute";
        AddSTSConfigurationProperty.trEntry(method);
        String[] groupPath = (String[])this.getTargetObject();
        STSConfigGroup configGroup = null;
        try {
            configGroup = this.loadConfig();
        }
        catch (Exception e) {
            this.processError(e);
            AddSTSConfigurationProperty.trExit(method);
            return;
        }
        STSConfigGroup subRoot = configGroup;
        if (groupPath != null && (subRoot = AddSTSConfigurationProperty.getConfiguration(configGroup, groupPath)) == null) {
            this.processError(AddSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9055W"));
            AddSTSConfigurationProperty.trExit(method);
            return;
        }
        String propertyName = null;
        String propertyType = null;
        String propertyValue = null;
        try {
            propertyName = (String)this.getParameter("newPropertyName");
            propertyType = (String)this.getParameter("newPropertyType");
            propertyValue = (String)this.getParameter("newPropertyValue");
        }
        catch (InvalidParameterNameException e) {
            this.processError(e);
            AddSTSConfigurationProperty.trExit(method);
            return;
        }
        List<STSProperty> properties = subRoot.getSTSProperty();
        for (STSProperty current : properties) {
            String currentType;
            if (!current.getName().equals(propertyName) || ((currentType = current.getType()) != null || propertyType != null) && (currentType == null || propertyType == null || !currentType.equals(propertyType))) continue;
            this.processError(AddSTSConfigurationProperty.instantiateCommandException("wssecurity.admin.sts.CWWSI9060W"));
            AddSTSConfigurationProperty.trExit(method);
            return;
        }
        STSProperty newProperty = new STSProperty();
        newProperty.setName(propertyName);
        newProperty.setType(propertyType);
        newProperty.setValue(propertyValue);
        properties.add(newProperty);
        try {
            this.updateConfig(configGroup);
        }
        catch (Exception e) {
            this.processError(e);
            AddSTSConfigurationProperty.trExit(method);
            return;
        }
        this.setResult(AddSTSConfigurationProperty.getMessage("wssecurity.admin.sts.CWWSI9075I"));
        AddSTSConfigurationProperty.trExit(method);
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }
}

