/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sts.commands;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sts.commands.AbstractSTSCommand;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSTSTrustAuthenticationCommand
extends AbstractSTSCommand {
    private static final TraceComponent tc = Tr.register(AbstractSTSTrustAuthenticationCommand.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public AbstractSTSTrustAuthenticationCommand(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public AbstractSTSTrustAuthenticationCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    protected Target findTarget(STSTargetMap map, String endpointURI) throws NoSuchElementException {
        String method = "findTarget";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (map == null || endpointURI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "map and endpointURI parameters must not be null.");
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9079W"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching configuration for specified target: " + endpointURI);
        }
        List<Target> targets = map.getTarget();
        Iterator<Target> targetsIter = targets.iterator();
        Target specifiedTarget = null;
        while (targetsIter.hasNext()) {
            Target currentTarget = targetsIter.next();
            String currentEndpoint = currentTarget.getAppliesTo();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found target with endpointURI: " + currentEndpoint);
            }
            if (currentEndpoint == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found target with a null appliesTo attribute, which is required. Skipping entry.");
                continue;
            }
            if (!currentEndpoint.equals(endpointURI)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found.");
            }
            specifiedTarget = currentTarget;
            break;
        }
        if (specifiedTarget == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Specified target not found.");
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9045W"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return specifiedTarget;
    }

    protected DefaultIssuerRule findDefaultIssuerRule(STSTargetMap map, Target startTarget, String endpointURI) throws NoSuchElementException {
        String method = "findDefaultIssuerRule";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        DefaultIssuerRule defaultRule = null;
        if (startTarget != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Target was provided. Searching for DefaultIssuerRule in the specified Target.");
            }
            endpointURI = startTarget.getAppliesTo();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Target not provided. Searching from the beginning.");
            }
            startTarget = this.findTarget(map, endpointURI);
        }
        defaultRule = startTarget.getDefaultIssuerRule();
        if (defaultRule == null) {
            String errorMsg = "DefaultIssuerRule was not found for specified endpoint: " + endpointURI;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errorMsg);
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9080W", new String[]{endpointURI}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully extracted DefaultIssuerRule from target: " + endpointURI);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return defaultRule;
    }

    protected IssuerRule findIssuerRule(STSTargetMap map, Target startTarget, String endpointURI, String issuerURI) throws NoSuchElementException {
        String method = "findIssuerRule";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (startTarget != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Target was provided. Searching for IssuerRule in the specified Target.");
            }
            endpointURI = startTarget.getAppliesTo();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Target not provided. Searching from the beginning.");
            }
            startTarget = this.findTarget(map, endpointURI);
        }
        IssuerRule iRule = null;
        List<IssuerRule> issuerRules = startTarget.getIssuerRule();
        for (IssuerRule currentIRule : issuerRules) {
            String currentIssuer = currentIRule.getIssuerURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found IssuerRule with IssuerURI: " + currentIssuer);
            }
            if (currentIssuer == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found issuerRule with null issuerURI attribute, which is required. Skipping entry.");
                continue;
            }
            if (!currentIssuer.equals(issuerURI)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Match found.");
            }
            iRule = currentIRule;
            break;
        }
        if (iRule == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Specified IssuerRule not found: " + issuerURI);
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9081W", new String[]{endpointURI, issuerURI}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully found specified IssuerRule.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return iRule;
    }

    protected TokenTypeRule findRule(STSTargetMap map, List<TokenTypeRule> rules, String endpointURI, String issuerURI, String tokenTypeURI) throws NoSuchElementException {
        String method = "findRules";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (tokenTypeURI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenTypeURI parameter must not be null.");
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9082W"));
        }
        if (rules == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Rules were not provided. Searching from beginning.");
            }
            if (issuerURI == null) {
                DefaultIssuerRule defaultRule = this.findDefaultIssuerRule(map, null, endpointURI);
                rules = defaultRule.getTokenTypeRule();
            } else {
                IssuerRule issuerRule = this.findIssuerRule(map, null, endpointURI, issuerURI);
                rules = issuerRule.getTokenTypeRule();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching configuration for specified token type: " + tokenTypeURI);
        }
        for (TokenTypeRule currentTTRule : rules) {
            String currentTTURI = currentTTRule.getRequiredTokenTypeURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found TokenTypeRule with requiredTokenTypeURI: " + currentTTURI);
            }
            if (currentTTURI == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found tokenTypeRule with null requiredTokenTypeURI attribute, which is required. Skipping entry.");
                continue;
            }
            if (!currentTTURI.equals(tokenTypeURI)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Successfully found specified TokenTypeRule.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, method);
            }
            return currentTTRule;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenTypeRule not found.");
        }
        throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9083W", new String[]{endpointURI, tokenTypeURI}));
    }

    protected Identity findIdentity(STSTargetMap map, TokenTypeRule rule, String endpointURI, String issuerURI, String tokenTypeURI, Properties identity) throws NoSuchElementException {
        String method = "findIdentity";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        if (rule == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for TokenTypeRule.");
            }
            rule = this.findRule(map, null, endpointURI, issuerURI, tokenTypeURI);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching through identities.");
        }
        Identity id = null;
        IdentityList idList = rule.getIdentityList();
        if (idList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IdentityList is null.");
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9084W", new String[]{endpointURI}));
        }
        List<Identity> idsList = idList.getIdentity();
        for (Identity currentID : idsList) {
            List<IdentityPart> idParts = currentID.getIdentityPart();
            if (idParts.size() != identity.size()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Identity rule does not contain the same number of parts as that specified. Skipping.");
                continue;
            }
            Iterator<IdentityPart> idPartsIter = idParts.iterator();
            boolean matches = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Identity with parts:");
            }
            while (idPartsIter.hasNext()) {
                IdentityPart currentIDPart = idPartsIter.next();
                String currentName = currentIDPart.getName();
                String currentValue = currentIDPart.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "  Name: " + currentName);
                    Tr.debug(tc, "  Value: " + currentValue);
                }
                if (currentName == null || currentValue == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found an IdentityPart element with a null Name or null Value attribute, both of which are required. Skipping entry.");
                    continue;
                }
                String matchValue = identity.getProperty(currentName);
                if (matchValue != null && matchValue.equals(currentValue)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a match. Continuing with next Identity rule.");
                }
                matches = false;
                break;
            }
            if (!matches) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found a match.");
            }
            id = currentID;
            break;
        }
        if (id == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find specified identity.");
            }
            throw new NoSuchElementException(AbstractSTSTrustAuthenticationCommand.getMessage("wssecurity.admin.sts.CWWSI9084W", new String[]{endpointURI}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully found specified Identity.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return id;
    }
}

