/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sc;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.SCClientCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class SCCommonCommandProvider
extends AbstractAdminCommand {
    private static final String SCConfigFile = "WSSCCache.xml";
    private static final String Package_Namespace = "com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache";
    protected static final String RESULT_MSG_SUCCESS_UPDATED = "The configuration was successfully updated. Use $AdminConfig save to commit the changes.";
    public static final String FFDC_ID_1 = "FFDC-1";
    public static final String FFDC_ID_2 = "FFDC-2";
    public static final String FFDC_ID_3 = "FFDC-3";
    public static final String FFDC_ID_4 = "FFDC-4";
    public static final String FFDC_ID_5 = "FFDC-5";
    public static final String FFDC_ID_6 = "FFDC-6";
    private RepositoryContext repContext;
    private boolean isSetup;
    private boolean repContextLoaded;
    protected static final String[] preDefinedProps = new String[]{"renewIntervalBeforeTimeoutMinutes", "minutesInCacheAfterTimeout", "distributedCache"};
    private static final TraceComponent tc = Tr.register(SCCommonCommandProvider.class, "Web Services Security", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");

    public SCCommonCommandProvider(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
        this.reset();
    }

    public SCCommonCommandProvider(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
        this.reset();
    }

    protected void setup() {
        CommandResultImpl result = new CommandResultImpl();
        this.setCommandResult(result);
        result.reset();
        this.isSetup = true;
    }

    protected void reset() {
        this.repContext = null;
        this.isSetup = false;
        this.repContextLoaded = false;
    }

    protected void setResult(Object result) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl cmdResult = (CommandResultImpl)this.getCommandResult();
        cmdResult.setResult(result);
    }

    protected Configuration loadConfiguration() throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfiguration()");
        }
        String absolutePath = this.extractFileFromWorkspace(SCConfigFile);
        Unmarshaller um = this.getUnmarshaller(Package_Namespace);
        SCClientCache cache = (SCClientCache)um.unmarshal(new File(absolutePath));
        Configuration cfg = cache.getConfiguration().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfiguration()");
        }
        return cfg;
    }

    protected void udpateConfiguration(Configuration cfg) throws InvalidParameterNameException, WorkSpaceException, FileNotFoundException, JAXBException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "udpateConfiguration");
        }
        String absolutePath = this.extractFileFromWorkspace(SCConfigFile);
        Marshaller m = this.getMarshaller(Package_Namespace);
        SCClientCache cache = new SCClientCache();
        cache.getConfiguration().add(cfg);
        m.marshal((Object)cache, (OutputStream)new FileOutputStream(absolutePath));
        this.updateFileInWorkspace(SCConfigFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "udpateConfiguration");
        }
    }

    private Unmarshaller getUnmarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller um = jc.createUnmarshaller();
        return um;
    }

    private Marshaller getMarshaller(String packageName) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }

    private String extractFileFromWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            if (!this.repContext.isExtracted(fileName)) {
                this.repContext.extract(fileName, true);
            }
        } else {
            throw new FileNotFoundException(fileName);
        }
        return SCCommonCommandProvider.constructAbsolutePath(this.repContext, fileName);
    }

    private void updateFileInWorkspace(String fileName) throws WorkSpaceException, FileNotFoundException {
        if (!this.repContextLoaded) {
            this.loadRepositoryContext(this.getConfigSession());
        }
        if (this.repContext.isAvailable(fileName)) {
            this.repContext.notifyChanged(1, fileName);
        }
    }

    private void loadRepositoryContext(Session session) throws WorkSpaceException {
        RepositoryContextType contextType;
        WorkSpace ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.getUserName());
        Collection col = ws.findContext(contextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells"));
        Iterator iter = col.iterator();
        if (!iter.hasNext()) {
            throw new WorkSpaceException("Cannot find cell repository context.");
        }
        this.repContext = (RepositoryContext)iter.next();
        this.repContextLoaded = true;
    }

    private static String constructAbsolutePath(RepositoryContext rc, String uri) {
        return rc.getPath() + File.separator + uri;
    }

    public static String getMessage(String key) {
        String ret = key;
        if (resourceBundle != null) {
            try {
                ret = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                ret = key;
            }
        }
        return ret;
    }

    public static String getMessage(String key, String[] args) {
        String ret = SCCommonCommandProvider.getMessage(key);
        if (args != null && args.length > 0) {
            ret = MessageFormat.format(ret, args);
        }
        return ret;
    }

    protected static CommandException instantiateCommandException(String messageKey) {
        return new CommandException(SCCommonCommandProvider.getMessage(messageKey));
    }

    protected static CommandException instantiateCommandException(String messageKey, String[] args) {
        return new CommandException(SCCommonCommandProvider.getMessage(messageKey, args));
    }

    protected void processError(Throwable t) {
        if (t instanceof InvalidParameterNameException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_1);
        } else if (t instanceof CommandException) {
            this.processError(t, "WSEC0003E", new String[]{t.getMessage()}, FFDC_ID_2);
        } else if (t instanceof FileNotFoundException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_3);
        } else if (t instanceof JAXBException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_4);
        } else if (t instanceof WorkSpaceException) {
            this.processError(t, "WSEC0004E", new String[]{t.getMessage()}, FFDC_ID_5);
        } else {
            this.processError(t, "WSEC0005E", new String[]{t.getMessage()}, FFDC_ID_6);
        }
    }

    protected void processError(Throwable t, String errorCode, String[] args, String ffdcID) {
        if (!this.isSetup) {
            this.setup();
        }
        CommandResultImpl result = (CommandResultImpl)this.getCommandResult();
        result.setException(t);
        Tr.error(tc, errorCode, args);
    }
}

