/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin.sc;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.ws.wssecurity.admin.sc.SCCommonCommandProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property;
import java.util.List;
import java.util.Properties;

public class QuerySCClientCacheConfiguration
extends SCCommonCommandProvider {
    private static String CLASS_NAME = QuerySCClientCacheConfiguration.class.getName();
    private static TraceComponent tc = Tr.register(QuerySCClientCacheConfiguration.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public QuerySCClientCacheConfiguration(CommandMetadata metadata) throws CommandNotFoundException {
        super(metadata);
    }

    public QuerySCClientCacheConfiguration(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        super(cmdData);
    }

    public void execute() {
        Configuration cfg = null;
        try {
            cfg = this.loadConfiguration();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load SC Cache configuration.", e);
            }
            this.processError(e);
            return;
        }
        if (cfg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no SC Cache configuration.");
            }
            return;
        }
        Properties props = new Properties();
        List<Property> listProps = cfg.getProperty();
        for (Property current : listProps) {
            String name = current.getName();
            String value = current.getValue();
            if (!preDefinedProps[0].equalsIgnoreCase(name) && !preDefinedProps[1].equalsIgnoreCase(name) && !preDefinedProps[2].equalsIgnoreCase(name)) continue;
            props.put(name, value);
        }
        this.setResult(props);
    }
}

