/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.QNameAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

class Trust10Assertion
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static TraceComponent tc = Tr.register(Trust10Assertion.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private List _assertions = new ArrayList();

    Trust10Assertion() {
    }

    public void addAssertion(String assertion) {
        if (!this._assertions.contains(assertion) && this.isSupported(assertion)) {
            this._assertions.add(assertion);
        }
    }

    public boolean isSupported(String assertion) {
        for (int i = 0; i < trust10_supportedAssertions.length; ++i) {
            if (!trust10_supportedAssertions[i].equals(assertion)) continue;
            return true;
        }
        return false;
    }

    AttributeList getAttributes() {
        AttributeList list = new AttributeList();
        Iterator assertions = this._assertions.iterator();
        while (assertions.hasNext()) {
            list.add(new Attribute((String)assertions.next(), "true"));
        }
        return list;
    }

    static Trust10Assertion getInstance(Policy policy) {
        Trust10Assertion assertion = new Trust10Assertion();
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : list) {
            if (obj instanceof JAXBElement) {
                String name = ((JAXBElement)obj).getName().getLocalPart();
                if (!((obj = ((JAXBElement)obj).getValue()) instanceof QNameAssertionType)) continue;
                assertion.addAssertion(name);
                continue;
            }
            Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), "Trust10"});
        }
        return assertion;
    }
}

