/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesUtil;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.wssecurity.admin.AttributesValidation;
import com.ibm.ws.wssecurity.admin.BindingMigration;
import com.ibm.ws.wssecurity.admin.BindingReader;
import com.ibm.ws.wssecurity.admin.BindingTransformation;
import com.ibm.ws.wssecurity.admin.BindingWriter;
import com.ibm.ws.wssecurity.admin.NamespacePrefixMapperImpl;
import com.ibm.ws.wssecurity.admin.ObjectModelHelper;
import com.ibm.ws.wssecurity.admin.PolicyBean;
import com.ibm.ws.wssecurity.admin.PolicyValidation;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SecureConversationTokenHelper;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyProvider
implements PolicyAttributesConstants,
PolicyTypeProvider {
    private static TraceComponent tc = Tr.register(SecurityPolicyProvider.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private Policy _policy = null;
    private static ObjectModelHelper policyHelper = ObjectModelHelper.getInstance();
    private static SecureConversationTokenHelper sctHelper = SecureConversationTokenHelper.getInstance();
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";

    @Override
    public String getType() {
        return "WSSecurity";
    }

    @Override
    public Properties getAttributes(String policyFileName, Properties p, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{policyFileName, p, context});
        }
        Properties retProps = this.getAttributes(new FileInputStream(policyFileName), p, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", new Object[]{policyFileName, p, context});
        }
        return retProps;
    }

    private Properties getAttributes(InputStream inStream, Properties p, Map context) throws Exception {
        this.loadPolicy(inStream);
        if (p == null) {
            p = new Properties();
        }
        PolicyBean pBean = new PolicyBean();
        pBean.init(this._policy, p, true);
        AttributeList attList = pBean.getAttributes(p);
        Properties props = PolicyAttributesUtil.getInstance().attributeListToProperties(attList, p);
        return props;
    }

    @Override
    public boolean setAttributes(String policyFileName, Properties p, boolean replace, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{policyFileName, p, replace, context});
        }
        if (p == null || p.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setAttributes, attribute list is empty");
            }
            return false;
        }
        Properties finalProps = null;
        finalProps = replace ? new Properties() : this.getAttributes(policyFileName, new Properties(), context);
        SecurityPolicyProvider.handleDeleteItems(finalProps, p);
        finalProps.putAll((Map<?, ?>)p);
        this.checkAlgorithmSuite(finalProps);
        AttributesValidation validator = new AttributesValidation();
        if (!validator.validateProperties(finalProps)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setAttributes returns false");
            }
            return false;
        }
        boolean b = this.writeAttributesToFile(new FileOutputStream(policyFileName), finalProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes returns " + b);
        }
        return b;
    }

    private boolean writeAttributesToFile(OutputStream outStream, Properties props) throws Exception {
        AttributeList attributes = PolicyAttributesUtil.getInstance().propertiesToAttributeList(props);
        this._policy = new Policy();
        ObjectModelHelper.getInstance().setAttributes(this._policy, attributes);
        this.savePolicy(outStream);
        return true;
    }

    @Override
    public Properties getBinding(String bindingFileName, Properties attributes, Map context) throws Exception {
        BindingReader reader = new BindingReader();
        return reader.getBinding(bindingFileName, attributes);
    }

    @Override
    public boolean setBinding(String bindingFileName, Properties attributes, boolean replace, Map context) throws Exception {
        BindingWriter writer = new BindingWriter();
        return writer.setBinding(bindingFileName, attributes, replace, context);
    }

    @Override
    public boolean validate(String policySetFileName, String policyFileName, Map context) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityPolicyProvider.validate", new Object[]{policySetFileName, policyFileName});
        }
        this.loadPolicy(policyFileName);
        return PolicyValidation.getInstance().validateFullPolicy(this._policy, true);
    }

    protected boolean loadPolicy(String fileName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPolicy file=" + fileName);
        }
        boolean b = this.loadPolicy(new FileInputStream(fileName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPolicy file=" + fileName);
        }
        return b;
    }

    protected boolean loadPolicy(InputStream is) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPolicy(InputStream)");
        }
        JAXBContext jcPolicy = JAXBContext.newInstance((String)"org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext", (ClassLoader)PolicyInboundConfig.class.getClassLoader());
        Unmarshaller umPolicy = jcPolicy.createUnmarshaller();
        Object obj = umPolicy.unmarshal(is);
        this._policy = null;
        if (!(obj instanceof Policy)) {
            Tr.error(tc, "CWWSI9034E");
            throw new SoapSecurityException("Unmarshalled obj is NOT a Policy object");
        }
        this._policy = (Policy)obj;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPolicy(InputStream) returns true");
        }
        return true;
    }

    @Override
    public InputStream downgradeBinding(InputStream bindingFileStream, Map<String, String> context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "downgradeBinding", new Object[]{context});
        }
        BindingTransformation transformer = BindingTransformation.getInstance();
        InputStream is = transformer.transformBindingTo61WSFEP(bindingFileStream, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "downgradeBinding", new Object[]{context});
        }
        return is;
    }

    @Override
    public InputStream downgradePolicy(InputStream policyFileStream, Map<String, String> context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "downgradePolicy", new Object[]{context});
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SecurityPolicyProvider.copyFile(policyFileStream, os);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "downgradePolicy", new Object[]{context});
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    @Override
    public boolean mergeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeBinding", new Object[]{oldBindingFilePath, newBindingFilePath});
        }
        FileInputStream oldInStream = new FileInputStream(oldBindingFilePath);
        FileInputStream newInStream = null;
        if (newBindingFilePath != null && !newBindingFilePath.equals(oldBindingFilePath)) {
            newInStream = new FileInputStream(newBindingFilePath);
        }
        boolean ret = this.migrateBindingInternal(oldInStream, newInStream, null, newBindingFilePath, false);
        if (oldInStream != null) {
            oldInStream.close();
        }
        if (newInStream != null) {
            newInStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeBinding", new Object[]{oldBindingFilePath, newBindingFilePath});
        }
        return ret;
    }

    @Override
    public boolean upgradeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "upgradeBinding", new Object[]{oldBindingFilePath, newBindingFilePath});
        }
        FileInputStream oldInStream = new FileInputStream(oldBindingFilePath);
        FileInputStream newInStream = null;
        if (newBindingFilePath != null && !newBindingFilePath.equals(oldBindingFilePath)) {
            newInStream = new FileInputStream(newBindingFilePath);
        }
        boolean ret = this.migrateBindingInternal(oldInStream, newInStream, null, newBindingFilePath, true);
        if (oldInStream != null) {
            oldInStream.close();
        }
        if (newInStream != null) {
            newInStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "upgradeBinding", new Object[]{oldBindingFilePath, newBindingFilePath});
        }
        return ret;
    }

    @Override
    public boolean upgradePolicy(String oldPolicyFilePath, String newPolicyFilePath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "upgradePolicy", new Object[]{oldPolicyFilePath, newPolicyFilePath});
        }
        boolean ret = true;
        FileInputStream oldInStream = new FileInputStream(oldPolicyFilePath);
        InputStream newInStream = null;
        if (newPolicyFilePath != null && !newPolicyFilePath.equals(oldPolicyFilePath)) {
            newInStream = new FileInputStream(newPolicyFilePath);
            ret = this.upgradePolicyInternal(oldInStream, newInStream, null, newPolicyFilePath);
        }
        if (oldInStream != null) {
            ((InputStream)oldInStream).close();
        }
        if (newInStream != null) {
            newInStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "upgradePolicy", new Object[]{oldPolicyFilePath, newPolicyFilePath});
        }
        return ret;
    }

    @Override
    public boolean upgradeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "upgradeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile});
        }
        boolean ret = this.migrateBindingInternal(oldBindingFile, newBindingFile, resultBindingFile, null, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "upgradeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile});
        }
        return ret;
    }

    @Override
    public boolean mergeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile});
        }
        boolean ret = this.migrateBindingInternal(oldBindingFile, newBindingFile, resultBindingFile, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile});
        }
        return ret;
    }

    private boolean migrateBindingInternal(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile, String resultFilePath, boolean upgrade) throws Exception {
        boolean ret = true;
        if (!upgrade && newBindingFile == null) {
            ret = SecurityPolicyProvider.copyFile(oldBindingFile, resultBindingFile);
        } else {
            BindingMigration migrator = BindingMigration.getInstance();
            ret = migrator.migrateBindingTo70(oldBindingFile, newBindingFile, resultBindingFile, resultFilePath, upgrade);
        }
        return ret;
    }

    @Override
    public boolean upgradePolicy(InputStream oldPolicyFile, InputStream newPolicyFile, OutputStream resultPolicyFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "upgradePolicy(InputStream, InputStream, OutputStream)", new Object[]{oldPolicyFile, newPolicyFile, resultPolicyFile});
        }
        boolean ret = this.upgradePolicyInternal(oldPolicyFile, newPolicyFile, resultPolicyFile, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "upgradePolicy(InputStream, InputStream, OutputStream)", new Object[]{oldPolicyFile, newPolicyFile, resultPolicyFile});
        }
        return ret;
    }

    private boolean upgradePolicyInternal(InputStream oldPolicyFile, InputStream newPolicyFile, OutputStream resultPolicyFile, String resultFilePath) throws Exception {
        if (newPolicyFile == null) {
            if (resultPolicyFile == null) {
                resultPolicyFile = new FileOutputStream(resultFilePath);
            }
            SecurityPolicyProvider.copyFile(oldPolicyFile, resultPolicyFile);
        } else {
            Properties oldProps = this.getAttributes(oldPolicyFile, null, new HashMap());
            Properties newProps = this.getAttributes(newPolicyFile, null, new HashMap());
            newProps.putAll((Map<?, ?>)oldProps);
            if (resultPolicyFile != null) {
                this.savePolicy(resultPolicyFile);
            } else {
                this.savePolicy(resultFilePath);
            }
        }
        return true;
    }

    protected int savePolicy(String fileName) throws JAXBException, FileNotFoundException, IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePolicy fileName=" + fileName);
        }
        FileOutputStream outStream = new FileOutputStream(fileName);
        int retCode = this.savePolicy(outStream);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePolicy fileName=" + fileName);
        }
        return retCode;
    }

    protected int savePolicy(OutputStream outStream) throws JAXBException, FileNotFoundException, IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePolicy(OutStream)");
        }
        int retCode = 0;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.xmlsoap.schemas.ws._2004._09.policy:org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext");
            Marshaller m = jc.createMarshaller();
            try {
                m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            m.marshal((Object)this._policy, outStream);
        }
        catch (JAXBException jaxe) {
            FFDCFilter.processException(jaxe, this.getClass().getName(), FFDC_ID_3);
            Tr.error(tc, "CWWSI9032E", (Object)jaxe);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "savePolicy - caught JAXBException while writing file");
                jaxe.printStackTrace();
            }
            throw jaxe;
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException(iae, this.className, FFDC_ID_5);
            Tr.error(tc, "CWWSI9032E", iae);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "savePolicy - caught IllegalArgumentException while writing file");
                iae.printStackTrace();
            }
            throw iae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePolicy(OutputStream), retCode=" + retCode);
        }
        return retCode;
    }

    public Policy getPolicyObject() {
        return this._policy;
    }

    protected static void handleDeleteItems(Properties oldProps, Properties newProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleDeleteItems", new Object[]{oldProps, newProps});
        }
        Enumeration<Object> names = newProps.keys();
        String value = null;
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = (String)newProps.get(name);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleDeleteItems - new property: name=" + name + ", value=" + value);
            }
            if (!"".equals(value) && !"false".equalsIgnoreCase(value)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleDeleteItems - find a delete property: name=" + name + ", value=" + value);
            }
            Enumeration<Object> onames = oldProps.keys();
            while (onames.hasMoreElements()) {
                String oname = (String)onames.nextElement();
                if (!oname.startsWith(name)) continue;
                oldProps.remove(oname);
            }
            newProps.remove(name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleDeleteItems", new Object[]{oldProps, newProps});
        }
    }

    public static boolean copyFile(InputStream srcFile, OutputStream dstFile) throws Exception {
        int c;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile, srcFile=" + srcFile + ", dstFile=" + dstFile);
        }
        while ((c = srcFile.read()) != -1) {
            dstFile.write(c);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
        return true;
    }

    public void checkAlgorithmSuite(Properties p) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAlgorithmSuite, Properties p[" + p + "]");
        }
        boolean hasASymmetricBinding = false;
        boolean hasSymmetricBinding = false;
        boolean hasAlgorithm = false;
        String key = null;
        String sepchar = "\\.";
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements() && !hasAlgorithm) {
            String[] suite;
            key = (String)keys.nextElement();
            if (key.startsWith("AsymmetricBinding")) {
                hasASymmetricBinding = true;
                if (key.contains("AlgorithmSuite")) {
                    suite = key.split(sepchar);
                    if (suite.length == 3) {
                        hasAlgorithm = AttributesValidation.isSupported(suite[2], PolicyValidationConstants.algorithmSuite_requiredValues);
                        if (hasAlgorithm) {
                            Tr.debug(tc, "Validated AlgorithmSuite: " + key);
                        } else {
                            Tr.debug(tc, "AlgorithmSuite found, but could not validate: " + key);
                        }
                    } else {
                        hasAlgorithm = false;
                        Tr.error(tc, "Unexpected AlgorithmSuite format: " + key);
                    }
                }
            }
            if (!key.startsWith("SymmetricBinding")) continue;
            hasSymmetricBinding = true;
            if (!key.contains("AlgorithmSuite")) continue;
            suite = key.split(sepchar);
            if (suite.length == 3) {
                hasAlgorithm = AttributesValidation.isSupported(suite[2], PolicyValidationConstants.algorithmSuite_requiredValues);
                if (hasAlgorithm) {
                    Tr.debug(tc, "Validated AlgorithmSuite: " + key);
                    continue;
                }
                Tr.debug(tc, "AlgorithmSuite found, but could not validate: " + key);
                continue;
            }
            hasAlgorithm = false;
            Tr.error(tc, "Unexpected AlgorithmSuite format: " + key);
        }
        if (hasASymmetricBinding && !hasAlgorithm) {
            String asymAlgorithmSuite = "AsymmetricBinding.AlgorithmSuite.Basic128Rsa15";
            p.put(asymAlgorithmSuite, "true");
            Tr.debug(tc, "Added default AlgorithmSuite to ASymmetric Binding: " + asymAlgorithmSuite);
        }
        if (hasSymmetricBinding && !hasAlgorithm) {
            String symAlgorithmSuite = "SymmetricBinding.AlgorithmSuite.Basic128Rsa15";
            p.put(symAlgorithmSuite, "true");
            Tr.debug(tc, "Added default AlgorithmSuite to Symmetric Binding: " + symAlgorithmSuite);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAlgorithmSuite");
        }
    }
}

