/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.BindingPropertyConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CRL;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Caller;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CallerIdentity;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Consumerbindingref;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Generatorbindingref;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.JAASConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.LdapCertStores;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.LdapServer;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.RequiredSigningPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TimestampExpires;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchorRef;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustedIdentity;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.ValueType;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.X509Certificates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingValidation
implements PolicyAttributesConstants,
BindingPropertyConstants {
    private static TraceComponent tc = Tr.register(BindingValidation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static BindingValidation instance = new BindingValidation();
    private HashMap tokenTypeMap = new HashMap();
    protected String className = this.getClass().getName();
    private HashMap orderMap = new HashMap();

    public static BindingValidation getInstance() {
        return instance;
    }

    public boolean validate(SecurityBindings bindings, String bindingLocation) {
        boolean isValid = true;
        if (bindings.getSecurityBinding().isEmpty()) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"securityBinding", "SecurityBindings"});
            isValid = false;
        }
        Iterator<SecurityBinding> it = bindings.getSecurityBinding().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next(), bindingLocation);
        }
        return isValid;
    }

    private boolean validate(SecurityBinding binding, String bindingLocation) {
        boolean isValid = true;
        isValid &= binding.getSecurityInboundBindingConfig() == null || this.validate(binding.getSecurityInboundBindingConfig(), bindingLocation);
        return isValid &= binding.getSecurityOutboundBindingConfig() == null || this.validate(binding.getSecurityOutboundBindingConfig(), bindingLocation);
    }

    private boolean validate(SecurityOutboundBindingConfig config2, String bindingLocation) {
        Iterator<Object> it;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate SecurityOutboundBindingConfig", new Object[]{config2, bindingLocation});
        }
        boolean isValid = true;
        this.orderMap.clear();
        if (config2.getGeneratorbindingref() != null) {
            isValid &= this.validate(config2.getGeneratorbindingref());
            if (!(config2.getSigningInfo().isEmpty() && config2.getEncryptionInfo().isEmpty() && config2.getKeyInfo().isEmpty() && config2.getTokenGenerator().isEmpty() && config2.getCertStoreList() == null && config2.getTimestampExpires() == null && config2.getProperties().isEmpty())) {
                Tr.warning(tc, "CWWSI9016W", new Object[]{"signingInfo", "generatorbindingref"});
                isValid = false;
            }
        } else {
            it = config2.getSigningInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate(it.next(), true);
            }
            it = config2.getEncryptionInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((EncryptionInfo)it.next(), true);
            }
            ArrayList<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
            for (KeyInfo keyInfo : config2.getKeyInfo()) {
                keyInfoList.add(keyInfo);
                isValid &= this.validate(keyInfo, false);
            }
            ArrayList tokenGeneratorUNTList = new ArrayList();
            HashMap tokenSet = new HashMap();
            for (TokenGenerator tg : config2.getTokenGenerator()) {
                isValid &= this.validateUniqueToken(tg, tokenSet, tokenGeneratorUNTList, keyInfoList);
                isValid &= this.validate(tg);
            }
            if (isValid && tokenGeneratorUNTList.size() > 1 && this.isDefaultNamedBindings(bindingLocation)) {
                isValid &= this.validateUNTHasIDAssertion(tokenGeneratorUNTList, config2);
            }
            isValid &= config2.getCertStoreList() == null || this.validate(config2.getCertStoreList());
            isValid &= config2.getTimestampExpires() == null || this.validate(config2.getTimestampExpires());
        }
        it = config2.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate SecurityOutboundBindingConfig", isValid);
        }
        return isValid;
    }

    private boolean validateUniqueToken(Object entry, HashMap tokenMap, List untTokenList, List<KeyInfo> keyInfoList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateUniqueToken", new Object[]{entry, tokenMap, untTokenList, keyInfoList});
        }
        String localName = "";
        String uri = "";
        String name = "";
        ValueType valueType = null;
        boolean result = false;
        if (entry instanceof TokenGenerator) {
            TokenGenerator tg = (TokenGenerator)entry;
            name = tg.getName();
            valueType = tg.getValueType();
        } else if (entry instanceof TokenConsumer) {
            TokenConsumer tc = (TokenConsumer)entry;
            name = tc.getName();
            valueType = tc.getValueType();
        }
        if (valueType != null) {
            localName = valueType.getLocalName();
            uri = valueType.getUri();
            String key = localName + uri;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key: " + key + ". Name: " + name);
            }
            if (localName.endsWith("#UsernameToken")) {
                untTokenList.add(entry);
                result = true;
            } else if (tokenMap.containsKey(key)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Duplicate Token entry.  Continue chekcing if referenced.");
                }
                boolean keyFound = false;
                boolean dupKeyFound = false;
                String dupKeyName = (String)tokenMap.get(key);
                for (KeyInfo keyInfo : keyInfoList) {
                    TokenReference tokenReference = keyInfo.getTokenReference();
                    if (tokenReference != null && tokenReference.getReference().equals(name)) {
                        keyFound = true;
                    }
                    if (tokenReference != null && tokenReference.getReference().equals(dupKeyName)) {
                        dupKeyFound = true;
                    }
                    if (!keyFound || !dupKeyFound) continue;
                    result = true;
                    break;
                }
                if (!result) {
                    Tr.warning(tc, "CWWSI9103W", new Object[]{name, dupKeyName});
                    result = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a dup key entry.  Add to the list");
                }
                tokenMap.put(key, name);
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateUniqueToken", new Object[]{result, tokenMap, untTokenList});
        }
        return result;
    }

    private boolean validateUNTHasIDAssertion(List tgUNTList, Object config2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateUNTHasIDAssertion", new Object[]{tgUNTList, config2});
        }
        boolean result = false;
        boolean idAssertionFound = false;
        if (tgUNTList.size() > 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "More than 2 username token exists.");
            }
            Tr.warning(tc, "CWWSI9101W");
            result = false;
        } else {
            CallbackHandler cbh = null;
            block0: for (Object entry : tgUNTList) {
                if (entry instanceof TokenGenerator) {
                    TokenGenerator tgUNT = (TokenGenerator)entry;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking TokenGenerator entry: " + tgUNT.getName());
                    }
                    cbh = tgUNT.getCallbackHandler();
                } else {
                    TokenConsumer tcUNT = (TokenConsumer)entry;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking TokenConsumer entry: " + tcUNT.getName());
                    }
                    cbh = tcUNT.getCallbackHandler();
                }
                if (cbh == null) continue;
                List<Properties> props = cbh.getProperties();
                for (Properties prop : props) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property Name: " + prop.getName() + ".  Property Value: " + prop.getValue());
                    }
                    if (!prop.getName().equals("com.ibm.wsspi.wssecurity.token.IDAssertion.isUsed") || !prop.getValue().equalsIgnoreCase("true")) continue;
                    if (idAssertionFound) {
                        Tr.warning(tc, "CWWSI9100W");
                        result = false;
                        continue block0;
                    }
                    result = true;
                    idAssertionFound = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateUNTHasIDAssertion", result);
        }
        return result;
    }

    private boolean validateTokenConsumerCallers(TokenConsumer tcUNT, Object config2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenConsumerCallers", new Object[]{tcUNT, config2});
        }
        boolean result = true;
        SecurityInboundBindingConfig inConfig = (SecurityInboundBindingConfig)config2;
        if (inConfig.getCaller().isEmpty()) {
            Tr.warning(tc, "CWWSI9096W", "This configuration is only valid only when using the Username token as a caller with trusted identity");
            result = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller found.  Continue checking trusted/caller identity");
            }
            ValueType vt = tcUNT.getValueType();
            String vtLocalName = vt.getLocalName();
            String vtUri = vt.getUri();
            List<Caller> callers = inConfig.getCaller();
            for (Caller caller : callers) {
                TrustedIdentity trustedID = caller.getTrustedIdentity();
                if (trustedID != null) {
                    String trustedIDlocalname = trustedID.getLocalName();
                    String trustedIDUri = trustedID.getUri();
                    if (!trustedIDlocalname.equals(vtLocalName) || !trustedIDUri.equals(vtUri)) {
                        result = false;
                        break;
                    }
                }
                if (!result) continue;
                CallerIdentity callerID = caller.getCallerIdentity();
                if (callerID != null) {
                    String callerIDlocalname = callerID.getLocalName();
                    String callerIDUri = callerID.getUri();
                    if (callerIDlocalname.equals(vtLocalName) && callerIDUri.equals(vtUri)) continue;
                    result = false;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Missing callerIdentity from Caller");
                }
                Tr.warning(tc, "CWWSI9027W", new Object[]{"callerIdentity", "Caller"});
                result = false;
            }
        }
        if (!result) {
            Tr.warning(tc, "CWWSI9097W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenConsumerCallers", result);
        }
        return result;
    }

    private boolean isDefaultNamedBindings(String bindingLocation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDefaultNamedBinding", bindingLocation);
        }
        boolean result = false;
        String newBindingLocation = bindingLocation.replace('\\', '/');
        int index = newBindingLocation.indexOf("/cells/");
        if (index > -1) {
            String realStringToEvaluate = newBindingLocation.substring(index);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Real String to Evaluate is " + realStringToEvaluate);
            }
            Pattern p = Pattern.compile("/cells/[^/]*/bindings/.*");
            Matcher m = p.matcher(realStringToEvaluate);
            result = m.matches();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDefaultNamedBindings", result);
        }
        return result;
    }

    private boolean validate(Generatorbindingref bindingRef) {
        boolean isValid = true;
        if (bindingRef.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "Generatorbindingref"});
            isValid = false;
        }
        if (bindingRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "Generatorbindingref"});
            isValid = false;
        }
        Iterator<Properties> it = bindingRef.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SigningInfo signingInfo, boolean outboundBinding) {
        boolean isValid = true;
        if (signingInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "signingInfo"});
            isValid = false;
        }
        if (outboundBinding) {
            String order = signingInfo.getOrder();
            if (order != null) {
                if (this.orderMap.get(order) == null) {
                    this.orderMap.put(order, signingInfo.getName());
                } else {
                    Tr.warning(tc, "CWWSI9098W", new Object[]{signingInfo.getName(), order, (String)this.orderMap.get(order)});
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        }
        Iterator<Object> it = signingInfo.getSigningKeyInfo().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        it = signingInfo.getSigningPartReference().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((SigningPartReference)it.next());
        }
        it = signingInfo.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        return isValid;
    }

    private boolean validate(EncryptionInfo encryptionInfo, boolean outboundBinding) {
        boolean isValid = true;
        if (encryptionInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "encryptionInfo"});
            isValid = false;
        }
        if (outboundBinding) {
            String order = encryptionInfo.getOrder();
            if (order != null) {
                if (this.orderMap.get(order) == null) {
                    this.orderMap.put(order, encryptionInfo.getName());
                } else {
                    Tr.warning(tc, "CWWSI9099W", new Object[]{encryptionInfo.getName(), order, (String)this.orderMap.get(order)});
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        }
        isValid &= encryptionInfo.getEncryptionPartReference() == null || this.validate(encryptionInfo.getEncryptionPartReference());
        Iterator<Object> it = encryptionInfo.getKeyEncryptionKeyInfo().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        it = encryptionInfo.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        return isValid;
    }

    private boolean validate(EncryptionPartReference encryptionPartReference) {
        boolean isValid = true;
        Iterator<DataEncryptionKeyInfo> it = encryptionPartReference.getDataEncryptionKeyInfo().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(KeyEncryptionKeyInfo keyEncryptionKeyInfo) {
        boolean isValid = true;
        if (keyEncryptionKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "KeyEncryptionKeyInfo"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(DataEncryptionKeyInfo dataEncryptionKeyInfo) {
        boolean isValid = true;
        if (dataEncryptionKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "DataEncryptionKeyInfo"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(KeyInfo keyInfo, boolean inboundBinding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BindingValidation.validate(KeyInfo)", new Object[]{keyInfo.getName(), keyInfo.getType(), inboundBinding});
        }
        boolean isValid = true;
        if (keyInfo.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "KeyInfo"});
            isValid = false;
        }
        if (keyInfo.getType() == null || keyInfo.getType().equals("")) {
            if (!inboundBinding) {
                Tr.warning(tc, "CWWSI9027W", new Object[]{"type", "KeyInfo"});
                isValid = false;
            }
        } else if (!(keyInfo.getType().equals("EMB") || keyInfo.getType().equals("THUMBPRINT") || keyInfo.getType().equals("KEYID") || keyInfo.getType().equals("STRREF") || keyInfo.getType().equals("X509ISSUER"))) {
            Tr.warning(tc, "CWWSI9010W", new Object[]{"Type", "KeyInfo"});
            isValid = false;
        }
        if (keyInfo.getClassname() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"classname", "KeyInfo"});
            isValid = false;
        }
        isValid &= keyInfo.getTokenReference() == null || this.validate(keyInfo.getTokenReference());
        Iterator<Properties> it = keyInfo.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BindingValidation.validate(KeyInfo), return " + isValid);
        }
        return isValid;
    }

    private boolean validate(TokenReference tokenReference) {
        boolean isValid = true;
        if (tokenReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "TokenReference"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(TokenGenerator tokenGenerator) {
        boolean isValid = true;
        if (tokenGenerator.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "TokenGenerator"});
            isValid = false;
        }
        if (tokenGenerator.getValueType() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"valueType", "TokenGenerator"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenGenerator.getValueType());
        }
        isValid &= tokenGenerator.getSecurityTokenReference() == null || this.validate(tokenGenerator.getSecurityTokenReference());
        if (tokenGenerator.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"jAASConfig", "TokenGenerator"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenGenerator.getJAASConfig());
        }
        if (tokenGenerator.getCallbackHandler() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"callbackHandler", "TokenGenerator"});
            isValid = false;
        } else {
            isValid &= this.validateCallbackHandler(tokenGenerator.getCallbackHandler(), "tokenGenerator", tokenGenerator.getName(), tokenGenerator.getValueType());
        }
        Iterator<Properties> it = tokenGenerator.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(ValueType valueType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate valueType", valueType);
        }
        boolean isValid = true;
        String localName = valueType.getLocalName();
        String uri = valueType.getUri();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localName: " + localName + ". URI: " + uri);
        }
        if (localName == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"localName", "ValueType"});
            isValid = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate valueType", isValid);
        }
        return isValid;
    }

    private boolean validate(SecurityTokenReference securityTokenReference) {
        boolean isValid = true;
        if (securityTokenReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "SecurityTokenReference"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(JAASConfig jAASConfig) {
        boolean isValid = true;
        if (jAASConfig.getConfigName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"configName", "JAASConfig"});
            isValid = false;
        }
        Iterator<Properties> it = jAASConfig.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validateCallbackHandler(CallbackHandler callbackHandler, String parentElement, String tokenName, ValueType valueType) {
        String tokenType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateCallbackHandler", new Object[]{parentElement, tokenName});
        }
        boolean isValid = true;
        if (callbackHandler.getClassname() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"classname", "CallbackHandler"});
            isValid = false;
        }
        isValid &= callbackHandler.getKeyStore() == null || this.validate(callbackHandler.getKeyStore());
        isValid &= callbackHandler.getKey() == null || this.validate(callbackHandler.getKey());
        isValid &= callbackHandler.getCertPathSettings() == null || this.validate(callbackHandler.getCertPathSettings());
        boolean basicAuthIsValid = true;
        if (parentElement.equals("tokenConsumer")) {
            basicAuthIsValid = false;
        } else if (parentElement.equals("tokenGenerator") && valueType != null && (tokenType = valueType.getLocalName()) != null && tokenType.equals("LTPA_PROPAGATION")) {
            basicAuthIsValid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateCallbackHandler, parentElement=" + parentElement + ", tokenName=" + tokenName + ", basicAuthIsValid=" + basicAuthIsValid);
        }
        if (basicAuthIsValid) {
            isValid &= callbackHandler.getBasicAuth() == null || this.validate(callbackHandler.getBasicAuth());
        } else if (parentElement.equals("tokenConsumer") && callbackHandler.getBasicAuth() != null) {
            Tr.warning(tc, "CWWSI9107W", new Object[]{tokenName});
        } else if (parentElement.equals("tokenGenerator") && callbackHandler.getBasicAuth() != null) {
            Tr.warning(tc, "CWWSI9106W", new Object[]{tokenName});
        }
        Iterator<Properties> it = callbackHandler.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCallbackHandler", new Object[]{parentElement, tokenName, new Boolean(isValid)});
        }
        return isValid;
    }

    private boolean validate(KeyStore keyStore) {
        boolean isValid = true;
        if (keyStore.getKeyStoreRef() == null && (keyStore.getPath() == null || keyStore.getStorepass() == null || keyStore.getType() == null)) {
            Tr.warning(tc, "CWWSI9028W");
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(Key key) {
        boolean isValid = true;
        if (key.getAlias() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"alias", "Key"});
            isValid = false;
        }
        if (key.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "Key"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CertPathSettings certPathSettings) {
        boolean isValid = true;
        isValid &= certPathSettings.getTrustAnchorRef() == null || this.validate(certPathSettings.getTrustAnchorRef());
        return isValid &= certPathSettings.getCertStoreRef() == null || this.validate(certPathSettings.getCertStoreRef());
    }

    private boolean validate(TrustAnchorRef trustAnchorRef) {
        boolean isValid = true;
        if (trustAnchorRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "TrustAnchorRef"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CertStoreRef certStoreRef) {
        boolean isValid = true;
        if (certStoreRef.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "CertStoreRef"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(BasicAuth basicAuth) {
        boolean isValid = true;
        if (basicAuth.getUserid() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"userid", "BasicAuth"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CertStoreList certStoreList) {
        boolean isValid = true;
        for (Object obj : certStoreList.getLdapCertStoresOrCollectionCertStores()) {
            if (obj instanceof LdapCertStores) {
                isValid &= this.validate((LdapCertStores)obj);
                continue;
            }
            if (!(obj instanceof CollectionCertStores)) continue;
            isValid &= this.validate((CollectionCertStores)obj);
        }
        return isValid;
    }

    private boolean validate(LdapCertStores ldapCertStores) {
        boolean isValid = true;
        if (ldapCertStores.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "LdapCertStores"});
            isValid = false;
        }
        if (ldapCertStores.getProvider() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"provider", "LdapCertStores"});
            isValid = false;
        }
        if (ldapCertStores.getLdapServer() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"ldapServer", "LdapCertStores"});
            isValid = false;
        } else {
            isValid &= this.validate(ldapCertStores.getLdapServer());
        }
        return isValid;
    }

    private boolean validate(LdapServer ldapServer) {
        boolean isValid = true;
        if (ldapServer.getHost() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"host", "LdapServer"});
            isValid = false;
        }
        if (ldapServer.getPort() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"port", "LdapServer"});
            isValid = false;
        }
        Iterator<Properties> it = ldapServer.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(Properties properties) {
        boolean isValid = true;
        if (properties.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "Properties"});
            isValid = false;
        }
        if (properties.getValue() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"value", "Properties"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CollectionCertStores collectionCertStores) {
        boolean isValid = true;
        if (collectionCertStores.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "CollectionCertStores"});
            isValid = false;
        }
        if (collectionCertStores.getProvider() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"provider", "CollectionCertStores"});
            isValid = false;
        }
        for (Object obj : collectionCertStores.getX509CertificatesOrCRL()) {
            if (obj instanceof X509Certificates) {
                isValid &= this.validate((X509Certificates)obj);
                continue;
            }
            if (!(obj instanceof CRL)) continue;
            isValid &= this.validate((CRL)obj);
        }
        return isValid;
    }

    private boolean validate(X509Certificates cert) {
        boolean isValid = true;
        if (cert.getPath() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Path", "X509Certificates"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(CRL crl) {
        boolean isValid = true;
        if (crl.getPath() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Path", "CRL"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(TimestampExpires timestampExpires) {
        boolean isValid = true;
        Iterator<Properties> it = timestampExpires.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SigningKeyInfo signingKeyInfo) {
        boolean isValid = true;
        if (signingKeyInfo.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "SigningKeyInfo"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(SigningPartReference signingPartReference) {
        boolean isValid = true;
        Iterator<Transform> it = signingPartReference.getTransform().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(Transform transform) {
        boolean isValid = true;
        if (transform.getAlgorithm() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Algorithm", "Transform"});
            isValid = false;
        }
        Iterator<Properties> it = transform.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(SecurityInboundBindingConfig config2, String bindingLocation) {
        Iterator<Object> it;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate SecurityInboundBindingConfig", new Object[]{config2, bindingLocation});
        }
        boolean isValid = true;
        if (config2.getConsumerbindingref() != null) {
            isValid &= this.validate(config2.getConsumerbindingref());
            if (!(config2.getSigningInfo().isEmpty() && config2.getEncryptionInfo().isEmpty() && config2.getKeyInfo().isEmpty() && config2.getTokenConsumer().isEmpty() && config2.getTrustAnchor().isEmpty() && config2.getCertStoreList() == null && config2.getCaller() == null && config2.getProperties().isEmpty())) {
                Tr.warning(tc, "CWWSI9016W", new Object[]{"signingInfo", "consumerbindingref"});
                isValid = false;
            }
        } else {
            it = config2.getSigningInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate(it.next(), false);
            }
            it = config2.getEncryptionInfo().iterator();
            while (it.hasNext()) {
                isValid &= this.validate((EncryptionInfo)it.next(), false);
            }
            ArrayList<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
            for (KeyInfo keyInfo : config2.getKeyInfo()) {
                keyInfoList.add(keyInfo);
                isValid &= this.validate(keyInfo, true);
            }
            ArrayList tokenConsumerUNTList = new ArrayList();
            HashMap tokenSet = new HashMap();
            for (TokenConsumer tc : config2.getTokenConsumer()) {
                isValid &= this.validateUniqueToken(tc, tokenSet, tokenConsumerUNTList, keyInfoList);
                isValid &= this.validate(tc);
            }
            if (isValid && tokenConsumerUNTList.size() > 1 && this.isDefaultNamedBindings(bindingLocation) && (isValid &= this.validateUNTHasIDAssertion(tokenConsumerUNTList, config2))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Continue checking trusted/caller identity for the TokenConsumers");
                }
                isValid &= this.validateTokenConsumerCallers((TokenConsumer)tokenConsumerUNTList.get(0), config2);
            }
            Iterator<Object> it2 = config2.getTrustAnchor().iterator();
            while (it2.hasNext()) {
                isValid &= this.validate((TrustAnchor)it2.next());
            }
            isValid &= config2.getCertStoreList() == null || this.validate(config2.getCertStoreList());
            isValid &= this.validate(config2.getCaller());
        }
        it = config2.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate((Properties)it.next());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate SecurityInboundBindingConfig", isValid);
        }
        return isValid;
    }

    private boolean validate(Consumerbindingref consumerbindingref) {
        boolean isValid = true;
        if (consumerbindingref.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Name", "Consumerbindingref"});
            isValid = false;
        }
        if (consumerbindingref.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "Consumerbindingref"});
            isValid = false;
        }
        Iterator<Properties> it = consumerbindingref.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(TokenConsumer tokenConsumer) {
        boolean isValid = true;
        if (tokenConsumer.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"name", "tokenConsumer"});
            isValid = false;
        }
        if (tokenConsumer.getValueType() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"valueType", "tokenConsumer"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenConsumer.getValueType());
        }
        isValid &= tokenConsumer.getSecurityTokenReference() == null || this.validate(tokenConsumer.getSecurityTokenReference());
        if (tokenConsumer.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"jAASConfig", "tokenConsumer"});
            isValid = false;
        } else {
            isValid &= this.validate(tokenConsumer.getJAASConfig());
        }
        isValid &= tokenConsumer.getCallbackHandler() == null || this.validateCallbackHandler(tokenConsumer.getCallbackHandler(), "tokenConsumer", tokenConsumer.getName(), tokenConsumer.getValueType());
        Iterator<Properties> it = tokenConsumer.getProperties().iterator();
        while (it.hasNext()) {
            isValid &= this.validate(it.next());
        }
        return isValid;
    }

    private boolean validate(TrustAnchor trustAnchor) {
        boolean isValid = true;
        if (trustAnchor.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Name", "TrustAnchor"});
            isValid = false;
        }
        if (trustAnchor.getKeyStore() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"KeyStore", "TrustAnchor"});
            isValid = false;
        } else {
            isValid &= this.validate(trustAnchor.getKeyStore());
        }
        return isValid;
    }

    private boolean validate(List<Caller> callers) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate callers", new Object[]{callers, this});
        }
        boolean isValid = true;
        ArrayList<Integer> callerOrders = new ArrayList<Integer>();
        for (Caller caller : callers) {
            String order = caller.getOrder();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller name is " + caller.getName() + ". Order is " + order);
            }
            if (order == null || order.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No order attribute found");
                }
                Tr.warning(tc, "CWWSI9109W", new Object[]{caller.getName()});
                isValid = false;
                break;
            }
            Integer orderInt = Integer.valueOf(order);
            int sign = Integer.signum(orderInt);
            if (sign == -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Order attribute is negative");
                }
                Tr.warning(tc, "CWWSI9094W");
                isValid = false;
                break;
            }
            if (callerOrders.contains(orderInt)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Order value is duplicated");
                }
                Tr.warning(tc, "CWWSI9095W");
                isValid = false;
                break;
            }
            callerOrders.add(orderInt);
            if (this.validate(caller)) continue;
            isValid = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate callers", new Boolean(isValid));
        }
        return isValid;
    }

    private boolean validate(Caller caller) {
        boolean isValid = true;
        if (caller.getName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"Name", "caller"});
            isValid = false;
        }
        if (caller.getJAASConfig() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"jAASConfig", "caller"});
            isValid = false;
        } else {
            isValid &= this.validate(caller.getJAASConfig());
        }
        isValid &= caller.getCallbackHandler() == null || this.validateCallbackHandler(caller.getCallbackHandler(), "caller", caller.getName(), null);
        if (caller.getCallerIdentity() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"callerIdentity", "caller"});
            isValid = false;
        } else {
            isValid &= this.validate(caller.getCallerIdentity());
        }
        isValid &= caller.getTrustedIdentity() == null || this.validate(caller.getTrustedIdentity());
        return isValid &= caller.getRequiredSigningPartReference() == null || this.validate(caller.getRequiredSigningPartReference());
    }

    private boolean validate(CallerIdentity callerIdentity) {
        boolean isValid = true;
        if (callerIdentity.getLocalName() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"localName", "caller"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validate(TrustedIdentity trustedIdentity) {
        boolean isValid = true;
        return isValid;
    }

    private boolean validate(RequiredSigningPartReference requiredSigningPartReference) {
        boolean isValid = true;
        if (requiredSigningPartReference.getReference() == null) {
            Tr.warning(tc, "CWWSI9027W", new Object[]{"reference", "requiredSigningPartReference"});
            isValid = false;
        }
        return isValid;
    }
}

