/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ws.wssecurity.admin.BindingPropertyConstants;
import com.ibm.ws.wssecurity.admin.BindingReader;
import com.ibm.ws.wssecurity.admin.BindingWriter;
import com.ibm.ws.wssecurity.admin.SecurityPolicyProvider;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTransformation
implements BindingPropertyConstants {
    private static TraceComponent _tc = Tr.register(BindingTransformation.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static BindingTransformation instance = new BindingTransformation();

    public static BindingTransformation getInstance() {
        return instance;
    }

    public InputStream transformBindingTo61WSFEP(InputStream is, Map<String, String> context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingTransformation.transformBindingTo61WSFEP, available bytes=" + is.available(), new Object[]{context});
        }
        BindingReader reader = new BindingReader();
        Properties props = reader.getBinding(is, new Properties());
        boolean trDebug = _tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(_tc, "BindingTransformation.transforBindingTo61WSFEP, binding is " + props + ", namespace=" + reader.getNameSpace());
        }
        if ("com.ibm.xmlns.prod.websphere._200710.ws_securitybinding".equals(reader.getNameSpace())) {
            this.downgradeBindingProperties(props);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingTransformation.transforBindingTo61WSFEP, new namespace, downgrade WSFEP binding is " + props);
            }
            BindingWriter writer = new BindingWriter();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            boolean success = writer.replaceBinding(os, props, "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", true);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "BindingTransformation.transformBindingTo61WSFEP, new namespace, success=" + success);
            }
            return new ByteArrayInputStream(os.toByteArray());
        }
        is.reset();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SecurityPolicyProvider.copyFile(is, os);
        if (trDebug) {
            Tr.debug(_tc, "BindingTransformation.transforBindingTo61WSFEP, old namespace, copy file");
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private void downgradeBindingProperties(Properties p) {
        this.downgradeLTPAv2("application.securityinboundbindingconfig.tokenconsumer_", ".valuetype.localname", ".valuetype.uri", p);
        this.downgradeLTPAv2("application.securityoutboundbindingconfig.tokengenerator_", ".valuetype.localname", ".valuetype.uri", p);
        this.downgradeLTPAv2("application.securityinboundbindingconfig.caller_", ".calleridentity.localname", ".calleridentity.uri", p);
        this.downgradeLTPAv2("bootstrap.securityinboundbindingconfig.tokenconsumer_", ".valuetype.localname", ".valuetype.uri", p);
        this.downgradeLTPAv2("bootstrap.securityoutboundbindingconfig.tokengenerator_", ".valuetype.localname", ".valuetype.uri", p);
        this.downgradeLTPAv2("bootstrap.securityinboundbindingconfig.caller_", ".calleridentity.localname", ".calleridentity.uri", p);
        this.downgradeCaller("application.securityinboundbindingconfig.caller_", p);
        this.downgradeCaller("bootstrap.securityinboundbindingconfig.caller_", p);
        this.downgradeSCTandDerivedKeyInfo("application.securityoutboundbindingconfig.tokengenerator_", "application.securityoutboundbindingconfig.keyinfo_", p);
        this.downgradeSCTandDerivedKeyInfo("application.securityinboundbindingconfig.tokenconsumer_", "application.securityinboundbindingconfig.keyinfo_", p);
        this.removeNewElements(p);
    }

    private void downgradeSCTandDerivedKeyInfo(String tokenPrefix, String keyInfoPrefix, Properties p) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "downgradeSCTandDerivedKeyInfo", new Object[]{tokenPrefix, keyInfoPrefix});
        }
        ArrayList<String> tokenNameList = new ArrayList<String>();
        String tokenPrefixWithIndex = null;
        String keyInfoPrefixWithIndex = null;
        String sctTokenName = null;
        String tokenReference = null;
        Object value = null;
        boolean firstKeyInfoFound = false;
        boolean trDebug = _tc.isDebugEnabled();
        int tokenIndex = 0;
        while (p.containsKey((tokenPrefixWithIndex = tokenPrefix + tokenIndex) + ".name")) {
            tokenNameList.add(p.getProperty(tokenPrefixWithIndex + ".name"));
            ++tokenIndex;
        }
        tokenIndex = 0;
        while (true) {
            tokenPrefixWithIndex = tokenPrefix + tokenIndex;
            if (trDebug) {
                Tr.debug(_tc, "BindingTransformation.downgradeSCTandDerivedKeyInfo: tokenPrefixWithIndex=" + tokenPrefixWithIndex);
            }
            if (!p.containsKey(tokenPrefixWithIndex + ".name")) break;
            if ("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(p.getProperty(tokenPrefixWithIndex + ".valuetype.localname"))) {
                p.setProperty(tokenPrefixWithIndex + ".valuetype.localname", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                sctTokenName = p.getProperty(tokenPrefixWithIndex + ".name");
                if (trDebug) {
                    Tr.debug(_tc, "BindingTransformation.downgradeSCTandDerivedKeyInfo: sctTokenName=" + sctTokenName);
                }
                firstKeyInfoFound = false;
                int keyInfoIndex = 0;
                while (true) {
                    keyInfoPrefixWithIndex = keyInfoPrefix + keyInfoIndex;
                    if (trDebug) {
                        Tr.debug(_tc, "BindingTransformation.downgradeSCTandDerivedKeyInfo: keyInfoPrefixWithIndex=" + keyInfoPrefixWithIndex);
                    }
                    if (!p.containsKey(keyInfoPrefixWithIndex + ".name")) break;
                    tokenReference = p.getProperty(keyInfoPrefixWithIndex + ".tokenreference.reference");
                    if (trDebug) {
                        Tr.debug(_tc, "BindingTransformation.downgradeSCTandDerivedKeyInfo: tokenReference=" + tokenReference + ", sctTokenName=" + sctTokenName);
                    }
                    if (sctTokenName.equals(tokenReference)) {
                        this.createAndSetSCTToken(p, keyInfoIndex, keyInfoPrefixWithIndex, sctTokenName, tokenPrefix, tokenPrefixWithIndex, tokenNameList, firstKeyInfoFound);
                        firstKeyInfoFound = true;
                    }
                    ++keyInfoIndex;
                }
            }
            ++tokenIndex;
        }
    }

    private void createAndSetSCTToken(Properties p, int keyInfoIndex, String keyInfoPrefixWithIndex, String sctTokenName, String tokenPrefix, String tokenPrefixWithIndex, List tokenNameList, boolean firstKeyInfoFound) {
        String newTokenPrefixWithIndex = null;
        if (!firstKeyInfoFound) {
            newTokenPrefixWithIndex = tokenPrefixWithIndex;
        } else {
            newTokenPrefixWithIndex = tokenPrefix + (tokenNameList.size() + keyInfoIndex);
            String newTokenName = this.getNewTokenName(sctTokenName, tokenNameList, keyInfoIndex);
            p.setProperty(newTokenPrefixWithIndex + ".name", newTokenName);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingTransformation.createAndSetSCTToken: create a new token for " + newTokenPrefixWithIndex + ", newTokenName=" + newTokenName);
            }
            Enumeration<?> e = p.propertyNames();
            String key = null;
            String newKey = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (!key.startsWith(tokenPrefixWithIndex) || key.endsWith(".name")) continue;
                newKey = key.replaceFirst(tokenPrefixWithIndex, newTokenPrefixWithIndex);
                p.setProperty(newKey, p.getProperty(key));
            }
            p.setProperty(keyInfoPrefixWithIndex + ".tokenreference.reference", newTokenName);
        }
        String[] DERIVEDKEY_PROPERTIES_70 = new String[]{".derivedkeyinfo.keylength", ".derivedkeyinfo.servicelabel", ".derivedkeyinfo.clientlabel"};
        String[] TOKEN_PROPERTIES_61 = new String[]{"com.ibm.wsspi.wssecurity.DerivedkeyToken.KeyLengthBytes", "com.ibm.ws.wssecurity.sc.dkt.ServiceLabel", "com.ibm.ws.wssecurity.sc.dkt.ClientLabel"};
        int propIndex = 0;
        String propKey = null;
        String value = null;
        for (int k = 0; k < TOKEN_PROPERTIES_61.length; ++k) {
            value = p.getProperty(keyInfoPrefixWithIndex + DERIVEDKEY_PROPERTIES_70[k]);
            if (value == null || value.equals("")) continue;
            propKey = newTokenPrefixWithIndex + ".properties_" + propIndex;
            p.setProperty(propKey + ".name", TOKEN_PROPERTIES_61[k]);
            p.setProperty(propKey + ".value", value);
            ++propIndex;
        }
    }

    private void removeNewElements(Properties p) {
        Enumeration<Object> e = p.keys();
        String key = null;
        ArrayList<String> removeKeyList = new ArrayList<String>();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (key.endsWith(".explicitlyprotectsignatureconfirmation")) {
                removeKeyList.add(key);
            }
            if (key.endsWith(".enforcetokenversion")) {
                removeKeyList.add(key);
            }
            if (key.contains(".derivedkeyinfo.")) {
                removeKeyList.add(key);
            }
            if (!key.contains(".onlySignEntireHeadersAndBody")) continue;
            removeKeyList.add(key);
        }
        for (int i = 0; i < removeKeyList.size(); ++i) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingTransformation.removeNewElements, remove " + (String)removeKeyList.get(i));
            }
            p.remove(removeKeyList.get(i));
        }
    }

    private void downgradeLTPAv2(String keyPrefix, String localNameKey, String uriKey, Properties p) {
        String keyPrefixWithIndex = null;
        String key = null;
        Object value = null;
        int i = 0;
        while (true) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingTransformation.downgradeLTPAv2: keyPrefix=" + keyPrefix + ", i=" + i);
            }
            keyPrefixWithIndex = keyPrefix + i;
            key = keyPrefixWithIndex + localNameKey;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingMigration.downgradeLTPAv2: key=" + key + ", name key=" + keyPrefixWithIndex + ".name");
            }
            if (!p.containsKey(keyPrefixWithIndex + ".name")) break;
            if ("LTPAv2".equals(p.getProperty(key))) {
                p.setProperty(key, "LTPA");
                p.setProperty(keyPrefixWithIndex + uriKey, "http://www.ibm.com/websphere/appserver/tokentype/5.0.2");
            }
            ++i;
        }
    }

    private void downgradeCaller(String callerPrefix, Properties p) {
        int i = 0;
        while (true) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingTransformation.downgradeCaller: i=" + i + ", key=" + callerPrefix + i + ".name");
            }
            if (!p.containsKey(callerPrefix + i + ".name")) break;
            p.remove(callerPrefix + i + ".order");
            ++i;
        }
    }

    private String getNewTokenName(String sctTokenName, List tokenNameList, int keyInfoIndex) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingTransformation.getNewTokenName", new Object[]{sctTokenName, tokenNameList, keyInfoIndex});
        }
        String newTokenName = null;
        boolean duplicate = false;
        int appendIndex = 2;
        while (true) {
            duplicate = false;
            newTokenName = sctTokenName + appendIndex;
            for (int i = 0; i < tokenNameList.size(); ++i) {
                if (!newTokenName.equals((String)tokenNameList.get(i))) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) break;
            ++appendIndex;
        }
        tokenNameList.add(newTokenName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "BindingTransformation.getNewTokenName", newTokenName);
        }
        return newTokenName;
    }
}

