/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.websphere.wssecurity.admin.PolicyAttributesUtil;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBindings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class BindingReader
implements PolicyAttributesConstants {
    private static TraceComponent tc = Tr.register(BindingReader.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    protected String className = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private Object _binding = null;
    private Object _applicationBinding = null;
    private Object _bootstrapBinding = null;
    private String _namespace = null;

    private AttributeList getAttributes(Object obj) {
        AttributeList list = new AttributeList();
        boolean hasGetMethods = false;
        Class<?> objClass = obj.getClass();
        Method[] methods = objClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith("get")) continue;
            hasGetMethods = true;
            Object child = null;
            try {
                child = methods[i].invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                continue;
            }
            catch (InvocationTargetException ex) {
                FFDCFilter.processException(ex.getCause(), this.getClass().getName(), FFDC_ID_2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "BindingReader.getAttributes() - caught InvocationTargetException while creating AttributeList");
                ex.getCause().printStackTrace();
                continue;
            }
            if (child == null) continue;
            boolean isPassword = false;
            if (methodName.equals("getPassword") || methodName.equals("getStorepass") || methodName.equals("getKeypass")) {
                isPassword = true;
            }
            if (child instanceof String) {
                String childName = methodName.substring(3).toLowerCase();
                if (isPassword) {
                    child = PasswordUtilFactory.getInstance().passwordDecode(child.toString());
                }
                list.add(new Attribute(childName, child));
                continue;
            }
            if (child instanceof List) {
                list.addAll(this.getAttributes(methodName.substring(3).toLowerCase(), (List)child));
                continue;
            }
            AttributeList childList = this.getAttributes(child);
            if (childList == null) continue;
            Object value = null;
            value = childList.isEmpty() ? "true" : childList;
            list.add(new Attribute(methodName.substring(3).toLowerCase(), value));
        }
        if (list.isEmpty() && hasGetMethods) {
            list = null;
        }
        return list;
    }

    private AttributeList getAttributes(String listName, List objList) {
        AttributeList list = new AttributeList();
        Iterator it = objList.iterator();
        int j = 0;
        while (it.hasNext()) {
            Object item = it.next();
            if (!listName.equalsIgnoreCase(item.getClass().getSimpleName())) {
                listName = item.getClass().getSimpleName().toLowerCase();
            }
            list.add(new Attribute(listName + "_" + j, this.getAttributes(item)));
            ++j;
        }
        return list;
    }

    public Properties getBinding(String bindingFileName, Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingReader.getBinding from file name, bindingFileName=" + bindingFileName + ", properties=" + properties);
        }
        this.load(bindingFileName);
        return this.getBindingAfterLoadingFile(properties);
    }

    public Properties getBinding(InputStream inputStream, Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingReader.getBinding from InputStream, properties=" + properties);
        }
        this.load(inputStream);
        return this.getBindingAfterLoadingFile(properties);
    }

    private Properties getBindingAfterLoadingFile(Properties properties) {
        AttributeList list = new AttributeList();
        if (this._applicationBinding != null) {
            list.add(new Attribute("application", this.getAttributes(this._applicationBinding)));
        }
        if (this._bootstrapBinding != null) {
            list.add(new Attribute("bootstrap", this.getAttributes(this._bootstrapBinding)));
        }
        return PolicyAttributesUtil.getInstance().attributeListToProperties(list, properties);
    }

    private boolean load(InputStream is) throws Exception {
        block14: {
            if (this._binding == null) {
                try {
                    JAXBContext jcBinding = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200608.ws_securitybinding:com.ibm.xmlns.prod.websphere._200710.ws_securitybinding", (ClassLoader)PolicyInboundConfig.class.getClassLoader());
                    Unmarshaller umBinding = jcBinding.createUnmarshaller();
                    this._binding = umBinding.unmarshal(is);
                    if (this._binding instanceof com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings) {
                        com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings bindingRoot = (com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings)this._binding;
                        for (SecurityBinding binding : bindingRoot.getSecurityBinding()) {
                            if (binding.getName() == null) {
                                binding.setName("application");
                            }
                            if (binding.getName().equals("application")) {
                                this._applicationBinding = binding;
                                continue;
                            }
                            if (!binding.getName().equals("bootstrap")) continue;
                            this._bootstrapBinding = binding;
                        }
                        this._namespace = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
                        break block14;
                    }
                    if (this._binding instanceof SecurityBindings) {
                        SecurityBindings bindingRoot = (SecurityBindings)this._binding;
                        for (com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding binding : bindingRoot.getSecurityBinding()) {
                            if (binding.getName() == null) {
                                binding.setName("application");
                            }
                            if (binding.getName().equals("application")) {
                                this._applicationBinding = binding;
                                continue;
                            }
                            if (!binding.getName().equals("bootstrap")) continue;
                            this._bootstrapBinding = binding;
                        }
                        this._namespace = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
                        break block14;
                    }
                    this._binding = null;
                    this._namespace = null;
                    throw new SoapSecurityException("BindingReader: Unmarshalled obj is NOT a SecurityBindings object");
                }
                catch (JAXBException jaxe) {
                    FFDCFilter.processException(jaxe, this.getClass().getName(), FFDC_ID_3);
                    Tr.error(tc, "CWWSI9036E", (Object)jaxe);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "BindingReader.load - caught JAXBException while reading bindings file");
                        jaxe.printStackTrace();
                    }
                    throw jaxe;
                }
                catch (SoapSecurityException ex) {
                    FFDCFilter.processException(ex, this.getClass().getName(), FFDC_ID_1);
                    Tr.error(tc, "CWWSI9036E", ex);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "BindingReader.load() - caught exception while read and parsing security bindings");
                        ex.printStackTrace();
                    }
                    throw ex;
                }
            }
        }
        return true;
    }

    public String getNameSpace() {
        return this._namespace;
    }

    private boolean load(String filename) throws Exception {
        File file = new File(filename);
        if (file.length() == 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingReader.load(String) - binding file is empty, returning without trying to load");
            }
            return true;
        }
        return this.load(new FileInputStream(filename));
    }
}

