/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.ws.wssecurity.admin.BindingPropertyConstants;
import com.ibm.ws.wssecurity.admin.BindingReader;
import com.ibm.ws.wssecurity.admin.BindingWriter;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class BindingMigration
implements BindingPropertyConstants {
    private static TraceComponent _tc = Tr.register(BindingMigration.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private static BindingMigration instance = new BindingMigration();

    public static BindingMigration getInstance() {
        return instance;
    }

    public boolean migrateBindingTo70(InputStream oldInStream, InputStream newInStream, OutputStream resultOutStream, String resultFilePath, boolean upgrade) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "BindingMigration.migrateBindingTo70" + new Object[]{oldInStream, newInStream, resultOutStream, resultFilePath, new Boolean(upgrade)});
        }
        boolean success = false;
        BindingReader reader = new BindingReader();
        Properties oldProps = reader.getBinding(oldInStream, new Properties());
        String oldNamespace = reader.getNameSpace();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "BindingMigration.migrateBindingTo70, 61WSFEP binding=" + oldProps + ", namespace=" + reader.getNameSpace());
        }
        Properties newProps = null;
        String newNamespace = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
        if (newInStream != null) {
            reader = new BindingReader();
            newProps = reader.getBinding(newInStream, new Properties());
            newNamespace = reader.getNameSpace();
        } else {
            newProps = new Properties();
            if (!upgrade) {
                newNamespace = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "BindingMigration.migrateBindingTo70, oldNamespace=" + oldNamespace + ", newNamespace=" + newNamespace);
        }
        if (oldNamespace.equals("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding") && newNamespace.equals("com.ibm.xmlns.prod.websphere._200710.ws_securitybinding")) {
            this.upgradeBindingProperties(oldProps);
        }
        newProps.putAll((Map<?, ?>)oldProps);
        BindingWriter writer = new BindingWriter();
        if (resultOutStream != null) {
            success = writer.replaceBinding(resultOutStream, newProps, newNamespace, true);
        } else {
            resultOutStream = new FileOutputStream(resultFilePath);
            success = writer.replaceBinding(resultOutStream, newProps, newNamespace, true);
            resultOutStream.close();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "BindingMigration.migrateBindingTo70, success=" + success);
        }
        return success;
    }

    private void upgradeBindingProperties(Properties p) {
        this.upgradeLTPA("application.securityinboundbindingconfig.tokenconsumer_", ".valuetype.localname", ".valuetype.uri", p);
        this.upgradeLTPA("bootstrap.securityinboundbindingconfig.tokenconsumer_", ".valuetype.localname", ".valuetype.uri", p);
        this.upgradeLTPA("application.securityinboundbindingconfig.caller_", ".calleridentity.localname", ".calleridentity.uri", p);
        this.upgradeLTPA("bootstrap.securityinboundbindingconfig.caller_", ".calleridentity.localname", ".calleridentity.uri", p);
        this.upgradeCaller("application.securityinboundbindingconfig.caller_", p);
        this.upgradeCaller("bootstrap.securityinboundbindingconfig.caller_", p);
        this.updateSCTandDerivedkeyInfo("application.securityoutboundbindingconfig.tokengenerator_", "application.securityoutboundbindingconfig.keyinfo_", p);
        this.updateSCTandDerivedkeyInfo("application.securityinboundbindingconfig.tokenconsumer_", "application.securityinboundbindingconfig.keyinfo_", p);
    }

    private void updateSCTandDerivedkeyInfo(String tokenPrefix, String keyInfoPrefix, Properties p) {
        int i;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "updateSCTandDerivedkeyInfo", new Object[]{tokenPrefix, keyInfoPrefix});
        }
        String tokenPrefix0 = tokenPrefix + 0;
        String tokenPrefixWithIndex = null;
        String keyInfoPrefixWithIndex = null;
        String sctTokenName = null;
        Object value = null;
        Object localname = null;
        Object uri = null;
        ArrayList<String> sctTokenList = new ArrayList<String>();
        ArrayList<String> keyInfoList = new ArrayList<String>();
        int tokenIndex = 0;
        while (true) {
            tokenPrefixWithIndex = tokenPrefix + tokenIndex;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingMigration.upgradeSCTandDerivedkeyInfo: tokenPrefixWithIndex=" + tokenPrefixWithIndex);
            }
            if (!p.containsKey(tokenPrefixWithIndex + ".name")) break;
            if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(p.getProperty(tokenPrefixWithIndex + ".valuetype.localname"))) {
                sctTokenList.add(tokenPrefixWithIndex);
                sctTokenName = p.getProperty(tokenPrefixWithIndex + ".name");
                p.setProperty(tokenPrefixWithIndex + ".valuetype.localname", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "BindingMigration.upgradeSCTandDerivedkeyInfo: sctTokneName=" + sctTokenName + ", valuetype.localname=" + p.getProperty(tokenPrefixWithIndex + ".valuetype.localname"));
                }
                int keyInfoIndex = 0;
                while (true) {
                    keyInfoPrefixWithIndex = keyInfoPrefix + keyInfoIndex;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "BindingMigration.updateSCTandDerivedkeyInfo: keyInfoIndexWithIndex=" + keyInfoPrefixWithIndex + ", token reference=" + p.getProperty(keyInfoPrefixWithIndex + ".tokenreference.reference"));
                    }
                    if (!p.containsKey(keyInfoPrefixWithIndex + ".name")) break;
                    if (sctTokenName.equals(p.getProperty(keyInfoPrefixWithIndex + ".tokenreference.reference"))) {
                        keyInfoList.add(keyInfoPrefixWithIndex + ".tokenreference.reference");
                        this.createDerivedKeyInfo(tokenPrefixWithIndex, keyInfoPrefixWithIndex, p);
                    }
                    ++keyInfoIndex;
                }
            }
            ++tokenIndex;
        }
        Enumeration<Object> e = p.keys();
        String key = null;
        ArrayList<String> removeKeyList = new ArrayList<String>();
        block2: while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            for (i = 1; i < sctTokenList.size(); ++i) {
                if (!key.startsWith((String)sctTokenList.get(i))) continue;
                removeKeyList.add(key);
                continue block2;
            }
        }
        for (i = 0; i < removeKeyList.size(); ++i) {
            p.remove(removeKeyList.get(i));
        }
        if (!sctTokenList.isEmpty()) {
            sctTokenName = p.getProperty((String)sctTokenList.get(0) + ".name");
            for (i = 0; i < keyInfoList.size(); ++i) {
                p.setProperty((String)keyInfoList.get(i), sctTokenName);
            }
        }
    }

    private void createDerivedKeyInfo(String tokenPrefixWithIndex, String keyInfoPrefixWithIndex, Properties p) {
        String propKeyWithIndex = null;
        String propName = null;
        String propValue = null;
        int propIndex = 0;
        while ((propName = p.getProperty((propKeyWithIndex = tokenPrefixWithIndex + ".properties_" + propIndex) + ".name")) != null) {
            propValue = p.getProperty(propKeyWithIndex + ".value");
            if (propValue != null && !propValue.equals("")) {
                if (propName.equals("com.ibm.wsspi.wssecurity.DerivedkeyToken.KeyLengthBytes")) {
                    p.setProperty(keyInfoPrefixWithIndex + ".derivedkeyinfo.keylength", propValue);
                    p.remove(propKeyWithIndex + ".name");
                    p.remove(propKeyWithIndex + ".value");
                } else if (propName.equals("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel")) {
                    p.setProperty(keyInfoPrefixWithIndex + ".derivedkeyinfo.servicelabel", propValue);
                    p.remove(propKeyWithIndex + ".name");
                    p.remove(propKeyWithIndex + ".value");
                } else if (propName.equals("com.ibm.ws.wssecurity.sc.dkt.ClientLabel")) {
                    p.setProperty(keyInfoPrefixWithIndex + ".derivedkeyinfo.clientlabel", propValue);
                    p.remove(propKeyWithIndex + ".name");
                    p.remove(propKeyWithIndex + ".value");
                }
            }
            ++propIndex;
        }
        String DERIVEDKEY_REQUIRE_DERIVED_KEYS = ".derivedkeyinfo.requirederivedkeys";
        String DERIVEDKEY_REQUIRE_EXPLICITY_DERIVED_KEYS = ".derivedkeyinfo.requireexplicitderivedkeys";
        p.setProperty(keyInfoPrefixWithIndex + DERIVEDKEY_REQUIRE_DERIVED_KEYS, "true");
        p.setProperty(keyInfoPrefixWithIndex + DERIVEDKEY_REQUIRE_EXPLICITY_DERIVED_KEYS, "true");
    }

    private void upgradeLTPA(String keyPrefix, String localNameKey, String uriKey, Properties p) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "BindingMigration.upgradeLTPA", new Object[]{keyPrefix, localNameKey, uriKey});
        }
        String keyPrefixWithIndex = null;
        String key = null;
        int i = 0;
        while (true) {
            keyPrefixWithIndex = keyPrefix + i;
            key = keyPrefixWithIndex + localNameKey;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "BindingMigration.upgradeLTPA: key=" + key + ", name key=" + keyPrefixWithIndex + ".name");
            }
            if (!p.containsKey(keyPrefixWithIndex + ".name")) {
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "BindingMigration.upgradeLTPA: does not contain name key=" + keyPrefixWithIndex + ".name");
                break;
            }
            if ("LTPA".equals(p.getProperty(key))) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "BindingMigration.upgradeLTPA: contains LTPA");
                }
                p.setProperty(key, "LTPAv2");
                p.setProperty(keyPrefixWithIndex + uriKey, "http://www.ibm.com/websphere/appserver/tokentype");
            }
            ++i;
        }
    }

    private void upgradeCaller(String callerPrefix, Properties p) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "BindingMigration.upgradeCaller, callerPrefix=" + callerPrefix);
        }
        if (p.containsKey(callerPrefix + 1 + ".name")) {
            Tr.warning(_tc, "CWWSI9108W");
        } else if (p.containsKey(callerPrefix + 0 + ".name")) {
            p.put(callerPrefix + 0 + ".order", "1");
        }
    }
}

