/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.admin;

import com.ibm.websphere.wssecurity.admin.PolicyAttributesConstants;
import com.ibm.ws.wssecurity.admin.AsymmetricBinding;
import com.ibm.ws.wssecurity.admin.PolicyValidation;
import com.ibm.ws.wssecurity.admin.PolicyValidationConstants;
import com.ibm.ws.wssecurity.admin.SymmetricBinding;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.bind.JAXBElement;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.QNameAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

abstract class BindingAssertion
implements PolicyAttributesConstants,
PolicyValidationConstants {
    private static PolicyValidation instance = new PolicyValidation();
    private static TraceComponent tc = Tr.register(BindingAssertion.class, "wssecuirty.admin", "com.ibm.ws.wssecurity.admin.resources.wssadminmsgs");
    private String _name = null;
    private List _algorithmSuite = new ArrayList();
    private List _layout = new ArrayList();
    protected boolean _includeTimestamp = false;

    BindingAssertion() {
    }

    static BindingAssertion getInstance(String name, NestedPolicyType nestedPolicy, boolean sctAllowed) {
        BindingAssertion assertion = null;
        if ("AsymmetricBinding".equals(name)) {
            assertion = new AsymmetricBinding();
        } else if ("SymmetricBinding".equals(name)) {
            assertion = new SymmetricBinding();
        } else {
            Tr.warning(tc, "CWWSI9002W", new Object[]{name, "Top level assertions"});
            return null;
        }
        assertion.parsePolicy(nestedPolicy.getPolicy(), sctAllowed);
        assertion.setName(name);
        return assertion;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    abstract void parsePolicy(Policy var1, boolean var2);

    void parseObject(JAXBElement element) {
        Object obj = element.getValue();
        if (obj instanceof QNameAssertionType) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse include time stamp");
            }
            if ("IncludeTimestamp".equals(element.getName().getLocalPart())) {
                this._includeTimestamp = true;
            }
        } else if (obj instanceof NestedPolicyType) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse algorithm suite and layout");
            }
            String name = element.getName().getLocalPart();
            NestedPolicyType np = (NestedPolicyType)element.getValue();
            List<Object> list = np.getPolicy().getPolicyOrAllOrExactlyOne();
            Object oneObj2 = null;
            for (Object oneObj2 : list) {
                if (oneObj2 instanceof JAXBElement) {
                    JAXBElement attribute = (JAXBElement)oneObj2;
                    String assertion = attribute.getName().getLocalPart();
                    if ("AlgorithmSuite".equals(name)) {
                        this._algorithmSuite.add(assertion);
                        continue;
                    }
                    if (!"Layout".equals(name)) continue;
                    this._layout.add(assertion);
                    continue;
                }
                Tr.warning(tc, "CWWSI9001W", new Object[]{oneObj2.getClass().getName(), this._name});
            }
        } else {
            Tr.warning(tc, "CWWSI9001W", new Object[]{obj.getClass().getName(), this._name});
        }
    }

    AttributeList getAttributes() {
        AttributeList list = new AttributeList();
        if (!this._algorithmSuite.isEmpty()) {
            AttributeList suiteList = new AttributeList();
            Iterator items = this._algorithmSuite.iterator();
            while (items.hasNext()) {
                suiteList.add(new Attribute((String)items.next(), "true"));
            }
            list.add(new Attribute("AlgorithmSuite", suiteList));
        }
        if (!this._layout.isEmpty()) {
            list.add(new Attribute("Layout", this._layout.get(0)));
        }
        if (this._includeTimestamp) {
            list.add(new Attribute("IncludeTimestamp", "true"));
        }
        return list;
    }
}

