/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.wsmex.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.attachment.WSDLPostProcessorExtended;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.xml.sax.InputSource;

public class WSDLDataLocator
implements AxisDataLocator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLDataLocator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final HashMap<String, Data[]> _resultCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws DataRetrievalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getData");
        }
        if (msgContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData with exception. MessageContext is null");
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{null});
            String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{null}, null);
            DataRetrievalException dre = new DataRetrievalException(msgStr);
            dre.addReason(msgStr);
            throw dre;
        }
        if (!request.getOutputForm().getType().equals(OutputForm.INLINE_FORM.getType())) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData returning null.  OutputForm Type is " + request.getOutputForm().getType());
            }
            return null;
        }
        EndpointReference epr = msgContext.getTo();
        String address = null;
        if (epr != null) {
            address = epr.getAddress();
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "null epr");
        }
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData with exception. AxisService is null");
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{address});
            String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{address}, null);
            DataRetrievalException dre = new DataRetrievalException(msgStr);
            dre.addReason(msgStr);
            throw dre;
        }
        QName serviceQName = null;
        Parameter parameter = service.getParameter("WSDL_SERVICE_QNAME");
        if (parameter == null) {
            parameter = service.getParameter("WSDL_SERVICE_QNAME");
        }
        if (parameter != null) {
            serviceQName = (QName)parameter.getValue();
        }
        Parameter appNameParam = service.getAxisConfiguration().getParameter("ApplicationName");
        String appName = (String)appNameParam.getValue();
        Parameter modNameParam = service.getAxisConfiguration().getParameter("ModuleName");
        String modName = (String)modNameParam.getValue();
        String resourceRef = "WebService:/" + modName + ":" + serviceQName;
        Data[] result = this.fetchResultHolderFromCache(resourceRef);
        Data[] resultClone = null;
        Data[] dataArray = result;
        synchronized (result) {
            Definition outputWSDLDefinition;
            ByteArrayOutputStream outputStream;
            WSDLWriter wsdlWriter;
            WSDLFactory wsdlFactory;
            if (result[0] != null) {
                resultClone = this.cloneDataArray(result);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getData returning cached value", resultClone);
                }
                // ** MonitorExit[var15_19] (shouldn't be in output)
                return resultClone;
            }
            boolean useSeperateCopy = true;
            Parameter p2 = service.getParameter("wsdl4jDefinition");
            if (useSeperateCopy) {
                Definition originalDefinition = (Definition)p2.getValue();
                try {
                    wsdlFactory = WSDLFactory.newInstance();
                    wsdlWriter = wsdlFactory.newWSDLWriter();
                    outputStream = new ByteArrayOutputStream();
                    String baseURI = originalDefinition.getDocumentBaseURI();
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "documentBaseURI is ", baseURI);
                    }
                    wsdlWriter.writeWSDL(originalDefinition, outputStream);
                    WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                    ByteArrayInputStream bais = new ByteArrayInputStream(outputStream.toByteArray());
                    InputSource is = new InputSource(bais);
                    outputWSDLDefinition = wsdlReader.readWSDL(baseURI, is);
                    WSDLPostProcessorExtended postProc = WSPolicyInternalFactory.singleton.createWSDLPostProcessorExtended();
                    postProc.postProcessWSDL(outputWSDLDefinition, appName, modName, serviceQName, service, address);
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "getData exception ", e);
                    }
                    Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{serviceQName});
                    String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{serviceQName}, null);
                    DataRetrievalException dre = new DataRetrievalException(msgStr);
                    dre.addReason(msgStr);
                    throw dre;
                }
            } else {
                outputWSDLDefinition = (Definition)p2.getValue();
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getData output wsdlDefinition", outputWSDLDefinition);
            }
            StAXOMBuilder builder = null;
            try {
                wsdlFactory = WSDLFactory.newInstance();
                wsdlWriter = wsdlFactory.newWSDLWriter();
                outputStream = new ByteArrayOutputStream();
                wsdlWriter.writeWSDL(outputWSDLDefinition, outputStream);
                builder = new StAXOMBuilder(new ByteArrayInputStream(outputStream.toByteArray()));
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getData exception ", e);
                }
                Tr.warning(TRACE_COMPONENT, "CWPOL1250", new Object[]{serviceQName});
                String msgStr = nls.getFormattedMessage("CWPOL1250", new Object[]{serviceQName}, null);
                DataRetrievalException dre = new DataRetrievalException(msgStr);
                dre.addReason(msgStr);
                throw dre;
            }
            OMElement wsdlElement = builder.getDocumentElement();
            result[0] = new Data(wsdlElement, serviceQName.toString());
            resultClone = this.cloneDataArray(result);
            // ** MonitorExit[var15_19] (shouldn't be in output)
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getData", resultClone);
            }
            return resultClone;
        }
    }

    private final Data[] cloneDataArray(Data[] result) {
        Data copyData = new Data(((OMElement)result[0].getData()).cloneOMElement(), result[0].getIdentifier());
        Data[] copyResult = new Data[]{copyData};
        return copyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Data[] fetchResultHolderFromCache(String resourceRef) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fetchResultHolderFromCache", resourceRef);
        }
        HashMap<String, Data[]> hashMap = _resultCache;
        synchronized (hashMap) {
            Data[] dataArray = _resultCache.get(resourceRef);
            if (dataArray == null) {
                dataArray = new Data[1];
                _resultCache.put(resourceRef, dataArray);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "fetchResultHolderFromCache");
            }
            return dataArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearResultHolderFromCache(String resourceRef) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "clearResultHolderFromCache", resourceRef);
        }
        HashMap<String, Data[]> hashMap = _resultCache;
        synchronized (hashMap) {
            _resultCache.remove(resourceRef);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "clearResultHolderFromCache");
        }
    }
}

