/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.wsmex.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wspolicy.WSPolicyInvalidMexConfig;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import com.ibm.ws.wspolicy.wsmex.server.WSDLDataLocator;
import com.ibm.ws.wspolicy.wsmex.server.WSPolicyConfigPluginHelper;
import com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol.WSMexResourceEndpoint;
import com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol.WSPolicyServiceControlReference;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultWSPolicyConfigPluginHelper implements WSPolicyConfigPluginHelper
{
    singleton;

    private final TraceComponent TRACE_COMPONENT = Tr.register(DefaultWSPolicyConfigPluginHelper.getMyClass(), "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    private static Class getMyClass() {
        return DefaultWSPolicyConfigPluginHelper.class;
    }

    @Override
    public void mexAttach(HashMap hm) throws DeploymentException, AxisFault {
        block37: {
            Boolean isServer;
            if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(this.TRACE_COMPONENT, "mexAttach", hm);
            }
            if ((isServer = (Boolean)hm.get("com.ibm.wsspi.websvcs.ServerSideKey")) == null || !isServer.booleanValue()) {
                if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(this.TRACE_COMPONENT, "mexAttach - not server side", hm);
                }
                return;
            }
            AxisService as = (AxisService)hm.get("com.ibm.wsspi.websvcs.AxisServiceKey");
            boolean isMexSupported = false;
            WSPolicyServiceControlReference scRef = null;
            if (as != null) {
                Parameter appNameParam;
                String appName;
                String cuName;
                if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(this.TRACE_COMPONENT, "AxisService found: " + as);
                }
                if ((cuName = (String)hm.get("com.ibm.wsspi.websvcs.CUName")) != null && !cuName.equals("")) {
                    as.addParameter("com.ibm.ws.wspolicy.PolicyConstants.Axis2Service_CUName_Key", cuName);
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(this.TRACE_COMPONENT, "mexAttach - invoked in a CU", hm);
                    }
                    return;
                }
                QName serviceQName = null;
                Parameter parameter = as.getParameter("WSDL_SERVICE_QNAME");
                if (parameter == null) {
                    parameter = as.getParameter("WSDL_SERVICE_QNAME");
                }
                if (parameter != null) {
                    serviceQName = (QName)parameter.getValue();
                }
                if ((appName = (String)(appNameParam = as.getAxisConfiguration().getParameter("ApplicationName")).getValue()) == null || appName.equals("")) {
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(this.TRACE_COMPONENT, "config - application name is null");
                    }
                    return;
                }
                Parameter modNameParam = as.getAxisConfiguration().getParameter("ModuleName");
                String modName = (String)modNameParam.getValue();
                String resourceRef = "WebService:/" + modName + ":" + serviceQName;
                WSDLDataLocator.clearResultHolderFromCache(resourceRef);
                if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(this.TRACE_COMPONENT, "Testing if WS-Mex is supported for resourceRef", resourceRef);
                }
                String policySetAttachmentPath = null;
                try {
                    FileLocator locator = FileLocatorFactory.getFileLocator();
                    String path = locator.getAttachmentPath(appName, "wsPolicyServiceControl.xml");
                    policySetAttachmentPath = locator.getAttachmentPath(appName, "policyAttachments.xml");
                    WSPolicyServiceControlHelper scHelper = WSPolicyServiceControlHelperFactory.createHelper(path, policySetAttachmentPath);
                    scRef = scHelper.getWSPolicyServiceControlReferenceInherited(resourceRef);
                    if (scRef != null && scRef.getWSMexSupported() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(this.TRACE_COMPONENT, "WS-Mex is supported");
                        }
                        isMexSupported = true;
                    }
                }
                catch (FileNotFoundException ioe) {
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(this.TRACE_COMPONENT, "no policy service control file exists");
                    }
                    return;
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(this.TRACE_COMPONENT, "caught Exception whilst using the service control file", e);
                    }
                    Tr.warning(this.TRACE_COMPONENT, "CWPOL1030", new Object[]{serviceQName, policySetAttachmentPath});
                }
                if (!isMexSupported) {
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(this.TRACE_COMPONENT, "config with no mex support");
                    }
                    return;
                }
                try {
                    AxisModule module;
                    AxisConfiguration axisCfg = as.getAxisConfiguration();
                    HashMap mods = axisCfg.getModules();
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(this.TRACE_COMPONENT, "modules" + mods.toString());
                    }
                    if ((module = axisCfg.getModule("WSPolicyServerMex")) != null) {
                        if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(this.TRACE_COMPONENT, "module WSPolicyServerMex found in configuration - engaging");
                        }
                        as.engageModule(axisCfg.getModule("WSPolicyServerMex"));
                        try {
                            as.addDataLocatorClassNames("http://schemas.xmlsoap.org/wsdl/", "com.ibm.ws.wspolicy.wsmex.server.WSDLDataLocator");
                            this.addPolicyToMexOp(as, scRef);
                            break block37;
                        }
                        catch (WSPolicyInvalidMexConfig imc) {
                            int partType = imc.getInvalidPartType();
                            switch (partType) {
                                case 1: {
                                    Tr.warning(this.TRACE_COMPONENT, "CWPOL1010", new Object[]{imc.getPolicySetName(), serviceQName});
                                    break;
                                }
                                case 2: {
                                    Tr.warning(this.TRACE_COMPONENT, "CWPOL1011", new Object[]{imc.getBindingsName(), serviceQName});
                                    break;
                                }
                                default: {
                                    Tr.warning(this.TRACE_COMPONENT, "CWPOL1012", new Object[]{imc.getPolicySetName(), imc.getBindingsName(), serviceQName});
                                }
                            }
                            FFDCFilter.processException((Throwable)imc, this.getClass() + ".mexAttach", "198", this);
                            if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(this.TRACE_COMPONENT, "exception manipulating mex - disengage the mex module", imc);
                            }
                            as.disengageModule(axisCfg.getModule("WSPolicyServerMex"));
                            break block37;
                        }
                        catch (Throwable t) {
                            if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(this.TRACE_COMPONENT, "exception manipulating mex - disengage the mex module", t);
                            }
                            as.disengageModule(axisCfg.getModule("WSPolicyServerMex"));
                            throw t;
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(this.TRACE_COMPONENT, "module WSPolicyServerMex not found in configuration");
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !this.TRACE_COMPONENT.isDebugEnabled()) break block37;
                    Tr.debug(this.TRACE_COMPONENT, "config caught exception " + t);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(this.TRACE_COMPONENT, "mexAttach");
        }
    }

    private void addPolicyToMexOp(AxisService as, WSPolicyServiceControlReference scRef) throws WSPolicyInvalidMexConfig, AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(this.TRACE_COMPONENT, "addPolicyToMexOp", scRef);
        }
        WSMexResourceEndpoint wsmre = scRef.getWSMexSupported();
        String policyName = wsmre.getPolicySetName();
        String bindingName = wsmre.getPolicySetBinding();
        if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isDebugEnabled()) {
            if (policyName != null) {
                Tr.debug(this.TRACE_COMPONENT, "Working with psn " + policyName + " and bn " + bindingName);
            } else {
                Tr.debug(this.TRACE_COMPONENT, "Working with null psn");
            }
        }
        PolicySetConfiguration psc = null;
        if (policyName != null) {
            ClassLoader appCL = this.getClass().getClassLoader();
            ClassLoader systemCL = this.getClass().getClassLoader();
            String rootDir = this.getBindingRootDirForApplication(as);
            boolean isClient = false;
            psc = this.resolvePolicySetAndBindingForMex(policyName, bindingName, appCL, systemCL, false, rootDir);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(this.TRACE_COMPONENT, "addPolicyToMexOp no policy to add");
            }
            psc = new PolicySetConfigurationImpl();
        }
        QName mexQName = new QName("getMetadata", "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request");
        AxisOperation mexOp = as.getOperation(mexQName);
        Parameter mex_param = new Parameter();
        mex_param.setName("WASAxis2PolicySet");
        mex_param.setValue(psc);
        mexOp.addParameter(mex_param);
    }

    private String getBindingRootDirForApplication(AxisService as) {
        Parameter appNameParam = as.getAxisConfiguration().getParameter("ApplicationName");
        String appName = (String)appNameParam.getValue();
        FileLocator fileLoc = FileLocatorFactory.getFileLocator();
        String fileToFind = "wsPolicyServiceControl.xml";
        String _applicationPath = fileLoc.getAttachmentPath(appName, "wsPolicyServiceControl.xml");
        String rootDir = _applicationPath.substring(0, _applicationPath.length() - "wsPolicyServiceControl.xml".length() - 1);
        return rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PolicySetConfiguration resolvePolicySetAndBindingForMex(String policyName, String bindingName, ClassLoader appCL, ClassLoader systemCL, boolean isClient, String rootDir) throws WSPolicyInvalidMexConfig {
        if (TraceComponent.isAnyTracingEnabled() && this.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(this.TRACE_COMPONENT, "resolvePolicySetAndBindingForMex", new Object[]{policyName, bindingName, appCL, systemCL, isClient, rootDir});
        }
        psConfig = new PolicySetConfigurationImpl();
        policyTypes = null;
        try {
            policyTypes = PolicySetAttachmentsImpl.getTypesForPolicySet(policyName);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() == false) throw new WSPolicyInvalidMexConfig(policyName, bindingName, 1);
            if (this.TRACE_COMPONENT.isDebugEnabled() == false) throw new WSPolicyInvalidMexConfig(policyName, bindingName, 1);
            Tr.exit(this.TRACE_COMPONENT, "exception getting types for PolicySet", new Object[]{policyName, e});
            throw new WSPolicyInvalidMexConfig(policyName, bindingName, 1);
        }
        if (!policyTypes.contains("WSSecurity")) {
            Tr.info(this.TRACE_COMPONENT, "CWPOL0013", new Object[]{policyName});
        }
        extensions = PolicyTypeAggregator.getExtensions();
        policyTypeConfig = null;
        variableExpander = VariableExpanderFactory.getVariableExpander();
        iter = extensions.iterator();
        try {
            while (iter.hasNext()) {
                loader = (PolicyTypeLoader)iter.next();
                policyType = null;
                policyType = loader.getType();
                if (policyTypes != null && policyTypes.contains(policyType)) {
                    try {
                        policyTypeConfig = PolicyTypeAggregator.getPolicyTypeInputStream(policyName, policyType);
                        if (this.TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(this.TRACE_COMPONENT, "About to call load on " + loader.getClass().getName());
                        }
                        loader.load(systemCL, variableExpander, policyTypeConfig, psConfig);
                        if (this.TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(this.TRACE_COMPONENT, "Back from load on " + loader.getClass().getName());
                        }
                        var16_18 = null;
                    }
                    catch (Throwable var15_20) {
                        var16_18 = null;
                        try {
                            if (policyTypeConfig == null) throw var15_20;
                            policyTypeConfig.close();
                            throw var15_20;
                        }
                        catch (IOException ioe) {
                            if (this.TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(this.TRACE_COMPONENT, "IOException closing policyType inputStream", ioe);
                            }
                            FFDCFilter.processException(ioe, "IOException closing policyType inputStream,", "351");
                        }
                        throw var15_20;
                    }
                    ** try [egrp 3[TRYBLOCK] [3 : 359->372)] { 
lbl48:
                    // 1 sources

                    if (policyTypeConfig == null) continue;
                    policyTypeConfig.close();
lbl51:
                    // 1 sources

                    catch (IOException ioe) {
                        if (this.TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(this.TRACE_COMPONENT, "IOException closing policyType inputStream", ioe);
                        }
                        FFDCFilter.processException(ioe, "IOException closing policyType inputStream,", "351");
                    }
                    continue;
                }
                if (!this.TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(this.TRACE_COMPONENT, "Policy type is not included in policy set: " + policyType);
            }
        }
        catch (Exception e) {
            throw new WSPolicyInvalidMexConfig(policyName, bindingName, 0);
        }
        if (isClient) {
            psConfig.setPolicyTypeConfiguration("attachmentType", "client");
        } else {
            psConfig.setPolicyTypeConfiguration("attachmentType", "application");
        }
        bindingScope = "domain";
        if (this.TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(this.TRACE_COMPONENT, "Loading bindings for " + policyName + " " + bindingName);
        }
        try {
            BindingAggregator.getCustomBinding(rootDir, bindingName, appCL, systemCL, psConfig, policyTypes, isClient != false ? "client" : "application", bindingScope);
        }
        catch (Exception e) {
            throw new WSPolicyInvalidMexConfig(policyName, bindingName, 2);
        }
        if (this.TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(this.TRACE_COMPONENT, "Done loading bindings for " + policyName + " " + bindingName);
        }
        if (TraceComponent.isAnyTracingEnabled() == false) return psConfig;
        if (this.TRACE_COMPONENT.isEntryEnabled() == false) return psConfig;
        Tr.exit(this.TRACE_COMPONENT, "resolvePolicySetAndBindingForMex", psConfig);
        return psConfig;
    }
}

