/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.BothAssertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.ws.wspolicy.wsdl.PolicyElementComparator;
import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.Operator;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.wsdl.UnknownWSDLElementException;
import com.ibm.wspolicy.wsdl.WSDLPolicyModel;
import com.ibm.wspolicy.wsdl.factory.WSPolicyWSDLProcessingFactory;
import com.ibm.wspolicy.xml.UnsupportedPolicyNamespaceException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLProcessor {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLProcessor.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Definition _definition;
    WSPolicyFactory wpf;
    WSPolicyWSDLProcessingFactory policywsdlfactory;
    com.ibm.wspolicy.wsdl.WSDLProcessor processor;
    WSDLPolicyModel model;
    String _obtainedFromAddress;

    public WSDLProcessor(WSPolicyFactory wspf, Definition definition) throws PolicyReferenceException, UnsupportedNamespaceException, WSPolicyException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EffectivePolicyWSDLEngine", definition);
        }
        this.wpf = wspf;
        this.policywsdlfactory = WSPolicyWSDLProcessingFactory.newInstance(this.wpf);
        this.processor = this.policywsdlfactory.createWSDLProcessor();
        try {
            this.model = this.processor.buildWSDLPolicyModel(definition);
        }
        catch (UnsupportedPolicyNamespaceException e) {
            throw new UnsupportedNamespaceException(null);
        }
        if (this.model.getPoliciesWithUnresolvedReferences().size() > 0) {
            Map<Policy, Set<PolicyReference>> failed = this.model.getPoliciesWithUnresolvedReferences();
            for (Set<PolicyReference> prs : failed.values()) {
                Iterator<PolicyReference> i$ = prs.iterator();
                if (!i$.hasNext()) continue;
                PolicyReference pr = i$.next();
                throw new PolicyReferenceException(pr.getURI());
            }
        }
        this._definition = definition;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EffectivePolicyWSDLEngine");
        }
    }

    public Definition getDefinition() {
        return this._definition;
    }

    public Policy getProviderEffectivePolicy(QName serviceQName, String portName, String operationName) throws PolicyReferenceException, WSPolicyException, WSPolicyFormattedException {
        Policy result = this.wpf.createDataModelFactory().createPolicy();
        try {
            List<Policy> servicePolicies = this.model.getServiceAttachedPolicies(serviceQName);
            result.getChildren().addAll(servicePolicies);
            if (portName != null) {
                List<Policy> endpointPolicies = this.model.getEndpointAttachedPolicies(serviceQName, portName);
                result.getChildren().addAll(endpointPolicies);
            }
        }
        catch (UnknownWSDLElementException e) {
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0006", new Object[]{this._obtainedFromAddress}, "CWPOL0006"), null);
        }
        if (operationName != null) {
            List<Policy> operationPolicies = this.model.getOperationAttachedPolicies(serviceQName, portName, operationName);
            result.getChildren().addAll(operationPolicies);
        }
        return result;
    }

    public Policy getInputMessageEffectivePolicy(QName serviceQName, String portName, String operationName) throws PolicyReferenceException, WSPolicyException, UnknownWSDLElementException, WSPolicyInternalException {
        List<String> ports;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getInputMessageEffectivePolicy", new Object[]{serviceQName, portName, operationName});
        }
        if (!(ports = this.getPortNames(serviceQName)).contains(portName)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        String opName = null;
        List<String> ops = this.getOperationNames(serviceQName, portName);
        if (ops.size() == 1) {
            opName = ops.get(0);
        } else if (ops.contains(operationName)) {
            opName = operationName;
        } else if (ops.size() > 0 && operationName == null) {
            boolean allSame = true;
            Policy last = null;
            for (String currentOp : ops) {
                List<Policy> policies = this.model.getRequestAttachedPolicies(serviceQName, portName, currentOp);
                Policy result = this.wpf.createDataModelFactory().createPolicy();
                result.getChildren().addAll(policies);
                if (last != null) {
                    allSame = PolicyElementComparator.compare(last, result);
                }
                if (!allSame) break;
                last = result;
            }
            if (allSame) {
                opName = ops.get(0);
            }
        }
        Policy result = null;
        if (opName != null) {
            List<Policy> policies = this.model.getRequestAttachedPolicies(serviceQName, portName, opName);
            result = this.wpf.createDataModelFactory().createPolicy();
            result.getChildren().addAll(policies);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getInputMessageEffectivePolicy", result);
        }
        return result;
    }

    public Policy getOutputMessageEffectivePolicy(QName serviceQName, String portName, String operationName) throws PolicyReferenceException, WSPolicyException, WSPolicyInternalException, UnknownWSDLElementException {
        List<String> ports;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getOutputMessageEffectivePolicy", new Object[]{serviceQName, portName, operationName});
        }
        if (!(ports = this.getPortNames(serviceQName)).contains(portName)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        String opName = null;
        List<String> ops = this.getOperationNames(serviceQName, portName);
        if (ops.size() == 1) {
            opName = ops.get(0);
        } else if (ops.contains(operationName)) {
            opName = operationName;
        } else if (ops.size() > 0 && operationName == null) {
            boolean allSame = true;
            Policy last = null;
            for (String currentOp : ops) {
                List<Policy> policies = this.model.getResponseAttachedPolicies(serviceQName, portName, currentOp);
                Policy result = this.wpf.createDataModelFactory().createPolicy();
                result.getChildren().addAll(policies);
                if (last != null) {
                    allSame = PolicyElementComparator.compare(last, result);
                }
                if (!allSame) break;
                last = result;
            }
            if (allSame) {
                opName = ops.get(0);
            }
        }
        Policy result = null;
        if (opName != null) {
            List<Policy> policies = this.model.getResponseAttachedPolicies(serviceQName, portName, opName);
            result = this.wpf.createDataModelFactory().createPolicy();
            result.getChildren().addAll(policies);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getOutputMessageEffectivePolicy", result);
        }
        return result;
    }

    public boolean containsPolicy() {
        return this.model.hasAttachedPolicy();
    }

    public List<String> getOperationNames(QName serviceQName, String portName) {
        return this.model.getOperationNames(serviceQName, portName);
    }

    public List<String> getPortNames(QName serviceQName) {
        return this.model.getPortNames(serviceQName);
    }

    public String getWSDL() {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            writer.writeWSDL(this._definition, stringWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((Object)stringWriter).toString();
    }

    private Set<QName> getUnsupportedVocabulary(Policy p) {
        HashSet<QName> result = new HashSet<QName>();
        this.populateUnsupportedVocabularySet(p, result);
        return result;
    }

    private void populateUnsupportedVocabularySet(PolicyElement pe, Set<QName> set) {
        if (pe instanceof com.ibm.wspolicy.datamodel.Assertion) {
            com.ibm.wspolicy.datamodel.Assertion a;
            PolicyProviderRegistry ppr = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry();
            WSPolicyAssertionProcessor wspap = ppr.findSupportingWSPolicyProcessor((a = (com.ibm.wspolicy.datamodel.Assertion)pe).getName());
            if (wspap != null) {
                Policy nestedPolicy = a.getNestedPolicy();
                if (nestedPolicy != null) {
                    this.populateUnsupportedVocabularySet(nestedPolicy, set);
                }
                if (ppr.hasSupportBehavior(a.getName())) {
                    Assertion oldass = null;
                    oldass = a instanceof Assertion ? (Assertion)((Object)a) : new BothAssertion(this.wpf.createDataModelFactory(), a);
                    try {
                        if (!wspap.supports(oldass, null)) {
                            set.add(a.getName());
                        }
                    }
                    catch (Exception e) {
                        set.add(a.getName());
                    }
                }
            } else {
                set.add(a.getName());
            }
        } else if (pe instanceof Operator) {
            Operator op = (Operator)pe;
            for (PolicyElement p : op.getChildren()) {
                this.populateUnsupportedVocabularySet(p, set);
            }
        }
    }

    public String getUnsupportedAssertions() {
        List<Policy> policies = this.model.getAllAttachedPolicies();
        String retval = "";
        HashSet<QName> allq = new HashSet<QName>();
        for (Policy p : policies) {
            Set<QName> qns = this.getUnsupportedVocabulary(p);
            allq.addAll(qns);
        }
        for (QName q : allq) {
            retval = retval + " " + q;
        }
        return "Unsupported Assertion List: " + retval;
    }

    public void setObtainedFromAddress(String address) {
        this._obtainedFromAddress = address;
    }

    public String getObtainedFromAddress() {
        return this._obtainedFromAddress;
    }
}

