/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExtensibleElement;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class PolicyElementComparator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyElementComparator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    public static final String WSPOLICY_NAMESPACE_W3C_RECOMMENDED = "http://www.w3.org/ns/ws-policy";
    public static final String WSPOLICY_NAMESPACE_W3C_SUBMISSION = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String WSPOLICY_NAMESPACE = "http://www.w3.org/ns/ws-policy";
    static final String TAG_XMLNS = "xmlns".intern();

    private static int calcHashForAssertion(Assertion a) throws WSPolicyException {
        QName aname = a.getName();
        String bigStr = aname.toString();
        int baseHash = 0;
        if (a.getNestedPolicy() != null) {
            baseHash = PolicyElementComparator.calcHashForPolicy(a.getNestedPolicy());
        }
        List<ExtensibleElement> lee = a.getElementParameters();
        for (ExtensibleElement ee : lee) {
            Node n = ee.getNode();
            if (n == null || n.getNodeType() == 3 && n.getTextContent().trim().length() == 0) continue;
            try {
                DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
                LSSerializer writer = impl.createLSSerializer();
                String str = writer.writeToString(n);
                bigStr = bigStr + str;
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "calcHashForAssertion caught Exception ", e);
                }
                FFDCFilter.processException(e, "com.ibm.ws.wspolicy.wsdl.PolicyElementComparator.calcHashForAssertion", "109");
                throw new WSPolicyException();
            }
        }
        Map<QName, String> attrparms = a.getAttributeParameters();
        for (Map.Entry<QName, String> entry : attrparms.entrySet()) {
            QName name = entry.getKey();
            String val = entry.getValue();
            if (name.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy") || name.getNamespaceURI().equals(TAG_XMLNS)) continue;
            bigStr = bigStr + (name + val).toUpperCase();
        }
        bigStr = bigStr + "wsp:optional" + a.isOptional();
        bigStr = bigStr + "wsp:ignorable" + a.isIgnorable();
        return bigStr.hashCode() ^ baseHash;
    }

    private static int calcHashForPolicy(Policy p) throws WSPolicyException {
        int retVal = 0;
        Map<QName, String> attrmap = p.getOtherAttributes();
        if (attrmap != null && attrmap.entrySet() != null) {
            for (Map.Entry<QName, String> entry : attrmap.entrySet()) {
                QName name = entry.getKey();
                String value = entry.getValue();
                if (name.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy") || name.getNamespaceURI().equals(TAG_XMLNS)) continue;
                retVal ^= (name + value).toUpperCase().hashCode();
            }
        }
        WSPolicyFactory wspf = WSPolicyFactory.newInstance();
        PolicyProcessor ap = wspf.createWSPolicyProcessor();
        Iterable<PolicyProcessor.Alternative> ac = ap.getAlternatives(p);
        ac.iterator();
        for (PolicyProcessor.Alternative tAlt : ac) {
            int altHashCode = PolicyElementComparator.calcHashForAlternative(tAlt);
            retVal ^= altHashCode;
        }
        return retVal;
    }

    public static boolean compare(Policy p1, Policy p2) throws WSPolicyException {
        return PolicyElementComparator.calcHashForPolicy(p1) == PolicyElementComparator.calcHashForPolicy(p2);
    }

    public static boolean compare(Assertion a1, Assertion a2) throws WSPolicyException {
        return PolicyElementComparator.calcHashForAssertion(a1) == PolicyElementComparator.calcHashForAssertion(a2);
    }

    private static int calcHashForAlternative(PolicyProcessor.Alternative a) throws WSPolicyException {
        Vector<Integer> hashCodes = new Vector<Integer>();
        List<Assertion> asserts = a.getAssertions();
        for (int i = 0; i < asserts.size(); ++i) {
            Assertion tA = asserts.get(i);
            int tcode = PolicyElementComparator.calcHashForAssertion(tA);
            hashCodes.add(tcode);
        }
        Object[] sortedHashCodes = hashCodes.toArray();
        Arrays.sort(sortedHashCodes);
        StringBuffer hashBase = new StringBuffer();
        for (int j = 0; j < sortedHashCodes.length; ++j) {
            hashBase.append(sortedHashCodes[j].toString());
        }
        int retVal = hashBase.toString().hashCode();
        return retVal;
    }

    public static boolean compare(PolicyProcessor.Alternative a1, PolicyProcessor.Alternative a2) throws WSPolicyException {
        return PolicyElementComparator.calcHashForAlternative(a1) == PolicyElementComparator.calcHashForAlternative(a2);
    }
}

