/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.WSPolicyIncompatiblePolicyAttachments;
import com.ibm.ws.wspolicy.WSPolicyIncorrectScopePointAttachment;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.PolicySetWrapper;
import com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper;
import com.ibm.wspolicy.datamodel.Policy;
import java.util.HashMap;
import java.util.Set;
import javax.wsdl.Definition;

public class WSDLTreeNode {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLTreeNode.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    WSDLTreeNode _parent = null;
    HashMap<String, WSDLTreeNode> _children = new HashMap();
    HashMap<String, PolicySetWrapper> _policySetWrappersAtScope = new HashMap();
    PolicySetWrapper _leafPolicySetWrapper = null;
    boolean _containsNull = false;
    HashMap<Integer, WSDLNodeWrapper> _nodeWrappers = new HashMap();
    String _key = null;
    Policy _policy = null;
    int _policySubject = -1;
    public static final int POLICY_SUBJECT_UNDEFINED = -1;
    public static final int POLICY_SUBJECT_SERVICE = 0;
    public static final int POLICY_SUBJECT_ENDPOINT = 1;
    public static final int POLICY_SUBJECT_OPERATION = 2;
    public static final int POLICY_SUBJECT_MESSAGE = 3;
    public static final int POLICY_SUBJECT_SIZE = 4;

    public WSDLTreeNode(String key, int policySubject) {
        this._key = key;
        this._policySubject = policySubject;
    }

    public void addWSDLNodeWrapper(WSDLNodeWrapper wsdlNodeWrapper, int attachPoint) {
        this._nodeWrappers.put(attachPoint, wsdlNodeWrapper);
    }

    public void addPolicy(Policy policy, int attachPoint, String policySetWrapperName) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException {
        int policySubject = WSDLTreeNode.attachPoint2PolicySubject(attachPoint);
        if (policySubject == -1) {
            WSPolicyIncorrectScopePointAttachment wspispa = new WSPolicyIncorrectScopePointAttachment(policy == null ? "" : policy);
            FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.utils.WSDLTreeNode.addPolicy", "93", this);
            throw wspispa;
        }
        if (WSDLTreeNode.attachPoint2PolicySubject(attachPoint) == this._policySubject) {
            WSDLNodeWrapper nodeWrapper = this._nodeWrappers.get(attachPoint);
            if (nodeWrapper != null) {
                nodeWrapper.addPolicy(policy, policySetWrapperName);
            }
        } else if (WSDLTreeNode.attachPoint2PolicySubject(attachPoint) < this._policySubject) {
            this._parent.addPolicy(policy, attachPoint, policySetWrapperName);
        } else {
            for (WSDLTreeNode child : this._children.values()) {
                child.addPolicy(policy, attachPoint, policySetWrapperName);
            }
        }
    }

    public PolicySetWrapper getLeafPolicySetWrapper() {
        return this._leafPolicySetWrapper;
    }

    public void addChild(WSDLTreeNode child) {
        this._children.put(child.getKey(), child);
        child.setParentNode(this);
    }

    public WSDLTreeNode getChildNode(String key) {
        return this._children.get(key);
    }

    public WSDLTreeNode getParentNode() {
        return this._parent;
    }

    public HashMap getChildNodes() {
        return this._children;
    }

    public boolean hasAnyChildren() {
        return this._children.size() > 0;
    }

    public String getKey() {
        return this._key;
    }

    public int getPolicySubject() {
        return this._policySubject;
    }

    public void addPolicySetWrapperToScope(PolicySetWrapper psw) {
        if (psw != null) {
            this._policySetWrappersAtScope.put(psw.getName(), psw);
        } else {
            this._containsNull = true;
        }
    }

    public WSDLTreeNode highestNodeWithNoDuplicatePolicySets(WSDLTreeNode currentHighest) {
        if (this.numberOfPolicySetsAtScope() < 2) {
            if (this._parent == null) {
                return this;
            }
            return this._parent.highestNodeWithNoDuplicatePolicySets(this);
        }
        return currentHighest;
    }

    private int numberOfPolicySetsAtScope() {
        Set<String> psws = this._policySetWrappersAtScope.keySet();
        int num = psws.size();
        if (this._containsNull) {
            ++num;
        }
        return num;
    }

    public void tagTreeWithPolicySets(PolicySetWrapper psWrapper) {
        int currentPolicySubject = this.getPolicySubject();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "tagTreeWithPolicySets", new Object[]{currentPolicySubject, psWrapper});
        }
        this._leafPolicySetWrapper = psWrapper;
        this.addPolicySetWrapperToScope(psWrapper);
        if (this._parent != null) {
            this._parent.tagUpTreeWithPolicySets(psWrapper);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "tagTreeWithPolicySets");
        }
    }

    public void tagUpTreeWithPolicySets(PolicySetWrapper psWrapper) {
        int currentPolicySubject = this.getPolicySubject();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "tagTreeWithPolicySets", new Object[]{currentPolicySubject});
        }
        this.addPolicySetWrapperToScope(psWrapper);
        if (this._parent != null) {
            this._parent.tagUpTreeWithPolicySets(psWrapper);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "tagTreeWithPolicySets");
        }
    }

    public void decorateWSDL(Definition definition, String uri) throws WSPolicyInternalException {
        for (WSDLNodeWrapper nodeWrapper : this._nodeWrappers.values()) {
            nodeWrapper.decorateWSDL(definition, uri);
        }
        if (this.hasAnyChildren()) {
            for (WSDLTreeNode child : this._children.values()) {
                child.decorateWSDL(definition, uri);
            }
        }
    }

    public void resolveWSDL() throws WSPolicyInternalException, WSPolicyIncompatiblePolicyAttachments {
        for (WSDLNodeWrapper nodeWrapper : this._nodeWrappers.values()) {
            nodeWrapper.resolvePolicy();
        }
        if (this.hasAnyChildren()) {
            for (WSDLTreeNode child : this._children.values()) {
                child.resolveWSDL();
            }
        }
    }

    private void setParentNode(WSDLTreeNode node) {
        this._parent = node;
    }

    public static int attachPoint2PolicySubject(int attachPoint) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "attachPoint2PolicySubject", new Object[]{attachPoint});
        }
        int result = -1;
        switch (attachPoint) {
            case 0: {
                result = 0;
                break;
            }
            case 1: 
            case 2: {
                result = 1;
                break;
            }
            case 3: {
                result = 2;
                break;
            }
            case 4: 
            case 5: {
                result = 3;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "attachPoint2PolicySubject", new Object[]{result});
        }
        return result;
    }
}

