/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class InternalUtils {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(InternalUtils.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    static final QName WSP_POL_ELEMENT_QNAME = new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.ELEMENT_POLICY);
    static final QName WSP_POLREF_ELEMENT_QNAME = new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.ELEMENT_POLICYREF);

    public static ExtensibilityElement createExtensibilityElement(WSPolicyFactory wspf, Policy policy) throws WSPolicyInternalException {
        try {
            UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
            ElementWriter<Document> ew = wspf.getWriter(Document.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            ew.write(policy, document);
            uee.setElement(document.getDocumentElement());
            uee.setElementType(WSP_POL_ELEMENT_QNAME);
            return uee;
        }
        catch (ParserConfigurationException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createExtensibilityElement caught ParserConfigurationException", e);
            }
            FFDCFilter.processException(e, "com.ibm.ws.wspolicy.utils.InternalUtils.createExtensibilityElement", "77");
            throw new WSPolicyInternalException(e);
        }
        catch (ElementWriterException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createExtensibilityElement caught ElementWriterException", e);
            }
            FFDCFilter.processException(e, "com.ibm.ws.wspolicy.utils.InternalUtils.createExtensibilityElement", "82");
            throw new WSPolicyInternalException(e);
        }
    }

    public static ExtensibilityElement createExtensibilityElement(WSPolicyFactory wspf, PolicyReference policyRef) {
        try {
            UnknownExtensibilityElement uee = new UnknownExtensibilityElement();
            ElementWriter<Document> ew = wspf.getWriter(Document.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            ew.write(policyRef, document);
            uee.setElement(document.getDocumentElement());
            uee.setElementType(WSP_POLREF_ELEMENT_QNAME);
            return uee;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught createExtensibilityElement ", e);
            }
            FFDCFilter.processException(e, "com.ibm.ws.wspolicy.utils.InternalUtils.createExtensibilityElement", "95");
            return null;
        }
    }

    public static Object[] traceStringWSDLNode(String nodeType, QName serviceQName, String portName, String operationName, String messageType) {
        Object[] full = new Object[1];
        String node = nodeType;
        if (serviceQName != null) {
            node = node + "[service:" + serviceQName + "]";
        }
        if (portName != null) {
            node = node + "[port/portType/binding:" + portName + "]";
        }
        if (operationName != null) {
            node = node + "[operation:" + operationName + "]";
        }
        if (messageType != null) {
            node = node + "[" + messageType + "]";
        }
        full[0] = node;
        return full;
    }
}

