/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.PolicyHolder;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionTransformer;
import com.ibm.ws.wspolicy.domain.WSPolicyTransform;
import com.ibm.ws.wspolicy.utils.CoreExceptionMapper;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSPolicyTransformImpl
implements WSPolicyTransform {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyTransformImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final QName RM_ASSERTION_QNAME = new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "RMAssertion");
    private static final QName ADDRESSING_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "Addressing");
    private final PolicyProviderRegistry _ppr;

    public WSPolicyTransformImpl() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSPolicyTransformImpl");
        }
        this._ppr = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSPolicyTransformImpl");
        }
    }

    @Override
    public PolicyInputStreamHolder transform(PolicyInputStreamHolder policy, List<String> transformOptions) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transform");
        }
        PolicyHolder workingPolicy = null;
        try {
            workingPolicy = new PolicyHolder(this._ppr.getWSPolicyFactory(), policy);
        }
        catch (ElementReaderException e) {
            throw new WSPolicyInternalException(e);
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        boolean deNormalize = false;
        if (transformOptions.contains("com.ibm.ws.wspolicy.WSPolicyTransformUtility.Denormalize")) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "DENORMALIZE");
            }
            deNormalize = true;
        }
        PolicyInputStreamHolder result = null;
        try {
            result = workingPolicy.toPolicyInputStreamHolder(deNormalize);
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transform");
        }
        return result;
    }

    @Override
    public InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, Map<String, Object> transformOptions, String policyType) throws WSPolicyInternalException, TransformationException {
        InputStream result;
        WSPolicyAssertionTransformer assertionProcessor;
        block23: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "transformForClientConfiguration");
            }
            if (TRACE_COMPONENT.isDebugEnabled() && policy != null) {
                Tr.debug(TRACE_COMPONENT, "Before transformation Main: " + this.streamToString(policy.getMain()));
                Tr.debug(TRACE_COMPONENT, "Before transformation Input: " + this.streamToString(policy.getInput()));
                Tr.debug(TRACE_COMPONENT, "Before transformation Output: " + this.streamToString(policy.getOutput()));
            }
            if ((assertionProcessor = this._ppr.getAssertionTransformByType(policyType)) == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "AssertionProcessor not found for" + policyType);
                }
                if (policy != null) {
                    return policy.getMain();
                }
                return null;
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Have Policy,Binding and AssertionProcessor");
            }
            if (policy != null && ("WSReliableMessaging".equals(policyType) || "WSAddressing".equals(policyType))) {
                try {
                    All all;
                    ExactlyOne eo;
                    Policy p;
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "WSRM/WSA Workaround active. Remove once domains are corrected.");
                    }
                    String main = this.streamToString(policy.getMain());
                    WSPolicyFactory wspf = WSPolicyFactory.newInstance();
                    ElementReader<String> er = wspf.getReader(String.class);
                    PolicyElement pe = er.read(main);
                    if (pe instanceof Policy && (p = (Policy)pe).getChildren().size() == 1 && p.getChildren().get(0) instanceof ExactlyOne && (eo = (ExactlyOne)p.getChildren().get(0)).getChildren().size() == 1 && eo.getChildren().get(0) instanceof All && (all = (All)eo.getChildren().get(0)).getChildren().size() > 0) {
                        Assertion rmass = null;
                        for (PolicyElement child : all.getChildren()) {
                            if (!(child instanceof Assertion)) continue;
                            Assertion a = (Assertion)child;
                            if (RM_ASSERTION_QNAME.equals(a.getName())) {
                                rmass = a;
                                continue;
                            }
                            if (!ADDRESSING_QNAME.equals(a.getName())) continue;
                            ArrayList<Assertion> nonAddressing = new ArrayList<Assertion>();
                            if (a.getNestedPolicy() == null) continue;
                            Policy np = a.getNestedPolicy();
                            for (PolicyElement nc : np.getChildren()) {
                                Assertion na;
                                if (!(nc instanceof Assertion) || (na = (Assertion)nc).getName().getNamespaceURI() == "http://www.w3.org/2007/05/addressing/metadata") continue;
                                nonAddressing.add(na);
                            }
                            np.getChildren().removeAll(nonAddressing);
                        }
                        if (rmass != null) {
                            all.getChildren().remove(rmass);
                            all.getChildren().add(0, rmass);
                        }
                    }
                    ElementWriter<StringBuffer> ew = wspf.getWriter(StringBuffer.class);
                    StringBuffer sb = new StringBuffer();
                    ew.write(pe, sb);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "WSRM/WSA Workaround gave back " + sb.toString());
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(sb.toString().getBytes());
                    policy.setMain(bais);
                }
                catch (ElementReaderException e) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "WSRM/WSA Workaround failed, this is not fatal", e);
                    }
                }
                catch (ElementWriterException e) {
                    if (!TRACE_COMPONENT.isDebugEnabled()) break block23;
                    Tr.debug(TRACE_COMPONENT, "WSRM/WSA Workaround failed, this is not fatal", e);
                }
            }
        }
        if ((result = assertionProcessor.transformForClientConfiguration(policy, transformOptions)) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor returned null so setting the Main Policy to be the source");
            }
            if (policy != null) {
                result = policy.getMain();
            }
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "After transformation " + this.streamToString(result));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        return result;
    }

    @Override
    public PolicyInputStreamHolder transformForClientIntersection(final InputStream policy, final Map<String, Object> transformOptions, String policyType) throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientIntersection");
        }
        PolicyInputStreamHolder result = null;
        final WSPolicyAssertionTransformer assertionProcessor = this._ppr.getAssertionTransformByType(policyType);
        if (assertionProcessor == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor not found for" + policyType);
            }
            return null;
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Have Policy,Binding and AssertionProcessor");
        }
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<PolicyInputStreamHolder>(){

                @Override
                public PolicyInputStreamHolder run() throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
                    return assertionProcessor.transformForClientIntersection(policy, transformOptions);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof WSPolicyBindingsException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration", e);
                }
                throw (WSPolicyBindingsException)e;
            }
            if (e instanceof TransformationException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration", e);
                }
                throw (TransformationException)e;
            }
            if (e instanceof WSPolicyInternalException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration", e);
                }
                throw (WSPolicyInternalException)e;
            }
            if (e instanceof RuntimeException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration", e);
                }
                throw (RuntimeException)e;
            }
            e = new WSPolicyInternalException(e);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration", e);
            }
            throw (WSPolicyInternalException)e;
        }
        if (result == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor returned null so setting the Main Policy to be the source");
            }
            result = new PolicyInputStreamHolder();
            result.setMain(policy);
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "After transformation Main: " + this.streamToString(result.getMain()));
            Tr.debug(TRACE_COMPONENT, "After transformation Input: " + this.streamToString(result.getInput()));
            Tr.debug(TRACE_COMPONENT, "After transformation Output: " + this.streamToString(result.getOutput()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientIntersection");
        }
        return result;
    }

    @Override
    public PolicyInputStreamHolder transformForPublish(Map<String, Object> transformOptions, String policyType) throws WSPolicyInternalException, WSPolicyBindingsException, TransformationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForPublish");
        }
        PolicyInputStreamHolder result = null;
        WSPolicyAssertionTransformer assertionProcessor = this._ppr.getAssertionTransformByType(policyType);
        if (assertionProcessor == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor not found for" + policyType);
            }
            return null;
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Have Policy,Binding and AssertionProcessor");
        }
        if ((result = assertionProcessor.transformForPublish(transformOptions)) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "AssertionProcessor returned null");
            }
            result = new PolicyInputStreamHolder();
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "After transformation Main: " + this.streamToString(result.getMain()));
            Tr.debug(TRACE_COMPONENT, "After transformation Input: " + this.streamToString(result.getInput()));
            Tr.debug(TRACE_COMPONENT, "After transformation Output: " + this.streamToString(result.getOutput()));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForPublish");
        }
        return result;
    }

    private String streamToString(InputStream policy) {
        String result;
        block3: {
            result = "";
            if (policy != null && policy instanceof ByteArrayInputStream) {
                try {
                    int inBytes = policy.available();
                    byte[] inBuf = new byte[inBytes];
                    policy.read(inBuf, 0, inBytes);
                    result = new String(inBuf);
                    policy.reset();
                }
                catch (IOException e) {
                    if (!TRACE_COMPONENT.isDebugEnabled()) break block3;
                    Tr.debug(TRACE_COMPONENT, "Unable to read the policy InputStream");
                }
            }
        }
        return result;
    }
}

