/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wspolicy.NullPolicyException;
import com.ibm.websphere.wspolicy.PolicyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wspolicy.PolicyHolder;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.UnknownOperationException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPConstants;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.WSPolicySetException;
import com.ibm.ws.wspolicy.acquisition.AcquireViaFile;
import com.ibm.ws.wspolicy.acquisition.AcquireViaMex;
import com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL;
import com.ibm.ws.wspolicy.acquisition.PolicyProvider;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelperFactory;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyTransform;
import com.ibm.ws.wspolicy.policyset.WSPolicyAttachments;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import com.ibm.ws.wspolicy.utils.CoreExceptionMapper;
import com.ibm.ws.wspolicy.wsdl.WSDLProcessor;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.wsdl.UnknownWSDLElementException;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.KeyValuePair;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.ProviderPolicyAcquisition;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.WSPolicyClientControlReference;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSPolicyProcessorImpl
implements WSPolicyProcessor {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyProcessorImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private boolean _wsPolicyProcessingRequired = false;
    private HashMap<String, WSDLProcessor> _wsdlProcessors;
    private WSPolicyFactory _factory;
    private DataModelUtility _dmu;
    private PolicyProcessor _bpp;
    private PolicyProcessor _ap;
    private PolicyProviderRegistry _ppr;
    private PolicyProcessor.FilterType iterationType = PolicyProcessor.FilterType.SUPPORTED;
    private boolean isStrictMode = false;
    private HashMap<String, Policy> _scopedRequesterPolicies;
    private HashMap<String, PolicyHolder> _calculatedPolicies;
    private HashMap<String, Object> _acquiredDefinitions = new HashMap();
    private String _clientControllerFileName;
    private WSPolicyClientControlHelper _clientController;
    private boolean _processingHalted;
    private HashMap<String, PolicyHolder> _sourceCache;
    private final Map<String, Set<QName>> _vocabs = new ConcurrentHashMap<String, Set<QName>>();
    private PolicyException _processingHaltedException;
    private WSPolicyTransform _transformer = null;
    private DefaultResourceEvaluator _defaultResourceEvaluator = new DefaultResourceEvaluator();
    private List<PolicySetReference> _referenceList;
    private HashMap<String, Object> _bindings;

    public WSPolicyProcessorImpl(String applicationPath, String serviceName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSPolicyProcessorImpl", new Object[]{applicationPath});
        }
        try {
            if (!applicationPath.endsWith("/")) {
                applicationPath = applicationPath + "/";
            }
            this._clientControllerFileName = applicationPath + "wsPolicyClientControl.xml";
            final String policySetAttachmentFileName = applicationPath + "clientPolicyAttachments.xml";
            boolean isPathBased = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    File file = new File(WSPolicyProcessorImpl.this._clientControllerFileName);
                    return file.exists();
                }
            });
            if (isPathBased) {
                this._clientController = WSPolicyClientControlHelperFactory.createHelper(this._clientControllerFileName, policySetAttachmentFileName);
            } else {
                InputStream istream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        InputStream stream = WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream(WSPolicyProcessorImpl.this._clientControllerFileName);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + WSPolicyProcessorImpl.this._clientControllerFileName);
                        }
                        if (stream == null) {
                            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(WSPolicyProcessorImpl.this._clientControllerFileName);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + WSPolicyProcessorImpl.this._clientControllerFileName);
                            }
                        }
                        return stream;
                    }
                });
                if (istream == null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Policy Control file not found. WSPolicyProcessorImpl: WS-Policy processing turned off for application " + applicationPath);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "WSPolicyProcessorImpl");
                    }
                    return;
                }
                InputStream policySetAttachmentIStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        InputStream stream = WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream(policySetAttachmentFileName);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "WSPolicyProcessorImpl.class.getClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + policySetAttachmentFileName);
                        }
                        if (stream == null) {
                            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(policySetAttachmentFileName);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + policySetAttachmentFileName);
                            }
                        }
                        return stream;
                    }
                });
                this._clientController = WSPolicyClientControlHelperFactory.createHelper(istream, policySetAttachmentIStream);
            }
            String resourceKey = null;
            resourceKey = moduleName != null ? "WebService:/" + moduleName + ":" + serviceName : "WebService:/" + serviceName;
            this._wsPolicyProcessingRequired = this._clientController.isProviderPolicyEnabled(resourceKey);
            if (this._wsPolicyProcessingRequired) {
                this._ppr = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry();
                this._calculatedPolicies = new HashMap();
                this._sourceCache = new HashMap();
                this._factory = this._ppr.getWSPolicyFactory();
                this._dmu = this._factory.createDataModelUtility();
                this._bpp = this._factory.createWSPolicyProcessor();
                this._ap = this._factory.createWSPolicyProcessor();
                this._wsdlProcessors = new HashMap();
            }
        }
        catch (FileNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Policy Control file not found. WSPolicyProcessorImpl: WS-Policy processing turned off for application " + applicationPath);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSPolicyProcessorImpl");
            }
            return;
        }
        catch (RuntimeException e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL9998", new Object[]{applicationPath}, "CWPOL9998E"), e);
            this.handleTerminalFault("Unknown error:", pe);
            throw e;
        }
        catch (Exception e) {
            PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL9998", new Object[]{applicationPath}, "CWPOL9998E"), e);
            this.handleTerminalFault("Unknown error:", pe);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSPolicyProcessorImpl");
        }
    }

    @Override
    public boolean isWSPolicyProcessingRequired() {
        return this._wsPolicyProcessingRequired;
    }

    @Override
    public PolicyInputStreamHolder calculatePolicy(String scopeKey, String policyType, MessageContext mc) throws NullPolicyException, PolicyException, UnknownOperationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "calculatePolicy", new Object[]{scopeKey, policyType, mc});
        }
        if (this._processingHalted) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "calculatePolicy failed");
            }
            FFDCFilter.processException(this._processingHaltedException, "WS-Policy processing halted due to an error", "428");
            throw this._processingHaltedException;
        }
        PolicyInputStreamHolder pish = null;
        try {
            PolicyHolder policy = this.calculatePolicyAtScopePoint(scopeKey, mc);
            pish = this.convertPolicyHolderToPolicyInputStreamHolder(policy, policyType, scopeKey);
        }
        catch (PolicyReferenceException pre) {
            String scopePoint = pre.getAttachPointName();
            if (scopePoint == null) {
                scopePoint = scopeKey;
            }
            Object[] args = new Object[]{this.getEndpointURIFromMsg(mc), pre.getReferenceURI(), scopePoint};
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to resolve PolicyReference", args);
            }
            throw new PolicyException(nls.getFormattedMessage("CWPOL0101", args, "CWPOL0101E"), pre);
        }
        catch (WSPolicyFormattedException wpfe) {
            throw new PolicyException(wpfe.getMessage(), wpfe.getCause());
        }
        catch (WSPolicyInternalException wspie) {
            AxisService service = mc.getAxisService();
            Object[] args = new Object[]{service == null ? null : service.getName(), wspie.getCause()};
            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), wspie);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "calculatePolicy", pish);
        }
        return pish;
    }

    private PolicyInputStreamHolder convertPolicyHolderToPolicyInputStreamHolder(PolicyHolder policy, String policyType, String scopeKey) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyFormattedException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertPolicyHolderToPolicyInputStreamHolder", new Object[]{policyType});
        }
        PolicyHolder chosenPolicy = new PolicyHolder(this._factory);
        chosenPolicy.setMain(this.getPolicyForType(policyType, policy.getMain()));
        chosenPolicy.setInput(this.getPolicyForType(policyType, policy.getInput()));
        chosenPolicy.setOutput(this.getPolicyForType(policyType, policy.getOutput()));
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Alternative selected");
        }
        boolean policyTaggedWithVocab = false;
        Set<QName> vocabSet = this._vocabs.get(scopeKey);
        StringBuilder sb = null;
        if (vocabSet != null) {
            for (QName qn : vocabSet) {
                if (!policyType.equals(this._ppr.getPolicyType(qn.getNamespaceURI()))) continue;
                if (sb == null) {
                    sb = new StringBuilder(qn.toString());
                    continue;
                }
                sb.append(" ").append(qn.toString());
            }
        }
        if (sb != null) {
            policyTaggedWithVocab = true;
            Policy main = chosenPolicy.getMain();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Adding provider vocab to main policy: ", sb.toString());
            }
            main.getOtherAttributes().put(WSPConstants.providerVocabQName, sb.toString());
        }
        Set<QName> inputVocabSet = this._vocabs.get(scopeKey + " Input");
        StringBuilder inputSb = null;
        if (inputVocabSet != null) {
            for (QName qn : inputVocabSet) {
                if (!policyType.equals(this._ppr.getPolicyType(qn.getNamespaceURI()))) continue;
                if (inputSb == null) {
                    inputSb = new StringBuilder(qn.toString());
                    continue;
                }
                inputSb.append(" ").append(qn.toString());
            }
        }
        if (inputSb != null) {
            policyTaggedWithVocab = true;
            Policy input = chosenPolicy.getInput();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Adding provider vocab to input policy: ", inputSb.toString());
            }
            input.getOtherAttributes().put(WSPConstants.providerVocabQName, inputSb.toString());
        }
        Set<QName> outputVocabSet = this._vocabs.get(scopeKey + " Output");
        StringBuilder outputSb = null;
        if (outputVocabSet != null) {
            for (QName qn : outputVocabSet) {
                if (!policyType.equals(this._ppr.getPolicyType(qn.getNamespaceURI()))) continue;
                if (outputSb == null) {
                    outputSb = new StringBuilder(qn.toString());
                    continue;
                }
                outputSb.append(" ").append(qn.toString());
            }
        }
        if (outputSb != null) {
            policyTaggedWithVocab = true;
            Policy output = chosenPolicy.getOutput();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Adding provider vocab to output policy: ", outputSb.toString());
            }
            output.getOtherAttributes().put(WSPConstants.providerVocabQName, outputSb.toString());
        }
        try {
            if (!policyTaggedWithVocab && chosenPolicy.isAllEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "convertPolicyHolderToPolicyInputStreamHolder. Policy empty");
                }
                return null;
            }
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        PolicyInputStreamHolder result = null;
        try {
            result = chosenPolicy.toPolicyInputStreamHolder(false);
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertPolicyHolderToPolicyInputStreamHolder");
        }
        return result;
    }

    private Policy getPolicyForType(String policyType, Policy policy) throws PolicyReferenceException, WSPolicyFormattedException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicyForType", new Object[]{policyType});
        }
        List<Assertion> assertions = null;
        try {
            assertions = policyType != null ? this._ppr.getAssertionsForPolicyTypeFromAlternative(policyType, this.getAlternative(policy, PolicyProcessor.FilterType.LOGICAL)) : this.getAlternative(policy, PolicyProcessor.FilterType.LOGICAL).getAssertions();
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        Policy result = this._factory.createDataModelFactory().createPolicy();
        ExactlyOne eo = this._factory.createDataModelFactory().createExactlyOne();
        All all = this._factory.createDataModelFactory().createAll();
        result.getChildren().add(eo);
        eo.getChildren().add(all);
        all.getChildren().addAll(assertions);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicyForType");
        }
        return result;
    }

    private PolicyHolder calculatePolicyAtScopePoint(String scopeKey, MessageContext mc) throws NullPolicyException, WSPolicyInternalException, WSPolicyFormattedException, UnknownOperationException {
        String namespace;
        String address;
        Definition definition;
        String providerNamespace;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "calculatePolicyAtScopePoint", new Object[]{scopeKey, mc});
        }
        if (!this.isWSPolicyProcessingRequired()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "calculatePolicy", null);
            }
            return null;
        }
        WSDLProcessor wsdlProcessor = this.setWSDLProcessorForProviderPolicy(scopeKey, mc);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSDLProcessor " + wsdlProcessor);
        }
        String string = providerNamespace = (definition = wsdlProcessor.getDefinition()) != null ? definition.getTargetNamespace() : null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            if (definition != null) {
                Tr.debug(TRACE_COMPONENT, "target namespace for WSDLDefinition " + definition.getTargetNamespace());
            } else {
                Tr.debug(TRACE_COMPONENT, "null WSDLDefinition");
            }
        }
        if ((address = this.getEndpointURIFromMsg(mc)) == null) {
            throw new WSPolicyInternalException("Cannot reolve target address");
        }
        PolicyHolder calculatedPolicy = this._calculatedPolicies.get(address + " " + scopeKey);
        if (calculatedPolicy != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Have previously cached Policy: " + calculatedPolicy);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getPolicyAttachedAtScopePoint", "Policy retrieved from cache");
            }
            return calculatedPolicy;
        }
        String operationName = null;
        String portName = null;
        String serviceName = null;
        if (providerNamespace == null) {
            throw new WSPolicyInternalException("Namespace of provider WSDL is null");
        }
        int openingIndex = scopeKey.indexOf(123);
        if (openingIndex != -1 && !providerNamespace.equals(namespace = scopeKey.substring(openingIndex + 1, scopeKey.indexOf(125))) && (namespace.charAt(namespace.length() - 1) == '/' ? namespace.length() != providerNamespace.length() + 1 || !namespace.startsWith(providerNamespace) : providerNamespace.length() != namespace.length() + 1 || !providerNamespace.startsWith(namespace))) {
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0006", new Object[]{wsdlProcessor.getObtainedFromAddress()}, null), null);
        }
        String scopeData = scopeKey.substring(scopeKey.indexOf(125) + 1, scopeKey.length());
        if (scopeData.indexOf(47) == -1) {
            serviceName = scopeData;
        } else {
            serviceName = scopeData.substring(0, scopeData.indexOf(47));
            if ((scopeData = scopeData.substring(scopeData.indexOf(47) + 1, scopeData.length())).indexOf(47) == -1) {
                portName = scopeData;
            } else {
                portName = scopeData.substring(0, scopeData.indexOf(47));
                operationName = scopeData.substring(scopeData.indexOf(47) + 1, scopeData.length());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "serviceName: " + serviceName);
            Tr.debug(TRACE_COMPONENT, "portName: " + portName);
            Tr.debug(TRACE_COMPONENT, "operationName: " + operationName);
        }
        QName serviceQName = new QName(providerNamespace, serviceName);
        try {
            calculatedPolicy = this.intersectAndMerge(scopeKey, operationName, portName, serviceQName, wsdlProcessor, address);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "adding policy to scope key " + address + " " + scopeKey);
            }
            this._calculatedPolicies.put(address + " " + scopeKey, calculatedPolicy);
        }
        catch (NullPolicyException nullWSPE) {
            this._calculatedPolicies.put(address + " " + scopeKey, null);
            throw nullWSPE;
        }
        catch (WSPolicyFormattedException wspfe) {
            this._calculatedPolicies.put(address + " " + scopeKey, null);
            throw wspfe;
        }
        catch (RuntimeException rte) {
            this._calculatedPolicies.put(address + " " + scopeKey, null);
            throw rte;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "calculatePolicyAtScopePoint");
        }
        return calculatedPolicy;
    }

    private void addFailureToObtainWSDLForResourceKeyToCache(WSPolicyClientControlReference reference, MessageContext mc, WSPolicyFormattedException wspfe) {
        String address;
        if (reference != null && (address = this.getEndpointURIFromMsg(mc)) != null) {
            String defKey = address + reference.getResource();
            this._acquiredDefinitions.put(defKey, wspfe);
        }
    }

    private void addFailureToObtainWSDLForResourceKeyToCache(WSPolicyClientControlReference reference, MessageContext mc, WSPolicyInternalException wspie) {
        String address;
        if (reference != null && (address = this.getEndpointURIFromMsg(mc)) != null) {
            String defKey = address + reference.getResource();
            this._acquiredDefinitions.put(defKey, wspie);
        }
    }

    private WSDLProcessor setWSDLProcessorForProviderPolicy(String scopeKey, MessageContext mc) throws WSPolicyInternalException, WSPolicyFormattedException {
        WSDLProcessor wsdlProcessor;
        block47: {
            WSPolicyClientControlReference reference;
            String overriddenURI;
            String endpointURI;
            block49: {
                List<ProviderPolicyAcquisition> acquisitions;
                String defKey;
                block50: {
                    block48: {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                            Tr.entry(TRACE_COMPONENT, "setWSDLProcessorForProviderPolicy", new Object[]{scopeKey, mc});
                        }
                        endpointURI = this.getEndpointURIFromMsg(mc);
                        wsdlProcessor = this._wsdlProcessors.get(endpointURI);
                        overriddenURI = endpointURI;
                        if (wsdlProcessor != null) break block47;
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "WSDL processor not initialised. Acquiring provider side policy");
                        }
                        reference = null;
                        try {
                            reference = this._clientController.getWSPolicyClientControlReferenceInherited(scopeKey);
                        }
                        catch (Exception e) {
                            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0030", new Object[]{scopeKey, this._clientController.getFileName()}, null), e);
                        }
                        if (reference != null) break block48;
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block49;
                        Tr.debug(TRACE_COMPONENT, "WSPolicyClientControlReference null for " + scopeKey);
                        break block49;
                    }
                    defKey = null;
                    if (mc != null && endpointURI != null) {
                        defKey = endpointURI + reference.getResource();
                        if (this._acquiredDefinitions.containsKey(defKey)) {
                            Object acquiredObj = this._acquiredDefinitions.get(defKey);
                            if (acquiredObj instanceof WSDLProcessor) {
                                wsdlProcessor = (WSDLProcessor)acquiredObj;
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.debug(TRACE_COMPONENT, "Definition cache hit for " + defKey + " " + wsdlProcessor);
                                }
                            } else {
                                if (acquiredObj instanceof WSPolicyFormattedException) {
                                    throw (WSPolicyFormattedException)acquiredObj;
                                }
                                if (acquiredObj instanceof WSPolicyInternalException) {
                                    throw (WSPolicyInternalException)acquiredObj;
                                }
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.debug(TRACE_COMPONENT, "Ignoring unexpected Definition cache hit for " + defKey);
                                }
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Definition cache miss for " + defKey);
                        }
                    }
                    if (wsdlProcessor != null) break block49;
                    acquisitions = reference.getProviderPolicyAcquisition();
                    if (acquisitions != null) break block50;
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block49;
                    Tr.debug(TRACE_COMPONENT, "ProviderPolicyAcquisition list null for " + scopeKey);
                    break block49;
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "ProviderPolicyAcquisition list has " + acquisitions.size() + " elements.");
                }
                for (ProviderPolicyAcquisition acquisition : acquisitions) {
                    String providerClass;
                    PolicyProvider pp;
                    block46: {
                        pp = null;
                        providerClass = acquisition.getPolicyAcquisitionClass();
                        if ("com.ibm.ws.wspolicy.acquisition.AcquireViaFile".equals(providerClass)) {
                            pp = new AcquireViaFile();
                        } else if ("com.ibm.ws.wspolicy.acquisition.AcquireViaMex".equals(providerClass)) {
                            pp = new AcquireViaMex();
                        } else if ("com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL".equals(providerClass)) {
                            pp = new AcquireViaQWSDL();
                        } else {
                            try {
                                Class<?> c = Class.forName(providerClass);
                                Object o = c.newInstance();
                                if (!(o instanceof PolicyProvider)) {
                                    throw new Exception("PolicyProvider class " + providerClass + " did not implement " + PolicyProvider.class.getName());
                                }
                                pp = (PolicyProvider)o;
                            }
                            catch (Exception e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isInfoEnabled()) break block46;
                                Tr.warning(TRACE_COMPONENT, "CWPOL8000", new Object[]{providerClass});
                            }
                        }
                    }
                    if (pp == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "Unable to instantiate " + providerClass + " trying next ProviderPolicyAcquisition element");
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Obtaining policy via " + pp.getClass().getName());
                    }
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("messageContext", mc);
                    parameters.put("resourcePattern", scopeKey);
                    List<KeyValuePair> params = acquisition.getParameters();
                    for (KeyValuePair param : params) {
                        parameters.put(param.getKey(), param.getValue());
                        if (!"policyURI".equals(param.getKey())) continue;
                        overriddenURI = param.getValue();
                    }
                    Definition def = null;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "PolicyProvider pre-invoke");
                        }
                        def = pp.getProviderPolicy(parameters);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "PolicyProvider post invoke : def " + (def == null ? "null" : "non-null"));
                        }
                    }
                    catch (WSPolicyInternalException wspie) {
                        FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.setWSDLProcessorForProviderPolicy", "820", this);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspie);
                        throw wspie;
                    }
                    catch (WSPolicyFormattedException wspfe) {
                        FFDCFilter.processException((Throwable)wspfe, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.setWSDLProcessorForProviderPolicy", "824", this);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    catch (WSPolicyException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.setWSDLProcessorForProviderPolicy", "827", this);
                        if (e instanceof UnsupportedPolicyElementException) {
                            UnsupportedPolicyElementException upee = (UnsupportedPolicyElementException)e;
                            WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0100", new Object[]{overriddenURI, upee.getAttachPointName()}, null), upee);
                            this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                            throw wspfe;
                        }
                        if (e instanceof UnsupportedNamespaceException) {
                            UnsupportedNamespaceException une = (UnsupportedNamespaceException)e;
                            WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0106", new Object[]{overriddenURI, une.getAttachPointName(), une.getElementQName()}, null), une);
                            this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                            throw wspfe;
                        }
                        if (e instanceof PolicyReferenceException) {
                            PolicyReferenceException pre = (PolicyReferenceException)e;
                            WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0101", new Object[]{overriddenURI, pre.getReferenceURI(), pre.getAttachPointName()}, null), pre);
                            this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                            throw wspfe;
                        }
                        WSPolicyInternalException wspie = new WSPolicyInternalException(e);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspie);
                        throw wspie;
                    }
                    if (def == null) continue;
                    try {
                        wsdlProcessor = new WSDLProcessor(this._factory, def);
                        wsdlProcessor.setObtainedFromAddress(overriddenURI);
                        if (defKey != null) {
                            this._acquiredDefinitions.put(defKey, wsdlProcessor);
                        }
                    }
                    catch (UnsupportedNamespaceException e) {
                        UnsupportedNamespaceException une = e;
                        WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0106", new Object[]{overriddenURI, une.getAttachPointName(), une.getElementQName()}, null), une);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    catch (com.ibm.wspolicy.PolicyReferenceException e) {
                        WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0101", new Object[]{overriddenURI, e.getReferenceURI(), ""}, null), e);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    catch (com.ibm.wspolicy.WSPolicyException e) {
                        WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0100", new Object[]{overriddenURI, ""}, null), e);
                        this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                        throw wspfe;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                    Tr.debug(TRACE_COMPONENT, "wsdlProcessor build from definition.");
                    break;
                }
            }
            if (wsdlProcessor != null) {
                this.loadBindings(scopeKey, overriddenURI);
                this._wsdlProcessors.put(endpointURI, wsdlProcessor);
                if (!wsdlProcessor.containsPolicy() && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isInfoEnabled()) {
                    Tr.info(TRACE_COMPONENT, "CWPOL0007", new Object[]{overriddenURI});
                }
            } else {
                WSPolicyFormattedException wspfe = new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0030", new Object[]{scopeKey, this._clientController.getFileName()}, null), null);
                this.addFailureToObtainWSDLForResourceKeyToCache(reference, mc, wspfe);
                throw wspfe;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setWSDLProcessorForProviderPolicy", wsdlProcessor);
        }
        return wsdlProcessor;
    }

    private String findLowestAttachPoint(String scopeKey, String operationName, String portName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "findLowestAttachPoint", new Object[]{scopeKey, operationName, portName});
        }
        if (operationName == null) {
            if (portName != null && this.hasNoPolicySetAttached(scopeKey)) {
                scopeKey = scopeKey.substring(0, scopeKey.lastIndexOf(portName) - 1);
            }
        } else if (this.hasNoPolicySetAttached(scopeKey) && this.hasNoPolicySetAttached(scopeKey = scopeKey.substring(0, scopeKey.lastIndexOf(operationName) - 1)) && this.hasNoPolicySetAttached(scopeKey = scopeKey.substring(0, scopeKey.lastIndexOf(portName) - 1))) {
            scopeKey = "WebService:/";
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "findLowestAttachPoint", new Object[]{scopeKey});
        }
        return scopeKey;
    }

    private boolean hasNoPolicySetAttached(String scopeKey) {
        boolean result;
        boolean bl = result = this.getClientPolicy(scopeKey) == null && this.getClientPolicy(scopeKey + "/" + "request:") == null && this.getClientPolicy(scopeKey + "/" + "response:") == null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "hasNoPolicySetAttached", new Object[]{result});
        }
        return result;
    }

    public String toStr(Policy p) {
        if (p == null) {
            return "null";
        }
        try {
            ElementWriter<StringBuffer> w = this._factory.getWriter(StringBuffer.class);
            StringBuffer s = new StringBuffer();
            w.write(p, s);
            return s.toString();
        }
        catch (Exception e) {
            return "Unable to dump " + p + "  " + p.getName() + " to a string";
        }
    }

    private Policy getProviderEffectivePolicyForDII(QName serviceQName, String portName, String operationName, WSDLProcessor wsdlProcessor, String endpointURL) throws UnknownOperationException, PolicyReferenceException, WSPolicyFormattedException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderEffectivePolicyForDII", new Object[]{serviceQName, portName, operationName, wsdlProcessor});
        }
        Policy result = null;
        result = this.getProviderEffectivePolicy(serviceQName, portName, operationName, wsdlProcessor, endpointURL);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getProviderEffectivePolicyForDII ", result);
        }
        return result;
    }

    public Policy getInputMessageEffectivePolicyForDII(WSDLProcessor wsdlProcessor, QName serviceQName, String portName, String operationName) throws PolicyReferenceException, com.ibm.wspolicy.WSPolicyException, UnknownWSDLElementException {
        Policy result;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getInputMessageEffectivePolicyForDII", new Object[]{serviceQName, portName, operationName});
        }
        if (operationName != null) {
            result = null;
        } else {
            try {
                result = wsdlProcessor.getInputMessageEffectivePolicy(serviceQName, portName, null);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "failed getting input policy DII, using null");
                }
                result = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getInputMessageEffectivePolicyForDII", result);
        }
        return result;
    }

    public Policy getOutputMessageEffectivePolicyForDII(WSDLProcessor wsdlProcessor, QName serviceQName, String portName, String operationName) throws PolicyReferenceException, com.ibm.wspolicy.WSPolicyException, UnknownWSDLElementException {
        Policy result;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getOutputMessageEffectivePolicyForDII", new Object[]{serviceQName, portName, operationName});
        }
        if (operationName != null) {
            result = null;
        } else {
            try {
                result = wsdlProcessor.getOutputMessageEffectivePolicy(serviceQName, portName, null);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "failed getting output policy DII, using null");
                }
                result = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getOutputMessageEffectivePolicyForDII", result);
        }
        return result;
    }

    private PolicyHolder intersectAndMerge(String scopeKey, String operationName, String portName, QName serviceQName, WSDLProcessor wsdlProcessor, String endpointURL) throws NullPolicyException, WSPolicyFormattedException, UnknownOperationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersectAndMerge", new Object[]{scopeKey, operationName, portName, serviceQName, wsdlProcessor});
        }
        String requestPortName = portName;
        String requestOperationName = operationName;
        PolicyHolder result = new PolicyHolder(this._factory);
        Policy resultPolicy = null;
        Policy resultInputPolicy = null;
        Policy resultOutPolicy = null;
        String clientScopeKey = this.findLowestAttachPoint(scopeKey, requestOperationName, requestPortName);
        Policy clientPolicy = this.getClientPolicy(clientScopeKey);
        Policy clientInputPolicy = this.getClientPolicy(clientScopeKey + "/" + "request:");
        Policy clientOutputPolicy = this.getClientPolicy(clientScopeKey + "/" + "response:");
        PolicyProcessor.Alternative alternative = null;
        PolicyProcessor.Alternative alternativeInput = null;
        PolicyProcessor.Alternative alternativeOutput = null;
        if (wsdlProcessor.containsPolicy()) {
            if (portName == null) {
                portName = this.getPortName(serviceQName, scopeKey, wsdlProcessor);
            }
            Policy providerPolicy = null;
            Policy providerInputPolicy = null;
            Policy providerOutputPolicy = null;
            try {
                Iterator<PolicyProcessor.Alternative> altIt;
                Iterable<PolicyProcessor.Alternative> alternatives;
                if (operationName == null) {
                    operationName = this.getoperationName(serviceQName, portName, scopeKey, wsdlProcessor);
                }
                try {
                    providerPolicy = this.getProviderEffectivePolicy(serviceQName, portName, operationName, wsdlProcessor, endpointURL);
                }
                catch (UnknownOperationException e) {
                    if (operationName != null && operationName.startsWith("anon")) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "intersectAndMerge found unknown operation anon* - assuming DII");
                        }
                        operationName = null;
                        providerPolicy = this.getProviderEffectivePolicyForDII(serviceQName, portName, operationName, wsdlProcessor, endpointURL);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge found unknown operation NOT DII");
                    }
                    throw e;
                }
                try {
                    if (operationName != null) {
                        providerInputPolicy = wsdlProcessor.getInputMessageEffectivePolicy(serviceQName, portName, operationName);
                        providerOutputPolicy = wsdlProcessor.getOutputMessageEffectivePolicy(serviceQName, portName, operationName);
                    } else {
                        providerInputPolicy = this.getInputMessageEffectivePolicyForDII(wsdlProcessor, serviceQName, portName, operationName);
                        providerOutputPolicy = this.getOutputMessageEffectivePolicyForDII(wsdlProcessor, serviceQName, portName, operationName);
                    }
                }
                catch (com.ibm.wspolicy.PolicyReferenceException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught Exception ", e);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.intersectAndMerge", "1284");
                    CoreExceptionMapper.map(e);
                }
                catch (UnknownWSDLElementException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught Exception ", e);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.intersectAndMerge", "1289");
                    CoreExceptionMapper.map(e);
                }
                catch (com.ibm.wspolicy.WSPolicyException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught Exception ", e);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.intersectAndMerge", "1294");
                    CoreExceptionMapper.map(e);
                }
                HashSet<QName> vocabSet = new HashSet<QName>();
                this.getGlobalVocab(providerPolicy, vocabSet);
                Iterator it = vocabSet.iterator();
                while (it.hasNext()) {
                    if (this._ppr.isProviderVocabularyRequired((QName)it.next())) continue;
                    it.remove();
                }
                this._vocabs.put(scopeKey, vocabSet);
                HashSet<QName> inputVocabSet = new HashSet<QName>();
                this.getGlobalVocab(providerInputPolicy, inputVocabSet);
                Iterator itIn = inputVocabSet.iterator();
                while (itIn.hasNext()) {
                    if (this._ppr.isProviderVocabularyRequired((QName)itIn.next())) continue;
                    itIn.remove();
                }
                this._vocabs.put(scopeKey + " Input", inputVocabSet);
                HashSet<QName> outputVocabSet = new HashSet<QName>();
                this.getGlobalVocab(providerOutputPolicy, outputVocabSet);
                Iterator itOut = outputVocabSet.iterator();
                while (itOut.hasNext()) {
                    if (this._ppr.isProviderVocabularyRequired((QName)itOut.next())) continue;
                    itOut.remove();
                }
                this._vocabs.put(scopeKey + " Output", outputVocabSet);
                if (providerPolicy == null) {
                    providerPolicy = this._factory.createDataModelFactory().createPolicy();
                }
                try {
                    if (clientPolicy != null) {
                        alternatives = this._ap.supplementedIntersect(providerPolicy, new HashSet<QName>(), clientPolicy, this.buildClientCapabilitiesBucket(clientPolicy), this.isStrictMode, this.iterationType);
                        altIt = alternatives.iterator();
                        if (altIt.hasNext()) {
                            alternative = altIt.next();
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "no client policy found, using provider only policy for scopeKey " + scopeKey);
                        }
                        alternative = this.getAlternative(providerPolicy, this.iterationType);
                    }
                }
                catch (com.ibm.wspolicy.PolicyReferenceException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught Exception ", e);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.intersectAndMerge", "1369");
                    CoreExceptionMapper.map(e);
                }
                if (alternative != null) {
                    resultPolicy = alternative.getAssertions() != null ? this.createPolicy(alternative.getAssertions()) : this._factory.createDataModelFactory().createPolicy();
                }
                if (providerInputPolicy == null) {
                    providerInputPolicy = this._factory.createDataModelFactory().createPolicy();
                }
                try {
                    if (clientInputPolicy != null) {
                        alternatives = this._ap.supplementedIntersect(providerInputPolicy, new HashSet<QName>(), clientInputPolicy, this.buildClientCapabilitiesBucket(clientInputPolicy), this.isStrictMode, this.iterationType);
                        altIt = alternatives.iterator();
                        if (altIt.hasNext()) {
                            alternativeInput = altIt.next();
                        }
                    } else {
                        alternativeInput = this.getAlternative(providerInputPolicy, this.iterationType);
                    }
                }
                catch (com.ibm.wspolicy.PolicyReferenceException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught Exception ", e);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.intersectAndMerge", "1426");
                    CoreExceptionMapper.map(e);
                }
                if (alternativeInput != null) {
                    resultInputPolicy = alternativeInput.getAssertions() != null ? this.createPolicy(alternativeInput.getAssertions()) : this._factory.createDataModelFactory().createPolicy();
                }
                if (providerOutputPolicy == null) {
                    providerOutputPolicy = this._factory.createDataModelFactory().createPolicy();
                }
                try {
                    if (clientOutputPolicy != null) {
                        alternatives = this._ap.supplementedIntersect(providerOutputPolicy, new HashSet<QName>(), clientOutputPolicy, this.buildClientCapabilitiesBucket(clientOutputPolicy), this.isStrictMode, this.iterationType);
                        altIt = alternatives.iterator();
                        if (altIt.hasNext()) {
                            alternativeOutput = altIt.next();
                        }
                    } else {
                        alternativeOutput = this.getAlternative(providerOutputPolicy, this.iterationType);
                    }
                }
                catch (com.ibm.wspolicy.PolicyReferenceException e) {
                    CoreExceptionMapper.map(e);
                }
                if (alternativeOutput != null) {
                    resultOutPolicy = alternativeOutput.getAssertions() != null ? this.createPolicy(alternativeOutput.getAssertions()) : this._factory.createDataModelFactory().createPolicy();
                }
                if (resultPolicy == null || resultInputPolicy == null || resultOutPolicy == null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Null Policy condition detected");
                    }
                    if (clientOutputPolicy == null && clientInputPolicy == null && clientPolicy == null) {
                        this.handleError104(wsdlProcessor);
                    }
                    this.handleError105(wsdlProcessor, clientPolicy, clientInputPolicy, clientOutputPolicy, providerPolicy, providerInputPolicy, providerOutputPolicy);
                }
                result.setMain(resultPolicy);
                result.setInput(resultInputPolicy);
                result.setOutput(resultOutPolicy);
            }
            catch (UnknownOperationException e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Skipping virtual operation " + operationName);
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "intersectAndMerge");
                }
                throw e;
            }
            catch (PolicyReferenceException pre) {
                String scopePoint = pre.getAttachPointName();
                if (scopePoint == null) {
                    scopePoint = "Service = " + serviceQName != null ? serviceQName.toString() : "";
                    scopePoint = scopePoint + ", Port = " + portName;
                    scopePoint = scopePoint + ", Operation = " + operationName;
                }
                Object[] args = new Object[]{endpointURL, pre.getReferenceURI(), scopePoint};
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Unable to resolve PolicyReference", args);
                }
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0101", args, "CWPOL0101E"), pre);
            }
            catch (WSPolicyInternalException wspie) {
                Object[] args = new Object[]{serviceQName == null ? null : serviceQName.toString(), wspie.getCause()};
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSPolicyInternalException", args);
                }
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), wspie);
            }
        } else {
            block81: {
                try {
                    if (clientPolicy != null) {
                        try {
                            alternative = this.getAlternative(clientPolicy, this.iterationType);
                        }
                        catch (com.ibm.wspolicy.PolicyReferenceException e) {
                            CoreExceptionMapper.map(e);
                        }
                        if (alternative != null) {
                            resultPolicy = alternative.getAssertions() != null ? this.createPolicy(alternative.getAssertions()) : this._factory.createDataModelFactory().createPolicy();
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "no client policy found, no policy for scopeKey " + scopeKey);
                        }
                        resultPolicy = this._factory.createDataModelFactory().createPolicy();
                    }
                    if (clientInputPolicy != null) {
                        try {
                            alternativeInput = this.getAlternative(clientInputPolicy, this.iterationType);
                        }
                        catch (com.ibm.wspolicy.PolicyReferenceException e) {
                            CoreExceptionMapper.map(e);
                        }
                        if (alternativeInput != null) {
                            resultInputPolicy = alternativeInput.getAssertions() != null ? this.createPolicy(alternativeInput.getAssertions()) : this._factory.createDataModelFactory().createPolicy();
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "no client input policy found, no input policy for scopeKey " + scopeKey);
                        }
                        resultInputPolicy = this._factory.createDataModelFactory().createPolicy();
                    }
                    if (clientOutputPolicy != null) {
                        try {
                            alternativeOutput = this.getAlternative(clientOutputPolicy, this.iterationType);
                        }
                        catch (com.ibm.wspolicy.PolicyReferenceException e) {
                            CoreExceptionMapper.map(e);
                        }
                        if (alternativeOutput != null) {
                            resultOutPolicy = alternativeOutput.getAssertions() != null ? this.createPolicy(alternativeOutput.getAssertions()) : this._factory.createDataModelFactory().createPolicy();
                        }
                        break block81;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "no client output policy found, no output policy for scopeKey " + scopeKey);
                    }
                    resultOutPolicy = this._factory.createDataModelFactory().createPolicy();
                }
                catch (PolicyReferenceException pre) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "PolicyReference exception detected processing client policy", pre);
                    }
                    Object[] args = new Object[]{endpointURL};
                    throw new NullPolicyException(nls.getFormattedMessage("CWPOL0107", args, "CWPOL0107E"));
                }
            }
            if (resultPolicy == null || resultInputPolicy == null || resultOutPolicy == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Client-only Null Policy condition detected");
                }
                Object[] args = new Object[]{endpointURL};
                throw new NullPolicyException(nls.getFormattedMessage("CWPOL0107", args, "CWPOL0107E"));
            }
            result.setMain(resultPolicy);
            result.setInput(resultInputPolicy);
            result.setOutput(resultOutPolicy);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectAndMerge");
        }
        return result;
    }

    private Set<QName> buildClientCapabilitiesBucket(Policy policy) {
        return this._ppr.getClientCapabilitiesBucketForPolicy(policy);
    }

    private void handleError104(WSDLProcessor wsdlProcessor) throws NullPolicyException {
        String wsdlStr = wsdlProcessor.getWSDL();
        String unknownAssertions = wsdlProcessor.getUnsupportedAssertions();
        Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress(), wsdlStr, unknownAssertions};
        throw new NullPolicyException(nls.getFormattedMessage("CWPOL0104", args, "CWPOL0104E"));
    }

    private void handleError105(WSDLProcessor wsdlProcessor, Policy clientPolicy, Policy clientInputPolicy, Policy clientOutputPolicy, Policy providerPolicy, Policy providerInputPolicy, Policy providerOutputPolicy) throws NullPolicyException {
        Set<QName> missingClientOutputAssertions;
        Set<QName> missingClientInputAssertions;
        String wsdlStr = wsdlProcessor.getWSDL();
        String unknownAssertions = wsdlProcessor.getUnsupportedAssertions();
        StringBuffer missingClientAssertionsStr = new StringBuffer();
        Set<QName> missingClientAssertions = this.getClientAssertionsUnsupportedByProvider(clientPolicy, providerPolicy);
        if (!missingClientAssertions.isEmpty()) {
            missingClientAssertionsStr.append(missingClientAssertions.toString());
        }
        if (!(missingClientInputAssertions = this.getClientAssertionsUnsupportedByProvider(clientInputPolicy, providerInputPolicy)).isEmpty()) {
            if (missingClientAssertionsStr.length() > 0) {
                missingClientAssertionsStr.append(", ");
            }
            missingClientAssertionsStr.append(missingClientInputAssertions.toString());
        }
        if (!(missingClientOutputAssertions = this.getClientAssertionsUnsupportedByProvider(clientOutputPolicy, providerOutputPolicy)).isEmpty()) {
            if (missingClientAssertionsStr.length() > 0) {
                missingClientAssertionsStr.append(", ");
            }
            missingClientAssertionsStr.append(missingClientOutputAssertions.toString());
        }
        Object[] args = new Object[]{wsdlProcessor.getObtainedFromAddress(), wsdlStr, unknownAssertions, missingClientAssertionsStr.toString()};
        throw new NullPolicyException(nls.getFormattedMessage("CWPOL0105", args, "CWPOL0105E"));
    }

    private Set<QName> getClientAssertionsUnsupportedByProvider(Policy clientPolicy, Policy providerPolicy) {
        Set<Object> clientAssertions = new HashSet();
        Set<Object> providerAssertions = new HashSet();
        HashSet<QName> unmatchedAssertions = new HashSet<QName>();
        if (clientPolicy != null) {
            clientAssertions = this._dmu.getVocabulary(clientPolicy);
        }
        if (providerPolicy != null) {
            providerAssertions = this._dmu.getVocabulary(providerPolicy);
        }
        for (QName assertionQN : clientAssertions) {
            if (providerAssertions.contains(assertionQN)) continue;
            unmatchedAssertions.add(assertionQN);
        }
        return unmatchedAssertions;
    }

    private void handleTerminalFault(String msg, PolicyException e) {
        this._processingHalted = true;
        this.handleFault(msg, e);
    }

    private void handleFault(String msg, PolicyException e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught " + exceptionName + ": " + exceptionMessage + " when trying to create a new WSPolicyProcessor:" + msg;
        this._processingHaltedException = e;
        Tr.debug(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, message, "1:579:1.3");
    }

    private String getoperationName(QName serviceQName, String portName, String scopeKey, WSDLProcessor wsdlProcessor) throws WSPolicyInternalException {
        String result = null;
        List<String> operations = wsdlProcessor.getOperationNames(serviceQName, portName);
        for (String operationName : operations) {
            Policy clientinputPolicy = this.getClientPolicy(scopeKey + "/" + operationName);
            if (clientinputPolicy != null) continue;
            result = operationName;
            break;
        }
        if (result == null) {
            result = operations.get(0);
        }
        return result;
    }

    private String getPortName(QName serviceQName, String scopeKey, WSDLProcessor wsdlProcessor) {
        String result = null;
        List<String> ports = wsdlProcessor.getPortNames(serviceQName);
        Iterator<String> portIter = ports.iterator();
        String port = null;
        while (portIter.hasNext()) {
            port = portIter.next();
            Policy clientPolicy = this.getClientPolicy(scopeKey + "/" + port);
            if (clientPolicy != null) continue;
            result = port;
            break;
        }
        if (result == null) {
            result = ports.get(0);
        }
        return result;
    }

    private Policy getProviderEffectivePolicy(QName serviceQName, String portName, String operationName, WSDLProcessor wsdlProcessor, String endpointURL) throws UnknownOperationException, PolicyReferenceException, WSPolicyFormattedException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderEffectivePolicy", new Object[]{serviceQName, portName, operationName, wsdlProcessor});
        }
        Policy result = null;
        try {
            result = wsdlProcessor.getProviderEffectivePolicy(serviceQName, portName, operationName);
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        catch (UnknownWSDLElementException e) {
            CoreExceptionMapper.map(e);
        }
        catch (com.ibm.wspolicy.WSPolicyException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getProviderEffectivePolicy", e);
            }
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0006", new Object[]{wsdlProcessor.getObtainedFromAddress()}, null), null);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getProviderEffectivePolicy ", result);
        }
        return result;
    }

    private Policy getClientPolicy(String scopeKey) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClientPolicy", new Object[]{scopeKey});
        }
        Policy result = null;
        if (this._scopedRequesterPolicies != null) {
            result = this._scopedRequesterPolicies.get(scopeKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClientPolicy");
        }
        return result;
    }

    @Override
    public void setRequesterPolicy(String scopeKey, String policyType, String policySetName, PolicyInputStreamHolder policyStream) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "setRequesterPolicy", new Object[]{scopeKey, policyType, policySetName});
            }
            try {
                if (this._processingHalted) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "The halt processing flag has been set due to a problem during initialization");
                    }
                    break block18;
                }
                String cacheKey = "PSN:" + policySetName + "PT:" + policyType;
                PolicyHolder policies = this._sourceCache.get(cacheKey);
                if (policies == null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "About to read WS-Policy");
                    }
                    try {
                        policies = new PolicyHolder(this._factory, policyStream);
                    }
                    catch (ElementReaderException e) {
                        throw new WSPolicyInternalException(e);
                    }
                    catch (com.ibm.wspolicy.PolicyReferenceException e) {
                        CoreExceptionMapper.map(e);
                    }
                }
                if (policies.getMain() != null) {
                    this.addScopedRequesterPolicy(scopeKey, policies.getMain());
                }
                if (policies.getInput() != null) {
                    this.addScopedRequesterPolicy(scopeKey + "/" + "request:", policies.getInput());
                }
                if (policies.getOutput() != null) {
                    this.addScopedRequesterPolicy(scopeKey + "/" + "response:", policies.getOutput());
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "New Policies added to cache");
                }
            }
            catch (WSPolicyInternalException e) {
                PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL9997", new Object[]{scopeKey, policyType, policySetName}, "CWPOL9997E"), e);
                this.handleFault("setRequesterPolicy failure", pe);
            }
            catch (PolicyReferenceException e) {
                PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL0101", new Object[]{scopeKey, e.getReferenceURI(), e.getAttachPointName()}, "CWPOL0101E"), e);
                this.handleFault("setRequesterPolicy failure", pe);
            }
            catch (UnsupportedNamespaceException e) {
                PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL0101", new Object[]{scopeKey, e.getAttachPointName()}, "CWPOL0101E"), e);
                this.handleFault("setRequesterPolicy failure", pe);
            }
            catch (UnsupportedPolicyElementException e) {
                PolicyException pe = new PolicyException(nls.getFormattedMessage("CWPOL0100", new Object[]{scopeKey, e.getAttachPointName()}, "CWPOL0100E"), e);
                this.handleFault("setRequesterPolicy failure", pe);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setRequesterPolicy");
        }
    }

    private void addScopedRequesterPolicy(String scopeKey, Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        Policy currentPolicy;
        if (this._scopedRequesterPolicies == null) {
            this._scopedRequesterPolicies = new HashMap();
        }
        if ((currentPolicy = this._scopedRequesterPolicies.get(scopeKey)) == null) {
            this._scopedRequesterPolicies.put(scopeKey, policy);
        } else {
            try {
                this._scopedRequesterPolicies.put(scopeKey, this._bpp.merge(currentPolicy, policy));
            }
            catch (com.ibm.wspolicy.PolicyReferenceException e) {
                CoreExceptionMapper.map(e);
            }
        }
    }

    @Override
    public boolean isAttached(String scopeKey, MessageContext mc) throws NullPolicyException, PolicyException, UnknownOperationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isAttached", new Object[]{scopeKey, mc, this});
        }
        boolean result = false;
        try {
            if (this.calculatePolicyAtScopePoint(scopeKey, mc) != null) {
                result = true;
            }
        }
        catch (WSPolicyInternalException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isAttached", new Object[]{e});
            }
            AxisService service = mc.getAxisService();
            Object[] args = new Object[]{service == null ? null : service.getName(), e};
            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
        }
        catch (WSPolicyFormattedException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isAttached", new Object[]{e});
            }
            throw new PolicyException(e.getMessage(), e.getCause());
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isAttached", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readWsdlFile(String location) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readWsdlFile", new Object[]{location, this});
        }
        BufferedReader input = null;
        String line = null;
        StringBuffer filecontents = new StringBuffer();
        BufferedInputStream istream = null;
        try {
            FileReader reader = new FileReader(location);
            input = new BufferedReader(reader);
            while ((line = input.readLine()) != null) {
                filecontents.append(line);
                filecontents.append(System.getProperty("line.separator"));
            }
            istream = new BufferedInputStream(new ByteArrayInputStream(filecontents.toString().getBytes()));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.readWsdlFile", "1119", this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "readWsdlFile", e);
            }
        }
        finally {
            block17: {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.readWsdlFile", "1126", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block17;
                    Tr.debug(TRACE_COMPONENT, "readWsdlFile", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readWsdlFile", istream);
        }
        return istream;
    }

    private String getEndpointURIFromMsg(MessageContext mc) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointURIFrom", new Object[]{mc});
        }
        if (mc == null) {
            return null;
        }
        String endpointURI = null;
        EndpointReference epr = mc.getTo();
        endpointURI = epr != null ? epr.getAddress() : (String)mc.getProperty("javax.xml.ws.service.endpoint.address");
        if (endpointURI == "") {
            endpointURI = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointURIFrom", " " + endpointURI);
        }
        return endpointURI;
    }

    private void getGlobalVocab(Policy policy, Set<QName> vocabSet) {
        Set<QName> vocab = this._dmu.getVocabulary(policy);
        vocabSet.addAll(vocab);
    }

    @Override
    public void clearProviderPolicy(MessageContext mc) {
        String endpointURI;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Clearing provider WS-Policy from WSPolicyProcessor");
        }
        if ((endpointURI = this.getEndpointURIFromMsg(mc)) != null) {
            this._wsdlProcessors.remove(endpointURI);
        }
        this._calculatedPolicies.clear();
        this._acquiredDefinitions.clear();
        this._vocabs.clear();
        this._factory = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry().getWSPolicyFactory();
    }

    @Override
    public Map<String, Object> getBindings() {
        if (this._bindings == null) {
            this._bindings = new HashMap();
        }
        return this._bindings;
    }

    @Override
    public void loadRequesterWSPolicy(List referenceList, Map<String, Object> transformOptions) throws PolicyException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadRequesterWSPolicy");
        }
        String resourcePattern = null;
        try {
            List refList = referenceList;
            for (PolicySetReference reference : refList) {
                String policySetName = reference.getName();
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "   Policy set name is " + reference.getName());
                }
                if (policySetName == null || policySetName.equals("")) continue;
                for (Resource resource : reference.getResource()) {
                    resourcePattern = resource.getPattern();
                    if (resourcePattern == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "loadRequesterWSPolicy", "resourcePattern is null, skip it");
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "loadRequesterWSPolicy", "Found WS-Policy at scope point: " + resourcePattern);
                    }
                    this.loadPolicySet(resourcePattern, policySetName, referenceList, transformOptions);
                }
            }
        }
        catch (WSPolicyInternalException e) {
            Object[] args = new Object[]{null, e};
            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
        }
        catch (TransformationException e) {
            Tr.warning(TRACE_COMPONENT, "CWPOL0200", new Object[]{null});
            Object[] args = new Object[]{null};
            throw new PolicyException(nls.getFormattedMessage("CWPOL0200", args, "CWPOL0200E"), e);
        }
        catch (WSPolicyBindingsException e) {
            Object[] args = new Object[]{null};
            throw new PolicyException(nls.getFormattedMessage("CWPOL0300", args, "CWPOL0300E"), e);
        }
        catch (WSPolicySetException e) {
            Object[] args = new Object[]{e.getPolicySetName()};
            throw new PolicyException(nls.getFormattedMessage("CWPOL0301", args, "CWPOL0301E"), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadRequesterWSPolicy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolicySet(String scopeKey, String policySetName, List referenceList, Map<String, Object> transformOptions) throws WSPolicySetException, WSPolicyBindingsException, WSPolicyInternalException, TransformationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadPolicySet", new Object[]{scopeKey, policySetName});
        }
        List typesInPolicySet = null;
        Set<String> allTypes = this._ppr.getAllDomainTypes();
        try {
            typesInPolicySet = PolicySetAttachmentsImpl.getTypesForPolicySet(policySetName);
        }
        catch (Exception e) {
            WSPolicySetException wspse = new WSPolicySetException(e);
            wspse.setPolicySetName(policySetName);
            throw wspse;
        }
        if (allTypes != null) {
            Iterator<String> iter = allTypes.iterator();
            while (iter.hasNext()) {
                InputStream policyTypeConfig = null;
                String policyType = iter.next();
                try {
                    HashMap<String, Object> transformOptionsWithPSConfig;
                    Object psa;
                    if (typesInPolicySet != null && typesInPolicySet.contains(policyType)) {
                        policyTypeConfig = PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, policyType);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "About to call WS-Policy loader for  " + policyType);
                    }
                    if ((psa = (transformOptionsWithPSConfig = new HashMap<String, Object>(transformOptions)).get("com.ibm.ws.wspolicy.PolicySetAttachment")) instanceof WSPolicyAttachments) {
                        try {
                            transformOptionsWithPSConfig.put("com.ibm.ws.wspolicy.PolicySetConfiguration", ((WSPolicyAttachments)psa).getPolicySet(scopeKey));
                        }
                        catch (Exception e) {
                            WSPolicySetException wspse = new WSPolicySetException(e);
                            wspse.setPolicySetName(policySetName);
                            throw wspse;
                        }
                    }
                    PolicyInputStreamHolder transformedPolicy = this.transformForClientIntersection(scopeKey, policyTypeConfig, policyType, referenceList, transformOptionsWithPSConfig);
                    this.setRequesterPolicy(scopeKey, policyType, policySetName, transformedPolicy);
                }
                finally {
                    try {
                        if (policyTypeConfig != null) {
                            policyTypeConfig.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "IOException reading bindingInputStream ", ioe);
                        }
                        FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2302", this);
                    }
                }
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "Back from WS-Policy load on " + policyType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadPolicySet");
        }
    }

    private PolicyInputStreamHolder transformForClientIntersection(String scopeKey, InputStream policyTypeConfig, String policyType, List<PolicySetReference> referenceList, Map<String, Object> transformOptions) throws WSPolicyBindingsException, WSPolicyInternalException, TransformationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientIntersection");
        }
        PolicyInputStreamHolder result = null;
        if (this._transformer == null) {
            this._transformer = WSPolicyInternalFactory.singleton.createPolicyTransform();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Calling transform utility ");
        }
        result = this._transformer.transformForClientIntersection(policyTypeConfig, transformOptions, policyType);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientIntersection");
        }
        return result;
    }

    private InputStream getBindingInputStream(String scopeKey, final String policyType, List<PolicySetReference> referenceList) throws WSPolicyBindingsException {
        String bindingScope;
        PolicySetReference psr = null;
        if (referenceList != null) {
            psr = this.findAttachment(scopeKey, this._defaultResourceEvaluator, referenceList);
        }
        final String bindingName = psr != null && psr.getPolicySetBinding() != null ? psr.getPolicySetBinding().getName() : null;
        String string = bindingScope = psr != null && psr.getPolicySetBinding() != null ? psr.getPolicySetBinding().getScope() : null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "bindingName ", bindingName);
        }
        try {
            return (InputStream)ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws WSPolicyBindingsException {
                    InputStream bindingStream = null;
                    if (bindingName == null) {
                        try {
                            String defaultBindingName = BindingAggregator.getDefaultBindingName("client");
                            bindingStream = BindingAggregator.getDefaultBindingInputStream(policyType, defaultBindingName);
                        }
                        catch (Throwable t) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "unable to obtain the default named binding", t);
                            }
                            throw new WSPolicyBindingsException();
                        }
                    } else if (bindingScope != null && bindingScope.equals("domain")) {
                        bindingStream = BindingAggregator.getGeneralBindingInputStream(policyType, bindingName);
                    } else {
                        String rootDir = WSPolicyProcessorImpl.this._clientControllerFileName.substring(0, WSPolicyProcessorImpl.this._clientControllerFileName.length() - "clientPolicyAttachments.xml".length() - 1);
                        bindingStream = BindingAggregator.getCustomBindingInputStream(rootDir, bindingName, policyType);
                    }
                    return bindingStream;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof WSPolicyBindingsException) {
                throw (WSPolicyBindingsException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WSPolicyBindingsException(e);
        }
    }

    private PolicySetReference findAttachment(String resourceName, ResourceEvaluator resourceEvaluator, List<PolicySetReference> referenceList) {
        String attachmentType = "client";
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "findAttachment", resourceName);
        }
        PolicySetReference policyRef = null;
        int matchDistance = Integer.MAX_VALUE;
        PolicySetReference savedPolicyRef = null;
        int savedMatchDistance = Integer.MAX_VALUE;
        if (resourceName != null) {
            if (!resourceName.endsWith("/")) {
                resourceName = resourceName + "/";
            }
            String resourceWithoutModule = resourceName;
            String savedResourceName = resourceName;
            boolean keepSearching = true;
            boolean resourceContainsModule = false;
            if (attachmentType.equals("client") && !resourceName.equals(resourceWithoutModule = this.removeModuleName(resourceName))) {
                resourceContainsModule = true;
            }
            while (keepSearching) {
                Iterator<PolicySetReference> iter = referenceList.iterator();
                block1: while (matchDistance != 0 && iter.hasNext()) {
                    PolicySetReference reference = iter.next();
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Testing attachment id " + reference.getId());
                        Tr.debug(TRACE_COMPONENT, "   Policy set name is " + reference.getName());
                        Tr.debug(TRACE_COMPONENT, "   Binding is " + reference.getPolicySetBinding());
                    }
                    for (Resource resource : reference.getResource()) {
                        int distance;
                        String resourcePattern = resource.getPattern();
                        if (resourcePattern == null) {
                            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "findAttachment, resourcePattern is null, skip it");
                            continue;
                        }
                        if (!resourcePattern.endsWith("/")) {
                            resourcePattern = resourcePattern + "/";
                        }
                        resourcePattern = this.removeModuleName(resourcePattern);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "resourceName=" + resourceName + ", resourcePattern=" + resourcePattern);
                        }
                        if ((distance = resourceEvaluator.getMatchDistance(resourcePattern, resourceName)) < 0) continue;
                        if (distance < matchDistance) {
                            policyRef = reference;
                            matchDistance = distance;
                        }
                        if (matchDistance != 0) continue;
                        continue block1;
                    }
                }
                if (attachmentType.equals("client")) {
                    if (matchDistance != 0 && resourceContainsModule) {
                        savedPolicyRef = policyRef;
                        savedMatchDistance = matchDistance;
                        resourceName = resourceWithoutModule;
                        resourceContainsModule = false;
                        matchDistance = Integer.MAX_VALUE;
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "match distance = " + savedMatchDistance);
                        Tr.debug(TRACE_COMPONENT, "getting ready to check without moduleName, updated resourceName = " + resourceName);
                        continue;
                    }
                    keepSearching = false;
                    continue;
                }
                keepSearching = false;
            }
            if (attachmentType.equals("client") && savedMatchDistance <= matchDistance) {
                policyRef = savedPolicyRef;
                matchDistance = savedMatchDistance;
                resourceName = savedResourceName;
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Closer match, so using policy reference with module name");
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "resourceName is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            if (matchDistance < Integer.MAX_VALUE) {
                Tr.debug(TRACE_COMPONENT, "Found attachment with id, name, and matchDistance of:", new Object[]{policyRef.getId(), policyRef.getName(), matchDistance});
            } else {
                Tr.debug(TRACE_COMPONENT, "Found no attachment");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "findAttachment", resourceName);
        }
        return policyRef;
    }

    private String removeModuleName(String resourceName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeModuleName", resourceName);
        }
        String updatedResource = resourceName;
        PolicyResource policyResource = new PolicyResource(resourceName);
        String moduleName = policyResource.getModuleName();
        if (moduleName != null) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(resourceName.substring(0, resourceName.indexOf(moduleName)));
            strBuf.append(resourceName.substring(resourceName.indexOf(moduleName) + moduleName.length() + 1));
            updatedResource = strBuf.toString();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Resource contains module name");
                Tr.debug(TRACE_COMPONENT, "Resource without moduleName is: " + updatedResource);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeModuleName", updatedResource);
        }
        return updatedResource;
    }

    @Override
    public void storeReferenceList(List references) {
        this._referenceList = references;
    }

    /*
     * Loose catch block
     */
    public void loadBindings(String scopeKeyIn, String endpointURI) throws WSPolicyFormattedException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadBindings", new Object[]{scopeKeyIn, endpointURI});
        }
        PolicyResource policyResource = new PolicyResource(scopeKeyIn);
        String serviceName = policyResource.getServiceName();
        String moduleName = policyResource.getModuleName();
        String scopeKey = "WebService:/";
        if (moduleName != null) {
            scopeKey = scopeKey + moduleName + ":";
        }
        if (serviceName != null) {
            scopeKey = scopeKey + serviceName;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "scopeKey that will be used to look up bindings is " + scopeKey);
        }
        List allTypes = PolicyTypeAggregator.getExtensions();
        for (PolicyTypeLoader loader : allTypes) {
            byte[] byteArray;
            String policyType;
            block33: {
                policyType = null;
                try {
                    policyType = loader.getType();
                }
                catch (Exception e) {
                    Object[] args = new Object[]{serviceName, e};
                    throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
                }
                if (policyType.equals("HTTPTransport") || policyType.equals("SSLTransport") || policyType.equals("JMSTransport")) continue;
                InputStream bindingStream = null;
                try {
                    bindingStream = this.getBindingInputStream(scopeKey, policyType, this._referenceList);
                }
                catch (WSPolicyBindingsException e) {
                    Object[] args = new Object[]{endpointURI};
                    throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0300", args, "CWPOL0300E"), e);
                }
                byteArray = null;
                if (bindingStream != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] tempBuffer = new byte[1024];
                    int bytesLen = 0;
                    while ((bytesLen = bindingStream.read(tempBuffer)) != -1) {
                        baos.write(tempBuffer, 0, bytesLen);
                    }
                    byteArray = baos.toByteArray();
                    Object var19_18 = null;
                    try {
                        if (bindingStream != null) {
                            bindingStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "IOException closing bindingInputStream ", ioe);
                        }
                        FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2307", this);
                    }
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                        break block33;
                    }
                    catch (IOException ioe) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "IOException closing temporary bindingOutputStream", ioe);
                        }
                        FFDCFilter.processException((Throwable)ioe, "IOException closing temporary bindingOutputStrea", "2317", this);
                    }
                    break block33;
                    {
                        catch (IOException ioe) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "IOException reading bindingInputStream ", ioe);
                            }
                            FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2302", this);
                            Object[] args = new Object[]{scopeKey};
                            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0301", args, "CWPOL0301E"), ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        var19_18 = null;
                        try {
                            if (bindingStream != null) {
                                bindingStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "IOException closing bindingInputStream ", ioe);
                            }
                            FFDCFilter.processException((Throwable)ioe, "IOException closing bindingInputStream", "2307", this);
                        }
                        try {
                            if (baos != null) {
                                baos.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "IOException closing temporary bindingOutputStream", ioe);
                            }
                            FFDCFilter.processException((Throwable)ioe, "IOException closing temporary bindingOutputStrea", "2317", this);
                        }
                        throw throwable;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Read default binding for " + policyType);
            }
            this.getBindings().put(policyType, byteArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadBindings");
        }
    }

    private InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, String policyType) throws WSPolicyInternalException, TransformationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        InputStream result = null;
        if (this._transformer == null) {
            this._transformer = WSPolicyInternalFactory.singleton.createPolicyTransform();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Calling transform utility ");
        }
        HashMap<String, Object> transformOptions = new HashMap<String, Object>();
        result = this._transformer.transformForClientConfiguration(policy, transformOptions, policyType);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformForClientConfiguration");
        }
        return result;
    }

    /*
     * Loose catch block
     */
    @Override
    public PolicySetConfigurationImpl generateQOSProperties(ClassLoader systemCL, String scopeInformation, List<String> typesInPolicySet, List<String> usedTypes, MessageContext mc, final String policySetName) throws NullPolicyException, PolicyException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "generateQOSProperties");
        }
        PolicySetConfigurationImpl psConfig = new PolicySetConfigurationImpl();
        VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
        List extensions = PolicyTypeAggregator.getExtensions();
        for (PolicyTypeLoader loader : extensions) {
            block32: {
                String policyType;
                block31: {
                    try {
                        policyType = loader.getType();
                    }
                    catch (Exception e) {
                        AxisService service = mc.getAxisService();
                        Object[] args = new Object[]{service == null ? null : service.getName(), e};
                        throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), new WSPolicyInternalException(e));
                    }
                    InputStream policyTypeConfig = null;
                    if (!(policyType == null || policyType.equals("HTTPTransport") || policyType.equals("SSLTransport") || policyType.equals("JMSTransport"))) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "About to call load on " + loader.getClass().getName());
                        }
                        PolicyInputStreamHolder preTransformedPolicy = null;
                        try {
                            preTransformedPolicy = this.calculatePolicy(scopeInformation, policyType, mc);
                        }
                        catch (UnknownOperationException e1) {
                            // empty catch block
                        }
                        try {
                            policyTypeConfig = this.transformForClientConfiguration(preTransformedPolicy, policyType);
                        }
                        catch (WSPolicyInternalException e) {
                            AxisService service = mc.getAxisService();
                            Object[] args = new Object[]{service == null ? null : service.getName(), e};
                            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), e);
                        }
                        catch (TransformationException e) {
                            AxisService service = mc.getAxisService();
                            String url = null;
                            if (service != null) {
                                url = service.getEndpointURL();
                            }
                            Tr.warning(TRACE_COMPONENT, "CWPOL0200", new Object[]{url});
                            Object[] args = new Object[]{url};
                            throw new PolicyException(nls.getFormattedMessage("CWPOL0200", args, "CWPOL0200E"), e);
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        if (policyType != null) {
                            Tr.debug(TRACE_COMPONENT, "Processing Non-WSPolicy Policy type : " + policyType);
                        } else {
                            Tr.debug(TRACE_COMPONENT, "Processing Non-WSPolicy Policy type : null");
                        }
                    }
                    if (policyType != null && policySetName != null && !policySetName.equals("") && typesInPolicySet != null && typesInPolicySet.contains(policyType)) {
                        policyTypeConfig = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                            @Override
                            public InputStream run() {
                                return PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, policyType);
                            }
                        });
                    }
                    if (policyTypeConfig == null) break block31;
                    if (policyType != null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "after transformation, loading config for type " + policyType);
                        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "policyType was null");
                        }
                    }
                    loader.load(systemCL, variableExpander, policyTypeConfig, psConfig);
                    usedTypes.add(policyType);
                    Object var20_22 = null;
                    try {
                        policyTypeConfig.close();
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Exception closing inputStream ", e);
                        }
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.generateQOSProperties", "2475", this);
                    }
                    break block32;
                    {
                        catch (Exception e) {
                            AxisService service = mc.getAxisService();
                            Object[] args = new Object[]{service == null ? null : service.getName(), e};
                            throw new PolicyException(nls.getFormattedMessage("CWPOL9999", args, "CWPOL9999E"), new WSPolicyInternalException(e));
                        }
                    }
                    catch (Throwable throwable) {
                        var20_22 = null;
                        try {
                            policyTypeConfig.close();
                        }
                        catch (Exception e) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "Exception closing inputStream ", e);
                            }
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl.generateQOSProperties", "2475", this);
                        }
                        throw throwable;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "after transformation, no config to load " + policyType);
                }
            }
            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "Back from load on " + loader.getClass().getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "generateQOSProperties");
        }
        return psConfig;
    }

    private Policy createPolicy(List<Assertion> assertions) {
        Policy result = this._factory.createDataModelFactory().createPolicy();
        ExactlyOne eo = this._factory.createDataModelFactory().createExactlyOne();
        All all = this._factory.createDataModelFactory().createAll();
        result.getChildren().add(eo);
        eo.getChildren().add(all);
        all.getChildren().addAll(assertions);
        return result;
    }

    private PolicyProcessor.Alternative getAlternative(Policy pol, PolicyProcessor.FilterType filterType) throws com.ibm.wspolicy.PolicyReferenceException {
        return this._ap.getSingleAlternative(pol, filterType);
    }
}

