/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.policyset.DefaultWSPolicyFactory;
import com.ibm.ws.wspolicy.policyset.WSPolicyAttachments;
import com.ibm.ws.wspolicy.policyset.WSPolicyFactoryPlugin;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class WSPolicyFactory {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyFactory.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final WSPolicyFactory _instance = new WSPolicyFactory();
    private final WSPolicyFactoryPlugin _wsPolicyFactoryPlugin;
    private static final String WSPOLICYFACTORY_EXTENSION_MAIN = "com.ibm.wspolicy.main.ibmwspolicy-qos-wspolicyfactory";
    private static final String WSPOLICYFACTORY_EXTENSION_THINCLIENT = "com.ibm.wsfp.thinclient.ibmwspolicy-qos-wspolicyfactory";

    public static WSPolicyFactory newInstance() {
        return _instance;
    }

    public WSPolicyProcessor createPolicyProcessor(String applicationPath, String serviceName, String moduleName) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicyProcessor", new Object[]{applicationPath});
        }
        WSPolicyProcessor result = null;
        try {
            result = this._wsPolicyFactoryPlugin.createPolicyProcessor(applicationPath, serviceName, moduleName);
        }
        catch (Exception e) {
            this.traceAndFFDCException("createPolicyProcessor", e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicyProcessor");
        }
        return result;
    }

    public WSPolicyAttachments createWSPolicyAttachments(WSPolicyProcessor wsp2, PolicySetAttachments psa, String applicationPath, String serviceName, String moduleName) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createWSPolicyAttachments", new Object[]{wsp2, psa, applicationPath, serviceName, moduleName});
        }
        WSPolicyAttachments result = null;
        try {
            result = this._wsPolicyFactoryPlugin.createWSPolicyAttachments(wsp2, psa, applicationPath, serviceName, moduleName);
        }
        catch (Exception e) {
            this.traceAndFFDCException("createWSPolicyAttachments", e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createWSPolicyAttachments");
        }
        return result;
    }

    public int version() {
        return this._wsPolicyFactoryPlugin.version();
    }

    private WSPolicyFactory() {
        IExtensionRegistry registry;
        IConfigurationElement[] elements;
        boolean found;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "init");
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Locate WSPolicyFactory plugins");
        }
        boolean bl = found = (elements = (registry = ExtensionRegistryFactory.instance().getExtensionRegistry()).getConfigurationElementsFor(WSPOLICYFACTORY_EXTENSION_MAIN)).length > 0;
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Extensions for com.ibm.wspolicy.main.ibmwspolicy-qos-wspolicyfactory " + elements.length);
        }
        if (!found) {
            elements = registry.getConfigurationElementsFor(WSPOLICYFACTORY_EXTENSION_THINCLIENT);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Extensions for com.ibm.wsfp.thinclient.ibmwspolicy-qos-wspolicyfactory " + elements.length);
            }
        }
        WSPolicyFactoryPlugin tempFactoryPlugin = null;
        if (elements.length > 0) {
            int version = Integer.MIN_VALUE;
            for (int i = 0; i < elements.length; ++i) {
                try {
                    Object obj = elements[i].createExecutableExtension("class");
                    if (!(obj instanceof WSPolicyFactoryPlugin)) {
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "found non WSPolicyFactoryPlugin", obj == null ? null : obj.getClass().getName());
                        continue;
                    }
                    WSPolicyFactoryPlugin factoryplugin = (WSPolicyFactoryPlugin)obj;
                    if (factoryplugin.version() <= version) continue;
                    tempFactoryPlugin = factoryplugin;
                    if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "found WSPolicyFactoryPlugin " + factoryplugin.getClass().getName());
                    continue;
                }
                catch (Exception e) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "WSPolicyFactory caught Exception", e);
                    }
                    FFDCFilter.processException(e, "WSPolicyFactory<CTOR>", "101");
                }
            }
        }
        if (tempFactoryPlugin == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Using Default WSPolicyFactory");
            }
            this._wsPolicyFactoryPlugin = new DefaultWSPolicyFactory();
        } else {
            this._wsPolicyFactoryPlugin = tempFactoryPlugin;
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "selected WSPolicyFactoryPlugin " + this._wsPolicyFactoryPlugin.getClass().getName());
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "init");
        }
    }

    private void traceAndFFDCException(String className, Exception e) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSPolicyFactory caught Exception", e);
        }
        FFDCFilter.processException(e, className, "199");
        throw new WSPolicyInternalException(e);
    }
}

